/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.httptunnel.tunnel.servlet;

import com.sun.messaging.jmq.httptunnel.api.share.HttpTunnelDefaults;
import com.sun.messaging.jmq.httptunnel.tunnel.HttpTunnelPacket;
import com.sun.messaging.jmq.httptunnel.tunnel.servlet.ConnKey;
import com.sun.messaging.jmq.httptunnel.tunnel.servlet.Connection;
import com.sun.messaging.jmq.httptunnel.tunnel.servlet.HelperThread;
import com.sun.messaging.jmq.httptunnel.tunnel.servlet.ServerLink;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.net.Socket;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;

public class ServerLinkTable
implements HttpTunnelDefaults {
    private static final int RUNNING = 0;
    private static final int SHUTTINGDOWN = 1;
    private static final int DESTROYED = 2;
    private int linkTableState = 0;
    private int servletPort;
    private int rxBufSize;
    private String servletHost = null;
    private HelperThread helperThread;
    private Hashtable linkTable;
    private Hashtable connTable;
    private Vector tmpList;
    private int nextConnId = 0;
    private long lastCheck = 0L;
    protected ServletContext servletContext;

    public ServerLinkTable(ServletConfig cfg) throws Exception {
        this(cfg, false);
    }

    public ServerLinkTable(ServletConfig cfg, boolean useSSL) throws Exception {
        this.servletContext = cfg.getServletContext();
        this.linkTableState = 0;
        this.nextConnId = (int)System.currentTimeMillis();
        this.lastCheck = 0L;
        this.linkTable = new Hashtable();
        this.connTable = new Hashtable();
        this.tmpList = new Vector();
        this.rxBufSize = 0;
        String rxBufSizeStr = cfg.getInitParameter("rxBufSize");
        if (rxBufSizeStr != null) {
            try {
                this.rxBufSize = Integer.parseInt(rxBufSizeStr);
            }
            catch (Exception e) {
                this.servletContext.log("Exception in HttpTunnelServlet : " + e.getMessage());
            }
        }
        int defaultPort = useSSL ? 7674 : 7675;
        String servletPortString = cfg.getInitParameter("servletPort");
        if (servletPortString == null) {
            servletPortString = cfg.getInitParameter("serverPort");
        }
        if (servletPortString != null) {
            try {
                this.servletPort = Integer.parseInt(servletPortString);
            }
            catch (Exception e) {
                this.servletPort = defaultPort;
            }
        } else {
            this.servletPort = defaultPort;
        }
        this.servletHost = cfg.getInitParameter("servletHost");
        if (this.servletHost == null) {
            this.servletHost = cfg.getInitParameter("serverHost");
        }
        if (useSSL) {
            String keystoreloc = cfg.getInitParameter("keystoreLocation");
            if (keystoreloc == null || keystoreloc.equals("")) {
                throw new Exception("keystore location not specified");
            }
            String kspassword = cfg.getInitParameter("keystorePassword");
            if (kspassword == null || kspassword.equals("")) {
                throw new Exception("keystore password not specified");
            }
            this.helperThread = new HelperThread(this.servletPort, this.servletHost, this.rxBufSize, keystoreloc, kspassword, this);
        } else {
            this.helperThread = new HelperThread(this.servletPort, this.servletHost, this.rxBufSize, this);
        }
        this.helperThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shuttingDown() {
        this.helperThread.close();
        Cloneable cloneable = this.linkTable;
        synchronized (cloneable) {
            this.linkTableState = 1;
        }
        cloneable = this.linkTable;
        synchronized (cloneable) {
            Enumeration servers = this.linkTable.keys();
            while (servers.hasMoreElements()) {
                String serverName = (String)servers.nextElement();
                ServerLink link = (ServerLink)this.linkTable.get(serverName);
                this.linkTable.remove(serverName);
                link.shutdown();
                link.linkDown();
            }
        }
        cloneable = this.tmpList;
        synchronized (cloneable) {
            for (int i = this.tmpList.size() - 1; i >= 0; --i) {
                ServerLink link = (ServerLink)this.tmpList.elementAt(i);
                link.shutdown();
                link.linkDown();
            }
        }
        cloneable = this.connTable;
        synchronized (cloneable) {
            Enumeration conns = this.connTable.keys();
            while (conns.hasMoreElements()) {
                Vector pullQ;
                ConnKey s = (ConnKey)conns.nextElement();
                Connection conn = (Connection)this.connTable.get(s);
                Vector vector = pullQ = conn.getPullQ();
                synchronized (vector) {
                    pullQ.notifyAll();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        this.linkTableState = 2;
        Cloneable cloneable = this.linkTable;
        synchronized (cloneable) {
            this.linkTable.clear();
        }
        cloneable = this.connTable;
        synchronized (cloneable) {
            this.connTable.clear();
        }
        cloneable = this.tmpList;
        synchronized (cloneable) {
            this.tmpList.removeAllElements();
        }
    }

    public void close() {
        try {
            this.helperThread.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addServer(Socket s) {
        try {
            ServerLink link = new ServerLink(s, this);
            Vector vector = this.tmpList;
            synchronized (vector) {
                this.tmpList.addElement(link);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateServerName(ServerLink link) throws IllegalStateException {
        String serverName = link.getServerName();
        Cloneable cloneable = this.linkTable;
        synchronized (cloneable) {
            if (this.linkTableState >= 1) {
                throw new IllegalStateException("HttpTunnelServlet: in destory");
            }
            ServerLink oldlink = (ServerLink)this.linkTable.get(serverName);
            if (oldlink != null && !oldlink.isDone()) {
                throw new IllegalStateException("HttpTunnelServlet: ServerName " + serverName + " conflict");
            }
            this.linkTable.put(serverName, link);
        }
        cloneable = this.tmpList;
        synchronized (cloneable) {
            int i = this.tmpList.indexOf(link);
            if (i > -1) {
                this.tmpList.removeElementAt(i);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateConnection(int connId, int pullPeriod, ServerLink link) throws IllegalStateException {
        Connection conn = new Connection(link);
        conn.setPullPeriod(pullPeriod);
        Hashtable hashtable = this.connTable;
        synchronized (hashtable) {
            if (this.linkTableState >= 1) {
                throw new IllegalStateException("HttpTunnelServlet: in destory");
            }
            this.connTable.put(new ConnKey(link.getServerName(), connId), conn);
        }
    }

    private boolean sameServerName(String serverName, Connection conn) {
        String servname = conn.getServerLink().getServerName();
        return servname != null && serverName != null && servname.equals(serverName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void serverDown(ServerLink link) {
        String serverName = link.getServerName();
        if (serverName != null) {
            ServerLink curlink = null;
            Hashtable hashtable = this.linkTable;
            synchronized (hashtable) {
                curlink = (ServerLink)this.linkTable.get(serverName);
                if (curlink != link) {
                    return;
                }
                this.linkTable.remove(serverName);
            }
        }
        link.shutdown();
        Hashtable hashtable = this.connTable;
        synchronized (hashtable) {
            Enumeration conns = this.connTable.keys();
            while (conns.hasMoreElements()) {
                ConnKey s = (ConnKey)conns.nextElement();
                Connection conn = (Connection)this.connTable.get(s);
                if (conn.getServerLink() != link) continue;
                int connId = s.getConnId();
                Vector pullQ = conn.getPullQ();
                this.abortClientConnection(connId, pullQ);
            }
        }
    }

    private static HttpTunnelPacket genAbortPacket(int connId) {
        HttpTunnelPacket p = new HttpTunnelPacket();
        p.setPacketType(9);
        p.setConnId(connId);
        p.setSequence(0);
        p.setWinsize(0);
        p.setChecksum(0);
        p.setPacketBody(null);
        return p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void abortClientConnection(int connId, Vector pullQ) {
        HttpTunnelPacket p = ServerLinkTable.genAbortPacket(connId);
        Vector vector = pullQ;
        synchronized (vector) {
            pullQ.addElement(p);
            pullQ.notify();
        }
    }

    private void abortServerConnection(int connId, Connection conn) {
        HttpTunnelPacket p = ServerLinkTable.genAbortPacket(connId);
        conn.getServerLink().sendPacket(p);
    }

    public String getDefaultServer() {
        String serverName = null;
        try {
            ServerLink link = (ServerLink)this.linkTable.elements().nextElement();
            if (link != null) {
                serverName = link.getServerName();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return serverName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getListenState(String serverName) {
        if (serverName == null) {
            return false;
        }
        ServerLink link = null;
        Hashtable hashtable = this.linkTable;
        synchronized (hashtable) {
            if (this.linkTableState >= 1) {
                return false;
            }
            link = (ServerLink)this.linkTable.get(serverName);
            if (link == null) {
                return false;
            }
        }
        return link.getListenState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int createNewConn(String serverName) {
        if (serverName == null) {
            return -1;
        }
        ServerLink link = null;
        Hashtable hashtable = this.linkTable;
        synchronized (hashtable) {
            if (this.linkTableState >= 1) {
                return -1;
            }
            link = (ServerLink)this.linkTable.get(serverName);
            if (link == null) {
                return -1;
            }
        }
        hashtable = this.connTable;
        synchronized (hashtable) {
            int connId = this.nextConnId++;
            ConnKey connKey = new ConnKey(link.getServerName(), connId);
            this.connTable.put(connKey, new Connection(link));
            return connId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyConn(int connId, String serverName) {
        if (serverName == null) {
            return;
        }
        Hashtable hashtable = this.connTable;
        synchronized (hashtable) {
            this.connTable.remove(new ConnKey(serverName, connId));
        }
    }

    public void sendPacket(HttpTunnelPacket p, String serverName) {
        if (serverName == null) {
            return;
        }
        ConnKey connKey = new ConnKey(serverName, p.getConnId());
        Connection conn = (Connection)this.connTable.get(connKey);
        if (conn == null) {
            return;
        }
        if (!this.sameServerName(serverName, conn)) {
            return;
        }
        if (p.getPacketType() == 10) {
            this.interceptConnOption(conn, p);
        }
        conn.getServerLink().sendPacket(p);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void receivePacket(HttpTunnelPacket p, ServerLink link) {
        Vector pullQ = null;
        Cloneable cloneable = this.connTable;
        synchronized (cloneable) {
            ConnKey connKey = new ConnKey(link.getServerName(), p.getConnId());
            Connection conn = (Connection)this.connTable.get(connKey);
            if (conn == null) {
                return;
            }
            pullQ = conn.getPullQ();
        }
        cloneable = pullQ;
        synchronized (cloneable) {
            pullQ.addElement(p);
            pullQ.notify();
        }
    }

    private void interceptConnOption(Connection conn, HttpTunnelPacket p) {
        byte[] buf = p.getPacketBody();
        ByteArrayInputStream bis = new ByteArrayInputStream(buf);
        DataInputStream dis = new DataInputStream(bis);
        try {
            int optname = dis.readInt();
            switch (optname) {
                case 1: {
                    int pullPeriod = dis.readInt();
                    conn.setPullPeriod(pullPeriod);
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpTunnelPacket waitForPacket(String connIdStr, String serverName) {
        int connId = -1;
        try {
            connId = Integer.parseInt(connIdStr);
        }
        catch (Exception e) {
            return null;
        }
        if (serverName == null) {
            return ServerLinkTable.genAbortPacket(connId);
        }
        ConnKey connKey = new ConnKey(serverName, connId);
        Connection conn = null;
        Hashtable hashtable = this.connTable;
        synchronized (hashtable) {
            conn = (Connection)this.connTable.get(connKey);
        }
        if (conn == null) {
            if (this.linkTable.get(serverName) != null) {
                return ServerLinkTable.genAbortPacket(connId);
            }
            return null;
        }
        if (!this.sameServerName(serverName, conn)) {
            return ServerLinkTable.genAbortPacket(connId);
        }
        conn.setInUse(true);
        HttpTunnelPacket p = this.waitForPacket(connKey, conn);
        conn.setInUse(false);
        return p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpTunnelPacket waitForPacket(ConnKey connKey, Connection conn) {
        Vector pullQ = conn.getPullQ();
        int pullPeriod = conn.getPullPeriod();
        HttpTunnelPacket p = null;
        boolean removeConn = false;
        Cloneable cloneable = pullQ;
        synchronized (cloneable) {
            if (pullPeriod > 0 && pullQ.isEmpty()) {
                return null;
            }
            long startTime = System.currentTimeMillis();
            long maxwait = 60000L;
            while (pullQ.isEmpty() && this.linkTableState == 0) {
                try {
                    pullQ.wait(maxwait);
                }
                catch (Exception e) {
                    // empty catch block
                }
                if ((maxwait -= System.currentTimeMillis() - startTime) > 0L) continue;
                return null;
            }
            if (pullQ.isEmpty()) {
                return null;
            }
            p = (HttpTunnelPacket)pullQ.elementAt(0);
            pullQ.removeElementAt(0);
            switch (p.getPacketType()) {
                case 9: {
                    removeConn = true;
                    pullQ.insertElementAt(p, 0);
                    pullQ.notifyAll();
                    break;
                }
                case 7: {
                    removeConn = true;
                    pullQ.insertElementAt(p, 0);
                    pullQ.notifyAll();
                    p = null;
                    break;
                }
                case 10: {
                    this.interceptConnOption(conn, p);
                }
            }
        }
        if (removeConn) {
            cloneable = this.connTable;
            synchronized (cloneable) {
                this.connTable.remove(connKey);
            }
        }
        return p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector waitForPackets(String connIdStr, String serverName) {
        int connId = -1;
        try {
            connId = Integer.parseInt(connIdStr);
        }
        catch (Exception e) {
            return null;
        }
        if (serverName == null) {
            Vector<HttpTunnelPacket> v1 = new Vector<HttpTunnelPacket>();
            v1.addElement(ServerLinkTable.genAbortPacket(connId));
            return v1;
        }
        ConnKey connKey = new ConnKey(serverName, connId);
        Connection conn = null;
        Hashtable hashtable = this.connTable;
        synchronized (hashtable) {
            conn = (Connection)this.connTable.get(connKey);
        }
        if (conn == null) {
            if (this.linkTable.get(serverName) != null) {
                Vector<HttpTunnelPacket> v2 = new Vector<HttpTunnelPacket>();
                v2.addElement(ServerLinkTable.genAbortPacket(connId));
                return v2;
            }
            return null;
        }
        if (!this.sameServerName(serverName, conn)) {
            Vector<HttpTunnelPacket> v3 = new Vector<HttpTunnelPacket>();
            v3.addElement(ServerLinkTable.genAbortPacket(connId));
            return v3;
        }
        conn.setInUse(true);
        Vector v = this.waitForPackets(connKey, conn);
        conn.setInUse(false);
        return v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Vector waitForPackets(ConnKey connKey, Connection conn) {
        Vector pullQ = conn.getPullQ();
        int pullPeriod = conn.getPullPeriod();
        Vector<HttpTunnelPacket> v = new Vector<HttpTunnelPacket>();
        boolean removeConn = false;
        Cloneable cloneable = pullQ;
        synchronized (cloneable) {
            if (pullPeriod > 0 && pullQ.isEmpty()) {
                return null;
            }
            long startTime = System.currentTimeMillis();
            long maxwait = 60000L;
            while (pullQ.isEmpty() && this.linkTableState == 0) {
                try {
                    pullQ.wait(maxwait);
                }
                catch (Exception e) {
                    // empty catch block
                }
                if ((maxwait -= System.currentTimeMillis() - startTime) > 0L) continue;
                return null;
            }
            if (pullQ.isEmpty()) {
                return v;
            }
            int size = 0;
            while (this.linkTableState == 0) {
                HttpTunnelPacket p = (HttpTunnelPacket)pullQ.elementAt(0);
                switch (p.getPacketType()) {
                    case 9: {
                        removeConn = true;
                        pullQ.notifyAll();
                        v.addElement(p);
                        break;
                    }
                    case 7: {
                        removeConn = true;
                        pullQ.notifyAll();
                        break;
                    }
                    case 10: {
                        this.interceptConnOption(conn, p);
                    }
                }
                if (removeConn || size > 0 && size + p.getPacketSize() > 8192) break;
                v.addElement(p);
                size += p.getPacketSize();
                pullQ.removeElementAt(0);
                if (p.getPacketType() != 2 && !pullQ.isEmpty()) continue;
                break;
            }
        }
        if (removeConn) {
            cloneable = this.connTable;
            synchronized (cloneable) {
                this.connTable.remove(connKey);
            }
        }
        return v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void retrySendPacket(HttpTunnelPacket p, String connIdStr, String serverName) {
        ConnKey connKey;
        if (serverName == null) {
            return;
        }
        Vector pullQ = null;
        try {
            connKey = new ConnKey(serverName, connIdStr);
        }
        catch (Exception e) {
            return;
        }
        Connection conn = null;
        Cloneable cloneable = this.connTable;
        synchronized (cloneable) {
            conn = (Connection)this.connTable.get(connKey);
        }
        if (conn == null) {
            return;
        }
        if (!this.sameServerName(serverName, conn)) {
            return;
        }
        pullQ = conn.getPullQ();
        cloneable = pullQ;
        synchronized (cloneable) {
            pullQ.insertElementAt(p, 0);
            pullQ.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void retrySendPackets(Vector v, String connIdStr, String serverName) {
        ConnKey connKey;
        if (serverName == null) {
            return;
        }
        Vector pullQ = null;
        try {
            connKey = new ConnKey(serverName, connIdStr);
        }
        catch (Exception e) {
            return;
        }
        Connection conn = null;
        Cloneable cloneable = this.connTable;
        synchronized (cloneable) {
            conn = (Connection)this.connTable.get(connKey);
        }
        if (conn == null) {
            return;
        }
        if (!this.sameServerName(serverName, conn)) {
            return;
        }
        pullQ = conn.getPullQ();
        cloneable = pullQ;
        synchronized (cloneable) {
            for (int i = 0; i < v.size(); ++i) {
                pullQ.insertElementAt(v.elementAt(i), i);
            }
            pullQ.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkConnectionTimeouts() {
        Object conn;
        long now = System.currentTimeMillis();
        if (this.lastCheck != 0L && now - this.lastCheck < 5000L) {
            return;
        }
        this.lastCheck = now;
        Vector<ConnKey> removeList = new Vector<ConnKey>();
        Hashtable hashtable = this.connTable;
        synchronized (hashtable) {
            Enumeration conns = this.connTable.keys();
            while (conns.hasMoreElements()) {
                ConnKey s = (ConnKey)conns.nextElement();
                conn = (Connection)this.connTable.get(s);
                if (!((Connection)conn).checkConnectionTimeout(now)) continue;
                removeList.addElement(s);
            }
        }
        for (int i = 0; i < removeList.size(); ++i) {
            ConnKey s = (ConnKey)removeList.elementAt(i);
            Connection conn2 = null;
            conn = this.connTable;
            synchronized (conn) {
                conn2 = (Connection)this.connTable.get(s);
            }
            int connId = s.getConnId();
            this.abortServerConnection(connId, conn2);
            Hashtable hashtable2 = this.connTable;
            synchronized (hashtable2) {
                this.connTable.remove(removeList.elementAt(i));
                continue;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getServerList() {
        Vector list = new Vector();
        Hashtable hashtable = this.linkTable;
        synchronized (hashtable) {
            Enumeration e = this.linkTable.keys();
            while (e.hasMoreElements()) {
                list.addElement(e.nextElement());
            }
        }
        return list;
    }

    public int getServletPort() {
        return this.servletPort;
    }
}

