/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.httptunnel.tunnel.server;

import com.sun.messaging.jmq.httptunnel.api.server.HttpTunnelServerDriver;
import com.sun.messaging.jmq.httptunnel.api.server.HttpTunnelServerSocket;
import com.sun.messaging.jmq.httptunnel.api.share.HttpTunnelSocket;
import com.sun.messaging.jmq.httptunnel.tunnel.HttpTunnelConnection;
import com.sun.messaging.jmq.httptunnel.tunnel.HttpTunnelSocketImpl;
import java.io.IOException;
import java.util.Vector;

public class HttpTunnelServerSocketImpl
implements HttpTunnelServerSocket {
    private Vector listenQ = null;
    private boolean closed;
    private HttpTunnelServerDriver wire = null;

    @Override
    public void init(HttpTunnelServerDriver wire) throws IOException {
        this.listenQ = wire.getListenQ();
        this.closed = false;
        this.wire = wire;
        wire.listen(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpTunnelSocket accept() throws IOException {
        Vector vector = this.listenQ;
        synchronized (vector) {
            while (this.listenQ.isEmpty() && !this.closed) {
                try {
                    this.listenQ.wait(5000L);
                }
                catch (Exception e) {}
            }
            if (this.closed) {
                if (!this.listenQ.isEmpty()) {
                    this.listenQ.notifyAll();
                }
                throw new IOException("Socket closed");
            }
            HttpTunnelConnection conn = (HttpTunnelConnection)this.listenQ.elementAt(0);
            this.listenQ.removeElementAt(0);
            return new HttpTunnelSocketImpl(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        this.wire.listen(false);
        Vector vector = this.listenQ;
        synchronized (vector) {
            this.closed = true;
            this.listenQ.notifyAll();
        }
    }
}

