/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.management.agent;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.net.tls.DefaultTrustManager;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.tlsutil.KeystoreUtil;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.net.ServerSocketFactory;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.TrustManager;
import javax.rmi.ssl.SslRMIServerSocketFactory;

public class MQRMIServerSocketFactory
extends SslRMIServerSocketFactory {
    private static SSLServerSocketFactory ssfactory = null;
    private static final Object classlock = new Object();
    private String jmxHostname = null;
    private int backlog = 0;
    private boolean useSSL = false;
    protected static final Logger logger = Globals.getLogger();
    protected static final BrokerResources br = Globals.getBrokerResources();

    public MQRMIServerSocketFactory(String jmxHostname, int backlog, boolean useSSL) {
        this.jmxHostname = jmxHostname;
        this.backlog = backlog;
        this.useSSL = useSSL;
    }

    @Override
    public ServerSocket createServerSocket(int port) throws IOException {
        ServerSocket serversocket = null;
        if (this.useSSL) {
            SSLServerSocketFactory ssf = (SSLServerSocketFactory)MQRMIServerSocketFactory.getSSLServerSocketFactory();
            if (this.jmxHostname != null && !this.jmxHostname.equals("*")) {
                InetAddress bindAddr = Globals.getJMXInetAddress();
                InetSocketAddress endpoint = new InetSocketAddress(bindAddr, port);
                serversocket = (SSLServerSocket)ssf.createServerSocket();
                serversocket.setReuseAddress(true);
                serversocket.bind(endpoint, this.backlog);
            } else {
                InetSocketAddress endpoint = new InetSocketAddress(port);
                serversocket = (SSLServerSocket)ssf.createServerSocket();
                serversocket.setReuseAddress(true);
                serversocket.bind(endpoint, this.backlog);
            }
        } else if (this.jmxHostname != null && !this.jmxHostname.equals("*")) {
            InetAddress bindAddr = Globals.getJMXInetAddress();
            InetSocketAddress endpoint = new InetSocketAddress(bindAddr, port);
            serversocket = new ServerSocket();
            serversocket.setReuseAddress(true);
            serversocket.bind(endpoint, this.backlog);
        } else {
            InetSocketAddress endpoint = new InetSocketAddress(port);
            serversocket = new ServerSocket();
            serversocket.setReuseAddress(true);
            serversocket.bind(endpoint, this.backlog);
        }
        return serversocket;
    }

    public String toString() {
        return "jmxHostname=" + this.jmxHostname + ",backlog=" + this.backlog + ",useSSL=" + this.useSSL;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof MQRMIServerSocketFactory)) {
            return false;
        }
        MQRMIServerSocketFactory that = (MQRMIServerSocketFactory)obj;
        if (this.jmxHostname != null ? that.jmxHostname == null || !that.jmxHostname.equals(this.jmxHostname) : that.jmxHostname != null) {
            return false;
        }
        if (this.backlog != that.backlog) {
            return false;
        }
        return this.useSSL == that.useSSL;
    }

    @Override
    public int hashCode() {
        return this.toString().hashCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ServerSocketFactory getSSLServerSocketFactory() throws IOException {
        Object object = classlock;
        synchronized (object) {
            if (ssfactory == null) {
                try {
                    KeyManagerFactory kmf;
                    String keystore_location = KeystoreUtil.getKeystoreLocation();
                    File kf = new File(keystore_location);
                    if (!kf.exists()) {
                        throw new IOException(br.getKString("B3019", keystore_location));
                    }
                    String pass_phrase = KeystoreUtil.getKeystorePassword();
                    if (pass_phrase == null) {
                        pass_phrase = "";
                        logger.log(32, br.getKString("B3021"));
                    }
                    char[] passphrase = pass_phrase.toCharArray();
                    SSLContext ctx = SSLContext.getInstance("TLS");
                    try {
                        kmf = KeyManagerFactory.getInstance("SunX509");
                    }
                    catch (NoSuchAlgorithmException e) {
                        String defaultAlg = KeyManagerFactory.getDefaultAlgorithm();
                        logger.log(8, br.getKString("B1312", e.getMessage(), defaultAlg));
                        kmf = KeyManagerFactory.getInstance(defaultAlg);
                    }
                    KeyStore ks = KeyStore.getInstance("JKS");
                    ks.load(new FileInputStream(keystore_location), passphrase);
                    kmf.init(ks, passphrase);
                    TrustManager[] tm = new TrustManager[]{new DefaultTrustManager()};
                    SecureRandom random = SecureRandom.getInstance("SHA1PRNG");
                    ctx.init(kmf.getKeyManagers(), null, random);
                    ssfactory = ctx.getServerSocketFactory();
                }
                catch (IOException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new IOException(e.toString());
                }
            }
            return ssfactory;
        }
    }
}

