/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.bdb;

import com.sleepycat.je.Cursor;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.persist.api.Store;
import com.sun.messaging.jmq.jmsserver.persist.bdb.DstMsgStore;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import java.util.Enumeration;
import java.util.NoSuchElementException;

public class MessageEnumeration
implements Enumeration {
    Store store = null;
    Database msgdb = null;
    Packet nextPacket = null;
    Cursor cs = null;

    protected MessageEnumeration(Database msgdb, Store store) throws BrokerException {
        this.msgdb = msgdb;
        this.store = store;
        if (msgdb != null) {
            try {
                this.cs = msgdb.openCursor(null, null);
            }
            catch (Exception e) {
                throw new BrokerException("Failed to open cursor for message enumeration of " + msgdb.getDatabaseName());
            }
        }
    }

    @Override
    public boolean hasMoreElements() {
        if (this.msgdb == null) {
            this.nextPacket = null;
            return false;
        }
        try {
            DatabaseEntry key = new DatabaseEntry();
            DatabaseEntry data = new DatabaseEntry();
            if (this.cs.getNext(key, data, LockMode.DEFAULT) == OperationStatus.NOTFOUND) {
                return false;
            }
            this.nextPacket = DstMsgStore.parseMessage(data.getData());
        }
        catch (Throwable e) {
            this.nextPacket = null;
            Globals.getLogger().logStack(32, e.getMessage(), e);
            this.close();
        }
        return this.nextPacket != null;
    }

    public Object nextElement() {
        if (this.nextPacket == null) {
            throw new NoSuchElementException();
        }
        if (this.store.isClosed()) {
            this.close();
            throw new NoSuchElementException(Globals.getBrokerResources().getKString("B1341"));
        }
        return this.nextPacket;
    }

    public void cancel() {
        this.close();
    }

    public void close() {
        if (this.cs == null) {
            return;
        }
        try {
            this.cs.close();
        }
        catch (Exception e) {
            Globals.getLogger().log(16, "XXX Failed to close cursor of message enumeration from " + this.msgdb.getDatabaseName() + ": " + e.getMessage());
        }
    }
}

