/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.bdb;

import com.sleepycat.je.Cursor;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.Transaction;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.persist.api.Store;
import com.sun.messaging.jmq.jmsserver.persist.bdb.BDBStore;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.log.Logger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.LinkedHashMap;

class TakeoverSessionStore {
    Logger logger = Globals.getLogger();
    BrokerResources br = Globals.getBrokerResources();
    protected static final String NEW_INHERENTED = "NEW_INHERENTED:";
    protected static final String NEW_CREATED = "NEW_CREATED:";
    protected static final String NOT_NEW = ":";
    protected static final String TAKEOVER_ME = "TAKEOVER_ME:";
    protected static final String[] OWNER_STATES = new String[]{":", "NEW_INHERENTED:", "NEW_CREATED:", "TAKEOVER_ME:"};
    protected static final String TAKEOVER_PREPARE = "TAKEOVER_PREPARE:";
    protected static final String TAKEOVER_PREPARED = "TAKEOVER_PREPARED:";
    protected static final String TAKEOVER_COMMITTED = "TAKEOVER_COMMITTED:";
    protected static final String TAKEOVER_MERGED = "TAKEOVER_MERGED:";
    private BDBStore parent = null;
    private Database db = null;

    protected TakeoverSessionStore(BDBStore p) {
        this.parent = p;
        this.db = p.getTakeoverSessionDatabase();
    }

    protected void storeTakeoverSession(Transaction txn, String session, String state, boolean overide, String[] expectedStates) throws BrokerException {
        try {
            DatabaseEntry key = new DatabaseEntry(session.getBytes("UTF-8"));
            DatabaseEntry data = new DatabaseEntry(state.getBytes("UTF-8"));
            OperationStatus status = this.db.putNoOverwrite(txn, key, data);
            if (status == OperationStatus.KEYEXIST) {
                if (!overide) {
                    String currstate = this.getTakeoverSessionState(txn, session);
                    String emsg = "Store session " + session + " exists with state " + currstate;
                    if (expectedStates != null) {
                        int len = expectedStates.length;
                        for (int i = 0; i < len; ++i) {
                            if (!currstate.startsWith(expectedStates[i])) continue;
                            return;
                        }
                    }
                    this.logger.log(32, emsg);
                    throw new BrokerException(emsg);
                }
                this.updateTakeoverSessionState(txn, session, state, expectedStates);
            }
        }
        catch (Exception e) {
            String emsg = "Store takeover session " + session + " failed";
            this.logger.log(32, emsg);
            throw new BrokerException(emsg, e);
        }
    }

    protected void updateTakeoverSessionState(Transaction txn, String session, String state, String[] expectedStates) throws BrokerException {
        try {
            DatabaseEntry key = new DatabaseEntry(session.getBytes("UTF-8"));
            DatabaseEntry data = new DatabaseEntry();
            OperationStatus status = this.db.get(txn, key, data, null);
            if (status == OperationStatus.NOTFOUND) {
                String emsg = "Takeover session " + session + " not found in store";
                this.logger.log(32, emsg);
                throw new BrokerException(emsg);
            }
            String oldstate = new String(data.getData(), "UTF-8");
            if (expectedStates != null) {
                boolean override = false;
                int len = expectedStates.length;
                for (int i = 0; i < len; ++i) {
                    if (!oldstate.startsWith(expectedStates[i])) continue;
                    override = true;
                    break;
                }
                if (!override) {
                    String emsg = "Unexpected existing state " + oldstate + ", new state " + state + ", expected states" + expectedStates[0] + " for store session " + session;
                    this.logger.log(32, emsg);
                    throw new BrokerException(emsg);
                }
            }
            data = new DatabaseEntry(state.getBytes("UTF-8"));
            status = this.db.put(txn, key, data);
        }
        catch (Exception e) {
            String emsg = "Update store session " + session + " state " + state + " failed";
            this.logger.log(32, emsg);
            throw new BrokerException(emsg, e);
        }
    }

    protected String getTakeoverSessionState(Transaction txn, String session) throws BrokerException {
        try {
            DatabaseEntry key = new DatabaseEntry(session.getBytes("UTF-8"));
            DatabaseEntry data = new DatabaseEntry();
            OperationStatus status = this.db.get(txn, key, data, null);
            if (status == OperationStatus.NOTFOUND) {
                String emsg = "Takeover session " + session + " not found in store";
                this.logger.log(32, emsg);
                throw new BrokerException(emsg);
            }
            return new String(data.getData(), "UTF-8");
        }
        catch (Exception e) {
            String emsg = "get takeover session " + session + " state failed";
            this.logger.log(32, emsg);
            throw new BrokerException(emsg, e);
        }
    }

    protected LinkedHashMap getAllTakeoverSessions(Transaction txn) throws BrokerException {
        LinkedHashMap<String, String> sessions = new LinkedHashMap<String, String>();
        Cursor cs = null;
        try {
            DatabaseEntry key = new DatabaseEntry();
            DatabaseEntry data = new DatabaseEntry();
            String session = null;
            String state = null;
            cs = this.db.openCursor(txn, null);
            while (cs.getNext(key, data, LockMode.DEFAULT) == OperationStatus.SUCCESS) {
                session = new String(key.getData(), "UTF-8");
                state = new String(data.getData(), "UTF-8");
                sessions.put(session, state);
            }
            cs.close();
            LinkedHashMap<String, String> linkedHashMap = sessions;
            return linkedHashMap;
        }
        catch (Exception e) {
            String emsg = "Get all takeoverSessions failed";
            this.logger.logStack(32, emsg, e);
            throw new BrokerException(emsg, e);
        }
        finally {
            if (cs != null) {
                try {
                    cs.close();
                }
                catch (Exception e) {
                    this.logger.log(16, "Failed to close cursor in getting all takeover sessions from store: " + e.getMessage());
                }
            }
        }
    }

    protected ArrayList<String> getTakeoverSessionsByStates(Transaction txn, String[] states) throws BrokerException {
        ArrayList<String> sessions = new ArrayList<String>();
        Cursor cs = null;
        try {
            DatabaseEntry key = new DatabaseEntry();
            DatabaseEntry data = new DatabaseEntry();
            String st = null;
            String ss = null;
            cs = this.db.openCursor(txn, null);
            while (cs.getNext(key, data, LockMode.DEFAULT) == OperationStatus.SUCCESS) {
                ss = new String(key.getData(), "UTF-8");
                st = new String(data.getData(), "UTF-8");
                for (int i = 0; i < states.length; ++i) {
                    if (!st.startsWith(states[i])) continue;
                    if (Store.getDEBUG()) {
                        this.logger.log(8, "getTakeoverSessionsByStates(" + states[i] + "): ss=" + ss + ", st=" + st);
                    }
                    if (sessions.contains(ss)) continue;
                    sessions.add(ss);
                }
            }
            cs.close();
            ArrayList<String> arrayList = sessions;
            return arrayList;
        }
        catch (Exception e) {
            String emsg = "Get takeoverSessionsByState " + Arrays.toString(states) + " failed";
            this.logger.logStack(32, emsg, e);
            throw new BrokerException(emsg, e);
        }
        finally {
            if (cs != null) {
                try {
                    cs.close();
                }
                catch (Exception e) {
                    this.logger.log(16, "Failed to close cursor in getting takeover sessions by state from store: " + e.getMessage());
                }
            }
        }
    }

    protected Hashtable getDebugState() {
        Hashtable<String, Object> t = new Hashtable<String, Object>();
        t.put("dbCount", String.valueOf(this.db.count()));
        t.put("dbConfig", this.db.getConfig().toString());
        try {
            t.put("takeoverSessions", this.getAllTakeoverSessions(null));
        }
        catch (Exception e) {
            this.logger.logStack(32, "Unable to get takeover sessions", e);
        }
        return t;
    }

    protected void close() {
        if (Store.getDEBUG()) {
            this.logger.log(8, "TakeoverSessionStore: closing with " + this.db.count() + " entries");
        }
    }
}

