/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.coherence;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.Consumer;
import com.sun.messaging.jmq.jmsserver.persist.api.Store;
import com.sun.messaging.jmq.jmsserver.persist.coherence.CoherenceStore;
import com.sun.messaging.jmq.jmsserver.persist.coherence.StoreEntryProcessor;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.log.Logger;
import com.tangosol.net.CacheFactory;
import com.tangosol.net.NamedCache;
import com.tangosol.util.InvocableMap;
import java.io.IOException;
import java.util.Hashtable;

class InterestStore {
    Logger logger = Globals.getLogger();
    BrokerResources br = Globals.getBrokerResources();
    private NamedCache interestcache = null;

    InterestStore(CoherenceStore s) {
        this.interestcache = CacheFactory.getCache((String)(s.getCacheNamePrefix() + "interestcache"));
    }

    protected void storeInterest(Consumer interest) throws IOException, BrokerException {
        String id = interest.getConsumerUID().toString();
        Object o = null;
        try {
            o = this.interestcache.invoke((Object)id, (InvocableMap.EntryProcessor)new StoreEntryProcessor(interest));
        }
        catch (Exception e) {
            String emsg = this.br.getKString("B4012", id);
            this.logger.log(32, emsg, e);
            throw new BrokerException(emsg, e);
        }
        if (o.equals(false)) {
            String emsg = this.br.getKString("B3010", id, interest.getDestinationUID().getLongString());
            this.logger.log(32, emsg);
            throw new BrokerException(emsg);
        }
    }

    protected void removeInterest(Consumer interest) throws IOException, BrokerException {
        String id = interest.getConsumerUID().toString();
        try {
            Object old = this.interestcache.remove((Object)id);
            if (old == null) {
                this.logger.log(32, "B3011", (Object)id, interest.getDestinationUID().getLongString());
                throw new BrokerException(this.br.getString("B3011", id, interest.getDestinationUID().getLongString()));
            }
        }
        catch (RuntimeException e) {
            this.logger.log(32, "B4034", id);
            throw new BrokerException(this.br.getString("B4034", id), e);
        }
    }

    protected Consumer[] getAllInterests() throws IOException {
        return this.interestcache.values().toArray(new Consumer[0]);
    }

    protected void clearAll() {
        if (Store.getDEBUG()) {
            this.logger.log(8, "InterestStore.clearAll()");
        }
        this.interestcache.destroy();
    }

    protected void close(boolean cleanup) {
        if (Store.getDEBUG()) {
            this.logger.log(8, "InterestStore.close(" + cleanup + ")" + this.interestcache.size() + " interests");
        }
        this.interestcache.release();
    }

    protected Hashtable getDebugState() {
        Hashtable<String, String> t = new Hashtable<String, String>();
        t.put("Interests", String.valueOf(this.interestcache.size()));
        return t;
    }
}

