/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.inmemory;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.persist.api.ChangeRecordInfo;
import com.sun.messaging.jmq.jmsserver.persist.api.Store;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;

class ConfigRecordStore {
    Logger logger = Globals.getLogger();
    BrokerResources br = Globals.getBrokerResources();
    private ArrayList timeList = new ArrayList(32);
    private ArrayList recordList = new ArrayList(32);

    ConfigRecordStore() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void storeConfigChangeRecord(long timestamp, byte[] recordData, boolean sync) throws BrokerException {
        ArrayList arrayList = this.timeList;
        synchronized (arrayList) {
            this.timeList.add(new Long(timestamp));
            this.recordList.add(recordData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<ChangeRecordInfo> getConfigChangeRecordsSince(long timestamp) {
        ArrayList<ChangeRecordInfo> records = new ArrayList<ChangeRecordInfo>();
        ArrayList arrayList = this.timeList;
        synchronized (arrayList) {
            Long stamp;
            int i;
            int size = this.timeList.size();
            for (i = 0; i < size && (stamp = (Long)this.timeList.get(i)) <= timestamp; ++i) {
            }
            while (i < size) {
                records.add(new ChangeRecordInfo((byte[])this.recordList.get(i), (Long)this.timeList.get(i)));
                ++i;
            }
            return records;
        }
    }

    public List<ChangeRecordInfo> getAllConfigRecords() throws BrokerException {
        ArrayList<ChangeRecordInfo> records = new ArrayList<ChangeRecordInfo>();
        for (int i = 0; i < this.timeList.size(); ++i) {
            records.add(new ChangeRecordInfo((byte[])this.recordList.get(i), (Long)this.timeList.get(i)));
        }
        return records;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearAll() throws BrokerException {
        if (Store.getDEBUG()) {
            this.logger.log(1, "ConfigRecordStore.clearAll() called");
        }
        ArrayList arrayList = this.timeList;
        synchronized (arrayList) {
            this.timeList.clear();
            this.recordList.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close(boolean cleanup) {
        if (Store.getDEBUG()) {
            this.logger.log(1, "ConfigRecordStore: closing, " + this.timeList.size() + " in-memory records");
        }
        ArrayList arrayList = this.timeList;
        synchronized (arrayList) {
            this.timeList.clear();
            this.recordList.clear();
        }
    }

    Hashtable getDebugState() {
        Hashtable<String, String> t = new Hashtable<String, String>();
        t.put("Config change records", String.valueOf(this.timeList.size()));
        return t;
    }

    void printInfo(PrintStream out) {
        out.println("\nConfiguration Change Record");
        out.println("---------------------------");
        out.println("number of records: " + this.timeList.size());
    }
}

