/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.service.imq.grizzly;

import com.sun.messaging.jmq.jmsserver.Broker;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.license.LicenseBase;
import com.sun.messaging.jmq.jmsserver.net.Protocol;
import com.sun.messaging.jmq.jmsserver.net.ProtocolCallback;
import com.sun.messaging.jmq.jmsserver.net.ProtocolStreams;
import com.sun.messaging.jmq.jmsserver.net.tcp.TcpProtocol;
import com.sun.messaging.jmq.jmsserver.service.imq.grizzly.GrizzlyIPService;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.jmsservice.BrokerEvent;
import java.io.IOException;
import java.nio.channels.spi.AbstractSelectableChannel;
import java.util.HashMap;
import java.util.Map;

public class GrizzlyProtocolImpl
implements Protocol {
    private static final int defaultReadTimeout = 0;
    private static final int defaultLingerTimeout = 0;
    private static final int defaultBacklog = 100;
    private static final int defaultPort = 8888;
    private static Boolean TLS_ALLOWED = null;
    private boolean requireClientAuth = false;
    private GrizzlyIPService service = null;
    private String proto = null;
    private String modelName = null;
    private int readTimeout = 0;
    private int lingerTimeout = 0;
    private int backlog = 100;
    private boolean tcpNoDelay = true;
    private int inputBufferSize = 0;
    private int outputBufferSize = 0;
    protected int port = 8888;
    protected String hostname = null;
    private int minThreads = 4;
    private int maxThreads = 10;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public GrizzlyProtocolImpl(GrizzlyIPService s, String proto) {
        this.service = s;
        this.proto = proto;
        if (!proto.equals("tls")) return;
        Class<GrizzlyProtocolImpl> clazz = GrizzlyProtocolImpl.class;
        synchronized (GrizzlyProtocolImpl.class) {
            if (TLS_ALLOWED == null) {
                try {
                    LicenseBase license = Globals.getCurrentLicense(null);
                    TLS_ALLOWED = license.getBooleanProperty("imq.enable_ssl", false);
                }
                catch (BrokerException ex) {
                    TLS_ALLOWED = Boolean.FALSE;
                }
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            if (TLS_ALLOWED.booleanValue()) return;
            String emsg = Globals.getBrokerResources().getKString("B3123", Globals.getBrokerResources().getString("B0036"));
            Globals.getLogger().log(32, emsg);
            Broker.getBroker().exit(1, emsg, BrokerEvent.Type.FATAL_ERROR);
            return;
        }
    }

    protected String getType() {
        return this.proto;
    }

    @Override
    public void setNoDelay(boolean v) {
        this.tcpNoDelay = v;
    }

    protected boolean getNoDelay() {
        return this.tcpNoDelay;
    }

    protected int getLingerTimeout() {
        return this.lingerTimeout;
    }

    @Override
    public void setTimeout(int time) {
        this.readTimeout = time;
    }

    protected int getTimeout() {
        return this.readTimeout;
    }

    protected int getBacklog() {
        return this.backlog;
    }

    @Override
    public void setInputBufferSize(int size) {
        this.inputBufferSize = size;
    }

    @Override
    public void setOutputBufferSize(int size) {
        this.outputBufferSize = size;
    }

    @Override
    public int getInputBufferSize() {
        return this.inputBufferSize;
    }

    @Override
    public int getOutputBufferSize() {
        return this.outputBufferSize;
    }

    @Override
    public boolean getBlocking() {
        throw new UnsupportedOperationException("Unsupported call: " + this.getClass().getName() + ".getBlocking");
    }

    protected boolean getRequireClientAuth() {
        return this.requireClientAuth;
    }

    @Override
    public void registerProtocolCallback(ProtocolCallback cb, Object callback_data) {
        throw new RuntimeException("Unsupported call: " + this.getClass().getName() + ".registerProtocolCallback()");
    }

    protected void notifyProtocolCallback() {
        throw new RuntimeException("Unsupported call: " + this.getClass().getName() + ".notifyProtocolCallback()");
    }

    @Override
    public boolean canPause() {
        throw new RuntimeException("Unsupported call: " + this.getClass().getName() + ".canPause()");
    }

    @Override
    public void configureBlocking(boolean blocking) throws UnsupportedOperationException, IOException {
        throw new UnsupportedOperationException("Unsupported call: " + this.getClass().getName() + ".configureBlocking");
    }

    @Override
    public AbstractSelectableChannel getChannel() throws IOException {
        return null;
    }

    @Override
    public ProtocolStreams accept() throws IOException {
        throw new UnsupportedOperationException("GrizzlyProtocolImpl:accept");
    }

    @Override
    public void open() throws IOException, IllegalStateException {
    }

    @Override
    public boolean isOpen() {
        return this.service.isOpen();
    }

    @Override
    public void close() throws IOException, IllegalStateException {
    }

    @Override
    public void checkParameters(Map params) throws IllegalArgumentException {
        TcpProtocol.checkTcpParameters(params);
    }

    @Override
    public Map setParameters(Map params) throws IOException {
        boolean newhost;
        if (params.get("serviceFactoryHandlerName") != null) {
            this.modelName = (String)params.get("serviceFactoryHandlerName");
        }
        HashMap<String, String> oldparams = null;
        int newport = TcpProtocol.getIntValue("port", params, this.port);
        this.readTimeout = TcpProtocol.getIntValue("readtimeout", params, this.readTimeout);
        this.lingerTimeout = TcpProtocol.getIntValue("solinger", params, this.lingerTimeout);
        int newbacklog = TcpProtocol.getIntValue("backlog", params, this.backlog);
        String newhostname = (String)params.get("hostname");
        if (newhostname == null) {
            newhostname = Globals.getHostname();
        }
        if (newhostname == null || newhostname.trim().length() == 0) {
            newhostname = "*";
        }
        int oldport = this.port;
        int oldbacklog = this.backlog;
        boolean bl = newhost = newhostname == null && this.hostname != null || newhostname != null && this.hostname == null || newhostname != null && this.hostname != null && !newhostname.equals(this.hostname);
        if (newport != this.port || newbacklog != this.backlog || newhost) {
            oldparams = new HashMap<String, String>();
            if (newport != -1) {
                oldparams.put("port", String.valueOf(this.port));
                this.port = newport;
            }
            if (newbacklog != -1) {
                oldparams.put("backlog", String.valueOf(this.backlog));
                this.backlog = newbacklog;
            }
            if (newhost) {
                oldparams.put("hostname", this.hostname == null ? "" : this.hostname);
                this.hostname = newhostname;
            }
        }
        if (this.proto.equals("tls")) {
            this.requireClientAuth = TcpProtocol.getBooleanValue("requireClientAuth", params, this.requireClientAuth);
        }
        return oldparams;
    }

    @Override
    public int getLocalPort() {
        return this.service.getLocalPort();
    }

    @Override
    public String getHostName() {
        if (this.hostname == null || this.hostname.equals("") || this.hostname.equals("*")) {
            return null;
        }
        return this.hostname;
    }

    public int getPort() {
        return this.port;
    }

    protected void setMinMaxThreads(int min, int max, String svcname) throws IllegalArgumentException {
        int tmpmin = min;
        int tmpmax = max;
        tmpmin = tmpmin <= -1 ? this.minThreads : (int)((float)(min / 2));
        if ((tmpmax = tmpmax <= -1 ? this.maxThreads : (int)((float)(max / 2))) == 0) {
            throw new IllegalArgumentException(Globals.getBrokerResources().getKString("B4136", svcname, String.valueOf(max)));
        }
        if (tmpmin > tmpmax) {
            throw new IllegalArgumentException(Globals.getBrokerResources().getKString("B4110", String.valueOf(min), String.valueOf(max)));
        }
        this.minThreads = tmpmin;
        this.maxThreads = tmpmax;
    }

    protected int getMinThreads() {
        return this.minThreads;
    }

    protected int getMaxThreads() {
        return this.maxThreads;
    }

    public String toString() {
        return this.getType() + "(host = " + (this.hostname == null ? "*" : this.hostname) + ", port=" + this.port + ", mode=" + this.modelName + ")";
    }
}

