/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.bridge.service.stomp;

import com.sun.messaging.bridge.api.BridgeContext;
import com.sun.messaging.bridge.api.MessageTransformer;
import com.sun.messaging.bridge.service.stomp.NotConnectedException;
import com.sun.messaging.bridge.service.stomp.StompConnection;
import com.sun.messaging.bridge.service.stomp.StompFrameMessage;
import com.sun.messaging.bridge.service.stomp.StompOutputHandler;
import com.sun.messaging.bridge.service.stomp.StompProtocolException;
import com.sun.messaging.bridge.service.stomp.StompSenderSession;
import com.sun.messaging.bridge.service.stomp.StompServer;
import com.sun.messaging.bridge.service.stomp.StompSubscriberSession;
import com.sun.messaging.bridge.service.stomp.StompTransactedSession;
import com.sun.messaging.bridge.service.stomp.UnrecoverableAckFailureException;
import com.sun.messaging.bridge.service.stomp.resources.StompBridgeResources;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.TextMessage;
import javax.jms.Topic;
import org.glassfish.grizzly.filterchain.FilterChainContext;

public class StompProtocolHandler {
    private Logger _logger = null;
    private static final String DEFAULT_SUBID_PREFIX = "/subscription-to/";
    private static final String MQ_TEMP_QUEUE_PREFIX = "temporary_destination://queue/";
    private static final String MQ_TEMP_TOPIC_PREFIX = "temporary_destination://topic/";
    private StompConnection _stompConnection = null;
    private Map<String, TemporaryQueue> _tempQueues = Collections.synchronizedMap(new HashMap());
    private Map<String, TemporaryTopic> _tempTopics = Collections.synchronizedMap(new HashMap());
    private Map<String, TemporaryQueue> _mqtempQueues = Collections.synchronizedMap(new HashMap());
    private Map<String, TemporaryTopic> _mqtempTopics = Collections.synchronizedMap(new HashMap());
    private List<String> _subids = Collections.synchronizedList(new ArrayList());
    private StompBridgeResources _sbr = null;

    public StompProtocolHandler(BridgeContext bc, Properties jmsprop) {
        this._logger = StompServer.logger();
        this._sbr = StompServer.getStompBridgeResources();
        this._stompConnection = new StompConnection(bc, jmsprop, this);
    }

    public void close(boolean spawnthread) {
        this._logger.log(Level.INFO, this._sbr.getKString("BSS1008", this._stompConnection) + "(" + spawnthread + ")");
        if (!spawnthread) {
            try {
                this._stompConnection.disconnect(false);
                return;
            }
            catch (Throwable t) {
                this._logger.log(Level.WARNING, this._sbr.getKString("BSS2003", this._stompConnection.toString(), t.getMessage()));
            }
        }
        Thread thr = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Logger logger = StompProtocolHandler.this._logger;
                    StompBridgeResources stompBridgeResources = StompProtocolHandler.this._sbr;
                    StompProtocolHandler.this._sbr;
                    logger.log(Level.INFO, stompBridgeResources.getKString("BSS1008", StompProtocolHandler.this._stompConnection));
                    StompProtocolHandler.this._stompConnection.disconnect(false);
                }
                catch (Throwable t) {
                    Logger logger = StompProtocolHandler.this._logger;
                    StompBridgeResources stompBridgeResources = StompProtocolHandler.this._sbr;
                    StompProtocolHandler.this._sbr;
                    logger.log(Level.WARNING, stompBridgeResources.getKString("BSS2003", StompProtocolHandler.this._stompConnection.toString(), t.getMessage()));
                }
            }
        });
        thr.setName("SpawnedClosingThread");
        thr.setDaemon(true);
        thr.start();
    }

    public void onCONNECT(StompFrameMessage message, StompOutputHandler out, FilterChainContext ctx) {
        StompFrameMessage reply = null;
        try {
            String login = message.getHeader("login".toString());
            if (this._logger.isLoggable(Level.FINE)) {
                this._logger.log(Level.FINE, "on" + (Object)((Object)message.getCommand()) + ", login=" + login);
            }
            String passcode = message.getHeader("passcode".toString());
            String clientid = message.getHeader("client-id".toString());
            String id = this._stompConnection.connect(login, passcode, clientid);
            reply = new StompFrameMessage(StompFrameMessage.Command.CONNECTED);
            reply.addHeader("session".toString(), id);
            String requestid = message.getHeader("receipt".toString());
            if (requestid != null) {
                reply.addHeader("receipt-id".toString(), requestid);
            }
            out.sendToClient(reply, ctx, this);
        }
        catch (Exception e) {
            Object[] eparam = new String[]{message.getCommand().toString(), e.getMessage(), this._stompConnection.toString()};
            this._logger.log(Level.SEVERE, this._sbr.getKString("BSS3002", eparam), e);
            try {
                reply = StompProtocolHandler.toStompErrorMessage(StompFrameMessage.Command.CONNECT.toString(), e);
                out.sendToClient(reply, ctx, this);
            }
            catch (Exception ee) {
                this._logger.log(Level.WARNING, this._sbr.getKString("BSS3001", e.getMessage(), ee.getMessage()), ee);
                return;
            }
        }
    }

    public void onDISCONNECT(StompFrameMessage message, StompOutputHandler out, FilterChainContext ctx) {
        try {
            if (this._logger.isLoggable(Level.FINE)) {
                this._logger.log(Level.FINE, "on" + (Object)((Object)message.getCommand()));
            }
            this._stompConnection.disconnect(true);
            StompFrameMessage reply = StompProtocolHandler.getStompReceiptMessage(message);
            if (reply != null) {
                out.sendToClient(reply, ctx, this);
            }
        }
        catch (Exception e) {
            Object[] eparam = new String[]{message.getCommand().toString(), e.getMessage(), this._stompConnection.toString()};
            if (e instanceof NotConnectedException) {
                this._logger.log(Level.SEVERE, this._sbr.getKString("BSS3002", eparam));
                return;
            }
            this._logger.log(Level.SEVERE, this._sbr.getKString("BSS3002", eparam), e);
            try {
                StompFrameMessage err = StompProtocolHandler.toStompErrorMessage(StompFrameMessage.Command.DISCONNECT.toString(), e);
                out.sendToClient(err, ctx, this);
            }
            catch (Exception ee) {
                this._logger.log(Level.WARNING, this._sbr.getKString("BSS3001", e.getMessage(), ee.getMessage()), ee);
                return;
            }
        }
    }

    public void onSEND(StompFrameMessage message, StompOutputHandler out, FilterChainContext ctx) {
        StompFrameMessage reply = null;
        Message jmsmsg = null;
        StompSenderSession ss = null;
        try {
            String tid;
            LinkedHashMap<String, String> headers = new LinkedHashMap<String, String>();
            headers.putAll(message.getHeaders());
            if (this._logger.isLoggable(Level.FINE)) {
                this._logger.log(Level.FINE, "on" + (Object)((Object)message.getCommand()) + ", headers=" + headers);
            }
            if ((tid = (String)headers.remove("transaction".toString())) != null) {
                ss = this._stompConnection.getTransactedSession(tid);
                this._logger.log(Level.FINE, "Sending message on transacted session: " + ss + " for transaction " + tid);
            } else {
                ss = this._stompConnection.getSenderSession();
            }
            if (message.getContentLength() != -1) {
                headers.remove("content-length".toString());
                jmsmsg = ss.getJMSSession().createBytesMessage();
                ((BytesMessage)jmsmsg).writeBytes(message.getBody());
            } else {
                jmsmsg = ss.getJMSSession().createTextMessage();
                jmsmsg.setText(message.getBodyText());
            }
            String stompdest = (String)headers.remove("destination".toString());
            Destination jmsdest = this.toJMSDestination(stompdest, ss.getJMSSession(), false);
            MessageProducer jmspub = ss.getJMSProducer();
            int priority = jmspub.getPriority();
            String v = (String)headers.remove("priority".toString());
            if (v != null) {
                priority = Integer.parseInt(v);
            }
            int deliveryMode = jmspub.getDeliveryMode();
            v = (String)headers.remove("persistent".toString());
            if (v != null) {
                deliveryMode = Boolean.valueOf(v) != false ? 2 : 1;
            }
            long timeToLive = jmspub.getTimeToLive();
            v = (String)headers.remove("expires".toString());
            if (v != null) {
                timeToLive = Long.parseLong(v);
            }
            jmsmsg.setJMSCorrelationID((String)headers.remove("correlation-id".toString()));
            v = (String)headers.remove("type".toString());
            if (v != null) {
                jmsmsg.setJMSType(v);
            }
            if ((v = (String)headers.remove("reply-to".toString())) != null) {
                jmsmsg.setJMSReplyTo(this.toJMSDestination(v, ss.getJMSSession(), false));
            }
            v = (String)headers.remove("receipt");
            MessageTransformer<Message, Message> mt = StompServer.getMessageTransformer();
            Properties props = null;
            if (mt != null) {
                props = new Properties();
            }
            String key = null;
            String val = null;
            String h = null;
            Iterator itr = headers.keySet().iterator();
            while (itr.hasNext()) {
                key = (String)itr.next();
                val = (String)headers.get(key);
                h = key + ":" + val;
                if (this._logger.isLoggable(Level.FINE)) {
                    this._logger.log(Level.FINE, "Setting header " + h + " as JMS message property");
                }
                try {
                    jmsmsg.setStringProperty(key, val);
                    itr.remove();
                }
                catch (JMSException e) {
                    if (mt == null) {
                        throw e;
                    }
                    props.setProperty(key, val);
                    if (this._logger.isLoggable(Level.FINE)) {
                        this._logger.log(Level.WARNING, this._sbr.getKString("BSS2004", h, e.getMessage()), e);
                    } else {
                        this._logger.log(Level.WARNING, this._sbr.getKString("BSS2004", h, e.getMessage()));
                    }
                    this._logger.log(Level.INFO, this._sbr.getString("BSS1009", h, mt.getClass().getName()));
                }
            }
            if (mt != null) {
                mt.init(ss.getJMSSession(), "STOMP");
                jmsmsg = mt.transform(jmsmsg, false, "UTF-8", "STOMP", "SUN_MQ", props);
                if (jmsmsg == null) {
                    throw new JMSException("null returned from " + mt.getClass().getName() + " transform() method");
                }
            }
            jmspub.send(jmsdest, jmsmsg, deliveryMode, priority, timeToLive);
            this._logger.log(Level.FINE, "Sent message " + jmsmsg.getJMSMessageID());
            reply = StompProtocolHandler.getStompReceiptMessage(message);
            if (reply != null) {
                out.sendToClient(reply, ctx, this);
            }
        }
        catch (Throwable e) {
            Object[] eparam = new String[]{message.getCommand().toString(), e.getMessage(), this._stompConnection.toString()};
            this._logger.log(Level.SEVERE, this._sbr.getKString("BSS3002", eparam), e);
            try {
                reply = StompProtocolHandler.toStompErrorMessage(StompFrameMessage.Command.SEND.toString(), e);
                out.sendToClient(reply, ctx, this);
            }
            catch (Exception ee) {
                this._logger.log(Level.WARNING, this._sbr.getKString("BSS3001", e.getMessage(), ee.getMessage()), ee);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onSUBSCRIBE(StompFrameMessage message, StompOutputHandler out, FilterChainContext ctx, StompOutputHandler aout) throws Exception {
        StompFrameMessage reply = null;
        String subid = null;
        String duraname = null;
        boolean created = false;
        try {
            LinkedHashMap<String, String> headers = message.getHeaders();
            if (this._logger.isLoggable(Level.FINE)) {
                this._logger.log(Level.FINE, "on" + (Object)((Object)message.getCommand()) + ", headers=" + headers);
            }
            String tid = (String)((HashMap)headers).get("transaction".toString());
            subid = (String)((HashMap)headers).get("id".toString());
            String ack = (String)((HashMap)headers).get("ack".toString());
            int ackMode = 1;
            if (ack != null && ack.equals("client".toString())) {
                ackMode = 2;
            }
            String selector = (String)((HashMap)headers).get("selector".toString());
            String stompdest = (String)((HashMap)headers).get("destination".toString());
            if (stompdest == null) {
                throw new StompProtocolException("SUBSCRIBE without destination header!");
            }
            if (subid == null) {
                subid = StompProtocolHandler.makeDefaultSubscriberId(stompdest);
            }
            if (this._subids.contains(subid)) {
                throw new StompProtocolException(this._sbr.getKString("BSS4018", subid));
            }
            boolean nolocal = false;
            String val = (String)((HashMap)headers).get("no-local".toString());
            if (val != null && val.equalsIgnoreCase("true")) {
                nolocal = true;
            }
            duraname = (String)((HashMap)headers).get("durable-subscriber-name".toString());
            if (tid == null) {
                StompSubscriberSession ss = this._stompConnection.createSubscriberSession(subid, ackMode);
                created = true;
                ss.createSubscriber(this.toJMSDestination(stompdest, ss.getJMSSession(), true), selector, duraname, nolocal, aout);
            } else {
                StompTransactedSession ts = this._stompConnection.getTransactedSession(tid);
                created = true;
                ts.createSubscriber(subid, this.toJMSDestination(stompdest, ts.getJMSSession(), true), selector, duraname, nolocal, aout);
            }
            this._subids.add(subid);
            reply = StompProtocolHandler.getStompReceiptMessage(message);
            if (reply != null) {
                out.sendToClient(reply, ctx, this);
            }
        }
        catch (Exception e) {
            Object[] eparam = new String[]{message.getCommand().toString(), e.getMessage(), this._stompConnection.toString()};
            this._logger.log(Level.SEVERE, this._sbr.getKString("BSS3002", eparam), e);
            try {
                if (created) {
                    this._stompConnection.closeSubscriber(subid, null);
                    this._subids.remove(subid);
                }
            }
            catch (Exception e1) {
                this._logger.log(Level.FINEST, (Object)((Object)message.getCommand()) + ": Unable to close subscriber (subid=" + subid + ", duraname=" + duraname + "): " + e1.getMessage() + " after creation failure: " + e.getMessage(), e1);
            }
            finally {
                try {
                    reply = StompProtocolHandler.toStompErrorMessage(StompFrameMessage.Command.SUBSCRIBE.toString(), e);
                    out.sendToClient(reply, ctx, this);
                }
                catch (Exception ee) {
                    this._logger.log(Level.WARNING, this._sbr.getKString("BSS3001", e.getMessage(), ee.getMessage()), ee);
                }
            }
            return;
        }
    }

    public void onUNSUBSCRIBE(StompFrameMessage message, StompOutputHandler out, FilterChainContext ctx) throws Exception {
        StompFrameMessage reply = null;
        try {
            LinkedHashMap<String, String> headers = message.getHeaders();
            if (this._logger.isLoggable(Level.FINE)) {
                this._logger.log(Level.FINE, "on" + (Object)((Object)message.getCommand()) + ", headers=" + headers);
            }
            String subid = (String)((HashMap)headers).get("id".toString());
            String stompdest = (String)((HashMap)headers).get("destination".toString());
            String duraname = (String)((HashMap)headers).get("durable-subscriber-name".toString());
            if (subid == null && duraname == null) {
                if (stompdest == null) {
                    throw new StompProtocolException(this._sbr.getKString("BSS4019", "destination", "id"));
                }
                subid = StompProtocolHandler.makeDefaultSubscriberId(stompdest);
            }
            String id = this._stompConnection.closeSubscriber(subid, duraname);
            if (duraname == null) {
                this._subids.remove(subid);
            } else if (id != null) {
                this._subids.remove(id);
            }
            reply = StompProtocolHandler.getStompReceiptMessage(message);
            if (reply != null) {
                out.sendToClient(reply, ctx, this);
            }
        }
        catch (Exception e) {
            Object[] eparam = new String[]{message.getCommand().toString(), e.getMessage(), this._stompConnection.toString()};
            this._logger.log(Level.SEVERE, this._sbr.getKString("BSS3002", eparam), e);
            try {
                reply = StompProtocolHandler.toStompErrorMessage(StompFrameMessage.Command.UNSUBSCRIBE.toString(), e);
                out.sendToClient(reply, ctx, this);
            }
            catch (Exception ee) {
                this._logger.log(Level.WARNING, this._sbr.getKString("BSS3001", e.getMessage(), ee.getMessage()), ee);
            }
            return;
        }
    }

    public void onBEGIN(StompFrameMessage message, StompOutputHandler out, FilterChainContext ctx) throws Exception {
        StompFrameMessage reply = null;
        try {
            String tid;
            LinkedHashMap<String, String> headers = message.getHeaders();
            if (this._logger.isLoggable(Level.FINE)) {
                this._logger.log(Level.FINE, "on" + (Object)((Object)message.getCommand()) + ", headers=" + headers);
            }
            if ((tid = (String)((HashMap)headers).get("transaction".toString())) == null) {
                throw new StompProtocolException(this._sbr.getKString("BSS4020", "transaction".toString(), StompFrameMessage.Command.BEGIN.toString()));
            }
            this._stompConnection.beginTransactedSession(tid);
            reply = StompProtocolHandler.getStompReceiptMessage(message);
            if (reply != null) {
                out.sendToClient(reply, ctx, this);
            }
        }
        catch (Exception e) {
            Object[] eparam = new String[]{message.getCommand().toString(), e.getMessage(), this._stompConnection.toString()};
            this._logger.log(Level.SEVERE, this._sbr.getKString("BSS3002", eparam), e);
            try {
                reply = StompProtocolHandler.toStompErrorMessage(StompFrameMessage.Command.BEGIN.toString(), e);
                out.sendToClient(reply, ctx, this);
            }
            catch (Exception ee) {
                this._logger.log(Level.WARNING, this._sbr.getKString("BSS3001", e.getMessage(), ee.getMessage()), ee);
            }
            return;
        }
    }

    public void onCOMMIT(StompFrameMessage message, StompOutputHandler out, FilterChainContext ctx) throws Exception {
        StompFrameMessage reply = null;
        try {
            String tid;
            LinkedHashMap<String, String> headers = message.getHeaders();
            if (this._logger.isLoggable(Level.FINE)) {
                this._logger.log(Level.FINE, "on" + (Object)((Object)message.getCommand()) + ", headers=" + headers);
            }
            if ((tid = (String)((HashMap)headers).get("transaction".toString())) == null) {
                throw new StompProtocolException(this._sbr.getKString("BSS4020", "transaction".toString(), StompFrameMessage.Command.COMMIT.toString()));
            }
            this._stompConnection.commitTransactedSession(tid);
            reply = StompProtocolHandler.getStompReceiptMessage(message);
            if (reply != null) {
                out.sendToClient(reply, ctx, this);
            }
        }
        catch (Exception e) {
            Object[] eparam = new String[]{message.getCommand().toString(), e.getMessage(), this._stompConnection.toString()};
            this._logger.log(Level.SEVERE, this._sbr.getKString("BSS3002", eparam), e);
            try {
                reply = StompProtocolHandler.toStompErrorMessage(StompFrameMessage.Command.COMMIT.toString(), e);
                out.sendToClient(reply, ctx, this);
            }
            catch (Exception ee) {
                this._logger.log(Level.WARNING, this._sbr.getKString("BSS3001", e.getMessage(), ee.getMessage()), ee);
            }
            return;
        }
    }

    public void onABORT(StompFrameMessage message, StompOutputHandler out, FilterChainContext ctx) throws Exception {
        StompFrameMessage reply = null;
        try {
            String tid;
            LinkedHashMap<String, String> headers = message.getHeaders();
            if (this._logger.isLoggable(Level.FINE)) {
                this._logger.log(Level.FINE, "on" + (Object)((Object)message.getCommand()) + ", headers=" + headers);
            }
            if ((tid = (String)((HashMap)headers).get("transaction".toString())) == null) {
                throw new StompProtocolException(this._sbr.getKString("BSS4020", "transaction".toString(), StompFrameMessage.Command.ABORT.toString()));
            }
            this._stompConnection.abortTransactedSession(tid);
            reply = StompProtocolHandler.getStompReceiptMessage(message);
            if (reply != null) {
                out.sendToClient(reply, ctx, this);
            }
        }
        catch (Exception e) {
            Object[] eparam = new String[]{message.getCommand().toString(), e.getMessage(), this._stompConnection.toString()};
            this._logger.log(Level.SEVERE, this._sbr.getKString("BSS3002", eparam), e);
            try {
                reply = StompProtocolHandler.toStompErrorMessage(StompFrameMessage.Command.ABORT.toString(), e);
                out.sendToClient(reply, ctx, this);
            }
            catch (Exception ee) {
                this._logger.log(Level.WARNING, this._sbr.getKString("BSS3001", e.getMessage(), ee.getMessage()), ee);
            }
            return;
        }
    }

    public void onACK(StompFrameMessage message, StompOutputHandler out, FilterChainContext ctx) throws Exception {
        StompFrameMessage reply = null;
        try {
            String msgid;
            LinkedHashMap<String, String> headers = message.getHeaders();
            if (this._logger.isLoggable(Level.FINE)) {
                this._logger.log(Level.FINE, "on" + (Object)((Object)message.getCommand()) + ", headers=" + headers);
            }
            if ((msgid = (String)((HashMap)headers).get("message-id")) == null) {
                throw new StompProtocolException(this._sbr.getKString("BSS4020", "message-id".toString(), StompFrameMessage.Command.ACK.toString()));
            }
            String tid = (String)((HashMap)headers).get("transaction".toString());
            String subid = (String)((HashMap)headers).get("subscription".toString());
            if (subid != null && !this._subids.contains(subid)) {
                throw new StompProtocolException(this._sbr.getKString("BSS4007", subid));
            }
            if (tid != null) {
                StompTransactedSession ts = this._stompConnection.getTransactedSession(tid);
                if (subid != null) {
                    ts.ack(subid, msgid);
                } else {
                    Object[] eparam = new String[]{"subscription".toString(), tid, DEFAULT_SUBID_PREFIX, msgid};
                    this._logger.log(Level.WARNING, this._sbr.getKString("BSS2005", eparam));
                    ts.ack(DEFAULT_SUBID_PREFIX, msgid, true);
                }
            } else if (subid != null) {
                StompSubscriberSession ss = this._stompConnection.getSubscriberSession(subid);
                if (ss != null) {
                    ss.ack(msgid);
                } else {
                    StompTransactedSession ts = this._stompConnection.getTransactedSession();
                    if (ts == null) {
                        throw new StompProtocolException(this._sbr.getKString("BSS4021", subid));
                    }
                    ts.ack(subid, msgid);
                }
            } else {
                Object[] eparam = new String[]{"subscription".toString(), DEFAULT_SUBID_PREFIX, msgid};
                this._logger.log(Level.WARNING, this._sbr.getKString("BSS2006", eparam));
                this._stompConnection.ackNonTransacted(DEFAULT_SUBID_PREFIX, msgid);
            }
            reply = StompProtocolHandler.getStompReceiptMessage(message);
            if (reply != null) {
                out.sendToClient(reply, ctx, this);
            }
        }
        catch (Exception e) {
            Object[] eparam = new String[]{message.getCommand().toString(), e.getMessage(), this._stompConnection.toString()};
            this._logger.log(Level.SEVERE, this._sbr.getKString("BSS3002", eparam), e);
            try {
                reply = StompProtocolHandler.toStompErrorMessage(StompFrameMessage.Command.ACK.toString(), e, e instanceof UnrecoverableAckFailureException);
                out.sendToClient(reply, ctx, this);
            }
            catch (Exception ee) {
                this._logger.log(Level.WARNING, this._sbr.getKString("BSS3001", e.getMessage(), ee.getMessage()), ee);
            }
            return;
        }
    }

    public static StompFrameMessage getStompReceiptMessage(StompFrameMessage message) throws Exception {
        StompFrameMessage reply = null;
        String requestid = message.getHeader("receipt".toString());
        if (requestid != null) {
            reply = new StompFrameMessage(StompFrameMessage.Command.RECEIPT);
            reply.addHeader("receipt-id".toString(), requestid);
        }
        return reply;
    }

    public static StompFrameMessage toStompErrorMessage(String where, Throwable e) throws Exception {
        return StompProtocolHandler.toStompErrorMessage(where, e, false);
    }

    public static StompFrameMessage toStompErrorMessage(String where, Throwable e, boolean fatal) throws Exception {
        StompFrameMessage err = new StompFrameMessage(StompFrameMessage.Command.ERROR);
        err.addHeader("message".toString(), where + ": " + e.getMessage() + (fatal ? ", STOMP connection will be closed" : ""));
        err.writeExceptionToBody(e);
        if (fatal) {
            err.setFatalERROR();
        }
        return err;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Destination toJMSDestination(String stompdest, Session ss, boolean sub) throws Exception {
        if (stompdest.startsWith("/queue/")) {
            String dest = stompdest.substring("/queue/".length(), stompdest.length()).trim();
            return ss.createQueue(dest);
        }
        if (stompdest.startsWith("/topic/")) {
            String dest = stompdest.substring("/topic/".length(), stompdest.length()).trim();
            return ss.createTopic(dest);
        }
        if (stompdest.startsWith("/temp-queue/")) {
            String dest = stompdest.substring("/temp-queue/".length(), stompdest.length()).trim();
            if (dest.startsWith(MQ_TEMP_QUEUE_PREFIX)) {
                if (sub) {
                    throw new JMSException("Can't subscribe " + stompdest);
                }
                Map<String, TemporaryQueue> map = this._mqtempQueues;
                synchronized (map) {
                    Destination d = this._mqtempQueues.get(dest);
                    if (d == null) {
                        throw new JMSException("MQ TemporaryQueue not found: " + stompdest);
                    }
                    return d;
                }
            }
            Map<String, TemporaryQueue> map = this._tempQueues;
            synchronized (map) {
                TemporaryQueue d = this._tempQueues.get(dest);
                if (d != null) {
                    return d;
                }
                d = ss.createTemporaryQueue();
                this._tempQueues.put(dest, d);
                return d;
            }
        }
        if (stompdest.startsWith("/temp-topic/")) {
            String dest = stompdest.substring("/temp-topic/".length(), stompdest.length()).trim();
            if (dest.startsWith(MQ_TEMP_TOPIC_PREFIX)) {
                if (sub) {
                    throw new JMSException("Can't subscribe " + stompdest);
                }
                Map<String, TemporaryTopic> map = this._mqtempTopics;
                synchronized (map) {
                    Destination d = this._mqtempTopics.get(dest);
                    if (d == null) {
                        throw new JMSException("MQ TemporaryTopic not found: " + stompdest);
                    }
                    return d;
                }
            }
            Map<String, TemporaryTopic> map = this._tempTopics;
            synchronized (map) {
                TemporaryTopic d = this._tempTopics.get(dest);
                if (d != null) {
                    return d;
                }
                d = ss.createTemporaryTopic();
                this._tempTopics.put(dest, d);
                return d;
            }
        }
        throw new StompProtocolException("Invalid header destination value:" + stompdest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toStompDestination(Destination jmsdest, boolean cache) throws Exception {
        if (jmsdest == null) {
            throw new JMSException("JMS destination null !");
        }
        StringBuffer buf = new StringBuffer();
        if (jmsdest instanceof TemporaryQueue) {
            String d = ((Queue)jmsdest).getQueueName();
            buf.append("/temp-queue/").append(d);
            if (cache) {
                Map<String, TemporaryQueue> map = this._mqtempQueues;
                synchronized (map) {
                    if (this._mqtempQueues.get(d) == null) {
                        this._mqtempQueues.put(d, (TemporaryQueue)jmsdest);
                    }
                }
            }
            return buf.toString();
        }
        if (jmsdest instanceof TemporaryTopic) {
            String d = ((Topic)jmsdest).getTopicName();
            buf.append("/temp-topic/").append(d);
            if (cache) {
                Map<String, TemporaryTopic> map = this._mqtempTopics;
                synchronized (map) {
                    if (this._mqtempTopics.get(d) == null) {
                        this._mqtempTopics.put(d, (TemporaryTopic)jmsdest);
                    }
                }
            }
            return buf.toString();
        }
        if (jmsdest instanceof Queue) {
            buf.append("/queue/").append(((Queue)jmsdest).getQueueName());
            return buf.toString();
        }
        if (jmsdest instanceof Topic) {
            buf.append("/topic/").append(((Topic)jmsdest).getTopicName());
            return buf.toString();
        }
        throw new JMSException("Unknow destination type: " + jmsdest);
    }

    private static String makeDefaultSubscriberId(String stompdest) {
        return DEFAULT_SUBID_PREFIX + stompdest;
    }

    protected StompFrameMessage toStompFrameMessage(Message jmsmsg, String subid, Session ss) throws Exception {
        MessageTransformer<Message, Message> mt = StompServer.getMessageTransformer();
        if (mt != null) {
            mt.init(ss, "STOMP");
            jmsmsg = mt.transform(jmsmsg, true, null, "SUN_MQ", "STOMP", null);
            if (jmsmsg == null) {
                throw new JMSException("null returned from " + mt.getClass().getName() + " transform() method for JMS message " + jmsmsg.toString() + " in subscription " + subid);
            }
        }
        StompFrameMessage message = new StompFrameMessage(StompFrameMessage.Command.MESSAGE);
        LinkedHashMap<String, String> headers = message.getHeaders();
        headers.put("subscription", subid);
        Destination jmsdest = jmsmsg.getJMSDestination();
        headers.put("destination".toString(), this.toStompDestination(jmsdest, false));
        jmsdest = jmsmsg.getJMSReplyTo();
        if (jmsdest != null) {
            headers.put("reply-to".toString(), this.toStompDestination(jmsdest, true));
        }
        headers.put("message-id".toString(), jmsmsg.getJMSMessageID());
        String val = jmsmsg.getJMSCorrelationID();
        if (val != null) {
            headers.put("correlation-id".toString(), val);
        }
        headers.put("expires".toString(), String.valueOf(jmsmsg.getJMSExpiration()));
        headers.put("redelivered", String.valueOf(jmsmsg.getJMSRedelivered()));
        headers.put("priority".toString(), String.valueOf(jmsmsg.getJMSPriority()));
        headers.put("timestamp".toString(), String.valueOf(jmsmsg.getJMSTimestamp()));
        val = jmsmsg.getJMSType();
        if (val != null) {
            headers.put("type".toString(), val);
        }
        Enumeration en = jmsmsg.getPropertyNames();
        while (en.hasMoreElements()) {
            String name = (String)en.nextElement();
            String value = jmsmsg.getObjectProperty(name).toString();
            headers.put(name, value);
        }
        if (jmsmsg instanceof TextMessage) {
            String text = ((TextMessage)jmsmsg).getText();
            if (text != null) {
                byte[] data = text.getBytes("UTF-8");
                message.setBody(data);
                headers.put("content-length", String.valueOf(data.length));
            } else {
                headers.put("content-length", String.valueOf(0));
            }
        } else if (jmsmsg instanceof BytesMessage) {
            BytesMessage m = (BytesMessage)jmsmsg;
            byte[] data = new byte[(int)m.getBodyLength()];
            m.readBytes(data);
            message.setBody(data);
            headers.put("content-length", String.valueOf(data.length));
        } else {
            throw new JMSException("Message type is not supported: " + jmsmsg);
        }
        return message;
    }
}

