/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver;

import com.sun.messaging.bridge.api.BridgeBaseContext;
import com.sun.messaging.jmq.io.MQAddress;
import com.sun.messaging.jmq.io.PortMapperEntry;
import com.sun.messaging.jmq.jmsserver.Broker;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.config.BrokerConfig;
import com.sun.messaging.jmq.jmsserver.memory.MemoryManager;
import com.sun.messaging.jmq.jmsserver.tlsutil.KeystoreUtil;
import com.sun.messaging.jmq.jmsserver.tlsutil.SSLPropertyMap;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Properties;

public class BridgeBaseContextAdapter
implements BridgeBaseContext,
SSLPropertyMap {
    private static boolean DEBUG = false;
    public static final String PROP_ADMIN_PASSWORD = "imq.bridge.admin.password";
    private Logger logger = null;
    private Broker broker = null;
    private boolean reset = false;
    private boolean embededBroker = false;

    protected static boolean bridgeEnabled() {
        return Globals.getConfig().getBooleanProperty("imq.bridge.enabled", false);
    }

    protected static String getManagerClass() {
        return Globals.getConfig().getProperty("imq.bridge.managerclass", "com.sun.messaging.bridge.admin.BridgeServiceManagerImpl");
    }

    protected BridgeBaseContextAdapter(Broker broker, boolean reset) {
        this.broker = broker;
        this.reset = reset;
        this.embededBroker = broker.isInProcess();
        this.logger = Globals.getLogger();
    }

    @Override
    public boolean isEmbeded() {
        return true;
    }

    @Override
    public boolean doBind() {
        if (!Globals.isNucleusManagedBroker()) {
            return true;
        }
        return Globals.getPortMapper().isDoBind();
    }

    @Override
    public boolean isEmbededBroker() {
        return this.embededBroker;
    }

    @Override
    public boolean isRunningOnNucleus() {
        return Globals.isNucleusManagedBroker();
    }

    @Override
    public boolean isSilentMode() {
        return this.broker.isSilentMode();
    }

    @Override
    public boolean isStartWithReset() {
        return this.reset;
    }

    @Override
    public Object getPUService() {
        return Globals.getPUService();
    }

    @Override
    public Properties getBridgeConfig() {
        Properties props = new Properties();
        String prefix = "imq.bridge";
        BrokerConfig bc = Globals.getConfig();
        List keys = Globals.getConfig().getPropertyNames(prefix);
        String key2 = null;
        for (String key2 : keys) {
            props.put(key2, bc.getProperty(key2));
        }
        props.put(prefix + ".varhome", Globals.getInstanceDir() + File.separator + "bridge" + "s");
        String lib = bc.getProperty("imq.libhome");
        props.put(prefix + ".libhome", lib);
        props.put(prefix + ".stomp.type", "stomp");
        props.put(prefix + ".stomp.class", "com.sun.messaging.bridge.service.stomp.StompBridge");
        props.put(prefix + ".jms.class", "com.sun.messaging.bridge.service.jms.BridgeImpl");
        props.put("PROP_PREFIX", prefix);
        return props;
    }

    @Override
    public void updateBridgeConfig(Properties props) throws Exception {
        Globals.getConfig().updateProperties(props);
    }

    @Override
    public boolean isJDBCStoreType() throws Exception {
        return Globals.getStore().getStoreType().equals("jdbc");
    }

    @Override
    public Object getJDBCStore() throws Exception {
        if (!Globals.getStore().isJDBCStore()) {
            return null;
        }
        return Globals.getStore();
    }

    @Override
    public boolean isHAEnabled() {
        return Globals.getHAEnabled();
    }

    @Override
    public String getBrokerServiceAddress(String protocol, String serviceType) throws Exception {
        PortMapperEntry pme = null;
        PortMapperEntry e2 = null;
        for (PortMapperEntry e2 : Globals.getPortMapper().getServices().values()) {
            Locale loc = Locale.getDefault();
            if (!e2.getProtocol().toLowerCase(loc).equals(protocol.toLowerCase(loc)) || !e2.getType().equals(serviceType)) continue;
            pme = e2;
            break;
        }
        if (pme == null) {
            throw new Exception("No available service found with protocol " + protocol + " and type " + serviceType);
        }
        String h = pme.getProperty("hostname");
        if (h == null || h.length() == 0 || h.equals("*")) {
            h = Globals.getMQAddress().getHostName();
            if (DEBUG) {
                this.logger.log(8, "getBrokerServiceAddress:" + serviceType + " " + protocol + " global hostname=" + h);
            }
        } else {
            h = MQAddress.getMQAddress(h, pme.getPort()).getHostName();
            if (DEBUG) {
                this.logger.log(8, "getBrokerServiceAddress:" + serviceType + " " + protocol + " service hostname=" + h);
            }
        }
        return "mq" + protocol.toLowerCase(Globals.getBrokerResources().getLocale()) + "://" + h + ":" + pme.getPort() + "/" + pme.getName();
    }

    @Override
    public String getBrokerHostName() {
        String h = Globals.getHostname();
        if (h != null && h.equals("*")) {
            return null;
        }
        return h;
    }

    @Override
    public String getIdentityName() throws Exception {
        return Globals.getIdentityName();
    }

    @Override
    public boolean allocateMemCheck(long size) {
        MemoryManager mm = Globals.getMemManager();
        if (mm == null) {
            return true;
        }
        return mm.allocateMemCheck(size);
    }

    @Override
    public void logError(String message, Throwable t) {
        String msg = "BridgeManager: " + message;
        if (t != null) {
            this.logger.logStack(32, msg, t);
        } else {
            this.logger.log(32, msg);
        }
    }

    @Override
    public void logWarn(String message, Throwable t) {
        String msg = "BridgeManager: " + message;
        if (t != null) {
            this.logger.logStack(16, msg, t);
        } else {
            this.logger.log(16, msg);
        }
    }

    @Override
    public void logInfo(String message, Throwable t) {
        String msg = "BridgeManager: " + message;
        if (t != null) {
            this.logger.logStack(8, msg, t);
        } else {
            this.logger.log(8, msg);
        }
    }

    @Override
    public void logDebug(String message, Throwable t) {
        String msg = "BridgeManager: " + message;
        if (t != null) {
            this.logger.logStack(4, msg, t);
        } else {
            this.logger.log(4, msg);
        }
    }

    @Override
    public boolean handleGlobalError(Throwable ex, String reason) {
        Globals.handleGlobalError(ex, reason);
        return true;
    }

    @Override
    public void registerService(String name, String protocol, String type, int port, HashMap props) {
        String nam = name + "[" + "bridge" + "]";
        String typ = type + "[" + "bridge" + "]";
        Globals.getPortMapper().addService(nam, protocol, typ, port, props);
    }

    @Override
    public Properties getDefaultSSLContextConfig(String caller) throws Exception {
        return KeystoreUtil.getDefaultSSLContextConfig(caller + "[" + "bridge" + "]", this);
    }

    @Override
    public String mapSSLProperty(String prop) throws Exception {
        if (prop.equals("javax.net.ssl.keyStore")) {
            return "javax.net.ssl.keyStore";
        }
        if (prop.equals("javax.net.ssl.keyStorePassword")) {
            return "javax.net.ssl.keyStorePassword";
        }
        if (prop.equals("javax.net.ssl.keyStoreType")) {
            return "javax.net.ssl.keyStoreType";
        }
        if (prop.equals("ssl.KeyManagerFactory.algorithm")) {
            return "ssl.KeyManagerFactory.algorithm";
        }
        if (prop.equals("javax.net.ssl.trustStore")) {
            return "javax.net.ssl.trustStore";
        }
        if (prop.equals("javax.net.ssl.trustStorePassword")) {
            return "javax.net.ssl.trustStorePassword";
        }
        if (prop.equals("javax.net.ssl.trustStoreType")) {
            return "javax.net.ssl.trustStoreType";
        }
        if (prop.equals("ssl.TrustManagerFactory.algorithm")) {
            return "ssl.TrustManagerFactory.algorithm";
        }
        if (prop.equals("securesocket.protocol")) {
            return "securesocket.protocol";
        }
        throw new IllegalArgumentException("unknow " + prop);
    }
}

