/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.api;

import com.sun.messaging.jmq.jmsserver.cluster.api.BrokerState;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.Date;
import java.util.List;

public final class HABrokerInfo
implements Externalizable {
    static final long serialVersionUID = -6833553314062089908L;
    public static final int UPDATE_VERSION = 0;
    public static final int UPDATE_URL = 1;
    public static final int RESET_TAKEOVER_BROKER_READY_OPERATING = 2;
    public static final int RESTORE_HEARTBEAT_ON_TAKEOVER_FAIL = 3;
    public static final int RESTORE_ON_TAKEOVER_FAIL = 4;
    private String id;
    private String takeoverBrokerID;
    private String url;
    private int version;
    private int state;
    private long sessionID;
    private long heartbeat;
    private List sessionList;
    private long takeoverTimestamp = 0L;

    public HABrokerInfo() {
    }

    public HABrokerInfo(String id, String takeoverBrokerID, String url, int version, int state, long sessionID, long heartbeat) {
        this.id = id;
        this.takeoverBrokerID = takeoverBrokerID == null ? "" : takeoverBrokerID;
        this.url = url;
        this.version = version;
        this.state = state;
        this.sessionID = sessionID;
        this.heartbeat = heartbeat;
        this.sessionList = Collections.emptyList();
    }

    public String getId() {
        return this.id;
    }

    public String getTakeoverBrokerID() {
        return this.takeoverBrokerID;
    }

    public String getUrl() {
        return this.url;
    }

    public int getVersion() {
        return this.version;
    }

    public int getState() {
        return this.state;
    }

    public long getSessionID() {
        return this.sessionID;
    }

    public List getAllSessions() {
        return this.sessionList;
    }

    public long getHeartbeat() {
        return this.heartbeat;
    }

    public void setSessionID(long id) {
        this.sessionID = id;
    }

    public void setSessionList(List list) {
        this.sessionList = list;
    }

    public void setTakeoverTimestamp(long ts) {
        this.takeoverTimestamp = ts;
    }

    public long getTakeoverTimestamp() {
        return this.takeoverTimestamp;
    }

    public String toString() {
        StringBuffer strBuf = new StringBuffer(128).append("(").append("brokerID=").append(this.id).append(", URL=").append(this.url).append(", version=").append(this.version).append(", state=").append(this.state).append(" [").append(BrokerState.getState(this.state).toString()).append("]").append(", sessionID=").append(this.sessionID).append(", heartbeatTS=").append(this.heartbeat).append(this.heartbeat > 0L ? " [" + new Date(this.heartbeat) + "]" : "").append(", takeoverBrokerID=").append(this.takeoverBrokerID).append(")");
        return strBuf.toString();
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.id = (String)in.readObject();
        this.takeoverBrokerID = (String)in.readObject();
        this.url = (String)in.readObject();
        this.version = in.readInt();
        this.state = in.readInt();
        this.sessionID = in.readLong();
        this.heartbeat = in.readLong();
        this.sessionList = (List)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.id);
        out.writeObject(this.takeoverBrokerID);
        out.writeObject(this.url);
        out.writeInt(this.version);
        out.writeInt(this.state);
        out.writeLong(this.sessionID);
        out.writeLong(this.heartbeat);
        out.writeObject(this.sessionList);
    }

    public static class StoreSession
    implements Externalizable {
        static final long serialVersionUID = -1619140799512705251L;
        private long id;
        private String brokerID;
        private int isCurrent;
        private String createdBy;
        private long createdTS;

        public StoreSession() {
        }

        public StoreSession(long id, String brokerID, int isCurrent, String createdBy, long createdTS) {
            this.id = id;
            this.brokerID = brokerID;
            this.isCurrent = isCurrent;
            this.createdBy = createdBy;
            this.createdTS = createdTS;
        }

        public long getID() {
            return this.id;
        }

        public String getBrokerID() {
            return this.brokerID;
        }

        public int getIsCurrent() {
            return this.isCurrent;
        }

        public String getCreatedBy() {
            return this.createdBy;
        }

        public long getCreatedTS() {
            return this.createdTS;
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.id = in.readLong();
            this.brokerID = (String)in.readObject();
            this.isCurrent = in.readInt();
            this.createdBy = (String)in.readObject();
            this.createdTS = in.readLong();
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeLong(this.id);
            out.writeObject(this.brokerID);
            out.writeInt(this.isCurrent);
            out.writeObject(this.createdBy);
            out.writeLong(this.createdTS);
        }
    }
}

