/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.admin.bkrutil;

import com.sun.messaging.jmq.admin.resources.AdminResources;
import com.sun.messaging.jmq.admin.util.Globals;
import com.sun.messaging.jmq.util.DestType;

public class BrokerAdminUtil {
    private static AdminResources ar = Globals.getAdminResources();

    public static String getDestinationType(int mask) {
        if (DestType.isTopic(mask)) {
            return ar.getString("A1500");
        }
        if (DestType.isQueue(mask)) {
            return ar.getString("A1501");
        }
        return ar.getString("A1502");
    }

    public static String getDestinationFlavor(int mask) {
        if (DestType.isTopic(mask)) {
            return "-";
        }
        if (DestType.isSingle(mask)) {
            return ar.getString("A1503");
        }
        if (DestType.isRRobin(mask)) {
            return ar.getString("A1504");
        }
        if (DestType.isFailover(mask)) {
            return ar.getString("A1505");
        }
        if (DestType.isQueue(mask)) {
            return ar.getString("A1503");
        }
        return ar.getString("A1502");
    }

    public static String getDestinationState(int destState) {
        switch (destState) {
            case 0: {
                return ar.getString("A1800");
            }
            case 1: {
                return ar.getString("A1801");
            }
            case 2: {
                return ar.getString("A1802");
            }
            case 3: {
                return ar.getString("A1803");
            }
        }
        return "UNKNOWN";
    }

    public static String getServiceState(int serviceState) {
        switch (serviceState) {
            case 0: {
                return ar.getString("A1790");
            }
            case 1: {
                return ar.getString("A1791");
            }
            case 2: {
                return ar.getString("A1792");
            }
            case 3: {
                return ar.getString("A1793");
            }
            case 4: {
                return ar.getString("A1794");
            }
            case 5: {
                return ar.getString("A1795");
            }
            case 6: {
                return ar.getString("A1796");
            }
            case 7: {
                return ar.getString("A1797");
            }
            case 8: {
                return ar.getString("A1798");
            }
        }
        return ar.getString("A1799");
    }

    public static String getActiveConsumers(int mask, int value) {
        if (DestType.isTopic(mask)) {
            return "-";
        }
        if (value == -1) {
            return ar.getString("A1537");
        }
        return Integer.valueOf(value).toString();
    }

    public static String getFailoverConsumers(int mask, int value) {
        if (DestType.isTopic(mask)) {
            return "-";
        }
        if (value == -1) {
            return ar.getString("A1537");
        }
        return Integer.valueOf(value).toString();
    }

    public static String getDSubLogString(String clientID, String duraName) {
        return "[" + (clientID == null ? "" : clientID) + ":" + duraName + "]";
    }
}

