/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging;

import com.sun.messaging.AdministeredObject;
import com.sun.messaging.jmq.jmsclient.ContainerType;
import com.sun.messaging.jmq.jmsclient.JMSContextImpl;
import com.sun.messaging.jmq.jmsclient.UnifiedConnectionImpl;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Properties;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.JMSContext;
import javax.jms.JMSException;

public class BasicConnectionFactory
extends AdministeredObject
implements ConnectionFactory {
    private static final String defaultsBase = "ConnectionFactory";
    private static final String DEFAULT_IMQ_CONNECTION_HANDLER = "com.sun.messaging.jmq.jmsclient.protocol.tcp.TCPStreamHandler";
    private static final String DEFAULT_IMQ_CONNECTION_HANDLER_LABEL = "Connection Handler Classname";
    private static final String DEFAULT_IMQ_USERNAME_PASSWORD = "guest";
    private static final String DEFAULT_IMQ_USERNAME_LABEL = "Default Username";
    private static final String DEFAULT_IMQ_PASSWORD_LABEL = "Default Password";
    private static final String DEFAULT_IMQ_ACKTIMEOUT = "0";
    private static final String DEFAULT_IMQ_ASYNC_SEND_COMPLETION_WAIT_TIMEOUT = "180000";
    private static final String DEFAULT_IMQ_ACKTIMEOUT_LABEL = "Acknowledgement Timeout";
    private static final String DEFAULT_IMQ_ASYNC_SEND_COMPLETION_WAIT_TIMEOUT_LABEL = "Async Send Completion Wait Timeout";
    private static final boolean DEFAULT_JMSXPROP_VALUE = false;
    private transient boolean adminConnectionCreated = false;
    private transient boolean adminKeyUsed = false;
    private transient String connectionType = "NORMAL";

    public BasicConnectionFactory() {
        super(defaultsBase);
    }

    protected BasicConnectionFactory(String defaultsBase) {
        super(defaultsBase);
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        this.adminConnectionCreated = false;
        this.adminKeyUsed = false;
        this.connectionType = "NORMAL";
    }

    @Override
    public Connection createConnection() throws JMSException {
        return this.createConnection(this.getProperty("imqDefaultUsername"), this.getProperty("imqDefaultPassword"));
    }

    @Override
    public Connection createConnection(String username, String password) throws JMSException {
        return new UnifiedConnectionImpl(this.getCurrentConfiguration(), username, password, this.getConnectionType());
    }

    @Override
    public JMSContext createContext() {
        return new JMSContextImpl(this, BasicConnectionFactory.getContainerType());
    }

    @Override
    public JMSContext createContext(String userName, String password) {
        return new JMSContextImpl(this, BasicConnectionFactory.getContainerType(), userName, password);
    }

    @Override
    public JMSContext createContext(String userName, String password, int sessionMode) {
        return new JMSContextImpl(this, BasicConnectionFactory.getContainerType(), userName, password, sessionMode);
    }

    @Override
    public JMSContext createContext(int sessionMode) {
        return new JMSContextImpl(this, BasicConnectionFactory.getContainerType(), sessionMode);
    }

    protected static ContainerType getContainerType() {
        return ContainerType.JavaSE;
    }

    public final void setConnectionType(String type) {
        this.connectionType = "ADMINKEY".equals(type) || "ADMIN".equals(type) ? type : "NORMAL";
    }

    public final String getConnectionType() {
        if (this.connectionType == null) {
            this.connectionType = "NORMAL";
        }
        return this.connectionType;
    }

    @Override
    public String toString() {
        return "Oracle GlassFish(tm) Server MQ ConnectionFactory" + super.toString();
    }

    @Override
    public void setDefaultConfiguration() {
        this.configuration = new Properties();
        this.configurationTypes = new Properties();
        this.configurationLabels = new Properties();
        this.configuration.put("imqConnectionHandler", DEFAULT_IMQ_CONNECTION_HANDLER);
        this.configurationTypes.put("imqConnectionHandler", "com.sun.messaging.PropertyOwner");
        this.configurationLabels.put("imqConnectionHandler", DEFAULT_IMQ_CONNECTION_HANDLER_LABEL);
        this.configuration.put("imqDefaultUsername", DEFAULT_IMQ_USERNAME_PASSWORD);
        this.configurationTypes.put("imqDefaultUsername", "java.lang.String");
        this.configurationLabels.put("imqDefaultUsername", DEFAULT_IMQ_USERNAME_LABEL);
        this.configuration.put("imqDefaultPassword", DEFAULT_IMQ_USERNAME_PASSWORD);
        this.configurationTypes.put("imqDefaultPassword", "java.lang.String");
        this.configurationLabels.put("imqDefaultPassword", DEFAULT_IMQ_PASSWORD_LABEL);
        this.configuration.put("imqAckTimeout", DEFAULT_IMQ_ACKTIMEOUT);
        this.configuration.put("imqAsyncSendCompletionWaitTimeout", DEFAULT_IMQ_ASYNC_SEND_COMPLETION_WAIT_TIMEOUT);
        this.configurationTypes.put("imqAckTimeout", "java.lang.Integer");
        this.configurationTypes.put("imqAsyncSendCompletionWaitTimeout", "java.lang.Long");
        this.configurationLabels.put("imqAckTimeout", DEFAULT_IMQ_ACKTIMEOUT_LABEL);
        this.configurationLabels.put("imqAsyncSendCompletionWaitTimeout", DEFAULT_IMQ_ASYNC_SEND_COMPLETION_WAIT_TIMEOUT_LABEL);
    }
}

