/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.io;

import com.sun.messaging.jmq.util.DiagDictionaryEntry;
import com.sun.messaging.jmq.util.DiagManager;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ByteBufferPool
implements DiagManager.Data {
    private static boolean DEBUG = false;
    public static final int DEFAULT_CAPACITY = 0x100000;
    public static final int DEFAULT_BLOCKSIZE = 128;
    public static final int DEFAULT_BIGBUFSIZE = 65536;
    public static final float DEFAULT_BIGRATIO = 0.5f;
    protected HashMap table = null;
    protected boolean useDirect = true;
    protected int blockSize = 128;
    protected int poolCapacity = 0x100000;
    protected int bigBufSize = 65536;
    protected float bigRatio = 0.5f;
    protected int bigPoolSize = 0;
    protected int poolSize = 0;
    protected int nBufs = 0;
    protected int directBytesAllocated = 0;
    protected int heapBytesAllocated = 0;
    protected int directBufsAllocated = 0;
    protected int heapBufsAllocated = 0;
    protected int hits = 0;
    protected int misses = 0;
    protected int adds = 0;
    protected int drops = 0;
    protected String poolContents = null;
    protected double utilization = 0.0;
    ArrayList diagDictionary = null;

    public ByteBufferPool() {
        this(0x100000, true);
    }

    public ByteBufferPool(int capacity, boolean useDirect) {
        this.poolCapacity = capacity;
        this.useDirect = useDirect;
        this.table = new HashMap();
        DiagManager.register(this);
    }

    public void setBigBufSize(int n) {
        this.bigBufSize = n;
    }

    public int getBigBufSize() {
        return this.bigBufSize;
    }

    public void setBigRatio(float n) {
        this.bigRatio = n;
    }

    public float getBigRatio() {
        return this.bigRatio;
    }

    public void setCapacity(int n) {
        this.poolCapacity = n;
    }

    public int getCapacity() {
        return this.poolCapacity;
    }

    public void setBlockSize(int n) {
        this.blockSize = n;
    }

    public int getBlockSize() {
        return this.blockSize;
    }

    public double getUtilization() {
        return (double)this.hits / (double)(this.hits + this.misses);
    }

    public synchronized ByteBuffer get(int bufSize) {
        int allocateSize = 0;
        ArrayList buffers = null;
        ByteBuffer b = null;
        allocateSize = bufSize / this.blockSize * this.blockSize;
        if (bufSize % this.blockSize > 0) {
            allocateSize += this.blockSize;
        }
        if ((buffers = (ArrayList)this.table.get(allocateSize)) == null || buffers.isEmpty()) {
            ++this.misses;
            if (this.directBytesAllocated >= this.poolCapacity) {
                b = ByteBuffer.allocate(bufSize);
                this.heapBytesAllocated += bufSize;
                ++this.heapBufsAllocated;
            } else if (this.useDirect) {
                b = ByteBuffer.allocateDirect(allocateSize);
                this.directBytesAllocated += allocateSize;
                ++this.directBufsAllocated;
            } else {
                b = ByteBuffer.allocate(allocateSize);
            }
            if (DEBUG) {
                System.out.println(super.toString() + " get(): miss: allocating new buffer. Requested " + bufSize + " bytes, allocating " + allocateSize);
            }
        } else {
            b = (ByteBuffer)buffers.remove(buffers.size() - 1);
            this.poolSize -= b.capacity();
            if (b.capacity() >= this.bigBufSize) {
                this.bigPoolSize -= b.capacity();
            }
            --this.nBufs;
            ++this.hits;
            if (DEBUG) {
                System.out.println(super.toString() + " get(): hit: Requested " + bufSize + " bytes, returning " + b.capacity());
            }
        }
        b.limit(bufSize);
        b.rewind();
        return b;
    }

    public synchronized void put(ByteBuffer b) {
        if (b == null) {
            return;
        }
        if (this.useDirect && !b.isDirect()) {
            if (DEBUG) {
                System.out.println(super.toString() + " put(): drop: buffer is not direct. " + "Dropping " + b.capacity() + " bytes onto floor ");
            }
            ++this.drops;
            return;
        }
        ArrayList<ByteBuffer> buffers = null;
        boolean bigBuf = false;
        if (b.capacity() >= this.bigBufSize) {
            bigBuf = true;
        }
        if (bigBuf && (float)this.bigPoolSize > (float)this.poolCapacity * this.bigRatio) {
            ++this.drops;
            if (DEBUG) {
                System.out.println(super.toString() + " put(): drop: big pool capacity of " + (float)this.poolCapacity * this.bigRatio + "exceeded. dropping " + b.capacity() + " bytes onto floor ");
            }
        } else if (this.poolSize < this.poolCapacity) {
            Integer key = b.capacity();
            buffers = (ArrayList<ByteBuffer>)this.table.get(key);
            if (buffers == null) {
                buffers = new ArrayList<ByteBuffer>(64);
                this.table.put(key, buffers);
            }
            buffers.add(b);
            this.poolSize += b.capacity();
            ++this.nBufs;
            ++this.adds;
            if (bigBuf) {
                this.bigPoolSize += b.capacity();
            }
            if (DEBUG) {
                System.out.println(super.toString() + "put(): add: putting " + b.capacity() + " bytes back into pool");
            }
        } else {
            ++this.drops;
            if (DEBUG) {
                System.out.println(super.toString() + " put(): drop: dropping " + b.capacity() + " bytes onto floor ");
            }
        }
    }

    public synchronized void clear() {
        this.table.clear();
        this.poolSize = 0;
        this.bigPoolSize = 0;
        this.nBufs = 0;
    }

    public String toString() {
        return super.toString() + ": capacity=" + this.poolCapacity + ", size=" + this.poolSize + ", nBufs=" + this.nBufs + ", bigBufSize=" + this.bigBufSize + ", bigPoolSize=" + this.bigPoolSize + ", bigRatio=" + this.bigRatio + ", utilization=" + this.getUtilization() + ", directBytes=" + this.directBytesAllocated + ", directBuffers=" + this.directBufsAllocated + ", heapBytes=" + this.heapBytesAllocated + ", heapBuffers=" + this.heapBufsAllocated;
    }

    public String toDiagString() {
        return this.toString() + ", hits=" + this.hits + ", misses=" + this.misses + ", adds=" + this.adds + ", drops=" + this.drops;
    }

    public String poolContents() {
        StringBuffer sb = new StringBuffer();
        Set set = this.table.entrySet();
        Iterator iter = set.iterator();
        boolean i = false;
        int totalBytes = 0;
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            int n = (Integer)entry.getKey();
            ArrayList list = (ArrayList)entry.getValue();
            sb.append(n + ":" + list.size() + " ");
            totalBytes += n * list.size();
        }
        sb.append(" Total Bytes: " + totalBytes);
        return sb.toString();
    }

    public void resetDiagCounters() {
        this.hits = 0;
        this.misses = 0;
        this.adds = 0;
        this.drops = 0;
    }

    @Override
    public synchronized List getDictionary() {
        if (this.diagDictionary == null) {
            this.diagDictionary = new ArrayList();
            this.diagDictionary.add(new DiagDictionaryEntry("poolCapacity", 1));
            this.diagDictionary.add(new DiagDictionaryEntry("poolSize", 1));
            this.diagDictionary.add(new DiagDictionaryEntry("blockSize", 1));
            this.diagDictionary.add(new DiagDictionaryEntry("nBufs", 1));
            this.diagDictionary.add(new DiagDictionaryEntry("bigBufSize", 1));
            this.diagDictionary.add(new DiagDictionaryEntry("bigPoolSize", 1));
            this.diagDictionary.add(new DiagDictionaryEntry("directBytesAllocated", 3));
            this.diagDictionary.add(new DiagDictionaryEntry("directBufsAllocated", 3));
            this.diagDictionary.add(new DiagDictionaryEntry("heapBytesAllocated", 3));
            this.diagDictionary.add(new DiagDictionaryEntry("heapBufsAllocated", 3));
            this.diagDictionary.add(new DiagDictionaryEntry("hits", 3));
            this.diagDictionary.add(new DiagDictionaryEntry("misses", 3));
            this.diagDictionary.add(new DiagDictionaryEntry("adds", 3));
            this.diagDictionary.add(new DiagDictionaryEntry("drops", 3));
            this.diagDictionary.add(new DiagDictionaryEntry("utilization", 1));
            this.diagDictionary.add(new DiagDictionaryEntry("poolContents", 1));
        }
        return this.diagDictionary;
    }

    @Override
    public void update() {
        this.poolContents = "[" + this.poolContents() + "]";
        this.utilization = this.getUtilization();
    }

    @Override
    public String getPrefix() {
        return "bbpool";
    }

    @Override
    public String getTitle() {
        return "ByteBufferPool";
    }
}

