/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.bdb;

import com.sleepycat.je.LockConflictException;
import com.sleepycat.je.Transaction;
import com.sun.messaging.jmq.jmsserver.persist.api.Store;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.log.Logger;

public class Util {

    public static class RetryStrategy {
        private Logger logger = null;
        private BrokerException originalEx = null;
        private int retryMax = 0;
        private int retryCount = 0;
        private Transaction txn = null;
        private Transaction reptxn = null;
        private String op = null;
        private Store store = null;

        public RetryStrategy(Transaction txn, int maxRetries, Logger logger, String op, Store p) throws BrokerException {
            this(txn, null, maxRetries, logger, op, p);
        }

        public RetryStrategy(Transaction txn, Transaction reptxn, int maxRetries, Logger logger, String op, Store p) throws BrokerException {
            this.txn = txn;
            this.reptxn = reptxn;
            this.retryMax = maxRetries;
            this.logger = logger;
            this.op = op;
            this.store = p;
        }

        public void assertShouldRetry(Throwable e) throws BrokerException {
            if (!(e instanceof BrokerException)) {
                if (this.txn != null) {
                    try {
                        this.txn.abort();
                    }
                    catch (Exception e1) {
                        this.logger.log(16, "XXX Failed to abort transaction " + this.txn + " on non-retriable exception " + e);
                    }
                }
                if (this.reptxn != null) {
                    try {
                        this.reptxn.abort();
                    }
                    catch (Exception e1) {
                        this.logger.log(16, "XXX Failed to abort replica transaction " + this.reptxn + " on non-retriable exception " + e);
                    }
                }
                throw new BrokerException(e.toString(), e);
            }
            if (this.originalEx == null) {
                this.originalEx = (BrokerException)e;
            }
            Throwable cause = e.getCause();
            boolean retry = false;
            if (cause instanceof LockConflictException) {
                if (this.txn != null) {
                    try {
                        this.txn.abort();
                    }
                    catch (Exception e1) {
                        this.logger.log(16, "XXX Failed to abort transaction " + this.txn + " after " + e + ": " + e1.getMessage());
                        throw this.originalEx;
                    }
                }
                if (this.reptxn != null) {
                    try {
                        this.reptxn.abort();
                    }
                    catch (Exception e1) {
                        this.logger.log(16, "XXX Failed to abort replica transaction " + this.reptxn + " after " + e + ": " + e1.getMessage());
                        throw this.originalEx;
                    }
                }
                ++this.retryCount;
                if (this.retryCount >= this.retryMax) {
                    this.logger.log(16, "XXX Maximum retries (" + this.retryMax + ") reached after " + this.originalEx);
                    throw this.originalEx;
                }
                if (this.store.isClosed()) {
                    throw this.originalEx;
                }
                if (Store.getDEBUG()) {
                    this.logger.log(8, "Retry (" + this.retryCount + ", " + this.retryMax + ") " + this.op + " after " + this.originalEx);
                }
                return;
            }
            if (this.txn != null) {
                try {
                    this.txn.abort();
                }
                catch (Exception e1) {
                    this.logger.log(16, "XXX Failed to abort transaction " + this.txn + " after " + e + ": " + e1.getMessage());
                    throw this.originalEx;
                }
            }
            if (this.reptxn != null) {
                try {
                    this.reptxn.abort();
                }
                catch (Exception e1) {
                    this.logger.log(16, "XXX Failed to abort replica transaction " + this.reptxn + " after " + e + ": " + e1.getMessage());
                    throw this.originalEx;
                }
            }
            throw this.originalEx;
        }
    }
}

