#!/bin/bash

# Start the client test on all clients
# We suppose that we are running this script from the same machine
# where we are running the server (IPS repository) with run_test_server.sh

SCRIPT_DIR=$(dirname $0)
ABS_SCRIPT_DIR=$(cd $SCRIPT_DIR && pwd)

test_script_file="run_test_client.sh"

# Get fully qualified host name
this_host=$(hostname)
ips_server=$(nslookup ${this_host} 2>/dev/null | awk '$1 == "Name:" || $1 == "Aliases:"{print $2}')

repo_url_prefix="http://${ips_server}"

# Windows
test_host="nss-w2kp.us.oracle.com"
ips_port=10021
test_dir="/e/security/test_nss_ips"

local_test_dir=$(echo $ABS_SCRIPT_DIR | sed -e "s|.*/mccrel3/|/U/|")
echo "Local test script for Windows=${local_test_dir}"
test_script=${local_test_dir}/${test_script_file}
repo_url="${repo_url_prefix}:${ips_port}"

rsh ${test_host} ${test_script} ${test_dir} ${repo_url}

# Solaris x86
test_host="biarritz.us.oracle.com"
ips_port=10022
test_dir="/export/test_nss_ips"

test_script=${ABS_SCRIPT_DIR}/${test_script_file}
repo_url="${repo_url_prefix}:${ips_port}"

rsh ${test_host} ${test_script} ${test_dir} ${repo_url}

# Solaris SPARC
test_host="simplify.us.oracle.com"
ips_port=10023
test_dir="/export/test_nss_ips"

test_script=${ABS_SCRIPT_DIR}/${test_script_file}
repo_url="${repo_url_prefix}:${ips_port}"

rsh ${test_host} ${test_script} ${test_dir} ${repo_url}

# Linux
test_host="nssamdrhel4.us.oracle.com"
ips_port=10024
test_dir="/export/test_nss_ips"

test_script=${ABS_SCRIPT_DIR}/${test_script_file}
repo_url="${repo_url_prefix}:${ips_port}"

rsh ${test_host} ${test_script} ${test_dir} ${repo_url}

# Darwin
test_host="nssmac4.us.oracle.com"
ips_port=10025
test_dir="/export/test_nss_ips"

test_script=${ABS_SCRIPT_DIR}/${test_script_file}
repo_url="${repo_url_prefix}:${ips_port}"

rsh ${test_host} ${test_script} ${test_dir} ${repo_url}
