/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.bdb;

import com.sun.messaging.jmq.io.SysMessageID;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import java.util.ArrayList;
import java.util.HashMap;

public class ConsumerStates {
    private BrokerResources br = Globals.getBrokerResources();
    ConsumerUID[] sids = null;
    int[] states = null;
    SysMessageID mid = null;
    ArrayList<ConsumerUID> asids = null;
    ArrayList<Integer> astates = null;

    public ConsumerStates() {
    }

    public ConsumerStates(ConsumerUID[] sids, int[] states) {
        this.sids = sids;
        this.states = states;
    }

    protected ConsumerUID[] getConsumers() {
        return this.sids;
    }

    protected int[] getStates() {
        return this.states;
    }

    protected void setSysMessageID(SysMessageID mid) {
        this.mid = mid;
    }

    protected void toArrays() {
        this.sids = this.asids.toArray(new ConsumerUID[this.asids.size()]);
        int size = this.astates.size();
        this.states = new int[size];
        for (int i = 0; i < size; ++i) {
            this.states[i] = this.astates.get(i);
        }
    }

    protected void addConsumerState(ConsumerUID sid, int state) {
        if (this.asids == null) {
            this.asids = new ArrayList();
            this.astates = new ArrayList();
        }
        this.asids.add(sid);
        this.astates.add(state);
    }

    protected int getConsumerState(ConsumerUID sid) throws BrokerException {
        int index = -1;
        if (this.asids == null || (index = this.asids.indexOf(sid)) == -1) {
            throw new BrokerException(this.br.getKString("B3014", sid, this.mid));
        }
        return this.astates.get(index);
    }

    protected void updateConsumerState(ConsumerUID sid, int state) throws BrokerException {
        int index = -1;
        if (this.asids == null || (index = this.asids.indexOf(sid)) == -1) {
            throw new BrokerException(this.br.getKString("B3014", sid, this.mid));
        }
        this.astates.set(index, state);
    }

    protected HashMap getInterestStates() throws BrokerException {
        if (this.asids == null) {
            throw new BrokerException(this.br.getKString("B3084", this.mid));
        }
        HashMap<ConsumerUID, Integer> m = new HashMap<ConsumerUID, Integer>();
        ConsumerUID[] s = this.asids.toArray(new ConsumerUID[this.asids.size()]);
        for (int i = 0; i < s.length; ++i) {
            m.put(s[i], this.astates.get(i));
        }
        return m;
    }

    protected ConsumerUID[] getUnAckedConsumerUIDs() throws BrokerException {
        if (this.asids == null) {
            return new ConsumerUID[0];
        }
        ArrayList<ConsumerUID> l = new ArrayList<ConsumerUID>();
        ConsumerUID[] s = this.asids.toArray(new ConsumerUID[this.asids.size()]);
        for (int i = 0; i < s.length; ++i) {
            if (this.astates.get(i) == 2) continue;
            l.add(s[i]);
        }
        return l.toArray(new ConsumerUID[0]);
    }

    protected boolean hasMessageBeenAcked() {
        if (this.astates == null || this.astates.size() == 0) {
            return false;
        }
        Integer state2 = null;
        for (Integer state2 : this.astates) {
            if (state2 == 2) continue;
            return false;
        }
        return true;
    }
}

