/*
 * Decompiled with CFR 0.152.
 */
package com.sun.pkg.bootstrap;

import com.sun.pkg.client.Action;
import com.sun.pkg.client.Fmri;
import com.sun.pkg.client.ImagePlanProgressTracker;
import java.io.Console;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BootstrapProgressTracker
extends ImagePlanProgressTracker {
    Fmri pkg = null;
    int totalPackages = 0;
    int totalDownloadFiles = 0;
    long totalDownloadSize = 0L;
    Logger logger = null;
    int nfiles = 0;
    Console console = System.console();

    private BootstrapProgressTracker() {
    }

    public BootstrapProgressTracker(Logger logger) {
        this.logger = logger;
    }

    public void startDownloadPhase(int totalPackages) {
        this.totalPackages = totalPackages;
        this.logger.log(Level.INFO, "downloading", totalPackages);
    }

    public void startPackageDownload(Fmri pkg, int totalDownloadFiles, long totalDownloadSize) {
        this.totalDownloadFiles = totalDownloadFiles;
        this.totalDownloadSize = totalDownloadSize;
        this.pkg = pkg;
        this.nfiles = 0;
        this.logger.log(Level.INFO, "downloadingpackage", new Object[]{pkg.getName(), totalDownloadFiles, totalDownloadSize});
    }

    public void startFileDownload(int index, long fileSize) {
    }

    public void onFileDownloadProgress(int index, long xferedBytes) {
    }

    public synchronized void endFileDownload(int index, long fileSize) {
        ++this.nfiles;
        if (this.console != null) {
            this.console.printf("\rFile %d/%d", this.nfiles, this.totalDownloadFiles);
        }
    }

    public void endPackageDownload(Fmri pkg, int totalDownloadFiles) {
        if (this.console != null) {
            this.console.printf("\n", new Object[0]);
        }
    }

    public void endDownloadPhase() {
    }

    public void startActions(int totalActions) {
    }

    public void startRemovalPhase(int totalRemovalActions) {
        if (totalRemovalActions > 0) {
            this.logger.log(Level.INFO, "executingremovalactions", totalRemovalActions);
        }
    }

    public void onRemovalAction(Action a) {
    }

    public void endRemovalPhase() {
    }

    public void startUpdatePhase(int totalUpdateActions) {
        if (totalUpdateActions > 0) {
            this.logger.log(Level.INFO, "executingupdateactions", totalUpdateActions);
        }
    }

    public void onUpdateAction(Action from, Action to) {
    }

    public void endUpdatePhase() {
    }

    public void startInstallPhase(int totalInstallActions) {
        if (totalInstallActions > 0) {
            this.logger.log(Level.INFO, "executinginstallactions", totalInstallActions);
        }
    }

    public void onInstallAction(Action a) {
    }

    public void endInstallPhase() {
    }
}

