#!/usr/bin/perl -w
# Converts a IPS manifest file from the output of "pkg contents -m <pkg_name>"
# to a IPS manifest template for the input of "pkgsend -s <repo> publish..."

# Takes input file from stdin
# Sends output to stdout

while (<>) {
	$line = $_;
	
	if ($line =~ "^legacy") {
		# remove legacy lines
	} else {
		if ($line =~ "^file") {
			# modify "file" lines
			# Remove the hex number after file
			$line =~ s/^file \w*(\s.*)/file$1/;
			# Remove chash
			$line =~ s/(.*) chash=\w*(\s.*)/$1$2/;
			# Remove elfarch
			$line =~ s/(.*) elfarch=\w*(\s.*)/$1$2/;
			# Remove elfbits
			$line =~ s/(.*) elfbits=\w*(\s.*)/$1$2/;
			# Remove elfhash
			$line =~ s/(.*) elfhash=\w*(\s.*)/$1$2/;
			# Remove pkg.csize
			$line =~ s/(.*) pkg\.csize=\w*(\s.*)/$1$2/;
			# Remove pkg.size
			$line =~ s/(.*) pkg\.size=\w*(\s.*)/$1$2/;
			
			# Add source for the file
			if ($line =~ /path=usr\/include\/mps/) {
				# from INC_DIR
				$filename = $line;
				$filename =~ s/.* path=usr\/include\/mps\/(\S*)\s*.*/$1/;
				#print "filename=$filename\n";
				$line =~ s/^file/file %INC_DIR%\/$filename/;
			} elsif ($line =~ /path=usr\/lib\/mps/) {
				# from LIB_DIR
				$filename = $line;
				$filename =~ s/.* path=usr\/lib\/mps\/(\S*)\s*.*/$1/;
				chomp $filename;
				#print "filename=$filename<\n";
				$filenameonly = $filename;
				$filenameonly =~ s/.*\/(.*)/$1/;
				if ($line =~ /variant\.arch=sparc/) {
					if ($filename =~ /sparcv9/) {
						$line =~ s/^file/file %LIB_S64_DIR%\/$filenameonly/;
					} else {
						$line =~ s/^file/file %LIB_S32_DIR%\/$filenameonly/;
					}
				} else {
					if ($filename =~ /amd64/) {
						$line =~ s/^file/file %LIB_X64_DIR%\/$filenameonly/;
					} else {
						$line =~ s/^file/file %LIB_X32_DIR%\/$filenameonly/;
					}
				}
			} elsif ($line =~ /path=usr\/sfw\/bin/) {
				# from BIN_DIR
				$filename = $line;
				$filename =~ s/.* path=usr\/sfw\/bin\/(\S*)\s*.*/$1/;
				chomp $filename;
				#print "filename=$filename<\n";
				$filenameonly = $filename;
				$filenameonly =~ s/.*\/(.*)/$1/;
				if ($line =~ /variant\.arch=sparc/) {
					if ($filename =~ /sparcv9/) {
						$line =~ s/^file/file %BIN_S64_DIR%\/$filenameonly/;
					} else {
						$line =~ s/^file/file %BIN_S32_DIR%\/$filenameonly/;
					}
				} else {
					if ($filename =~ /amd64/) {
						$line =~ s/^file/file %BIN_X64_DIR%\/$filenameonly/;
					} else {
						$line =~ s/^file/file %BIN_X32_DIR%\/$filenameonly/;
					}
				}
			}
		}
		
		# print line
		print "$line";
	}
}
