/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;

public class MetricCounters
implements Cloneable,
Serializable {
    private transient Object inLock = new Object();
    private transient Object outLock = new Object();
    public long messagesIn = 0L;
    public long messagesOut = 0L;
    public long messageBytesIn = 0L;
    public long messageBytesOut = 0L;
    public long packetsIn = 0L;
    public long packetsOut = 0L;
    public long packetBytesIn = 0L;
    public long packetBytesOut = 0L;
    public long totalMemory = 0L;
    public long freeMemory = 0L;
    public int threadsActive = 0;
    public int threadsHighWater = 0;
    public int threadsLowWater = 0;
    public long timeStamp = 0L;
    public int nConnections = 1;

    public MetricCounters() {
        this.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        Object object = this.inLock;
        synchronized (object) {
            this.messageBytesIn = 0L;
            this.messagesIn = 0L;
            this.packetBytesIn = 0L;
            this.packetsIn = 0L;
        }
        object = this.outLock;
        synchronized (object) {
            this.messageBytesOut = 0L;
            this.messagesOut = 0L;
            this.packetBytesOut = 0L;
            this.packetsOut = 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void updateIn(long messagesIn, long messageBytesIn, long packetsIn, long packetBytesIn) {
        Object object = this.inLock;
        synchronized (object) {
            this.messagesIn += messagesIn;
            this.messageBytesIn += messageBytesIn;
            this.packetsIn += packetsIn;
            this.packetBytesIn += packetBytesIn;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void updateOut(long messagesOut, long messageBytesOut, long packetsOut, long packetBytesOut) {
        Object object = this.outLock;
        synchronized (object) {
            this.messagesOut += messagesOut;
            this.messageBytesOut += messageBytesOut;
            this.packetsOut += packetsOut;
            this.packetBytesOut += packetBytesOut;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void update(MetricCounters counter) {
        Object object = this.inLock;
        synchronized (object) {
            this.messagesIn += counter.messagesIn;
            this.messageBytesIn += counter.messageBytesIn;
            this.packetsIn += counter.packetsIn;
            this.packetBytesIn += counter.packetBytesIn;
        }
        object = this.outLock;
        synchronized (object) {
            this.messagesOut += counter.messagesOut;
            this.messageBytesOut += counter.messageBytesOut;
            this.packetsOut += counter.packetsOut;
            this.packetBytesOut += counter.packetBytesOut;
            this.threadsActive = counter.threadsActive;
            this.threadsHighWater = counter.threadsHighWater;
            this.threadsLowWater = counter.threadsLowWater;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        Object object = this.outLock;
        synchronized (object) {
            Object object2 = this.inLock;
            synchronized (object2) {
                return " In: " + this.messagesIn + " messages(" + this.messageBytesIn + " bytes)\t" + this.packetsIn + " packets(" + this.packetBytesIn + " bytes)\n" + "Out: " + this.messagesOut + " messages(" + this.messageBytesOut + " bytes)\t" + this.packetsOut + " packets(" + this.packetBytesOut + " bytes)\n";
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object clone() {
        MetricCounters counter = null;
        try {
            counter = (MetricCounters)super.clone();
        }
        catch (CloneNotSupportedException e) {
            System.out.println("Class MetricCounters could not be cloned.");
            return null;
        }
        counter.inLock = new Object();
        counter.outLock = new Object();
        Object object = this.inLock;
        synchronized (object) {
            counter.messagesIn = this.messagesIn;
            counter.messageBytesIn = this.messageBytesIn;
            counter.packetsIn = this.packetsIn;
            counter.packetBytesIn = this.packetBytesIn;
        }
        object = this.outLock;
        synchronized (object) {
            counter.messagesOut = this.messagesOut;
            counter.messageBytesOut = this.messageBytesOut;
            counter.packetsOut = this.packetsOut;
            counter.packetBytesOut = this.packetBytesOut;
        }
        return counter;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.inLock = new Object();
        this.outLock = new Object();
    }
}

