/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.cluster.api;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.Consumer;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.core.PacketReference;
import com.sun.messaging.jmq.jmsserver.service.ConnectionUID;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.log.Logger;
import com.sun.messaging.jmq.util.selector.Selector;
import com.sun.messaging.jmq.util.selector.SelectorFormatException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class RemoteConsumer
extends Consumer {
    transient Set consumers = new HashSet();
    private static boolean DEBUG = false;
    private static Logger logger = Globals.getLogger();

    public RemoteConsumer(DestinationUID duid) throws IOException, SelectorFormatException {
        super(duid, null, false, (ConnectionUID)null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getConsumerCount() {
        Set set = this.consumers;
        synchronized (set) {
            return this.consumers.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConsumer(Consumer c) {
        Set set = this.consumers;
        synchronized (set) {
            this.consumers.add(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConsumer(Consumer c) {
        Set set = this.consumers;
        synchronized (set) {
            this.consumers.remove(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean match(PacketReference msg, Set s) throws BrokerException, SelectorFormatException {
        boolean match = false;
        Map props = null;
        HashMap headers = null;
        Set set = this.consumers;
        synchronized (set) {
            Iterator itr = this.consumers.iterator();
            Consumer c = (Consumer)itr.next();
            if (c.getSelector() == null) {
                match = true;
                s.add(c);
            } else {
                Selector selector = c.getSelector();
                if (props == null && selector.usesProperties()) {
                    try {
                        props = msg.getProperties();
                    }
                    catch (ClassNotFoundException ex) {
                        logger.logStack(32, "INTERNAL ERROR", ex);
                        props = new HashMap();
                    }
                }
                if (headers == null && selector.usesFields()) {
                    headers = msg.getHeaders();
                }
                if (selector.match(props, headers)) {
                    match = true;
                    s.add(c);
                }
            }
            return match;
        }
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        this.consumers = new HashSet();
    }
}

