/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsclient.protocol.websocket;

import com.sun.messaging.AdministeredObject;
import com.sun.messaging.jmq.io.BigPacketException;
import com.sun.messaging.jmq.io.ByteBufferOutput;
import com.sun.messaging.jmq.io.ReadWritePacket;
import com.sun.messaging.jmq.jmsclient.ConnectionHandler;
import com.sun.messaging.jmq.jmsclient.ConnectionImpl;
import com.sun.messaging.jmq.jmsclient.Debug;
import com.sun.messaging.jmq.jmsclient.MQAddress;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.websocket.ClientEndpointConfig;
import javax.websocket.CloseReason;
import javax.websocket.ContainerProvider;
import javax.websocket.Endpoint;
import javax.websocket.EndpointConfig;
import javax.websocket.MessageHandler;
import javax.websocket.Session;
import javax.websocket.WebSocketContainer;

public class WebSocketConnectionHandler
extends Endpoint
implements ConnectionHandler,
MessageHandler.Whole<ByteBuffer> {
    private static final boolean debug = Debug.debug;
    private static final Logger logger = ConnectionImpl.getConnectionLogger();
    private static final String WEBSOCKET_JMS_PATH = "/mqjms";
    private static final String DEFAULT_WS_SERVICE_NAME = "wsjms";
    private static final String DEFAULT_WSS_SERVICE_NAME = "wssjms";
    private static final int DEFAULT_ASYNC_SEND_TIMEOUT = 0;
    private static final int DEFAULT_MAX_BINARY_BUFFER_SIZE = Integer.MAX_VALUE;
    private static final int DEFAULT_MAX_TEXT_BUFFER_SIZE = Integer.MAX_VALUE;
    private static final int DEFAULT_MAX_SESSION_IDLE_TIMEOUT = 0;
    private Object sessionLock = new Object();
    private Session session = null;
    private boolean closed = false;
    private ReadWritePacket packetRead = null;
    private ReadWritePacket packetPending = null;
    private final CountDownLatch onOpenLatch = new CountDownLatch(1);
    private ConnectionImpl conn = null;
    private MQAddress mqaddr = null;
    private int connectTimeout = 0;

    public WebSocketConnectionHandler(MQAddress addr, ConnectionImpl conn) {
        this.mqaddr = addr;
        this.connectTimeout = conn.getSocketConnectTimeout();
        this.conn = conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getLocalPort() throws IOException {
        Object object = this.sessionLock;
        synchronized (object) {
            if (this.closed) {
                throw new IOException(AdministeredObject.cr.getKString("C4325"));
            }
            if (this.session == null) {
                throw new IOException("WebSocket Session not open on JMS connection " + this.conn.getConnectionID());
            }
        }
        return this.session.getId().hashCode();
    }

    @Override
    public boolean isDirectMode() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReadWritePacket readPacket() throws IOException {
        ReadWritePacket pkt = null;
        Object object = this.sessionLock;
        synchronized (object) {
            if (this.session == null) {
                throw new IOException("WebSocket Session not open on JMS connection " + this.conn.getConnectionID());
            }
            String id = this.session.getId();
            while (!this.closed && this.packetRead == null) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "WebSocketConnectionHandler@" + this.hashCode() + ": readPacket() waiting for incoming packet, ws-session=" + id + " on JMS connection " + this.conn.getConnectionID());
                }
                try {
                    this.sessionLock.wait();
                }
                catch (InterruptedException e) {}
            }
            if (this.closed) {
                throw new IOException(AdministeredObject.cr.getKString("C4325"));
            }
            pkt = this.packetRead;
            this.packetRead = null;
            this.sessionLock.notifyAll();
        }
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "WebSocketConnectionHandler@" + this.hashCode() + ": READ PACKET=" + pkt + ", ws-session=" + this.session.getId() + ", on JMS connection " + this.conn.getConnectionID());
        }
        return pkt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writePacket(ReadWritePacket pkt) throws IOException {
        Object object = this.sessionLock;
        synchronized (object) {
            if (this.session == null) {
                throw new IOException("WebSocket Session not open on JMS connection " + this.conn.getConnectionID());
            }
            if (this.closed) {
                throw new IOException(AdministeredObject.cr.getKString("C4325"));
            }
        }
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "WebSocketConnectionHandler@" + this.hashCode() + ": WRITE PACKET=" + pkt + ", ws-session=" + this.session.getId() + " on JMS connection " + this.conn.getConnectionID());
        }
        pkt.writePacket(new ByteBufferOutput(){

            public void writeByteBuffer(ByteBuffer data) throws IOException {
                WebSocketConnectionHandler.this.session.getBasicRemote().sendBinary(data);
            }

            public void writeBytes(byte[] data) throws IOException {
                throw new IOException("Unexpected call", new UnsupportedOperationException("writeBytes(byte[])"));
            }
        }, true);
    }

    private URI getURI() throws Exception {
        String mqscheme = this.mqaddr.getSchemeName();
        String service = this.mqaddr.getServiceName();
        String scheme = "ws";
        if (mqscheme.equalsIgnoreCase("mqws")) {
            if (service == null || service.trim().equals("")) {
                service = DEFAULT_WS_SERVICE_NAME;
            }
        } else {
            scheme = "wss";
            if (service == null || service.trim().equals("")) {
                service = DEFAULT_WSS_SERVICE_NAME;
            }
        }
        return new URI(scheme, null, this.mqaddr.getHostName(), this.mqaddr.getPort(), "/" + service + WEBSOCKET_JMS_PATH, null, null);
    }

    @Override
    public void configure(Properties configuration) throws IOException {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "WebSocketConnectionHandler@" + this.hashCode() + ": configure(" + configuration + ") on jms-connection@" + this.conn.hashCode());
        }
        try {
            WebSocketContainer client = ContainerProvider.getWebSocketContainer();
            client.setAsyncSendTimeout(0L);
            client.setDefaultMaxBinaryMessageBufferSize(Integer.MAX_VALUE);
            client.setDefaultMaxTextMessageBufferSize(Integer.MAX_VALUE);
            client.setDefaultMaxSessionIdleTimeout(0L);
            URI uri = this.getURI();
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "WebSocketConnectionHandler@" + this.hashCode() + ": configure(): WebSocketContainer.connectToServer(" + uri + ") on jms-connection@" + this.conn.hashCode());
            }
            client.connectToServer((Endpoint)this, ClientEndpointConfig.Builder.create().build(), uri);
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "WebSocketConnectionHandler@" + this.hashCode() + ": configure(): waiting (" + this.connectTimeout + ") for websocket session open to " + uri + " on jms-connection@" + this.conn.hashCode());
            }
            if (this.connectTimeout > 0) {
                if (!this.onOpenLatch.await(this.connectTimeout, TimeUnit.MILLISECONDS)) {
                    throw new IOException(AdministeredObject.cr.getKString("C4329", this.mqaddr.getURL(), "jms-connection@" + this.conn.hashCode()));
                }
            } else {
                this.onOpenLatch.await();
            }
        }
        catch (Exception e) {
            Object[] params = new String[]{this.mqaddr.getURL(), "jms-connection@" + this.conn.hashCode(), e.getMessage()};
            String emsg = AdministeredObject.cr.getKString("C4328", params);
            logger.log(Level.SEVERE, emsg, e);
            throw new IOException(emsg, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        String id = null;
        Session ss = null;
        Object object = this.sessionLock;
        synchronized (object) {
            if (this.closed) {
                return;
            }
            this.closed = true;
            ss = this.session;
            if (ss != null) {
                id = ss.getId();
            }
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "WebSocketConnectionHandler@" + this.hashCode() + ": close(): ws-session=" + id + " on JMS connection " + this.conn.getConnectionID());
        }
        if (ss != null) {
            ss.close();
        }
        object = this.sessionLock;
        synchronized (object) {
            this.sessionLock.notifyAll();
            this.onOpenLatch.countDown();
        }
    }

    @Override
    public String getBrokerAddress() {
        return this.mqaddr.getURL();
    }

    @Override
    public String getBrokerHostName() {
        return this.mqaddr.getHostName();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        throw new UnsupportedOperationException("WebSocketConnectionHandler.getInputStream()");
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        throw new UnsupportedOperationException("WebSocketConnectionHandler.getOutputStream()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onOpen(Session ss, EndpointConfig config) {
        block19: {
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, "WebSocketConnectionHandler@" + this.hashCode() + ": onOpen(WS-Session=" + ss + ", EndpointConfig=" + config + ") on JMS connection " + this.conn.getConnectionID());
            } else if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "WebSocketConnectionHandler@" + this.hashCode() + ": onOpen(WS-Session=" + ss.getId() + ") on JMS connection " + this.conn.getConnectionID());
            }
            boolean doclose = false;
            Object object = this.sessionLock;
            synchronized (object) {
                if (this.session != null || this.closed) {
                    doclose = true;
                } else {
                    this.session = ss;
                    this.onOpenLatch.countDown();
                }
            }
            if (doclose) {
                try {
                    try {
                        ss.close();
                        break block19;
                    }
                    finally {
                        this.close();
                    }
                }
                catch (Exception e) {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.log(Level.FINE, AdministeredObject.cr.getKString("W2012", this.toString(), e.toString()), e);
                    }
                }
                finally {
                    if (!this.closed) {
                        throw new IllegalStateException("There is an existing WebSocket session " + this);
                    }
                    break block19;
                }
            }
            this.session.addMessageHandler((MessageHandler)this);
        }
    }

    public void onClose(Session session, CloseReason closeReason) {
        block5: {
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, "WebSocketConnectionHandler@" + this.hashCode() + ": onClose(Session=" + session + ", CloseReason=" + closeReason + "), ws-session=" + this.session + " on JMS connection " + this.conn.getConnectionID());
            } else if (logger.isLoggable(Level.FINE)) {
                Session ss = this.session;
                logger.log(Level.FINE, "WebSocketConnectionHandler@" + this.hashCode() + ": onClose(Session=" + session.getId() + ", CloseReason=" + closeReason + "), ws-session=" + (ss == null ? "null" : ss.getId()) + " on JMS connection " + this.conn.getConnectionID());
            }
            try {
                this.close();
            }
            catch (Exception e) {
                if (!logger.isLoggable(Level.FINE)) break block5;
                logger.log(Level.FINE, AdministeredObject.cr.getKString("W2012", this.toString(), e.toString()), e);
            }
        }
    }

    public void onError(Session session, Throwable thr) {
        logger.log(Level.SEVERE, "onError(" + session + ", " + thr + ")" + this, thr);
        logger.log(Level.INFO, AdministeredObject.cr.getKString("C4327", this.toString(), thr.toString()));
        try {
            this.close();
        }
        catch (Exception e) {
            logger.log(Level.WARNING, AdministeredObject.cr.getKString("W2012", this.toString(), e.toString()), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(ByteBuffer data) {
        if (logger.isLoggable(Level.FINEST)) {
            Session ss = this.session;
            logger.log(Level.FINEST, Thread.currentThread() + "WebSocketConnectionHandler@" + this.hashCode() + ": onMessage(ByteBuffer@" + data.hashCode() + "[len=" + data.remaining() + ", pos=" + data.position() + "]), ws-session=" + (ss == null ? "null" : ss.getId()) + " on JMS connection " + this.conn.getConnectionID());
        }
        String id = null;
        while (data.hasRemaining()) {
            Object[] params;
            Object object = this.sessionLock;
            synchronized (object) {
                if (this.session == null) {
                    throw new IllegalStateException("WebSocket Session not open on JMS connection " + this.conn.getConnectionID());
                }
                id = this.session.getId();
                while (!this.closed && this.packetRead != null) {
                    if (logger.isLoggable(Level.FINE)) {
                        logger.log(Level.FINE, Thread.currentThread() + "WebSocketConnectionHandler@" + this.hashCode() + ": onMessage() waiting for packet read to be dispatched, ws-session=" + id + " on JMS connection " + this.conn.getConnectionID());
                    }
                    try {
                        this.sessionLock.wait();
                    }
                    catch (InterruptedException e) {}
                }
                if (this.closed) {
                    throw new IllegalStateException(AdministeredObject.cr.getKString("C4325"));
                }
                if (this.packetPending == null) {
                    this.packetPending = new ReadWritePacket();
                }
            }
            try {
                if (!this.packetPending.readPacket(data)) continue;
                if (!this.packetPending.hasBigPacketException()) {
                    object = this.sessionLock;
                    synchronized (object) {
                        this.packetRead = this.packetPending;
                        this.packetPending = null;
                        this.sessionLock.notifyAll();
                    }
                    if (!logger.isLoggable(Level.FINEST)) continue;
                    logger.log(Level.FINEST, Thread.currentThread() + "WebSocketConnectionHandler@" + this.hashCode() + ": onMessage(): RECEIVED PACKET=" + this.packetPending + ", remaining=" + data.remaining() + ",ws-session=" + id + " on JMS connection " + this.conn.getConnectionID());
                    continue;
                }
                BigPacketException ioe = this.packetPending.getBigPacketException();
                this.packetPending = null;
                throw new IOException("BigPacketException", ioe);
            }
            catch (BigPacketException e) {
                params = new String[]{this.packetPending == null ? "(r):" + this.packetRead : "(p):" + this.packetPending, this.toString(), e.getMessage()};
                String emsg = AdministeredObject.cr.getKString("C4326", params);
                logger.log(Level.SEVERE, emsg);
            }
            catch (IOException e) {
                this.onError(this.session, e);
                params = new String[]{this.packetPending == null ? "(r):" + this.packetRead : "(p):" + this.packetPending, this.toString(), e.getMessage()};
                throw new RuntimeException(AdministeredObject.cr.getKString("C4326", params), e);
            }
        }
    }

    public String toString() {
        Session ss = this.session;
        return "[WebSocketConnectionHandler@" + this.hashCode() + ", ws-session=" + (ss == null ? "null" : ss.getId()) + ", jms-connection@" + this.conn.hashCode() + "[" + this.conn.getConnectionID() + "]]";
    }
}

