/*
 * Decompiled with CFR 0.152.
 */
package com.sun.interview;

import com.sun.interview.Interview;
import com.sun.interview.Question;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public abstract class ChoiceQuestion
extends Question {
    private String[] choices;
    private String[] displayChoices;
    protected String value;
    private String defaultValue;

    protected ChoiceQuestion(Interview interview, String string) {
        super(interview, string);
    }

    protected ChoiceQuestion(Interview interview, String string, String[] stringArray) {
        super(interview, string);
        this.setChoices(stringArray, stringArray);
    }

    protected void setChoices(String[] stringArray) {
        this.setChoices(stringArray, stringArray);
    }

    protected void setChoices(String[] stringArray, boolean bl) {
        this.setChoices(stringArray, bl ? null : stringArray);
    }

    protected void setChoices(String[] stringArray, String[] stringArray2) {
        if (stringArray == null) {
            throw new NullPointerException();
        }
        if (stringArray2 != null && stringArray.length != stringArray2.length) {
            throw new IllegalArgumentException();
        }
        boolean bl = this.choices == null;
        this.choices = stringArray;
        this.displayChoices = stringArray2;
        this.defaultValue = stringArray[0];
        if (bl && this.interview.getInterviewSemantics() > 0) {
            this.clear();
        } else if (this.value == null) {
            this.value = stringArray[0];
        } else {
            for (int i = 0; i < stringArray.length; ++i) {
                if (!this.value.equals(stringArray[i])) continue;
                this.value = stringArray[i];
                return;
            }
            this.value = stringArray[0];
        }
    }

    protected void setI18NChoices(String[] stringArray) {
        this.setChoices(stringArray, true);
    }

    public String[] getChoices() {
        return this.choices;
    }

    public String[] getDisplayChoices() {
        if (this.displayChoices == null) {
            ResourceBundle resourceBundle = this.interview.getResourceBundle();
            if (resourceBundle == null) {
                return this.choices;
            }
            this.displayChoices = new String[this.choices.length];
            for (int i = 0; i < this.choices.length; ++i) {
                String string = this.choices[i];
                try {
                    this.displayChoices[i] = string == null ? null : resourceBundle.getString(this.key + "." + string);
                    continue;
                }
                catch (MissingResourceException missingResourceException) {
                    this.displayChoices[i] = string;
                }
            }
        }
        return this.displayChoices;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String string) {
        this.defaultValue = string;
    }

    public String getValue() {
        return this.value;
    }

    public String getDisplayValue() {
        this.getDisplayChoices();
        String string = this.getValue();
        for (int i = 0; i < this.choices.length; ++i) {
            if (!(string == null ? this.choices[i] == null : string.equals(this.choices[i]))) continue;
            return this.displayChoices[i];
        }
        return string;
    }

    public String getValueOnPath() throws Interview.NotOnPathFault {
        this.interview.verifyPathContains(this);
        return this.getValue();
    }

    public String getStringValue() {
        return this.getValue();
    }

    public void setValue(String string) {
        if (this.choices == null) {
            return;
        }
        if (string == null) {
            if (this.value != null) {
                this.value = null;
                this.interview.updatePath(this);
                this.interview.setEdited(true);
            }
        } else {
            for (int i = 0; i < this.choices.length; ++i) {
                if (!string.equals(this.choices[i])) continue;
                string = this.choices[i];
                break;
            }
            if (!string.equals(this.value)) {
                this.value = string;
                this.interview.updatePath(this);
                this.interview.setEdited(true);
            }
        }
    }

    public boolean isValueValid() {
        for (int i = 0; i < this.choices.length; ++i) {
            if (!(this.value == null ? this.choices[i] == null : this.value.equals(this.choices[i]))) continue;
            return true;
        }
        return false;
    }

    public boolean isValueAlwaysValid() {
        return false;
    }

    public void clear() {
        this.setValue(this.defaultValue);
    }

    protected void load(Map map) {
        Object v = map.get(this.tag);
        if (v instanceof String) {
            this.setValue((String)v);
        }
    }

    protected void save(Map map) {
        if (this.value != null) {
            map.put(this.tag, this.value);
        }
    }
}

