/*
 * Decompiled with CFR 0.152.
 */
package com.sun.interview;

import com.sun.interview.Interview;
import com.sun.interview.Question;
import java.util.Map;
import java.util.Vector;

public abstract class StringListQuestion
extends Question {
    private static final String[] empty = new String[0];
    protected String[] value;
    private String[] defaultValue;
    private boolean duplicatesAllowed = true;

    protected StringListQuestion(Interview interview, String string) {
        super(interview, string);
        this.clear();
        this.setDefaultValue(this.value);
    }

    public String[] getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String[] stringArray) {
        this.defaultValue = stringArray;
    }

    public void setDuplicatesAllowed(boolean bl) {
        this.duplicatesAllowed = bl;
    }

    public boolean isDuplicatesAllowed() {
        return this.duplicatesAllowed;
    }

    public String[] getValue() {
        return this.value;
    }

    public String[] getValueOnPath() throws Interview.NotOnPathFault {
        this.interview.verifyPathContains(this);
        return this.getValue();
    }

    public String getStringValue() {
        if (this.value == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.value.length; ++i) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append('\n');
            }
            if (this.value[i] == null) continue;
            stringBuffer.append(this.value[i]);
        }
        return stringBuffer.toString();
    }

    public boolean isValueValid() {
        return true;
    }

    public boolean isValueAlwaysValid() {
        return false;
    }

    public void setValue(String string) {
        this.setValue(string == null ? (String[])null : StringListQuestion.split(string));
    }

    public void setValue(String[] stringArray) {
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i] != null && stringArray[i].indexOf("\n") == -1) continue;
                throw new IllegalArgumentException();
            }
        }
        if (!StringListQuestion.equal(stringArray, this.value)) {
            if (stringArray == null) {
                this.value = null;
            } else {
                this.value = new String[stringArray.length];
                System.arraycopy(stringArray, 0, this.value, 0, stringArray.length);
            }
            this.interview.updatePath(this);
            this.interview.setEdited(true);
        }
    }

    public void clear() {
        this.setValue(this.defaultValue);
    }

    protected void load(Map map) {
        Object v = map.get(this.tag);
        if (v instanceof String[]) {
            this.setValue((String[])v);
        } else if (v instanceof String) {
            this.setValue((String)v);
        }
    }

    protected void save(Map map) {
        if (this.value != null) {
            map.put(this.tag, this.getStringValue());
        }
    }

    protected static boolean equal(String[] stringArray, String[] stringArray2) {
        if (stringArray == null || stringArray2 == null) {
            return stringArray == stringArray2;
        }
        if (stringArray.length != stringArray2.length) {
            return false;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (StringListQuestion.equal(stringArray[i], stringArray2[i])) continue;
            return false;
        }
        return true;
    }

    protected static boolean equal(String string, String string2) {
        return string == null ? string2 == null : string.equals(string2);
    }

    protected static String[] split(String string) {
        if (string == null) {
            return empty;
        }
        Vector<String> vector = new Vector<String>();
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '\n') {
                if (n != -1) {
                    vector.addElement(string.substring(n, i));
                }
                n = -1;
                continue;
            }
            if (n != -1) continue;
            n = i;
        }
        if (n != -1) {
            vector.addElement(string.substring(n));
        }
        if (vector.size() == 0) {
            return empty;
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }
}

