/*
 * Decompiled with CFR 0.152.
 */
package com.sun.interview.wizard;

import com.sun.interview.ChoiceQuestion;
import com.sun.interview.Question;
import com.sun.interview.wizard.I18NResourceBundle;
import com.sun.interview.wizard.SmartChoiceQuestionRenderer;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

class ChoiceQuestionRenderer
extends SmartChoiceQuestionRenderer {
    private JPanel btnPanel;
    private static final I18NResourceBundle i18n = I18NResourceBundle.getDefaultBundle();

    ChoiceQuestionRenderer() {
    }

    public JComponent getQuestionRendererComponent(Question question, ActionListener actionListener) {
        ChoiceQuestion choiceQuestion = (ChoiceQuestion)question;
        this.setCurrQuestion(choiceQuestion);
        if (this.isEnoughPlace()) {
            return this.createRadioButtons(choiceQuestion, this.getRowsNumber(), this.getColsNumber(), actionListener);
        }
        return this.createChoiceList(choiceQuestion, actionListener);
    }

    public String getInvalidValueMessage(Question question) {
        return null;
    }

    private JComponent createRadioButtons(final ChoiceQuestion choiceQuestion, int n, int n2, final ActionListener actionListener) {
        Object object;
        Object object2;
        int n3;
        String[] stringArray = choiceQuestion.getChoices();
        String[] stringArray2 = choiceQuestion.getDisplayChoices();
        boolean bl = stringArray[0] == null;
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 23;
        gridBagConstraints.fill = 2;
        jPanel.setName("chc.btns");
        jPanel.setFocusable(false);
        String string = choiceQuestion.getValue();
        ButtonGroup buttonGroup = new ButtonGroup();
        ActionListener actionListener2 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                choiceQuestion.setValue(actionEvent.getActionCommand());
                ChoiceQuestionRenderer.this.fireEditedEvent(actionEvent.getSource(), actionListener);
            }
        };
        int n4 = 0;
        int n5 = n3 = bl ? 1 : 0;
        while (n3 < stringArray.length) {
            object2 = stringArray[n3];
            object = stringArray2[n3];
            JRadioButton jRadioButton = new JRadioButton((String)object, string == object2);
            jRadioButton.setName("chc.btn." + stringArray[n3]);
            if (n4 < 10) {
                jRadioButton.setMnemonic(48 + n4);
            }
            jRadioButton.setToolTipText(i18n.getString("chc.btn.tip"));
            jRadioButton.getAccessibleContext().setAccessibleName(jRadioButton.getName());
            jRadioButton.getAccessibleContext().setAccessibleDescription(jRadioButton.getToolTipText());
            jRadioButton.setActionCommand((String)object2);
            jRadioButton.addActionListener(actionListener2);
            buttonGroup.add(jRadioButton);
            gridBagConstraints.gridx = n4 % n2;
            gridBagConstraints.gridy = n4 / n2;
            jPanel.add((Component)jRadioButton, gridBagConstraints);
            ++n4;
            ++n3;
        }
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.setName("chc");
        jPanel2.setFocusable(false);
        object2 = new JLabel(i18n.getString("chc.btns.lbl"));
        object = new GridBagConstraints();
        ((GridBagConstraints)object).anchor = 18;
        ((GridBagConstraints)object).gridwidth = 0;
        ((GridBagConstraints)object).weightx = 1.0;
        jPanel2.add((Component)object2, object);
        ((GridBagConstraints)object).insets.top = 10;
        ((GridBagConstraints)object).anchor = 11;
        jPanel2.add((Component)jPanel, object);
        return jPanel2;
    }

    private JPanel createChoiceList(final ChoiceQuestion choiceQuestion, final ActionListener actionListener) {
        String[] stringArray;
        boolean bl;
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setName("chc");
        jPanel.setFocusable(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        JLabel jLabel = new JLabel(i18n.getString("chc.combo.lbl"));
        jLabel.setName("choice.combo.lbl");
        jLabel.setDisplayedMnemonic(i18n.getString("chc.combo.mne").charAt(0));
        jLabel.setToolTipText(i18n.getString("chc.combo.tip"));
        jPanel.add((Component)jLabel, gridBagConstraints);
        final String[] stringArray2 = choiceQuestion.getChoices();
        String[] stringArray3 = choiceQuestion.getDisplayChoices();
        boolean bl2 = bl = stringArray2[0] == null;
        if (bl) {
            stringArray = new String[stringArray2.length];
            stringArray[0] = i18n.getString("chc.selectOne");
            System.arraycopy(stringArray3, 1, stringArray, 1, stringArray2.length - 1);
        } else {
            stringArray = stringArray3;
        }
        final JComboBox<String> jComboBox = new JComboBox<String>(stringArray2);
        jComboBox.setName("chc.list");
        if (choiceQuestion.getValue() == null) {
            jComboBox.setSelectedIndex(0);
        } else {
            jComboBox.setSelectedItem(choiceQuestion.getValue());
        }
        jComboBox.setEditable(false);
        jLabel.setLabelFor(jComboBox);
        if (stringArray != stringArray2) {
            jComboBox.setRenderer(new DefaultListCellRenderer(){

                public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                    Object object2 = object;
                    for (int i = 0; i < stringArray2.length; ++i) {
                        if (stringArray2[i] != object) continue;
                        object2 = stringArray[i];
                        break;
                    }
                    return super.getListCellRendererComponent((JList<?>)jList, object2, n, bl, bl2);
                }
            });
        }
        jComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                choiceQuestion.setValue((String)jComboBox.getSelectedItem());
                ChoiceQuestionRenderer.this.fireEditedEvent(actionEvent.getSource(), actionListener);
            }
        });
        gridBagConstraints.insets.top = 10;
        gridBagConstraints.anchor = 11;
        jPanel.add(jComboBox, gridBagConstraints);
        return jPanel;
    }

    private void fireEditedEvent(Object object, ActionListener actionListener) {
        ActionEvent actionEvent = new ActionEvent(object, 1001, "edited");
        actionListener.actionPerformed(actionEvent);
    }
}

