/*
 * Decompiled with CFR 0.152.
 */
package com.sun.interview.wizard;

import com.sun.interview.wizard.I18NResourceBundle;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.lang.reflect.Array;
import java.text.MessageFormat;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

class EditableList
extends JPanel {
    private boolean duplicatesAllowed;
    private Listener listener = new Listener();
    private Renderer renderer = new Renderer();
    private DefaultListModel listModel;
    private JList list;
    private JButton addBtn;
    private JButton removeBtn;
    private JButton upBtn;
    private JButton downBtn;
    private static final I18NResourceBundle i18n = I18NResourceBundle.getDefaultBundle();

    public EditableList(String string, Object[] objectArray) {
        this.setLayout(new BorderLayout());
        this.setName(string);
        this.setFocusable(false);
        this.listModel = new DefaultListModel();
        if (objectArray != null) {
            for (int i = 0; i < objectArray.length; ++i) {
                this.listModel.addElement(objectArray[i]);
            }
        }
        this.list = new JList(this.listModel);
        this.list.setName(string);
        this.list.setToolTipText(i18n.getString(string + ".tip"));
        this.list.getAccessibleContext().setAccessibleName(this.list.getName());
        this.list.getAccessibleContext().setAccessibleDescription(this.list.getToolTipText());
        this.list.setSelectionMode(0);
        this.list.setCellRenderer(this.renderer);
        this.list.addListSelectionListener(this.listener);
        this.list.addMouseListener(this.listener);
        this.list.setVisibleRowCount(5);
        JScrollPane jScrollPane = new JScrollPane(this.list);
        jScrollPane.setName(string + ".sp");
        jScrollPane.setFocusable(false);
        this.add((Component)jScrollPane, "Center");
        JToolBar jToolBar = new JToolBar(1);
        jToolBar.setName(string + "bar");
        jToolBar.setFocusable(false);
        jToolBar.setFloatable(false);
        this.addBtn = this.createButton("elst.add");
        jToolBar.add(this.addBtn);
        this.removeBtn = this.createButton("elst.remove");
        jToolBar.add(this.removeBtn);
        this.upBtn = this.createButton("elst.up");
        jToolBar.add(this.upBtn);
        this.downBtn = this.createButton("elst.down");
        jToolBar.add(this.downBtn);
        this.add((Component)jToolBar, "East");
        this.updateButtons();
        this.setBorder(BorderFactory.createEtchedBorder());
    }

    public int getItemCount() {
        return this.listModel.getSize();
    }

    public Object getItem(int n) {
        return this.listModel.elementAt(n);
    }

    public Object[] getItems() {
        return this.listModel.toArray();
    }

    public Object[] getItems(Class clazz) {
        Object[] objectArray = (Object[])Array.newInstance(clazz, this.listModel.size());
        this.listModel.copyInto(objectArray);
        return objectArray;
    }

    public int getSelectedIndex() {
        return this.list.getSelectedIndex();
    }

    public Object getSelectedItem() {
        return this.list.getSelectedValue();
    }

    public void setSelectedItem(Object object) {
        this.list.setSelectedValue(object, true);
    }

    public void addListDataListener(ListDataListener listDataListener) {
        this.listModel.addListDataListener(listDataListener);
    }

    public void removeListDataListener(ListDataListener listDataListener) {
        this.listModel.removeListDataListener(listDataListener);
    }

    public void setDuplicatesAllowed(boolean bl) {
        this.duplicatesAllowed = bl;
    }

    public boolean isDuplicatesAllowed() {
        return this.duplicatesAllowed;
    }

    protected Object getDisplayValue(Object object) {
        return object;
    }

    protected Object getNewItem() {
        return JOptionPane.showInputDialog(this, (Object)i18n.getString("elst.add.title"));
    }

    protected Object getNewItem(Object object) {
        return JOptionPane.showInputDialog(this, i18n.getString("elst.change.title"), object);
    }

    protected void itemsChanged() {
    }

    protected void selectedItemChanged() {
    }

    protected void insertItem() {
        Object object = this.getNewItem();
        if (!this.duplicatesAllowed && this.listModel.contains(object)) {
            this.showDuplicateError(object);
            return;
        }
        if (object != null) {
            if (this.list.isSelectionEmpty()) {
                this.listModel.addElement(object);
            } else {
                this.listModel.add(1 + this.list.getSelectedIndex(), object);
            }
            this.list.setSelectedValue(object, true);
        }
    }

    protected void removeSelectedItem() {
        if (!this.list.isSelectionEmpty()) {
            this.listModel.remove(this.list.getSelectedIndex());
        }
    }

    protected void moveSelectedItemUp() {
        int n;
        if (!this.list.isSelectionEmpty() && (n = this.list.getSelectedIndex()) > 0) {
            this.swap(n, n - 1);
            this.list.setSelectedIndex(n - 1);
        }
    }

    private void moveSelectedItemDown() {
        int n;
        if (!this.list.isSelectionEmpty() && (n = this.list.getSelectedIndex()) + 1 < this.listModel.size()) {
            this.swap(n, n + 1);
            this.list.setSelectedIndex(n + 1);
        }
    }

    private void editItem(int n) {
        Object object = this.getNewItem(this.listModel.getElementAt(n));
        if (!this.duplicatesAllowed && this.listModel.contains(object)) {
            this.showDuplicateError(object);
            return;
        }
        if (object != null) {
            this.listModel.set(n, object);
        }
    }

    protected JButton createButton(String string) {
        JButton jButton = new JButton(i18n.getString(string + ".btn"));
        jButton.setName(string);
        jButton.setToolTipText(i18n.getString(string + ".tip"));
        jButton.setMnemonic(i18n.getString(string + ".mne").charAt(0));
        jButton.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
        jButton.addActionListener(this.listener);
        return jButton;
    }

    private void showDuplicateError(Object object) {
        String string = MessageFormat.format(i18n.getString("elst.duplicate.text"), this.getDisplayValue(object));
        String string2 = i18n.getString("elst.duplicate.title");
        JOptionPane.showMessageDialog(this, string, string2, 1);
    }

    private void updateButtons() {
        if (this.list.isSelectionEmpty()) {
            this.removeBtn.setEnabled(false);
            this.upBtn.setEnabled(false);
            this.downBtn.setEnabled(false);
        } else {
            this.removeBtn.setEnabled(true);
            int n = this.list.getSelectedIndex();
            this.upBtn.setEnabled(n > 0);
            this.downBtn.setEnabled(n + 1 < this.listModel.size());
        }
    }

    private void swap(int n, int n2) {
        Object e = this.listModel.elementAt(n);
        Object e2 = this.listModel.elementAt(n2);
        this.listModel.set(n, e2);
        this.listModel.set(n2, e);
    }

    private class Listener
    implements ActionListener,
    ListSelectionListener,
    MouseListener {
        private Listener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == EditableList.this.addBtn) {
                EditableList.this.insertItem();
            } else if (object == EditableList.this.removeBtn) {
                EditableList.this.removeSelectedItem();
            } else if (object == EditableList.this.upBtn) {
                EditableList.this.moveSelectedItemUp();
            } else if (object == EditableList.this.downBtn) {
                EditableList.this.moveSelectedItemDown();
            }
            EditableList.this.itemsChanged();
            EditableList.this.updateButtons();
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            EditableList.this.selectedItemChanged();
            EditableList.this.updateButtons();
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() == 2) {
                int n = EditableList.this.list.locationToIndex(mouseEvent.getPoint());
                EditableList.this.editItem(n);
            }
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }
    }

    private class Renderer
    extends DefaultListCellRenderer {
        private Renderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            return super.getListCellRendererComponent((JList<?>)jList, EditableList.this.getDisplayValue(object), n, bl, bl2);
        }
    }
}

