/*
 * Decompiled with CFR 0.152.
 */
package com.sun.interview.wizard;

import com.sun.interview.FileFilter;
import com.sun.interview.FileListQuestion;
import com.sun.interview.Question;
import com.sun.interview.wizard.ActionListDataListener;
import com.sun.interview.wizard.FileList;
import com.sun.interview.wizard.I18NResourceBundle;
import com.sun.interview.wizard.QuestionRenderer;
import com.sun.interview.wizard.SwingFileFilter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

class FileListQuestionRenderer
implements QuestionRenderer {
    private static final I18NResourceBundle i18n = I18NResourceBundle.getDefaultBundle();

    FileListQuestionRenderer() {
    }

    public JComponent getQuestionRendererComponent(Question question, ActionListener actionListener) {
        final FileListQuestion fileListQuestion = (FileListQuestion)question;
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setName("flst");
        jPanel.setFocusable(false);
        JLabel jLabel = new JLabel(i18n.getString("flst.lbl"));
        jLabel.setName("flst.lbl");
        jLabel.setDisplayedMnemonic(i18n.getString("flst.mne").charAt(0));
        jLabel.setToolTipText(i18n.getString("flst.tip"));
        jPanel.add((Component)jLabel, "North");
        final FileList fileList = new FileList("flst", fileListQuestion.getValue());
        fileList.setDuplicatesAllowed(fileListQuestion.isDuplicatesAllowed());
        fileList.addListDataListener(new ActionListDataListener(jPanel, actionListener, "edited"));
        fileList.setBaseDirectory(fileListQuestion.getBaseDirectory());
        jLabel.setLabelFor(fileList);
        FileFilter[] fileFilterArray = fileListQuestion.getFilters();
        if (fileFilterArray == null || fileFilterArray.length == 0) {
            fileList.setFileSelectionMode(0);
        } else {
            int n = -1;
            for (int i = 0; i < fileFilterArray.length; ++i) {
                FileFilter fileFilter = fileFilterArray[i];
                fileList.addFilter(SwingFileFilter.wrap(fileFilter));
                if (fileFilter.acceptsDirectories()) {
                    if (n == -1) {
                        n = 2;
                        continue;
                    }
                    if (n != 0) continue;
                    n = 2;
                    continue;
                }
                if (n == -1) {
                    n = 0;
                    continue;
                }
                if (n != 1) continue;
                n = 2;
            }
            fileList.setFileSelectionMode(n);
        }
        jPanel.add((Component)fileList, "Center");
        Runnable runnable = new Runnable(){

            public void run() {
                fileListQuestion.setValue(fileList.getFiles());
            }
        };
        jPanel.putClientProperty("valueSaver", runnable);
        return jPanel;
    }

    public String getInvalidValueMessage(Question question) {
        return null;
    }
}

