/*
 * Decompiled with CFR 0.152.
 */
package com.sun.interview.wizard;

import com.sun.interview.ExtensionFileFilter;
import com.sun.interview.FileFilter;
import com.sun.interview.FileQuestion;
import com.sun.interview.Question;
import com.sun.interview.wizard.I18NResourceBundle;
import com.sun.interview.wizard.QuestionRenderer;
import com.sun.interview.wizard.SwingFileFilter;
import com.sun.interview.wizard.TypeInPanel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;

class FileQuestionRenderer
implements QuestionRenderer {
    private static final I18NResourceBundle i18n = I18NResourceBundle.getDefaultBundle();

    FileQuestionRenderer() {
    }

    public JComponent getQuestionRendererComponent(Question question, ActionListener actionListener) {
        String[] stringArray;
        File[] fileArray;
        final FileQuestion fileQuestion = (FileQuestion)question;
        final JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setDialogTitle(fileQuestion.getSummary());
        FileFilter[] fileFilterArray = fileQuestion.getFilters();
        if (fileFilterArray == null || fileFilterArray.length == 0) {
            jFileChooser.setAcceptAllFileFilterUsed(true);
            jFileChooser.setFileSelectionMode(0);
        } else {
            int n = -1;
            for (int i = 0; i < fileFilterArray.length; ++i) {
                fileArray = fileFilterArray[i];
                jFileChooser.addChoosableFileFilter(SwingFileFilter.wrap((FileFilter)fileArray));
                if (fileArray.acceptsDirectories()) {
                    if (n == -1) {
                        n = 2;
                        continue;
                    }
                    if (n != 0) continue;
                    n = 2;
                    continue;
                }
                if (n == -1) {
                    n = 0;
                    continue;
                }
                if (n != 1) continue;
                n = 2;
            }
            jFileChooser.setFileSelectionMode(n);
        }
        File file = fileQuestion.getValue();
        if (file == null) {
            File file2 = fileQuestion.getBaseDirectory();
            if (file2 == null) {
                file2 = new File(System.getProperty("user.dir"));
            }
            jFileChooser.setCurrentDirectory(file2);
        } else {
            jFileChooser.setSelectedFile(file);
        }
        final JButton jButton = new JButton(i18n.getString("file.browse.btn"));
        jButton.setName("file.browse.btn");
        jButton.setMnemonic(i18n.getString("file.browse.mne").charAt(0));
        jButton.setToolTipText(i18n.getString("file.browse.tip"));
        fileArray = fileQuestion.getSuggestions();
        if (fileArray == null) {
            stringArray = null;
        } else {
            stringArray = new String[fileArray.length];
            for (int i = 0; i < fileArray.length; ++i) {
                stringArray[i] = fileArray[i].getPath();
            }
        }
        final TypeInPanel typeInPanel = new TypeInPanel("file", fileQuestion, 0, stringArray, jButton, actionListener);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int n;
                Object object;
                String string = typeInPanel.getValue();
                if (string != null && string.length() > 0) {
                    File file = new File(string);
                    object = fileQuestion.getBaseDirectory();
                    if (!file.isAbsolute() && object != null) {
                        file = new File((File)object, string);
                    }
                    jFileChooser.setSelectedFile(file);
                }
                if ((n = jFileChooser.showDialog(jButton, "Select")) == 0) {
                    String string2;
                    Object object2;
                    object = jFileChooser.getSelectedFile().getPath();
                    FileFilter fileFilter = SwingFileFilter.unwrap(jFileChooser.getFileFilter());
                    if (fileFilter != null && fileFilter instanceof ExtensionFileFilter) {
                        object2 = (ExtensionFileFilter)fileFilter;
                        object = ((ExtensionFileFilter)object2).ensureExtension((String)object);
                    }
                    if ((object2 = fileQuestion.getBaseDirectory()) != null && ((String)object).startsWith((string2 = ((File)object2).getPath()) + File.separatorChar)) {
                        object = ((String)object).substring(string2.length() + 1);
                    }
                    typeInPanel.setValue((String)object);
                }
            }
        });
        return typeInPanel;
    }

    public String getInvalidValueMessage(Question question) {
        return null;
    }
}

