/*
 * Decompiled with CFR 0.152.
 */
package com.sun.interview.wizard;

import com.sun.interview.InetAddressQuestion;
import com.sun.interview.Question;
import com.sun.interview.wizard.ActionDocListener;
import com.sun.interview.wizard.I18NResourceBundle;
import com.sun.interview.wizard.QuestionRenderer;
import com.sun.interview.wizard.TypeInPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import javax.swing.AbstractAction;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.Keymap;

class InetAddressQuestionRenderer
implements QuestionRenderer {
    private JOptionPane lookupPane;
    private static final KeyStroke enterKey = KeyStroke.getKeyStroke(10, 0);
    private static final I18NResourceBundle i18n = I18NResourceBundle.getDefaultBundle();
    private static Color INVALID_VALUE_COLOR = i18n.getErrorColor();

    InetAddressQuestionRenderer() {
    }

    public JComponent getQuestionRendererComponent(Question question, ActionListener actionListener) {
        InetAddressQuestion inetAddressQuestion = (InetAddressQuestion)question;
        int n = inetAddressQuestion.getType();
        int n2 = inetAddressQuestion.getStyle();
        InetAddress[] inetAddressArray = inetAddressQuestion.getSuggestions();
        if (n == 0 && n2 == 0 && inetAddressArray == null) {
            return this.createIPv4Panel(inetAddressQuestion, actionListener);
        }
        return this.createIPv6Panel(inetAddressQuestion, actionListener);
    }

    private JPanel createIPv4Panel(final InetAddressQuestion inetAddressQuestion, ActionListener actionListener) {
        InetAddress inetAddress = inetAddressQuestion.getValue();
        byte[] byArray = inetAddress == null ? new byte[4] : inetAddress.getAddress();
        final JTextField[] jTextFieldArray = new JTextField[4];
        AbstractAction abstractAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                JTextField jTextField = (JTextField)actionEvent.getSource();
                JTextField jTextField2 = (JTextField)jTextField.getClientProperty("next");
                String string = actionEvent.getActionCommand();
                if (string.equals(".")) {
                    if (jTextField2 != null) {
                        jTextField2.requestFocus();
                        jTextField2.getCaret().setDot(0);
                        jTextField2.getCaret().moveDot(jTextField2.getText().length());
                        return;
                    }
                } else if (Character.isDigit(string.charAt(0))) {
                    int n = jTextField.getCaret().getDot();
                    int n2 = jTextField.getCaret().getMark();
                    String string2 = jTextField.getText();
                    DefaultEditorKit.InsertContentAction insertContentAction = new DefaultEditorKit.InsertContentAction();
                    insertContentAction.actionPerformed(actionEvent);
                    String string3 = jTextField.getText();
                    int n3 = Integer.parseInt(string3);
                    if (string3.length() <= 3 && n3 <= 255) {
                        if (jTextField.getCaretPosition() == 3 && jTextField2 != null) {
                            jTextField2.requestFocus();
                            jTextField2.getCaret().setDot(0);
                            jTextField2.getCaret().moveDot(jTextField2.getText().length());
                        }
                        return;
                    }
                    jTextField.setText(string2);
                    jTextField.getCaret().setDot(n2);
                    jTextField.getCaret().moveDot(n);
                } else if (string.charAt(0) == '\n') {
                    return;
                }
                jTextFieldArray[0].getToolkit().beep();
            }
        };
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setName("inet");
        jPanel.setFocusable(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        for (int i = 0; i < 4; ++i) {
            String string = i == 0 ? "inet.ip" : "inet.dot";
            JLabel jLabel = new JLabel(i18n.getString(string + ".lbl"));
            jLabel.setDisplayedMnemonic(i == 0 ? (int)i18n.getString(string + ".mne").charAt(0) : 48 + i);
            jLabel.setToolTipText(i18n.getString(string + ".tip"));
            jPanel.add((Component)jLabel, gridBagConstraints);
            int n = byArray[i];
            JTextField jTextField = new JTextField(String.valueOf(n < 0 ? n + 256 : n), 3);
            jTextField.setName("inet." + i);
            jTextField.setToolTipText(i18n.getString("inet.field.tip", new Integer(i)));
            jTextField.getDocument().addDocumentListener(new ActionDocListener(jTextField, actionListener, "edited"));
            Keymap keymap = JTextField.addKeymap("IP field", jTextField.getKeymap());
            keymap.setDefaultAction(abstractAction);
            jTextField.setKeymap(keymap);
            jLabel.setLabelFor(jTextField);
            if (i == 3) {
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.anchor = 17;
            }
            jPanel.add((Component)jTextField, gridBagConstraints);
            if (i > 0) {
                jTextFieldArray[i - 1].putClientProperty("next", jTextField);
            }
            jTextFieldArray[i] = jTextField;
        }
        Runnable runnable = new Runnable(){

            public void run() {
                StringBuffer stringBuffer = new StringBuffer();
                for (int i = 0; i < 4; ++i) {
                    String string = jTextFieldArray[i].getText();
                    if (string == null || string.length() == 0) {
                        stringBuffer.append("0");
                    } else {
                        stringBuffer.append(string);
                    }
                    if (i >= 3) continue;
                    stringBuffer.append(".");
                }
                try {
                    InetAddress inetAddress = InetAddress.getByName(stringBuffer.toString());
                    inetAddressQuestion.setValue(inetAddress);
                }
                catch (UnknownHostException unknownHostException) {
                    // empty catch block
                }
            }
        };
        jPanel.putClientProperty("valueSaver", runnable);
        return jPanel;
    }

    private JPanel createIPv6Panel(InetAddressQuestion inetAddressQuestion, ActionListener actionListener) {
        String[] stringArray;
        InetAddress[] inetAddressArray = inetAddressQuestion.getSuggestions();
        if (inetAddressArray == null) {
            stringArray = null;
        } else {
            stringArray = new String[inetAddressArray.length];
            for (int i = 0; i < inetAddressArray.length; ++i) {
                InetAddress inetAddress = inetAddressArray[i];
                stringArray[i] = inetAddress == null ? "" : inetAddress.getHostAddress();
            }
        }
        JButton jButton = new JButton(i18n.getString("inet.lookup.btn"));
        jButton.setName("inet.lookup.btn");
        jButton.setMnemonic(i18n.getString("inet.lookup.mne").charAt(0));
        jButton.setToolTipText(i18n.getString("inet.lookup.tip"));
        int n = inetAddressQuestion.getType();
        int n2 = n == 0 ? 16 : 0;
        final TypeInPanel typeInPanel = new TypeInPanel("inet", inetAddressQuestion, n2, stringArray, jButton, actionListener);
        this.lookupPane = new LookupPane(n);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JDialog jDialog = InetAddressQuestionRenderer.this.lookupPane.createDialog(typeInPanel, i18n.getString("inet.lookup.title"));
                jDialog.setVisible(true);
                typeInPanel.setValue((String)InetAddressQuestionRenderer.this.lookupPane.getValue());
            }
        });
        return typeInPanel;
    }

    public String getInvalidValueMessage(Question question) {
        return null;
    }

    private class LookupPane
    extends JOptionPane
    implements ActionListener,
    DocumentListener,
    ListSelectionListener {
        private int type;
        private JTextField nameField;
        private JTextField errorField;
        private DefaultListModel listModel;
        private JList list;
        private JButton okBtn;
        private static final String LOOKUP = "lookup";
        private static final String OK = "ok";
        private static final String CANCEL = "cancel";

        LookupPane(int n) {
            super(new JPanel(new GridBagLayout()));
            this.setMessageType(3);
            this.type = n;
            JPanel jPanel = (JPanel)this.getMessage();
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            JLabel jLabel = new JLabel(i18n.getString("inet.lookup.name.lbl"));
            jLabel.setDisplayedMnemonic(i18n.getString("inet.lookup.name.mne").charAt(0));
            gridBagConstraints.insets.right = 5;
            jPanel.add((Component)jLabel, gridBagConstraints);
            this.nameField = new JTextField(16);
            this.nameField.setActionCommand(LOOKUP);
            this.nameField.addActionListener(this);
            jLabel.setLabelFor(this.nameField);
            gridBagConstraints.insets.right = 0;
            gridBagConstraints.weightx = 1.0;
            jPanel.add((Component)this.nameField, gridBagConstraints);
            String string = i18n.getString("inet.lookup.icon");
            URL uRL = this.getClass().getResource(string);
            JButton jButton = uRL == null ? new JButton(string) : new JButton(new ImageIcon(uRL));
            jButton.setActionCommand(LOOKUP);
            jButton.addActionListener(this);
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.insets.left = 5;
            gridBagConstraints.gridwidth = 0;
            jPanel.add((Component)jButton, gridBagConstraints);
            this.errorField = new JTextField(16);
            this.errorField.setName("inet.lookup.error");
            this.errorField.setEditable(false);
            this.errorField.setBorder(null);
            this.errorField.setFont(this.errorField.getFont().deriveFont(1));
            this.errorField.setForeground(INVALID_VALUE_COLOR);
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets.left = 0;
            gridBagConstraints.weightx = 1.0;
            jPanel.add((Component)this.errorField, gridBagConstraints);
            this.listModel = new DefaultListModel();
            this.list = new JList(this.listModel);
            this.list.setVisibleRowCount(3);
            this.list.setSelectionMode(0);
            this.list.addListSelectionListener(this);
            gridBagConstraints.fill = 1;
            gridBagConstraints.weightx = 1.0;
            jPanel.add((Component)new JScrollPane(this.list), gridBagConstraints);
            this.okBtn = new JButton(i18n.getString("inet.lookup.ok.btn"));
            this.okBtn.setActionCommand(OK);
            this.okBtn.setEnabled(false);
            this.okBtn.addActionListener(this);
            JButton jButton2 = new JButton(i18n.getString("inet.lookup.cancel.btn"));
            jButton2.setActionCommand(OK);
            jButton2.addActionListener(this);
            this.setOptions(new Object[]{this.okBtn, jButton2});
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals(LOOKUP)) {
                String string2 = this.nameField.getText();
                if (string2 == null || string2.length() == 0) {
                    this.errorField.setText(i18n.getString("inet.lookup.noName.err"));
                } else {
                    InetAddress[] inetAddressArray;
                    try {
                        inetAddressArray = InetAddress.getAllByName(string2);
                    }
                    catch (UnknownHostException unknownHostException) {
                        inetAddressArray = null;
                    }
                    this.listModel.clear();
                    if (inetAddressArray == null || inetAddressArray.length == 0) {
                        this.errorField.setText(i18n.getString("inet.lookup.notFound.err"));
                    } else {
                        this.errorField.setText("");
                        for (int i = 0; i < inetAddressArray.length; ++i) {
                            this.listModel.addElement(inetAddressArray[i].getHostAddress());
                        }
                        this.list.setSelectedIndex(0);
                    }
                }
            } else if (string.equals(OK)) {
                this.setValue(this.list.getSelectedValue());
                SwingUtilities.getRoot(this).setVisible(false);
            } else if (string.equals(CANCEL)) {
                this.setValue(null);
                SwingUtilities.getRoot(this).setVisible(false);
            }
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            this.changedUpdate(documentEvent);
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            this.changedUpdate(documentEvent);
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            this.errorField.setText("");
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            this.okBtn.setEnabled(this.list.getSelectedValue() != null);
        }
    }
}

