/*
 * Decompiled with CFR 0.152.
 */
package com.sun.interview.wizard;

import com.sun.interview.ErrorQuestion;
import com.sun.interview.Interview;
import com.sun.interview.Question;
import com.sun.interview.wizard.I18NResourceBundle;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import javax.accessibility.AccessibleContext;
import javax.help.BadIDException;
import javax.help.HelpSet;
import javax.help.InvalidHelpSetContextException;
import javax.help.JHelpContentViewer;
import javax.help.Map;
import javax.swing.JComponent;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;

class InfoPanel
extends JComponent {
    private Interview interview;
    private HelpSet infoHelpSet;
    private JHelpContentViewer viewer;
    private Listener listener = new Listener();
    private static final I18NResourceBundle i18n = I18NResourceBundle.getDefaultBundle();
    private static final int PREFERRED_WIDTH = 4;
    private static final int PREFERRED_HEIGHT = 3;

    public InfoPanel(Interview interview) {
        this.interview = interview;
        this.infoHelpSet = interview.getHelpSet();
        this.viewer = new JHelpContentViewer(this.infoHelpSet);
        this.viewer.setName("help");
        this.viewer.setToolTipText(i18n.getString("info.tip"));
        AccessibleContext accessibleContext = this.viewer.getAccessibleContext();
        accessibleContext.setAccessibleName(i18n.getString("info.name"));
        accessibleContext.setAccessibleDescription(this.viewer.getToolTipText());
        this.setName("info");
        this.setLayout(new BorderLayout());
        this.addAncestorListener(new Listener());
        this.add((Component)this.viewer, "Center");
    }

    public HelpSet getHelpSet() {
        return this.infoHelpSet;
    }

    public void setCurrentID(Question question) {
        try {
            Map.ID iD = question.getHelpID();
            if (iD == null) {
                System.err.println("WARNING: no help for " + question.getKey());
            } else {
                this.viewer.setCurrentID(iD);
            }
        }
        catch (BadIDException badIDException) {
            System.err.println("WARNING: no help for " + question.getKey());
        }
        catch (InvalidHelpSetContextException invalidHelpSetContextException) {
            invalidHelpSetContextException.printStackTrace();
        }
    }

    public Dimension getPreferredSize() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension dimension = new Dimension(4 * toolkit.getScreenResolution(), 3 * toolkit.getScreenResolution());
        return dimension;
    }

    private class Listener
    implements AncestorListener,
    Interview.Observer {
        private Listener() {
        }

        public void ancestorAdded(AncestorEvent ancestorEvent) {
            InfoPanel.this.interview.addObserver(this);
            this.currentQuestionChanged(InfoPanel.this.interview.getCurrentQuestion());
        }

        public void ancestorMoved(AncestorEvent ancestorEvent) {
        }

        public void ancestorRemoved(AncestorEvent ancestorEvent) {
            InfoPanel.this.interview.removeObserver(this);
        }

        public void pathUpdated() {
        }

        public void currentQuestionChanged(Question question) {
            if (!(question instanceof ErrorQuestion)) {
                InfoPanel.this.setCurrentID(question);
            }
        }
    }
}

