/*
 * Decompiled with CFR 0.152.
 */
package com.sun.interview.wizard;

import com.sun.interview.Interview;
import com.sun.interview.ListQuestion;
import com.sun.interview.Question;
import com.sun.interview.wizard.EditableList;
import com.sun.interview.wizard.I18NResourceBundle;
import com.sun.interview.wizard.QuestionRenderer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

class ListQuestionRenderer
implements QuestionRenderer {
    private static final I18NResourceBundle i18n = I18NResourceBundle.getDefaultBundle();
    private static String INVALID_VALUE = i18n.getString("list.incomplete.txt");
    private static String INVALID_VALUE_COLOR = i18n.getString("i18n.error.clr");
    static /* synthetic */ Class class$com$sun$interview$ListQuestion$Body;

    ListQuestionRenderer() {
    }

    public JComponent getQuestionRendererComponent(Question question, ActionListener actionListener) {
        ListQuestion listQuestion = (ListQuestion)question;
        if (listQuestion.isEnd()) {
            return this.createMoreButton(listQuestion);
        }
        return this.createList(listQuestion, actionListener);
    }

    public String getInvalidValueMessage(Question question) {
        ListQuestion listQuestion = (ListQuestion)question;
        return i18n.getString("list.invalid", new Integer(listQuestion.getIncompleteBodyCount()));
    }

    private JComponent createMoreButton(final ListQuestion listQuestion) {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setName("more");
        jPanel.setFocusable(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 14;
        JButton jButton = new JButton(i18n.getString("list.more.btn"));
        jButton.setName("list.more.btn");
        jButton.setMnemonic(i18n.getString("list.more.mne").charAt(0));
        jButton.setToolTipText(i18n.getString("list.more.tip"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ListQuestion listQuestion2 = listQuestion.getOther();
                try {
                    ListQuestionRenderer.getRootInterview(listQuestion).setCurrentQuestion(listQuestion2);
                }
                catch (Interview.Fault fault) {
                    // empty catch block
                }
            }
        });
        jPanel.add((Component)jButton, gridBagConstraints);
        return jPanel;
    }

    private JComponent createList(ListQuestion listQuestion, ActionListener actionListener) {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setName("list");
        jPanel.setFocusable(false);
        JLabel jLabel = new JLabel(i18n.getString("list.lbl"));
        jLabel.setName("list.lbl");
        jLabel.setDisplayedMnemonic(i18n.getString("list.mne").charAt(0));
        jLabel.setToolTipText(i18n.getString("list.tip"));
        jPanel.add((Component)jLabel, "North");
        BodyList bodyList = new BodyList(listQuestion);
        ListQuestion.Body body = listQuestion.getSelectedBody();
        if (body != null) {
            bodyList.setSelectedItem(body);
        }
        jLabel.setLabelFor(bodyList);
        jPanel.add((Component)bodyList, "Center");
        return jPanel;
    }

    private static Interview getRootInterview(Question question) {
        Interview interview = question.getInterview();
        while (interview.getParent() != null) {
            interview = interview.getParent();
        }
        return interview;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class BodyList
    extends EditableList {
        private ListQuestion question;

        BodyList(ListQuestion listQuestion) {
            super("list", listQuestion.getBodies());
            this.question = listQuestion;
        }

        protected Object getDisplayValue(Object object) {
            if (object instanceof ListQuestion.Body) {
                ListQuestion.Body body = (ListQuestion.Body)object;
                String string = body.getSummary();
                if (string == null) {
                    string = body.getDefaultSummary();
                }
                if (body.isBodyFinishable()) {
                    return string;
                }
                return "<html><b><font color=\"" + INVALID_VALUE_COLOR + "\">*</font></b> " + this.escape(string) + " <font color=\"" + INVALID_VALUE_COLOR + "\">" + this.escape(INVALID_VALUE) + "</font></html>";
            }
            return object;
        }

        protected Object getNewItem() {
            int n = this.getSelectedIndex();
            if (n == -1) {
                n = this.getItemCount();
            }
            return this.question.createBody(n);
        }

        protected Object getNewItem(Object object) {
            this.question.setValue(this.getSelectedIndex());
            try {
                ListQuestionRenderer.getRootInterview(this.question).next();
            }
            catch (Interview.Fault fault) {
                // empty catch block
            }
            return null;
        }

        protected void insertItem() {
            super.insertItem();
            this.itemsChanged();
            try {
                ListQuestionRenderer.getRootInterview(this.question).next();
            }
            catch (Interview.Fault fault) {
                // empty catch block
            }
        }

        protected void itemsChanged() {
            this.question.setBodies(this.getBodies(), this.getSelectedIndex());
        }

        protected void selectedItemChanged() {
            this.question.setValue(this.getSelectedIndex());
        }

        private ListQuestion.Body[] getBodies() {
            ListQuestion.Body[] bodyArray = (ListQuestion.Body[])this.getItems(class$com$sun$interview$ListQuestion$Body == null ? (class$com$sun$interview$ListQuestion$Body = ListQuestionRenderer.class$("com.sun.interview.ListQuestion$Body")) : class$com$sun$interview$ListQuestion$Body);
            return bodyArray;
        }

        private String escape(String string) {
            if (string == null) {
                return "";
            }
            boolean bl = false;
            for (int i = 0; i < string.length() && !bl; ++i) {
                switch (string.charAt(i)) {
                    case '&': 
                    case '<': 
                    case '>': {
                        bl = true;
                    }
                }
            }
            if (bl) {
                StringBuffer stringBuffer = new StringBuffer();
                block9: for (int i = 0; i < string.length(); ++i) {
                    char c = string.charAt(i);
                    switch (c) {
                        case '<': {
                            stringBuffer.append("&lt;");
                            continue block9;
                        }
                        case '>': {
                            stringBuffer.append("&gt;");
                            continue block9;
                        }
                        case '&': {
                            stringBuffer.append("&amp;");
                            continue block9;
                        }
                        default: {
                            stringBuffer.append(c);
                        }
                    }
                }
                return stringBuffer.toString();
            }
            return string;
        }
    }
}

