/*
 * Decompiled with CFR 0.152.
 */
package com.sun.interview.wizard;

import com.sun.interview.ErrorQuestion;
import com.sun.interview.FinalQuestion;
import com.sun.interview.Interview;
import com.sun.interview.NullQuestion;
import com.sun.interview.Question;
import com.sun.interview.wizard.I18NResourceBundle;
import com.sun.interview.wizard.QuestionPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.accessibility.AccessibleContext;
import javax.swing.AbstractListModel;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.Scrollable;
import javax.swing.UIManager;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.metal.MetalLookAndFeel;

class PathPanel
extends JPanel
implements Scrollable {
    private QuestionPanel questionPanel;
    private Interview interview;
    private PathList pathList;
    private JList list;
    private String moreText;
    private boolean markersEnabled;
    private boolean markersFilterEnabled;
    private String markerName = null;
    private static final I18NResourceBundle i18n = I18NResourceBundle.getDefaultBundle();
    private static Color INVALID_VALUE_COLOR = i18n.getErrorColor();
    private static final int DOTS_PER_INCH = Toolkit.getDefaultToolkit().getScreenResolution();

    public PathPanel(QuestionPanel questionPanel, Interview interview) {
        this.questionPanel = questionPanel;
        this.interview = interview;
        this.moreText = i18n.getString("path.more");
        this.initGUI();
    }

    public Dimension getPreferredSize() {
        return this.list.getPreferredSize();
    }

    public Dimension getPreferredScrollableViewportSize() {
        return this.list.getPreferredScrollableViewportSize();
    }

    public int getScrollableBlockIncrement(Rectangle rectangle, int n, int n2) {
        return this.list.getScrollableBlockIncrement(rectangle, n, n2);
    }

    public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
        return this.list.getScrollableUnitIncrement(rectangle, n, n2);
    }

    public boolean getScrollableTracksViewportHeight() {
        if (this.getParent() instanceof JViewport) {
            return ((JViewport)this.getParent()).getHeight() > this.getPreferredSize().height;
        }
        return false;
    }

    public boolean getScrollableTracksViewportWidth() {
        return true;
    }

    boolean getMarkersEnabled() {
        return this.markersEnabled;
    }

    void setMarkersEnabled(boolean bl) {
        if (bl != this.markersEnabled) {
            this.markersEnabled = bl;
            this.pathList.update();
        }
    }

    boolean getMarkersFilterEnabled() {
        return this.markersFilterEnabled;
    }

    void setMarkersFilterEnabled(boolean bl) {
        if (bl != this.markersFilterEnabled) {
            this.markersFilterEnabled = bl;
            this.pathList.update();
        }
    }

    Question getNextVisible() {
        return this.pathList.getNextVisible();
    }

    Question getPrevVisible() {
        return this.pathList.getPrevVisible();
    }

    Question getLastVisible() {
        return this.pathList.getLastVisible();
    }

    JMenu getMarkerMenu() {
        return this.createMenu();
    }

    private void initGUI() {
        this.setName("path");
        this.setFocusable(false);
        this.setLayout(new BorderLayout());
        this.pathList = new PathList();
        this.list = new JList(this.pathList);
        this.setInfo(this.list, "path.list", true);
        this.list.setCellRenderer(this.pathList);
        KeyStroke keyStroke = KeyStroke.getKeyStroke(10, 0);
        this.list.registerKeyboardAction(this.pathList, keyStroke, 0);
        this.list.addListSelectionListener(this.pathList);
        this.list.addMouseListener(this.pathList);
        this.list.setFixedCellWidth(2 * DOTS_PER_INCH);
        this.list.setSelectionMode(0);
        this.list.setVisibleRowCount(5);
        this.pathList.currentQuestionChanged(this.interview.getCurrentQuestion());
        this.addAncestorListener(this.pathList);
        this.add(this.list);
    }

    private void setInfo(JComponent jComponent, String string, boolean bl) {
        jComponent.setName(string);
        AccessibleContext accessibleContext = jComponent.getAccessibleContext();
        accessibleContext.setAccessibleName(i18n.getString(string + ".name"));
        if (bl) {
            String string2 = i18n.getString(string + ".tip");
            jComponent.setToolTipText(string2);
            accessibleContext.setAccessibleDescription(string2);
        } else {
            accessibleContext.setAccessibleDescription(i18n.getString(string + ".desc"));
        }
    }

    private JMenu createMenu() {
        return (JMenu)new Menu(0).getComponent();
    }

    private JPopupMenu createPopupMenu() {
        return (JPopupMenu)new Menu(1).getComponent();
    }

    private static class EllipsisIcon
    implements Icon {
        private BufferedImage image;
        private static final int iconWidth = 48;
        private static final int iconHeight = 6;
        private static final int dots = 3;
        private static final int dotWidth = 2;
        private static final int dotHeight = 1;
        private static final int dotSep = 4;
        private static final int dotIndent = 20;

        private EllipsisIcon() {
        }

        public int getIconWidth() {
            return 48;
        }

        public int getIconHeight() {
            return 6;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            if (this.image == null) {
                this.image = new BufferedImage(this.getIconWidth(), this.getIconHeight(), 2);
                this.paintMe(this.image);
            }
            graphics.drawImage(this.image, n, n2, null);
        }

        private void paintMe(BufferedImage bufferedImage) {
            Graphics graphics = bufferedImage.getGraphics();
            graphics.setColor(Color.black);
            for (int i = 0; i < 1; ++i) {
                int n = 2 + i;
                for (int j = 0; j < 3; ++j) {
                    int n2 = 20 + j * 6;
                    graphics.drawLine(n2, n, n2 + 2 - 1, n);
                }
            }
        }
    }

    private static class MarkerIcon
    implements Icon {
        private boolean on;
        private BufferedImage image;
        private static final int iconWidth = 8;
        private static final int iconHeight = 16;
        private static final int iconIndent = 3;

        MarkerIcon(boolean bl) {
            this.on = bl;
        }

        public int getIconWidth() {
            return 8;
        }

        public int getIconHeight() {
            return 16;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            if (this.on) {
                if (this.image == null) {
                    this.image = new BufferedImage(this.getIconWidth(), this.getIconHeight(), 2);
                    this.paintMe(this.image);
                }
                graphics.drawImage(this.image, n, n2, null);
            }
        }

        private void paintMe(BufferedImage bufferedImage) {
            int n;
            Graphics graphics = bufferedImage.getGraphics();
            int n2 = 0;
            int n3 = 0;
            int n4 = n = Math.min(8, 16);
            int[] nArray = new int[]{n2 + 3, n, n, n - 3, n2, n2 + 3};
            int[] nArray2 = new int[]{n3, n4 - 3, n4, n4, n3 + 3, n3 + 3};
            graphics.setColor(MetalLookAndFeel.getPrimaryControlDarkShadow());
            graphics.fillPolygon(nArray, nArray2, nArray.length);
        }
    }

    private class Menu
    implements ActionListener,
    ChangeListener,
    MenuListener,
    PopupMenuListener {
        static final int JMENU = 0;
        static final int JPOPUPMENU = 1;
        private int type;
        private JComponent comp;
        private JCheckBoxMenuItem enableItem;
        private JCheckBoxMenuItem filterItem;
        private JMenuItem markItem;
        private JMenuItem unmarkItem;
        private JMenuItem clearItem;
        private JMenuItem openGroupItem;
        private JMenuItem closeGroupItem;
        private JMenuItem clearMarkedItem;
        private JMenuItem removeAllItem;
        private static final String ENABLE = "enable";
        private static final String FILTER = "filter";
        private static final String MARK = "mark";
        private static final String UNMARK = "unmark";
        private static final String CLEAR = "clear";
        private static final String OPEN_GROUP = "open";
        private static final String CLOSE_GROUP = "close";
        private static final String CLEAR_MARKED = "clearMarked";
        private static final String REMOVE_MARKERS = "remove";

        Menu(int n) {
            this.type = n;
            if (n == 0) {
                this.enableItem = this.createCheckBoxItem(ENABLE);
                this.filterItem = this.createCheckBoxItem(FILTER);
            }
            this.markItem = this.createItem(MARK);
            this.unmarkItem = this.createItem(UNMARK);
            this.clearItem = this.createItem(CLEAR);
            this.openGroupItem = this.createItem(OPEN_GROUP);
            this.closeGroupItem = this.createItem(CLOSE_GROUP);
            if (n == 0) {
                this.clearMarkedItem = this.createItem(CLEAR_MARKED);
                this.removeAllItem = this.createItem(REMOVE_MARKERS);
            }
            if (n == 0) {
                JMenu jMenu = new JMenu(i18n.getString("path.mark.menu"));
                jMenu.setName("path.mark.menu");
                jMenu.getAccessibleContext().setAccessibleDescription(i18n.getString("path.mark.desc"));
                char c = i18n.getString("path.mark.mne").charAt(0);
                jMenu.setMnemonic((int)c);
                jMenu.add(this.enableItem);
                jMenu.add(this.filterItem);
                jMenu.addSeparator();
                jMenu.add(this.markItem);
                jMenu.add(this.unmarkItem);
                jMenu.add(this.clearItem);
                jMenu.addSeparator();
                jMenu.add(this.openGroupItem);
                jMenu.add(this.closeGroupItem);
                jMenu.addSeparator();
                jMenu.add(this.clearMarkedItem);
                jMenu.add(this.removeAllItem);
                jMenu.addMenuListener(this);
                this.comp = jMenu;
            } else {
                JPopupMenu jPopupMenu = new JPopupMenu();
                jPopupMenu.add(this.markItem);
                jPopupMenu.add(this.unmarkItem);
                jPopupMenu.add(this.clearItem);
                jPopupMenu.add(this.openGroupItem);
                jPopupMenu.add(this.closeGroupItem);
                jPopupMenu.addPopupMenuListener(this);
                this.comp = jPopupMenu;
            }
        }

        JComponent getComponent() {
            return this.comp;
        }

        private JMenuItem createItem(String string) {
            JMenuItem jMenuItem = new JMenuItem(i18n.getString("path.mark." + string + ".mit"));
            jMenuItem.setName(string);
            jMenuItem.setActionCommand(string);
            jMenuItem.addActionListener(this);
            this.setMnemonic(jMenuItem, string);
            return jMenuItem;
        }

        private JCheckBoxMenuItem createCheckBoxItem(String string) {
            JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(i18n.getString("path.mark." + string + ".ckb"));
            jCheckBoxMenuItem.setName(string);
            jCheckBoxMenuItem.addChangeListener(this);
            this.setMnemonic(jCheckBoxMenuItem, string);
            return jCheckBoxMenuItem;
        }

        private void updateItems() {
            Question question = PathPanel.this.interview.getCurrentQuestion();
            boolean bl = question.hasMarker(PathPanel.this.markerName);
            boolean bl2 = PathPanel.this.pathList.isQuestionVisible(question);
            boolean bl3 = PathPanel.this.pathList.isQuestionAutoOpened(question);
            if (this.type == 0) {
                this.enableItem.setSelected(PathPanel.this.markersEnabled);
                this.filterItem.setSelected(PathPanel.this.markersFilterEnabled);
                this.filterItem.setEnabled(PathPanel.this.markersEnabled);
                this.markItem.setVisible(!bl);
                this.markItem.setEnabled(PathPanel.this.markersEnabled);
                this.unmarkItem.setVisible(bl);
                this.unmarkItem.setEnabled(PathPanel.this.markersEnabled);
                this.clearItem.setVisible(true);
                this.clearItem.setEnabled(PathPanel.this.markersEnabled && !(question instanceof NullQuestion));
                this.openGroupItem.setVisible(!PathPanel.this.markersFilterEnabled || !bl2);
                this.openGroupItem.setEnabled(PathPanel.this.markersEnabled && PathPanel.this.markersFilterEnabled);
                this.closeGroupItem.setVisible(PathPanel.this.markersFilterEnabled && bl2);
                this.closeGroupItem.setEnabled(PathPanel.this.markersEnabled && PathPanel.this.markersFilterEnabled);
                this.clearMarkedItem.setVisible(true);
                this.clearMarkedItem.setEnabled(PathPanel.this.markersEnabled);
                this.removeAllItem.setVisible(true);
                this.removeAllItem.setEnabled(PathPanel.this.markersEnabled);
            } else {
                this.markItem.setVisible(bl2 && !bl);
                this.unmarkItem.setVisible(bl2 && bl);
                this.clearItem.setVisible(bl2 && !(question instanceof NullQuestion));
                this.openGroupItem.setVisible(PathPanel.this.markersFilterEnabled && !bl2);
                this.closeGroupItem.setVisible(PathPanel.this.markersFilterEnabled && bl3);
            }
        }

        private void setMnemonic(JMenuItem jMenuItem, String string) {
            char c = i18n.getString("path.mark." + string + ".mne").charAt(0);
            jMenuItem.setMnemonic((int)c);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals(MARK)) {
                PathPanel.this.pathList.markCurrentQuestion();
            } else if (string.equals(UNMARK)) {
                PathPanel.this.pathList.unmarkCurrentQuestion();
            } else if (string.equals(CLEAR)) {
                Question question = PathPanel.this.interview.getCurrentQuestion();
                question.clear();
                PathPanel.this.questionPanel.showQuestion(question);
            } else if (string.equals(OPEN_GROUP)) {
                PathPanel.this.pathList.openCurrentEntry();
            } else if (string.equals(CLOSE_GROUP)) {
                PathPanel.this.pathList.closeCurrentEntry();
            } else if (string.equals(CLEAR_MARKED)) {
                Question question = PathPanel.this.interview.getCurrentQuestion();
                PathPanel.this.interview.clearMarkedResponses(PathPanel.this.markerName);
                if (question == PathPanel.this.interview.getCurrentQuestion()) {
                    PathPanel.this.questionPanel.showQuestion(question);
                }
            } else if (string.equals(REMOVE_MARKERS)) {
                PathPanel.this.interview.removeMarkers(PathPanel.this.markerName);
                if (PathPanel.this.getMarkersFilterEnabled()) {
                    PathPanel.this.setMarkersFilterEnabled(false);
                } else {
                    PathPanel.this.pathList.update();
                }
            }
        }

        public void stateChanged(ChangeEvent changeEvent) {
            Object object = changeEvent.getSource();
            if (object == this.enableItem) {
                PathPanel.this.questionPanel.saveCurrentResponse();
                boolean bl = this.enableItem.isSelected();
                PathPanel.this.setMarkersEnabled(bl);
            } else if (object == this.filterItem) {
                PathPanel.this.questionPanel.saveCurrentResponse();
                boolean bl = this.filterItem.isSelected();
                PathPanel.this.setMarkersFilterEnabled(bl);
            }
        }

        public void menuSelected(MenuEvent menuEvent) {
            this.updateItems();
        }

        public void menuDeselected(MenuEvent menuEvent) {
        }

        public void menuCanceled(MenuEvent menuEvent) {
        }

        public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
            this.updateItems();
        }

        public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
        }

        public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
        }
    }

    private class PathList
    extends AbstractListModel
    implements ActionListener,
    AncestorListener,
    ListCellRenderer,
    ListSelectionListener,
    MouseListener,
    Interview.Observer {
        private JLabel sample = new JLabel(){

            public Dimension getMaximumSize() {
                return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
            }
        };
        private Question[] currPath = new Question[0];
        private Question currQuestion;
        private Object[] currEntries = new Object[0];
        private int currIndex;
        private boolean currEnabled;
        private boolean[] currMarks;
        private Set autoOpenSet = new HashSet();
        private Icon markerIcon = new MarkerIcon(true);
        private Icon noMarkerIcon = new MarkerIcon(false);
        private Icon ellipsisIcon = new EllipsisIcon();
        private JPopupMenu popupMenu;

        private PathList() {
        }

        Question getNextVisible() {
            for (int i = this.currIndex + 1; i < this.currEntries.length; ++i) {
                Object object = this.currEntries[i];
                if (!(object instanceof Question)) continue;
                return (Question)object;
            }
            return null;
        }

        Question getPrevVisible() {
            for (int i = this.currIndex - 1; i >= 0; --i) {
                Object object = this.currEntries[i];
                if (!(object instanceof Question)) continue;
                return (Question)object;
            }
            return null;
        }

        Question getLastVisible() {
            for (int i = this.currEntries.length - 1; i >= 0; --i) {
                Object object = this.currEntries[i];
                if (!(object instanceof Question)) continue;
                return (Question)object;
            }
            return null;
        }

        boolean isQuestionVisible(Question question) {
            for (int i = 0; i < this.currEntries.length; ++i) {
                Object object = this.currEntries[i];
                if (object instanceof Question && (Question)object == question) {
                    return true;
                }
                if (!(object instanceof List) || !((List)object).contains(question)) continue;
                return false;
            }
            return false;
        }

        boolean isQuestionAutoOpened(Question question) {
            boolean bl = this.autoOpenSet.contains(null);
            for (int i = 0; i < this.currEntries.length; ++i) {
                Object object = this.currEntries[i];
                if (object instanceof Question) {
                    Question question2 = (Question)object;
                    if (question2.hasMarker(PathPanel.this.markerName)) {
                        if (question2 == question) {
                            return false;
                        }
                        bl = this.autoOpenSet.contains(question2);
                        continue;
                    }
                    if (question2 != question) continue;
                    return bl;
                }
                if (!(object instanceof List) || !((List)object).contains(question)) continue;
                return false;
            }
            return false;
        }

        void markCurrentQuestion() {
            this.setQuestionMarked(PathPanel.this.interview.getCurrentQuestion(), true);
        }

        void unmarkCurrentQuestion() {
            this.setQuestionMarked(PathPanel.this.interview.getCurrentQuestion(), false);
        }

        private void setQuestionMarked(Question question, boolean bl) {
            PathPanel.this.questionPanel.saveCurrentResponse();
            if (bl) {
                question.addMarker(PathPanel.this.markerName);
            } else {
                question.removeMarker(PathPanel.this.markerName);
            }
            PathPanel.this.pathList.update(question);
        }

        void openCurrentEntry() {
            this.openEntry(this.currIndex);
        }

        void openEntry(int n) {
            Object object = this.currEntries[n];
            if (!(object instanceof List)) {
                return;
            }
            for (int i = 1; i < this.currEntries.length; ++i) {
                if (this.currEntries[i] != object) continue;
                Object object2 = this.currEntries[i - 1];
                if (object2 instanceof Question) {
                    this.autoOpenSet.add(object2);
                }
                this.update();
            }
        }

        void closeCurrentEntry() {
            this.closeEntry(this.currIndex);
        }

        void closeEntry(int n) {
            Object object = this.currEntries[n];
            if (!(object instanceof Question)) {
                return;
            }
            Question question = null;
            for (int i = n; i >= 0; --i) {
                Object object2 = this.currEntries[i];
                if (!(object2 instanceof Question)) continue;
                Question question2 = (Question)object2;
                if (i != 0 && !question2.hasMarker(PathPanel.this.markerName)) continue;
                question = question2;
                break;
            }
            if (question == object) {
                return;
            }
            this.autoOpenSet.remove(question);
            this.update();
        }

        public int getSize() {
            return this.currEntries == null ? 0 : this.currEntries.length;
        }

        public Object getElementAt(int n) {
            return n < this.currEntries.length ? this.currEntries[n] : null;
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (object instanceof Question) {
                Color color;
                String string;
                Font font;
                Question question = (Question)object;
                if (question instanceof ErrorQuestion) {
                    font = jList.getFont().deriveFont(1);
                    string = "   " + question.getSummary();
                    color = INVALID_VALUE_COLOR;
                } else if (question instanceof NullQuestion) {
                    font = jList.getFont().deriveFont(1);
                    string = " " + question.getSummary();
                    color = jList.getForeground();
                } else {
                    font = jList.getFont().deriveFont(0);
                    string = "   " + question.getSummary();
                    color = jList.getForeground();
                }
                this.sample.setText(string);
                this.sample.setFont(font);
                this.sample.setForeground(color);
                if (PathPanel.this.markersEnabled) {
                    this.sample.setIcon(question.hasMarker(PathPanel.this.markerName) ? this.markerIcon : this.noMarkerIcon);
                } else {
                    this.sample.setIcon(null);
                }
            } else if (object instanceof List) {
                this.sample.setText(null);
                this.sample.setFont(jList.getFont());
                this.sample.setForeground(jList.getForeground());
                this.sample.setIcon(this.ellipsisIcon);
            } else if (object instanceof String) {
                this.sample.setText(" " + (String)object);
                this.sample.setFont(jList.getFont().deriveFont(2));
                this.sample.setForeground(jList.getForeground());
                this.sample.setIcon(PathPanel.this.markersEnabled ? this.noMarkerIcon : null);
            } else {
                throw new IllegalArgumentException();
            }
            if (bl) {
                this.sample.setBackground(jList.getSelectionBackground());
            } else {
                this.sample.setBackground(jList.getBackground());
            }
            this.sample.setOpaque(true);
            this.sample.setEnabled(jList.isEnabled());
            this.sample.setBorder(bl2 ? UIManager.getBorder("List.focusCellHighlightBorder") : null);
            return this.sample;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JList jList = (JList)actionEvent.getSource();
            Object e = jList.getSelectedValue();
            if (e != null && e instanceof Question) {
                Question question = (Question)e;
                if (question == PathPanel.this.interview.getCurrentQuestion()) {
                    return;
                }
                PathPanel.this.questionPanel.saveCurrentResponse();
                try {
                    PathPanel.this.interview.setCurrentQuestion(question);
                }
                catch (Interview.Fault fault) {
                    // empty catch block
                }
            }
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            JList jList = (JList)listSelectionEvent.getSource();
            Object e = jList.getSelectedValue();
            if (e == null) {
                return;
            }
            if (e instanceof Question) {
                Question question = (Question)e;
                if (question == PathPanel.this.interview.getCurrentQuestion()) {
                    return;
                }
                PathPanel.this.questionPanel.saveCurrentResponse();
                try {
                    PathPanel.this.interview.setCurrentQuestion(question);
                }
                catch (Interview.Fault fault) {}
            } else if (e instanceof List) {
                List list = (List)e;
                if (list.contains(PathPanel.this.interview.getCurrentQuestion())) {
                    return;
                }
                PathPanel.this.questionPanel.saveCurrentResponse();
                try {
                    Question question = (Question)list.get(0);
                    PathPanel.this.interview.setCurrentQuestion(question);
                }
                catch (Interview.Fault fault) {}
            } else {
                jList.setSelectedIndex(this.currIndex);
            }
        }

        public void ancestorAdded(AncestorEvent ancestorEvent) {
            PathPanel.this.interview.addObserver(this);
            this.pathUpdated();
        }

        public void ancestorMoved(AncestorEvent ancestorEvent) {
        }

        public void ancestorRemoved(AncestorEvent ancestorEvent) {
            PathPanel.this.interview.removeObserver(this);
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (PathPanel.this.markersEnabled && mouseEvent.isPopupTrigger() && this.isOverSelection(mouseEvent)) {
                this.showPopupMenu(mouseEvent);
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (PathPanel.this.markersEnabled && mouseEvent.isPopupTrigger() && this.isOverSelection(mouseEvent)) {
                this.showPopupMenu(mouseEvent);
            }
        }

        private boolean isOverSelection(MouseEvent mouseEvent) {
            JList jList = (JList)mouseEvent.getComponent();
            Rectangle rectangle = jList.getCellBounds(this.currIndex, this.currIndex);
            return rectangle.contains(mouseEvent.getX(), mouseEvent.getY());
        }

        private void showPopupMenu(MouseEvent mouseEvent) {
            if (this.popupMenu == null) {
                this.popupMenu = PathPanel.this.createPopupMenu();
            }
            this.popupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (!PathPanel.this.markersEnabled) {
                return;
            }
            Point point = mouseEvent.getPoint();
            int n = PathPanel.this.list.locationToIndex(point);
            if (n == -1) {
                return;
            }
            Object object = this.currEntries[n];
            switch (mouseEvent.getClickCount()) {
                case 1: {
                    Question question;
                    if (point.x >= this.markerIcon.getIconWidth() || !(object instanceof Question)) break;
                    this.setQuestionMarked(question, !(question = (Question)object).hasMarker(PathPanel.this.markerName));
                    break;
                }
                case 2: {
                    if (!PathPanel.this.markersFilterEnabled) break;
                    if (object instanceof List) {
                        this.openEntry(n);
                        break;
                    }
                    this.closeEntry(n);
                }
            }
        }

        public void pathUpdated() {
            this.update(PathPanel.this.interview.getPath(), PathPanel.this.interview.getCurrentQuestion());
        }

        public void currentQuestionChanged(Question question) {
            int n = this.currIndex;
            this.currQuestion = question;
            for (int i = 0; i < this.currEntries.length; ++i) {
                Object object = this.currEntries[i];
                if (object != question && (!(object instanceof List) || !((List)object).contains(question))) continue;
                this.currIndex = i;
                break;
            }
            this.fireContentsChanged(this, n, this.currIndex);
            PathPanel.this.list.setSelectedIndex(this.currIndex);
            PathPanel.this.list.ensureIndexIsVisible(this.currIndex);
        }

        public void finished() {
        }

        void update() {
            this.update(this.currPath, this.currQuestion);
        }

        void update(Question question) {
            if (PathPanel.this.markersFilterEnabled) {
                this.update();
            } else {
                for (int i = 0; i < this.currEntries.length; ++i) {
                    Object object = this.currEntries[i];
                    if (object != question) continue;
                    this.currMarks[i] = PathPanel.this.markersEnabled && question.hasMarker(PathPanel.this.markerName);
                    this.fireContentsChanged(this, i, i);
                    break;
                }
            }
        }

        private void update(Question[] questionArray, Question question) {
            int n;
            int n2;
            boolean bl = this.currEnabled;
            Object[] objectArray = this.currEntries;
            boolean[] blArray = this.currMarks;
            if (!PathPanel.this.markersFilterEnabled) {
                this.autoOpenSet.clear();
            }
            Object[] objectArray2 = this.getEntries(questionArray);
            boolean[] blArray2 = new boolean[objectArray2.length];
            if (PathPanel.this.markersEnabled) {
                for (n2 = 0; n2 < objectArray2.length; ++n2) {
                    blArray2[n2] = objectArray2[n2] instanceof Question && ((Question)objectArray2[n2]).hasMarker(PathPanel.this.markerName);
                }
            }
            this.currPath = questionArray;
            this.currEntries = objectArray2;
            this.currEnabled = PathPanel.this.markersEnabled;
            this.currMarks = blArray2;
            n2 = Math.min(objectArray.length, objectArray2.length);
            if (this.currEnabled == bl) {
                for (n = 0; n < n2; ++n) {
                    Object object = objectArray[n];
                    boolean bl2 = blArray[n];
                    Object object2 = objectArray2[n];
                    boolean bl3 = blArray2[n];
                    if (!(object instanceof Question ? object == object2 && bl2 == bl3 : object instanceof List && object2 instanceof List)) break;
                }
            }
            if (n != objectArray.length || n != objectArray2.length) {
                if (n != n2) {
                    this.fireContentsChanged(this, n, n2 - 1);
                }
                if (n2 != objectArray.length) {
                    this.fireIntervalRemoved(this, n2, objectArray.length - 1);
                }
                if (n2 != objectArray2.length) {
                    this.fireIntervalAdded(this, n2, objectArray2.length - 1);
                }
            }
            this.currQuestion = question;
            for (int i = 0; i < this.currEntries.length; ++i) {
                Object object = this.currEntries[i];
                if (object != this.currQuestion && (!(object instanceof List) || !((List)object).contains(this.currQuestion))) continue;
                this.currIndex = i;
                break;
            }
            PathPanel.this.list.setSelectedIndex(this.currIndex);
            PathPanel.this.list.ensureIndexIsVisible(this.currIndex);
        }

        private Object[] getEntries(Question[] questionArray) {
            boolean bl;
            if (questionArray.length == 0) {
                return questionArray;
            }
            Question question = questionArray[questionArray.length - 1];
            boolean bl2 = bl = !(question instanceof ErrorQuestion) && !(question instanceof FinalQuestion);
            if (!(PathPanel.this.markersEnabled && PathPanel.this.markersFilterEnabled || bl)) {
                return questionArray;
            }
            Vector<Object> vector = new Vector<Object>();
            Question question2 = null;
            for (int i = 0; i < questionArray.length; ++i) {
                List<Question> list;
                Question question3 = questionArray[i];
                if (!PathPanel.this.markersEnabled || !PathPanel.this.markersFilterEnabled) {
                    vector.add(question3);
                    continue;
                }
                if (question3.hasMarker(PathPanel.this.markerName) || i == 0 || i == questionArray.length - 1 && question3 instanceof FinalQuestion) {
                    question2 = question3;
                    vector.add(question3);
                    continue;
                }
                if (this.autoOpenSet.contains(question2)) {
                    vector.add(question3);
                    continue;
                }
                Object e = vector.lastElement();
                if (e == null || e instanceof Question) {
                    list = new Vector();
                    vector.add(list);
                } else {
                    list = (List)e;
                }
                list.add(question3);
            }
            if (!(question instanceof FinalQuestion) && vector.lastElement() instanceof List) {
                List list = (List)vector.lastElement();
                vector.setSize(vector.size() - 1);
                vector.addAll(list);
            }
            if (bl) {
                vector.add(PathPanel.this.moreText);
            }
            Object[] objectArray = new Object[vector.size()];
            vector.copyInto(objectArray);
            return objectArray;
        }
    }
}

