/*
 * Decompiled with CFR 0.152.
 */
package com.sun.interview.wizard;

import com.sun.interview.ErrorQuestion;
import com.sun.interview.Interview;
import com.sun.interview.Question;
import com.sun.interview.wizard.ChoiceArrayQuestionRenderer;
import com.sun.interview.wizard.ChoiceQuestionRenderer;
import com.sun.interview.wizard.FileListQuestionRenderer;
import com.sun.interview.wizard.FileQuestionRenderer;
import com.sun.interview.wizard.FloatQuestionRenderer;
import com.sun.interview.wizard.I18NResourceBundle;
import com.sun.interview.wizard.InetAddressQuestionRenderer;
import com.sun.interview.wizard.IntQuestionRenderer;
import com.sun.interview.wizard.ListQuestionRenderer;
import com.sun.interview.wizard.NullQuestionRenderer;
import com.sun.interview.wizard.QuestionRenderer;
import com.sun.interview.wizard.SizeSensitiveQuestionRenderer;
import com.sun.interview.wizard.StringListQuestionRenderer;
import com.sun.interview.wizard.StringQuestionRenderer;
import com.sun.interview.wizard.TreeQuestionRenderer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.accessibility.AccessibleContext;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.FocusManager;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.Scrollable;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.plaf.metal.MetalLookAndFeel;

class QuestionPanel
extends JPanel
implements Scrollable {
    private Interview interview;
    private Question currentQuestion;
    private QuestionRenderer currentRenderer;
    private JLabel graphicLabel;
    private JTextField titleField;
    private JTextArea textArea;
    private JPanel valuePanel;
    private Runnable valueSaver;
    private JTextField valueMessageField;
    private JPanel propsPanel;
    private JTextField tagField;
    private Map renderers;
    private Listener listener = new Listener();
    private static final I18NResourceBundle i18n = I18NResourceBundle.getDefaultBundle();
    private static String INVALID_VALUE = i18n.getString("qu.invalidValue.txt");
    private static Color INVALID_VALUE_COLOR = i18n.getErrorColor();
    private KeyStroke enterKey = KeyStroke.getKeyStroke(10, 0);
    private Action valueAction = new AbstractAction(){

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("edited")) {
                QuestionPanel.this.showValueMessage(null);
            } else if (QuestionPanel.this.nextAction != null) {
                QuestionPanel.this.nextAction.actionPerformed(actionEvent);
            } else {
                try {
                    QuestionPanel.this.saveCurrentResponse();
                    QuestionPanel.this.interview.next();
                }
                catch (Interview.Fault fault) {
                    QuestionPanel.this.showValueInvalidMessage();
                }
            }
        }
    };
    private Action nextAction;
    private static final int PREFERRED_HEIGHT = 3;
    private static final int PREFERRED_WIDTH = 4;
    private static final int DOTS_PER_INCH = Toolkit.getDefaultToolkit().getScreenResolution();
    private static final int TEXT_AREA_INSETS_TOP = 20;
    private static final int TEXT_AREA_INSETS_LEFT_RIGHT = 10;
    private static final int TEXT_AREA_INSETS_BOTTOM = 10;
    private static final int VALUE_PANEL_INSETS_TOP = 0;
    private static final int VALUE_PANEL_INSETS_BOTTOM = 10;
    private static final int PROPS_PANEL_INSETS_BOTTOM = 10;
    private static final int VALUE_MESSAGE_FIELD_INSETS_BOTTOM = 0;
    static /* synthetic */ Class class$com$sun$interview$ChoiceQuestion;
    static /* synthetic */ Class class$com$sun$interview$ChoiceArrayQuestion;
    static /* synthetic */ Class class$com$sun$interview$FileQuestion;
    static /* synthetic */ Class class$com$sun$interview$FileListQuestion;
    static /* synthetic */ Class class$com$sun$interview$FloatQuestion;
    static /* synthetic */ Class class$com$sun$interview$IntQuestion;
    static /* synthetic */ Class class$com$sun$interview$InetAddressQuestion;
    static /* synthetic */ Class class$com$sun$interview$ListQuestion;
    static /* synthetic */ Class class$com$sun$interview$NullQuestion;
    static /* synthetic */ Class class$com$sun$interview$StringQuestion;
    static /* synthetic */ Class class$com$sun$interview$StringListQuestion;
    static /* synthetic */ Class class$com$sun$interview$TreeQuestion;

    QuestionPanel(Interview interview) {
        this.interview = interview;
        this.initRenderers();
        this.initGUI();
        this.addAncestorListener(this.listener);
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        dimension.height = Math.max(dimension.height, 3 * DOTS_PER_INCH);
        dimension.width = Math.max(dimension.width, 4 * DOTS_PER_INCH);
        return dimension;
    }

    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    public int getScrollableUnitIncrement(Rectangle rectangle, int n, int n2) {
        switch (n) {
            case 1: {
                return rectangle.height / 10;
            }
            case 0: {
                return rectangle.width / 10;
            }
        }
        throw new IllegalArgumentException("Invalid orientation: " + n);
    }

    public int getScrollableBlockIncrement(Rectangle rectangle, int n, int n2) {
        switch (n) {
            case 1: {
                return rectangle.height;
            }
            case 0: {
                return rectangle.width;
            }
        }
        throw new IllegalArgumentException("Invalid orientation: " + n);
    }

    public boolean getScrollableTracksViewportHeight() {
        if (this.getParent() instanceof JViewport) {
            return ((JViewport)this.getParent()).getHeight() > this.getPreferredSize().height;
        }
        return false;
    }

    public final boolean getScrollableTracksViewportWidth() {
        boolean bl = this.currentRenderer instanceof SizeSensitiveQuestionRenderer ? (this.getParent() instanceof JViewport ? ((JViewport)this.getParent()).getWidth() > this.getPreferredSize().width : false) : true;
        this.setHorScrollStatus(!bl);
        return bl;
    }

    void setNextAction(Action action) {
        this.nextAction = action;
    }

    void saveCurrentResponse() {
        if (this.valueSaver != null) {
            this.valueSaver.run();
        }
    }

    boolean isTagVisible() {
        return this.propsPanel.isVisible();
    }

    void setTagVisible(boolean bl) {
        this.propsPanel.setVisible(bl);
    }

    private void initRenderers() {
        this.renderers = new HashMap();
        this.renderers.put(class$com$sun$interview$ChoiceQuestion == null ? (class$com$sun$interview$ChoiceQuestion = QuestionPanel.class$("com.sun.interview.ChoiceQuestion")) : class$com$sun$interview$ChoiceQuestion, new ChoiceQuestionRenderer());
        this.renderers.put(class$com$sun$interview$ChoiceArrayQuestion == null ? (class$com$sun$interview$ChoiceArrayQuestion = QuestionPanel.class$("com.sun.interview.ChoiceArrayQuestion")) : class$com$sun$interview$ChoiceArrayQuestion, new ChoiceArrayQuestionRenderer());
        this.renderers.put(class$com$sun$interview$FileQuestion == null ? (class$com$sun$interview$FileQuestion = QuestionPanel.class$("com.sun.interview.FileQuestion")) : class$com$sun$interview$FileQuestion, new FileQuestionRenderer());
        this.renderers.put(class$com$sun$interview$FileListQuestion == null ? (class$com$sun$interview$FileListQuestion = QuestionPanel.class$("com.sun.interview.FileListQuestion")) : class$com$sun$interview$FileListQuestion, new FileListQuestionRenderer());
        this.renderers.put(class$com$sun$interview$FloatQuestion == null ? (class$com$sun$interview$FloatQuestion = QuestionPanel.class$("com.sun.interview.FloatQuestion")) : class$com$sun$interview$FloatQuestion, new FloatQuestionRenderer());
        this.renderers.put(class$com$sun$interview$IntQuestion == null ? (class$com$sun$interview$IntQuestion = QuestionPanel.class$("com.sun.interview.IntQuestion")) : class$com$sun$interview$IntQuestion, new IntQuestionRenderer());
        this.renderers.put(class$com$sun$interview$InetAddressQuestion == null ? (class$com$sun$interview$InetAddressQuestion = QuestionPanel.class$("com.sun.interview.InetAddressQuestion")) : class$com$sun$interview$InetAddressQuestion, new InetAddressQuestionRenderer());
        this.renderers.put(class$com$sun$interview$ListQuestion == null ? (class$com$sun$interview$ListQuestion = QuestionPanel.class$("com.sun.interview.ListQuestion")) : class$com$sun$interview$ListQuestion, new ListQuestionRenderer());
        this.renderers.put(class$com$sun$interview$NullQuestion == null ? (class$com$sun$interview$NullQuestion = QuestionPanel.class$("com.sun.interview.NullQuestion")) : class$com$sun$interview$NullQuestion, new NullQuestionRenderer());
        this.renderers.put(class$com$sun$interview$StringQuestion == null ? (class$com$sun$interview$StringQuestion = QuestionPanel.class$("com.sun.interview.StringQuestion")) : class$com$sun$interview$StringQuestion, new StringQuestionRenderer());
        this.renderers.put(class$com$sun$interview$StringListQuestion == null ? (class$com$sun$interview$StringListQuestion = QuestionPanel.class$("com.sun.interview.StringListQuestion")) : class$com$sun$interview$StringListQuestion, new StringListQuestionRenderer());
        this.renderers.put(class$com$sun$interview$TreeQuestion == null ? (class$com$sun$interview$TreeQuestion = QuestionPanel.class$("com.sun.interview.TreeQuestion")) : class$com$sun$interview$TreeQuestion, new TreeQuestionRenderer());
    }

    private void initGUI() {
        Serializable serializable;
        this.setInfo(this, "qu", false);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.graphicLabel = new JLabel();
        this.setInfo(this.graphicLabel, "qu.icon", false);
        this.graphicLabel.setFocusable(false);
        if (this.interview != null && (serializable = this.interview.getDefaultImage()) != null) {
            this.graphicLabel.setIcon(new ImageIcon((URL)serializable));
        }
        gridBagConstraints.anchor = 10;
        gridBagConstraints.gridheight = 0;
        this.add((Component)this.graphicLabel, gridBagConstraints);
        this.titleField = new JTextField();
        this.setInfo(this.titleField, "qu.title", true);
        this.titleField.setEditable(false);
        this.titleField.setBackground(MetalLookAndFeel.getPrimaryControlDarkShadow());
        this.titleField.setForeground(MetalLookAndFeel.getWindowBackground());
        serializable = MetalLookAndFeel.getSystemTextFont();
        this.titleField.setFont(((Font)serializable).deriveFont((float)((Font)serializable).getSize() * 1.5f));
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.titleField, gridBagConstraints);
        this.textArea = new JTextArea(3, 30);
        this.setInfo(this.textArea, "qu.text", true);
        this.textArea.setEditable(false);
        this.textArea.setLineWrap(true);
        this.textArea.setOpaque(false);
        this.textArea.setWrapStyleWord(true);
        this.textArea.setFocusTraversalKeys(0, null);
        this.textArea.setFocusTraversalKeys(1, null);
        Serializable serializable2 = this.textArea.getInputMap();
        ((InputMap)serializable2).put(this.enterKey, "next");
        ActionMap actionMap = this.textArea.getActionMap();
        actionMap.put("next", this.valueAction);
        gridBagConstraints.insets.top = 20;
        gridBagConstraints.insets.right = 10;
        gridBagConstraints.insets.left = 10;
        gridBagConstraints.insets.bottom = 10;
        gridBagConstraints.fill = 1;
        this.add((Component)this.textArea, gridBagConstraints);
        this.valuePanel = new JPanel(new BorderLayout());
        this.setInfo(this.valuePanel, "qu.vp", false);
        this.valuePanel.setOpaque(true);
        serializable2 = this.valuePanel.getInputMap(1);
        ((InputMap)serializable2).put(this.enterKey, "next");
        actionMap = this.valuePanel.getActionMap();
        actionMap.put("next", this.valueAction);
        gridBagConstraints.insets.top = 0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets.bottom = 10;
        this.add((Component)this.valuePanel, gridBagConstraints);
        gridBagConstraints.fill = 1;
        this.valueMessageField = new JTextField();
        this.setInfo(this.valueMessageField, "qu.vmsg", false);
        this.valueMessageField.setEditable(false);
        this.valueMessageField.setOpaque(false);
        this.valueMessageField.setFont(this.valueMessageField.getFont().deriveFont(1));
        this.valueMessageField.setBorder(null);
        gridBagConstraints.insets.bottom = 0;
        gridBagConstraints.weighty = 0.0;
        this.add((Component)this.valueMessageField, gridBagConstraints);
        this.propsPanel = new JPanel(new BorderLayout());
        this.propsPanel.setBorder(BorderFactory.createEtchedBorder());
        this.propsPanel.setName("qu.props.pnl");
        this.propsPanel.setFocusable(false);
        serializable2 = new JLabel(i18n.getString("qu.tag.lbl"));
        this.setInfo((JComponent)serializable2, "qu.tag.lbl", true);
        ((JLabel)serializable2).setDisplayedMnemonic(i18n.getString("qu.tag.mne").charAt(0));
        ((JComponent)serializable2).setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 7));
        this.propsPanel.add((Component)serializable2, "West");
        this.tagField = new JTextField();
        this.tagField.setName("qu.tag.fld");
        this.tagField.setEditable(false);
        this.tagField.setBorder(null);
        ((JLabel)serializable2).setLabelFor(this.tagField);
        this.propsPanel.add((Component)this.tagField, "Center");
        this.propsPanel.setVisible(false);
        gridBagConstraints.insets.bottom = 10;
        this.add((Component)this.propsPanel, gridBagConstraints);
        actionMap = this.getActionMap();
        actionMap.put("hideProps", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                QuestionPanel.this.propsPanel.setVisible(false);
            }
        });
        actionMap.put("showProps", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                QuestionPanel.this.propsPanel.setVisible(true);
            }
        });
        actionMap.put("toggleProps", new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                QuestionPanel.this.propsPanel.setVisible(!QuestionPanel.this.propsPanel.isVisible());
            }
        });
        InputMap inputMap = this.getInputMap(1);
        inputMap.put(KeyStroke.getKeyStroke("ctrl T"), "toggleProps");
    }

    private void setInfo(JComponent jComponent, String string, boolean bl) {
        jComponent.setName(string);
        AccessibleContext accessibleContext = jComponent.getAccessibleContext();
        accessibleContext.setAccessibleName(i18n.getString(string + ".name"));
        if (bl) {
            String string2 = i18n.getString(string + ".tip");
            jComponent.setToolTipText(string2);
            accessibleContext.setAccessibleDescription(string2);
        } else {
            accessibleContext.setAccessibleDescription(i18n.getString(string + ".desc"));
        }
    }

    private Dimension getValuePanelAvailableSize() {
        Dimension dimension = new Dimension(this.getVisibleRect().width, this.getVisibleRect().height);
        if (this.getParent().getParent() instanceof JScrollPane) {
            JScrollBar jScrollBar = ((JScrollPane)this.getParent().getParent()).getHorizontalScrollBar();
            JScrollBar jScrollBar2 = ((JScrollPane)this.getParent().getParent()).getVerticalScrollBar();
            if (jScrollBar.isVisible()) {
                dimension.height += jScrollBar.getSize().height;
            }
            if (jScrollBar2.isVisible()) {
                dimension.width += jScrollBar2.getSize().width;
            }
        }
        dimension.width -= 20;
        int n = this.graphicLabel.getSize().width;
        dimension.width = dimension.width - (n > 0 ? n : 0);
        dimension.height -= 10;
        n = this.titleField.getSize().height;
        dimension.height = dimension.height - (n > 0 ? n : 0);
        n = 75;
        n = this.textArea.getPreferredSize().height + 20 + 10;
        dimension.height = dimension.height - (n > 0 ? n : 0);
        n = this.valueMessageField.getSize().height;
        dimension.height = dimension.height - (n > 0 ? n : 0);
        n = this.propsPanel.getSize().height;
        dimension.height = dimension.height - (n > 0 ? n : 0);
        return dimension;
    }

    public void showQuestion(Question question) {
        Serializable serializable;
        ImageIcon imageIcon;
        if (question instanceof ErrorQuestion) {
            JTextArea jTextArea = new JTextArea(question.getText());
            jTextArea.setOpaque(false);
            jTextArea.setEditable(false);
            jTextArea.setLineWrap(true);
            jTextArea.setWrapStyleWord(true);
            jTextArea.setSize(new Dimension(5 * DOTS_PER_INCH, Integer.MAX_VALUE));
            JOptionPane.showMessageDialog(this, jTextArea, question.getSummary(), 0);
            try {
                this.interview.prev();
            }
            catch (Interview.Fault fault) {
                // empty catch block
            }
            return;
        }
        URL uRL = question.getImage();
        ImageIcon imageIcon2 = imageIcon = uRL == null ? null : new ImageIcon(uRL);
        if (imageIcon != null) {
            this.graphicLabel.setIcon(imageIcon);
        }
        this.titleField.setText(question.getSummary());
        this.textArea.setText(question.getText());
        this.tagField.setText(question.getTag());
        boolean bl = this.anyChildHasFocus(this.valuePanel);
        this.valuePanel.removeAll();
        QuestionRenderer questionRenderer = this.getRenderer(question);
        if (questionRenderer instanceof SizeSensitiveQuestionRenderer) {
            serializable = this.getValuePanelAvailableSize();
            ((SizeSensitiveQuestionRenderer)questionRenderer).setPreferredPaneSize((Dimension)serializable);
        }
        if (questionRenderer == null) {
            this.valueSaver = null;
        } else {
            serializable = questionRenderer.getQuestionRendererComponent(question, this.valueAction);
            if (serializable == null) {
                this.valueSaver = null;
                if (bl) {
                    this.textArea.requestFocus();
                }
            } else {
                if (((Component)serializable).getName() == null) {
                    ((Component)serializable).setName(questionRenderer.getClass().getName());
                }
                this.valueSaver = (Runnable)((JComponent)serializable).getClientProperty("valueSaver");
                this.valuePanel.add((Component)serializable);
                if (bl) {
                    FocusManager focusManager = FocusManager.getCurrentManager();
                    focusManager.focusNextComponent(this.textArea);
                }
            }
        }
        if (question.isValueAlwaysValid()) {
            this.valueMessageField.setVisible(false);
        } else {
            this.showValueMessage(null);
            this.valueMessageField.setVisible(true);
        }
        this.revalidate();
        this.currentRenderer = questionRenderer;
        this.currentQuestion = question;
    }

    private void setHorScrollStatus(boolean bl) {
        int n = bl ? 30 : 31;
        ((JScrollPane)this.getParent().getParent()).setHorizontalScrollBarPolicy(n);
    }

    public void showValueInvalidMessage() {
        String string = this.currentRenderer == null ? null : this.currentRenderer.getInvalidValueMessage(this.currentQuestion);
        this.showValueMessage(string == null ? INVALID_VALUE : string, INVALID_VALUE_COLOR);
    }

    private void showValueMessage(String string) {
        this.showValueMessage(string, MetalLookAndFeel.getBlack());
    }

    private void showValueMessage(String string, Color color) {
        if (string == null || string.length() == 0) {
            this.valueMessageField.setText("");
            this.valueMessageField.setEnabled(false);
        } else {
            this.valueMessageField.setForeground(color);
            this.valueMessageField.setText(string);
            this.valueMessageField.setEnabled(true);
        }
    }

    private QuestionRenderer getRenderer(Question question) {
        for (Class<?> clazz = question.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            QuestionRenderer questionRenderer = (QuestionRenderer)this.renderers.get(clazz);
            if (questionRenderer == null) continue;
            return questionRenderer;
        }
        return null;
    }

    private boolean anyChildHasFocus(JPanel jPanel) {
        if (jPanel.hasFocus()) {
            return true;
        }
        for (int i = 0; i < jPanel.getComponentCount(); ++i) {
            Component component = jPanel.getComponent(i);
            if ((!(component instanceof JComponent) || !((JComponent)component).hasFocus()) && (!(component instanceof JPanel) || !this.anyChildHasFocus((JPanel)component))) continue;
            return true;
        }
        return false;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class Listener
    implements AncestorListener,
    Interview.Observer {
        private Listener() {
        }

        public void ancestorAdded(AncestorEvent ancestorEvent) {
            QuestionPanel.this.interview.addObserver(this);
            QuestionPanel.this.showQuestion(QuestionPanel.this.interview.getCurrentQuestion());
        }

        public void ancestorMoved(AncestorEvent ancestorEvent) {
        }

        public void ancestorRemoved(AncestorEvent ancestorEvent) {
            QuestionPanel.this.interview.removeObserver(this);
        }

        public void pathUpdated() {
            QuestionPanel.this.showValueMessage(null);
        }

        public void currentQuestionChanged(Question question) {
            QuestionPanel.this.showQuestion(question);
        }

        public void finished() {
        }
    }
}

