/*
 * Decompiled with CFR 0.152.
 */
package com.sun.interview.wizard;

import com.sun.interview.Interview;
import com.sun.interview.Question;
import com.sun.interview.WizPrint;
import com.sun.interview.wizard.Exporter;
import com.sun.interview.wizard.I18NResourceBundle;
import com.sun.interview.wizard.InfoPanel;
import com.sun.interview.wizard.PathPanel;
import com.sun.interview.wizard.QuestionPanel;
import com.sun.interview.wizard.SearchDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Properties;
import javax.help.HelpBroker;
import javax.help.HelpSet;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSplitPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.filechooser.FileFilter;

public class Wizard
extends JComponent {
    public static final String OK = "OK";
    private ActionListener performer = new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            Wizard.this.perform(actionEvent.getActionCommand());
        }
    };
    private Interview interview;
    private Exporter[] exporters;
    private String title;
    private JMenuBar menuBar;
    private JMenu fileMenu;
    private JComponent main;
    private JPanel body;
    private PathPanel pathPanel;
    private QuestionPanel questionPanel;
    private InfoPanel infoPanel;
    private JToolBar buttonPanel;
    private JButton cancelBtn;
    private JButton backBtn;
    private JButton nextBtn;
    private JButton okBtn;
    private JToggleButton infoBtn;
    private Window window;
    private ActionListener okListener;
    private SearchDialog searchDialog;
    private boolean initialInfoVisible = true;
    private Listener listener = new Listener();
    private HelpSet helpHelpSet;
    private HelpBroker helpHelpBroker;
    private String helpHelpPrefix;
    private JMenu helpMenu;
    private File currFile;
    private File defaultFile;
    private boolean exitOnClose;
    private final FileFilter jtiFilter = new ExtensionFileFilter(".jti");
    private final FileFilter htmlFilter = new ExtensionFileFilter(new String[]{".htm", ".html"});
    private static final KeyStroke enterKey = KeyStroke.getKeyStroke("ENTER");
    private static final I18NResourceBundle i18n = I18NResourceBundle.getDefaultBundle();
    private static final String[][] fileMenuData = new String[][]{{"new", "performNew"}, {"open", "performOpen"}, {"save", "performSave"}, {"saveAs", "performSaveAs"}, null, {"exportLog", "performExportLog"}};
    private static final String[][] helpMenuData = new String[][]{{"help", "performHelp", "F1"}};
    private static final String[][] searchMenuData = new String[][]{{"find", "performFind", "control F"}, {"findNext", "performFindNext", "F3"}};
    static /* synthetic */ Class class$com$sun$interview$wizard$Wizard;

    public static void main(String[] stringArray) {
        try {
            UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
            Class<?> clazz = Class.forName(stringArray[0]);
            Interview interview = (Interview)clazz.newInstance();
            Wizard wizard = new Wizard(interview);
            wizard.showInFrame(true);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            System.exit(1);
        }
    }

    public Wizard(Interview interview) {
        this(interview, null);
    }

    public Wizard(Interview interview, Exporter[] exporterArray) {
        this.interview = interview;
        this.exporters = exporterArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open(File file) throws Interview.Fault, IOException {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
        try {
            Properties properties = new Properties();
            properties.load(bufferedInputStream);
            this.interview.load(properties);
            this.interview.setEdited(false);
            this.initialInfoVisible = properties.getProperty("INFO", "true").equals("true");
        }
        finally {
            ((InputStream)bufferedInputStream).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(File file) throws IOException {
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
        try {
            Properties properties = new Properties();
            if (this.infoPanel != null) {
                properties.put("INFO", String.valueOf(this.infoPanel.isShowing()));
            }
            this.interview.save(properties);
            this.interview.setEdited(false);
            properties.save(bufferedOutputStream, "Wizard data file: " + this.interview.getTitle());
        }
        finally {
            ((OutputStream)bufferedOutputStream).close();
        }
    }

    public File getFile() {
        return this.currFile;
    }

    public void setFile(File file) {
        this.currFile = new File(file.getAbsolutePath());
        if (this.window != null) {
            this.updateTitle(this.window);
        }
    }

    public void setDefaultFile(File file) {
        this.defaultFile = file;
        if (this.window != null) {
            this.updateTitle(this.window);
        }
    }

    public void setHelpBroker(HelpBroker helpBroker) {
        this.helpHelpBroker = helpBroker;
    }

    public void setHelpSet(HelpSet helpSet) {
        this.helpHelpSet = helpSet;
    }

    public void setHelpSetPrefix(String string) {
        this.helpHelpPrefix = string;
    }

    public void setHelpMenu(JMenu jMenu) {
        this.helpMenu = jMenu;
    }

    public void showInFrame(final boolean bl) {
        if (this.window != null && !(this.window instanceof JFrame)) {
            throw new IllegalStateException();
        }
        if (!EventQueue.isDispatchThread()) {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    Wizard.this.showInFrame(bl);
                }
            });
            return;
        }
        this.initGUI();
        this.okBtn.setVisible(false);
        this.cancelBtn.setVisible(false);
        JFrame jFrame = new JFrame();
        this.initMenuBar(jFrame);
        this.updateTitle(jFrame);
        jFrame.setName("interview.wizard");
        jFrame.setJMenuBar(this.menuBar);
        jFrame.setContentPane(this.main);
        jFrame.pack();
        jFrame.setDefaultCloseOperation(0);
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                if (Wizard.this.interview.isEdited() && !Wizard.this.okToContinue()) {
                    return;
                }
                windowEvent.getWindow().dispose();
            }

            public void windowClosed(WindowEvent windowEvent) {
                if (bl) {
                    System.exit(0);
                }
            }
        });
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = jFrame.getSize();
        jFrame.setLocation(dimension.width / 2 - dimension2.width / 2, dimension.height / 2 - dimension2.height / 2);
        jFrame.show();
        this.window = jFrame;
    }

    public void showInDialog(final Frame frame, final ActionListener actionListener) {
        if (this.window != null && !(this.window instanceof JDialog)) {
            throw new IllegalStateException();
        }
        if (!EventQueue.isDispatchThread()) {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    Wizard.this.showInDialog(frame, actionListener);
                }
            });
            return;
        }
        this.okListener = actionListener;
        this.initGUI();
        this.okBtn.setVisible(true);
        this.okBtn.setEnabled(this.interview.isFinishable());
        this.cancelBtn.setVisible(true);
        JDialog jDialog = new JDialog(frame);
        this.initMenuBar(jDialog);
        this.updateTitle(jDialog);
        jDialog.setJMenuBar(this.menuBar);
        jDialog.setContentPane(this.main);
        jDialog.pack();
        jDialog.setDefaultCloseOperation(0);
        jDialog.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                if (!Wizard.this.interview.isEdited() || Wizard.this.okToContinue()) {
                    windowEvent.getWindow().dispose();
                }
            }

            public void windowClosed(WindowEvent windowEvent) {
            }
        });
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = jDialog.getSize();
        jDialog.setLocation(dimension.width / 2 - dimension2.width / 2, dimension.height / 2 - dimension2.height / 2);
        jDialog.show();
        this.window = jDialog;
    }

    public boolean isShowing() {
        return this.window != null && this.window.isShowing();
    }

    public void toFront() {
        if (this.window != null) {
            this.window.toFront();
        }
    }

    private void initGUI() {
        this.title = this.interview.getTitle();
        if (this.title == null || this.title.equals("")) {
            this.title = i18n.getString("wizard.defaultTitle");
        }
        this.setLayout(new BorderLayout());
        this.main = this;
        this.questionPanel = new QuestionPanel(this.interview);
        this.questionPanel.setBorder(BorderFactory.createLoweredBevelBorder());
        this.pathPanel = new PathPanel(this.questionPanel, this.interview);
        if (this.interview.getHelpSet() != null) {
            this.infoPanel = new InfoPanel(this.interview);
        }
        this.buttonPanel = new JToolBar();
        this.buttonPanel.setFloatable(false);
        this.buttonPanel.add(Box.createHorizontalGlue());
        this.backBtn = this.createButton("back", "performBack", this.performer);
        this.buttonPanel.add(this.backBtn);
        this.nextBtn = this.createButton("next", "performNext", this.performer);
        this.buttonPanel.add(this.nextBtn);
        this.buttonPanel.addSeparator();
        this.okBtn = this.createButton("ok", "performOk", this.performer);
        this.buttonPanel.add(this.okBtn);
        this.cancelBtn = this.createButton("cancel", "performCancel", this.performer);
        this.buttonPanel.add(this.cancelBtn);
        if (this.infoPanel != null) {
            this.buttonPanel.addSeparator();
            this.infoBtn = this.createToggle("info", "performInfo", this.performer);
            this.infoBtn.setSelected(this.initialInfoVisible);
            this.buttonPanel.add(this.infoBtn);
        }
        this.buttonPanel.addAncestorListener(new Listener());
        this.body = new JPanel(new BorderLayout());
        this.body.add((Component)this.pathPanel, "West");
        this.body.add((Component)this.questionPanel, "Center");
        this.body.add((Component)this.buttonPanel, "South");
        this.body.registerKeyboardAction(this.performer, "performFindNext", KeyStroke.getKeyStroke("F3"), 1);
        if (this.helpHelpPrefix == null) {
            this.helpHelpPrefix = "wizard.";
        }
        if (this.helpHelpSet == null && this.infoPanel != null) {
            this.helpHelpSet = this.infoPanel.getHelpSet();
        }
        if (this.helpHelpBroker == null && this.helpHelpSet != null) {
            this.helpHelpBroker = this.helpHelpSet.createHelpBroker();
        }
        if (this.helpHelpBroker != null && this.helpHelpSet != null) {
            this.helpHelpBroker.enableHelpKey(this.main, this.helpHelpPrefix + "window.csh", this.helpHelpSet);
        }
        if (this.infoPanel == null) {
            this.main.add(this.body);
        } else {
            this.update(this.infoBtn.isSelected());
        }
    }

    private void initMenuBar(Window window) {
        this.menuBar = new JMenuBar();
        this.fileMenu = this.createMenu("file", fileMenuData, this.performer);
        if (window instanceof JFrame) {
            this.fileMenu.addSeparator();
            this.fileMenu.add(this.createMenuItem("file", "exit", "performExit", this.performer));
        } else {
            this.fileMenu.addSeparator();
            this.fileMenu.add(this.createMenuItem("file", "close", "performCancel", this.performer));
        }
        if (this.exporters != null) {
            for (int i = 0; i < this.fileMenu.getItemCount(); ++i) {
                JMenuItem jMenuItem = this.fileMenu.getItem(i);
                if (jMenuItem == null || !jMenuItem.getActionCommand().equals("performExportLog")) continue;
                this.fileMenu.remove(i);
                ExportMenu exportMenu = new ExportMenu(this.exporters);
                exportMenu.add(this.createMenuItem("export", "log", "performExportLog", this.performer));
                this.fileMenu.insert(exportMenu, i);
                break;
            }
        }
        this.menuBar.add(this.fileMenu);
        JMenu jMenu = this.createMenu("search", searchMenuData, this.performer);
        this.menuBar.add(jMenu);
        if (this.helpHelpBroker != null) {
            if (this.helpMenu == null) {
                this.helpMenu = this.createMenu("help", helpMenuData, this.performer);
            }
            this.menuBar.add(this.helpMenu);
        }
    }

    private void update(boolean bl) {
        Dimension dimension = this.body.getSize();
        if (dimension.width == 0) {
            dimension = this.body.getPreferredSize();
        }
        Dimension dimension2 = this.infoPanel.getSize();
        if (dimension2.width == 0) {
            dimension2 = this.infoPanel.getPreferredSize();
        }
        boolean bl2 = this.infoPanel.isShowing();
        this.main.removeAll();
        if (bl) {
            JSplitPane jSplitPane = new JSplitPane(1, this.body, this.infoPanel);
            jSplitPane.setDividerLocation(dimension.width + 2);
            this.main.add(jSplitPane);
            this.infoPanel.setCurrentID(this.interview.getCurrentQuestion());
        } else {
            this.main.add(this.body);
        }
        if (this.window != null) {
            int n = new JSplitPane().getDividerSize();
            Dimension dimension3 = this.window.getSize();
            int n2 = dimension3.width;
            if (bl != bl2) {
                n2 += (bl ? 1 : -1) * (dimension2.width + n + 4);
            }
            this.window.setSize(n2, dimension3.height);
        }
        if (this.infoBtn.isSelected() != bl) {
            this.infoBtn.setSelected(bl);
        }
    }

    private void updateTitle(Window window) {
        String string = this.currFile == null || this.defaultFile != null && this.currFile.equals(this.defaultFile) ? this.title : i18n.getString("wizard.titleAndFile", new Object[]{this.title, this.currFile.getPath()});
        if (window instanceof JFrame) {
            ((JFrame)window).setTitle(string);
        } else {
            ((JDialog)window).setTitle(string);
        }
    }

    private void perform(String string) {
        try {
            Method method = (class$com$sun$interview$wizard$Wizard == null ? (class$com$sun$interview$wizard$Wizard = Wizard.class$("com.sun.interview.wizard.Wizard")) : class$com$sun$interview$wizard$Wizard).getDeclaredMethod(string, new Class[0]);
            method.invoke((Object)this, new Object[0]);
        }
        catch (IllegalAccessException illegalAccessException) {
            System.err.println(string);
            illegalAccessException.printStackTrace();
        }
        catch (InvocationTargetException invocationTargetException) {
            System.err.println(string);
            invocationTargetException.getTargetException().printStackTrace();
        }
        catch (NoSuchMethodException noSuchMethodException) {
            System.err.println(string);
        }
    }

    private void performBack() {
        try {
            this.questionPanel.saveCurrentResponse();
            this.interview.prev();
        }
        catch (Interview.Fault fault) {
        }
        catch (RuntimeException runtimeException) {
            this.questionPanel.getToolkit().beep();
        }
    }

    private void performCancel() {
        this.questionPanel.saveCurrentResponse();
        if (this.interview.isEdited() && !this.okToContinue()) {
            return;
        }
        this.window.dispose();
    }

    private void performExit() {
        this.questionPanel.saveCurrentResponse();
        if (this.interview.isEdited() && !this.okToContinue()) {
            return;
        }
        System.exit(0);
    }

    private void performExportLog() {
        File file;
        int n;
        this.questionPanel.saveCurrentResponse();
        JFileChooser jFileChooser = new JFileChooser();
        if (this.currFile != null) {
            jFileChooser.setCurrentDirectory(new File(this.currFile.getParent()));
            n = this.currFile.getName().lastIndexOf(".");
            if (n != -1) {
                file = new File(this.currFile.getName().substring(0, n) + ".html");
                jFileChooser.setSelectedFile(file);
            }
        } else {
            jFileChooser.setCurrentDirectory(this.getUserDir());
        }
        jFileChooser.setFileFilter(this.htmlFilter);
        n = jFileChooser.showDialog(this.main, i18n.getString("wizard.exportLog"));
        if (n != 0) {
            return;
        }
        file = this.ensureExtn(jFileChooser.getSelectedFile(), ".html");
        if (file.exists() && !this.okToOverwrite(file)) {
            return;
        }
        try {
            FileWriter fileWriter = new FileWriter(file);
            WizPrint wizPrint = new WizPrint(this.interview, this.interview.getPath());
            wizPrint.setShowResponses(true);
            wizPrint.write(fileWriter);
        }
        catch (FileNotFoundException fileNotFoundException) {
            JOptionPane.showMessageDialog(this.main, i18n.getString("wizard.fileNotFound.txt", fileNotFoundException.getMessage()), i18n.getString("wizard.fileNotFound.title"), 0);
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(this.main, i18n.getString("wizard.badFile.txt", iOException.getMessage()), i18n.getString("wizard.badFile.title"), 0);
        }
    }

    private void performFind() {
        if (this.searchDialog == null) {
            this.searchDialog = SearchDialog.create(this.window, this.interview, this.helpHelpBroker, this.helpHelpPrefix);
        }
        this.searchDialog.setVisible(true);
    }

    private void performFindNext() {
        if (this.searchDialog == null) {
            this.searchDialog = SearchDialog.create(this.window, this.interview, this.helpHelpBroker, this.helpHelpPrefix);
        }
        this.searchDialog.find();
    }

    private void performHelp() {
        this.helpHelpBroker.setCurrentID(this.helpHelpPrefix + "intro.csh");
        this.helpHelpBroker.setDisplayed(true);
    }

    private void performInfo() {
        boolean bl = this.infoBtn.isSelected();
        if (this.infoPanel.isShowing() != bl) {
            this.update(bl);
            this.window.validate();
        }
    }

    private void performNew() {
        this.questionPanel.saveCurrentResponse();
        if (this.interview.isEdited() && !this.okToContinue()) {
            return;
        }
        this.interview.clear();
        this.interview.setEdited(false);
        this.setFile(this.defaultFile);
    }

    private void performNext() {
        try {
            this.questionPanel.saveCurrentResponse();
            this.interview.next();
        }
        catch (Interview.Fault fault) {
            this.questionPanel.getToolkit().beep();
        }
        catch (RuntimeException runtimeException) {
            this.questionPanel.getToolkit().beep();
        }
    }

    private void performOk() {
        try {
            this.questionPanel.saveCurrentResponse();
            this.window.dispose();
            this.okListener.actionPerformed(new ActionEvent(this, 1001, OK));
        }
        catch (RuntimeException runtimeException) {
            this.questionPanel.getToolkit().beep();
        }
    }

    private void performOpen() {
        this.questionPanel.saveCurrentResponse();
        if (this.interview.isEdited() && !this.okToContinue()) {
            return;
        }
        JFileChooser jFileChooser = new JFileChooser();
        if (this.currFile != null) {
            jFileChooser.setCurrentDirectory(new File(this.currFile.getParent()));
            jFileChooser.setSelectedFile(new File(this.currFile.getName()));
        } else {
            jFileChooser.setCurrentDirectory(this.getUserDir());
        }
        jFileChooser.setFileFilter(this.jtiFilter);
        int n = jFileChooser.showOpenDialog(this.main);
        if (n != 0) {
            return;
        }
        File file = this.ensureExtn(jFileChooser.getSelectedFile(), ".jti");
        try {
            this.open(file);
            this.setFile(file);
        }
        catch (Interview.Fault fault) {
            JOptionPane.showMessageDialog(this.main, i18n.getString("wizard.badInterview.txt", fault.getMessage()), i18n.getString("wizard.badInterview.title"), 0);
        }
        catch (FileNotFoundException fileNotFoundException) {
            JOptionPane.showMessageDialog(this.main, i18n.getString("wizard.fileNotFound.txt", fileNotFoundException.getMessage()), i18n.getString("wizard.fileNotFound.title"), 0);
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(this.main, i18n.getString("wizard.badFile.txt", iOException.getMessage()), i18n.getString("wizard.badFile.title"), 0);
        }
    }

    private void performSave() {
        this.questionPanel.saveCurrentResponse();
        if (this.currFile == null) {
            this.performSaveAs();
        } else {
            this.performSaveInternal(this.currFile);
        }
    }

    private void performSaveAs() {
        this.questionPanel.saveCurrentResponse();
        JFileChooser jFileChooser = new JFileChooser();
        if (this.currFile != null) {
            jFileChooser.setCurrentDirectory(new File(this.currFile.getParent()));
            jFileChooser.setSelectedFile(new File(this.currFile.getName()));
        } else {
            jFileChooser.setCurrentDirectory(this.getUserDir());
        }
        jFileChooser.setFileFilter(this.jtiFilter);
        int n = jFileChooser.showSaveDialog(this.main);
        if (n != 0) {
            return;
        }
        File file = this.ensureExtn(jFileChooser.getSelectedFile(), ".jti");
        if (file.exists() && !this.okToOverwrite(file)) {
            return;
        }
        this.performSaveInternal(file);
    }

    private void performSaveInternal(File file) {
        try {
            this.save(file);
            this.setFile(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            JOptionPane.showMessageDialog(this.main, i18n.getString("wizard.fileNotFound.txt", fileNotFoundException.getMessage()), i18n.getString("wizard.fileNotFound.title"), 0);
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(this.main, i18n.getString("wizard.badFile.txt", iOException.getMessage()), i18n.getString("wizard.badFile.title"), 0);
        }
    }

    private File getUserDir() {
        return new File(System.getProperty("user.dir"));
    }

    private JButton createButton(String string, String string2, ActionListener actionListener) {
        JButton jButton = new JButton(this.createIcon(string));
        jButton.setToolTipText(i18n.getString("wizard." + string + ".tip"));
        jButton.setActionCommand(string2);
        jButton.addActionListener(actionListener);
        jButton.registerKeyboardAction(actionListener, string2, enterKey, 0);
        return jButton;
    }

    private Icon createIcon(String string) {
        String string2 = i18n.getString("wizard." + string + ".icon");
        URL uRL = this.getClass().getResource(string2);
        return uRL == null ? null : new ImageIcon(uRL);
    }

    private JMenu createMenu(String string, String[][] stringArray, ActionListener actionListener) {
        JMenu jMenu = new JMenu(i18n.getString("wizard." + string + ".menu"));
        jMenu.setName("wizard." + string);
        jMenu.setMnemonic(i18n.getString("wizard." + string + ".mne").charAt(0));
        for (int i = 0; i < stringArray.length; ++i) {
            String[] stringArray2 = stringArray[i];
            if (stringArray2 == null) {
                jMenu.addSeparator();
                continue;
            }
            JMenuItem jMenuItem = this.createMenuItem(string, stringArray2[0], stringArray2[1], actionListener);
            if (stringArray2.length > 2) {
                KeyStroke keyStroke = KeyStroke.getKeyStroke(stringArray2[2]);
                jMenuItem.setAccelerator(keyStroke);
            }
            jMenu.add(jMenuItem);
        }
        return jMenu;
    }

    private JMenuItem createMenuItem(String string, String string2, String string3, ActionListener actionListener) {
        JMenuItem jMenuItem = new JMenuItem(i18n.getString("wizard." + string + "." + string2 + ".mit"));
        jMenuItem.setName(string2);
        jMenuItem.setMnemonic(i18n.getString("wizard." + string + "." + string2 + ".mne").charAt(0));
        jMenuItem.setActionCommand(string3);
        jMenuItem.addActionListener(actionListener);
        return jMenuItem;
    }

    private JToggleButton createToggle(String string, String string2, ActionListener actionListener) {
        JToggleButton jToggleButton = new JToggleButton(this.createIcon(string)){

            public Insets getInsets() {
                return Wizard.this.nextBtn == null ? super.getInsets() : Wizard.this.nextBtn.getInsets();
            }
        };
        jToggleButton.setToolTipText(i18n.getString("wizard." + string + ".tip"));
        jToggleButton.setActionCommand(string2);
        jToggleButton.addActionListener(actionListener);
        jToggleButton.registerKeyboardAction(actionListener, string2, enterKey, 0);
        return jToggleButton;
    }

    private File ensureExtn(File file, String string) {
        if (file.getName().endsWith(string)) {
            return file;
        }
        return new File(file.getPath() + string);
    }

    private boolean okToContinue() {
        int n = JOptionPane.showConfirmDialog(this.main, i18n.getString("wizard.unsavedAnswers.txt"), i18n.getString("wizard.unsavedAnswers.title"), 0);
        return n == 0;
    }

    private boolean okToOverwrite(File file) {
        int n = JOptionPane.showConfirmDialog(this.main, i18n.getString("wizard.overwrite.txt", file), i18n.getString("wizard.overwrite.title"), 0);
        return n == 0;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class Listener
    implements AncestorListener,
    Interview.Observer {
        private Listener() {
        }

        public void ancestorAdded(AncestorEvent ancestorEvent) {
            Wizard.this.interview.addObserver(this);
            this.pathUpdated();
            this.currentQuestionChanged(Wizard.this.interview.getCurrentQuestion());
        }

        public void ancestorMoved(AncestorEvent ancestorEvent) {
        }

        public void ancestorRemoved(AncestorEvent ancestorEvent) {
            Wizard.this.interview.removeObserver(this);
        }

        public void pathUpdated() {
            Wizard.this.okBtn.setEnabled(Wizard.this.interview.isFinishable());
        }

        public void currentQuestionChanged(Question question) {
            Wizard.this.backBtn.setEnabled(!Wizard.this.interview.isFirst(question));
            Wizard.this.nextBtn.setEnabled(!Wizard.this.interview.isLast(question));
        }
    }

    private class ExportMenu
    extends JMenu
    implements ActionListener,
    PopupMenuListener {
        ExportMenu(Exporter[] exporterArray) {
            super(i18n.getString("wizard.export.menu"));
            this.setName("export");
            this.setMnemonic(i18n.getString("wizard.export.mne").charAt(0));
            for (int i = 0; i < exporterArray.length; ++i) {
                JMenuItem jMenuItem = new JMenuItem(exporterArray[i].getName());
                jMenuItem.putClientProperty("exporter", exporterArray[i]);
                jMenuItem.setActionCommand("performGenericExport");
                jMenuItem.addActionListener(this);
                this.add(jMenuItem);
            }
            this.getPopupMenu().addPopupMenuListener(this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Wizard.this.questionPanel.saveCurrentResponse();
            JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
            Exporter exporter = (Exporter)jMenuItem.getClientProperty("exporter");
            this.export(exporter);
        }

        public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
        }

        public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
        }

        public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
            JPopupMenu jPopupMenu = (JPopupMenu)popupMenuEvent.getSource();
            for (int i = 0; i < jPopupMenu.getComponentCount(); ++i) {
                Exporter exporter;
                JMenuItem jMenuItem = (JMenuItem)jPopupMenu.getComponent(i);
                if (jMenuItem == null || (exporter = (Exporter)jMenuItem.getClientProperty("exporter")) == null) continue;
                jMenuItem.setEnabled(exporter.isExportable());
            }
        }

        private void export(Exporter exporter) {
            String[] stringArray;
            JFileChooser jFileChooser = new JFileChooser();
            if (Wizard.this.currFile != null) {
                jFileChooser.setCurrentDirectory(new File(Wizard.this.currFile.getParent()));
                stringArray = exporter.getFileExtensions();
                int n = Wizard.this.currFile.getName().lastIndexOf(".");
                if (n != -1 && stringArray != null && stringArray.length > 0) {
                    File file = new File(Wizard.this.currFile.getName().substring(0, n) + stringArray[0]);
                    jFileChooser.setSelectedFile(file);
                }
            } else {
                jFileChooser.setCurrentDirectory(Wizard.this.getUserDir());
            }
            jFileChooser.setApproveButtonText(i18n.getString("wizard.exportChooser.export"));
            stringArray = exporter.getFileExtensions();
            String string = exporter.getFileDescription();
            jFileChooser.setFileFilter(new ExtensionFileFilter(stringArray, string));
            int n = jFileChooser.showSaveDialog(Wizard.this.main);
            if (n != 0) {
                return;
            }
            try {
                File file = Wizard.this.ensureExtn(jFileChooser.getSelectedFile(), stringArray[0]);
                if (file.exists() && !Wizard.this.okToOverwrite(file)) {
                    return;
                }
                exporter.export(file);
            }
            catch (IOException iOException) {
                JOptionPane.showMessageDialog(Wizard.this.main, i18n.getString("wizard.exportError.txt", iOException.getMessage()), i18n.getString("wizard.exportError.title"), 0);
            }
            catch (Interview.Fault fault) {
                JOptionPane.showMessageDialog(Wizard.this.main, i18n.getString("wizard.exportError.txt", fault.getMessage()), i18n.getString("wizard.exportError.title"), 0);
            }
        }
    }

    private class ExtensionFileFilter
    extends FileFilter {
        private String[] extns;
        private String description;

        ExtensionFileFilter(String string) {
            this.extns = new String[]{string};
        }

        ExtensionFileFilter(String[] stringArray) {
            this.extns = stringArray;
        }

        ExtensionFileFilter(String[] stringArray, String string) {
            this.extns = stringArray;
            this.description = string;
        }

        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            for (int i = 0; i < this.extns.length; ++i) {
                if (!file.getName().endsWith(this.extns[i])) continue;
                return true;
            }
            return false;
        }

        public String getDescription() {
            if (this.description == null) {
                StringBuffer stringBuffer = new StringBuffer("wizard.extn");
                if (this.extns.length == 0) {
                    stringBuffer.append(".allFiles");
                } else {
                    for (int i = 0; i < this.extns.length; ++i) {
                        stringBuffer.append(this.extns[i]);
                    }
                }
                this.description = i18n.getString(stringBuffer.toString());
            }
            return this.description;
        }
    }
}

