/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest;

import com.sun.javatest.util.I18NResourceBundle;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.util.HashSet;
import java.util.Set;

public class EditLinks {
    private File[] inFiles = new File[0];
    private File outFile;
    private String[][] edits = new String[0][];
    private Set ignores = new HashSet();
    private int c;
    private int line;
    private File currFile;
    private Reader in;
    private Writer out;
    private boolean copying;
    private static final I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(class$com$sun$javatest$EditLinks == null ? (class$com$sun$javatest$EditLinks = EditLinks.class$("com.sun.javatest.EditLinks")) : class$com$sun$javatest$EditLinks);
    static /* synthetic */ Class class$com$sun$javatest$EditLinks;

    public static void main(String[] stringArray) {
        try {
            if (stringArray.length == 0) {
                EditLinks.usage(System.err);
            } else {
                EditLinks editLinks = new EditLinks(stringArray);
                if (editLinks.edits.length == 0) {
                    System.err.println(i18n.getString("editLinks.noEdits"));
                }
                editLinks.run();
            }
        }
        catch (BadArgs badArgs) {
            System.err.println(badArgs.getMessage());
            EditLinks.usage(System.err);
            System.exit(1);
        }
        catch (IOException iOException) {
            System.err.println(iOException);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            System.exit(2);
        }
    }

    private static void usage(PrintStream printStream) {
        int n;
        String string = System.getProperty("program", "java " + (class$com$sun$javatest$EditLinks == null ? (class$com$sun$javatest$EditLinks = EditLinks.class$("com.sun.javatest.EditLinks")) : class$com$sun$javatest$EditLinks).getName());
        String string2 = i18n.getString("editLinks.usage", string);
        int n2 = 0;
        while ((n = string2.indexOf("\n", n2)) != -1) {
            System.err.println(string2.substring(n2, n));
            n2 = n + 1;
        }
        if (n2 < string2.length()) {
            System.err.println(string2.substring(n2));
        }
    }

    public EditLinks() {
    }

    public EditLinks(String[] stringArray) throws BadArgs {
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-e") && i + 2 < stringArray.length) {
                String string = stringArray[++i];
                String string2 = stringArray[++i];
                this.addEdit(string, string2);
                continue;
            }
            if (stringArray[i].equals("-ignore") && i + 2 < stringArray.length) {
                this.ignore(stringArray[++i]);
                continue;
            }
            if (stringArray[i].equals("-o") && i + 1 < stringArray.length) {
                this.outFile = new File(stringArray[++i]);
                continue;
            }
            if (stringArray[i].startsWith("-")) {
                throw new BadArgs(i18n, "editLinks.badOpt", stringArray[i]);
            }
            this.inFiles = new File[stringArray.length - i];
            for (int j = 0; j < this.inFiles.length; ++j) {
                this.inFiles[j] = new File(stringArray[i++]);
            }
        }
        if (this.inFiles == null || this.inFiles.length == 0) {
            throw new BadArgs(i18n, "editLinks.noInput");
        }
        if (this.outFile == null) {
            if (this.inFiles.length == 1) {
                this.outFile = this.inFiles[0];
            } else {
                throw new BadArgs(i18n, "editLinks.noOutput");
            }
        }
    }

    public void addEdit(String string, String string2) {
        String[][] stringArrayArray = new String[this.edits.length + 1][];
        System.arraycopy(this.edits, 0, stringArrayArray, 0, this.edits.length);
        stringArrayArray[this.edits.length] = new String[]{string, string2};
        this.edits = stringArrayArray;
    }

    public void ignore(String string) {
        this.ignores.add(string);
    }

    public void run() throws IOException {
        this.edit(this.inFiles, this.outFile);
    }

    public void edit(File[] fileArray, File file) throws IOException {
        for (int i = 0; i < fileArray.length; ++i) {
            this.edit(fileArray[i], file);
        }
    }

    public void edit(File file, File file2) throws IOException {
        if (!file.exists()) {
            throw new FileNotFoundException(file.getPath());
        }
        if (file.isDirectory()) {
            if (!file2.exists()) {
                if (!file2.mkdir()) {
                    throw new FileNotFoundException(file2.getPath());
                }
            } else if (!file2.isDirectory()) {
                throw new IllegalArgumentException(i18n.getString("editLinks.dirExpected", file2));
            }
            File file3 = file2.getCanonicalFile();
            this.ignores.add(file3);
            String[] stringArray = file.list();
            if (stringArray != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    String string = stringArray[i];
                    File file4 = new File(file, string);
                    File file5 = new File(file2, string);
                    if (this.ignores.contains(string) || this.ignores.contains(file4.getCanonicalFile())) continue;
                    this.edit(file4, file5);
                }
            }
            this.ignores.remove(file3);
        } else {
            if (file2.exists() && file2.isDirectory()) {
                file2 = new File(file2, file.getName());
            }
            if (file.getName().endsWith(".html")) {
                this.in = new BufferedReader(new FileReader(file));
                if (file2.equals(file)) {
                    int n = (int)file.length();
                    char[] cArray = new char[n];
                    for (int i = 0; i < cArray.length; i += this.in.read(cArray, i, cArray.length - i)) {
                    }
                    this.in.close();
                    String string = new String(cArray, 0, cArray.length);
                    this.in = new StringReader(string);
                }
                this.out = new BufferedWriter(new FileWriter(file2));
                this.currFile = file;
                this.line = 1;
                this.edit(this.in, this.out);
                this.in.close();
                this.out.close();
            } else {
                this.copyFile(file, file2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyFile(File file, File file2) throws IOException {
        if (file.equals(file2)) {
            return;
        }
        int n = (int)file.length();
        byte[] byArray = new byte[n];
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
        try {
            for (int i = 0; i < byArray.length; i += ((InputStream)bufferedInputStream).read(byArray, i, byArray.length - i)) {
            }
        }
        finally {
            ((InputStream)bufferedInputStream).close();
        }
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file2));
        try {
            ((OutputStream)bufferedOutputStream).write(byArray, 0, byArray.length);
        }
        finally {
            ((OutputStream)bufferedOutputStream).close();
        }
    }

    private void edit(Reader reader, Writer writer) throws IOException {
        this.copying = false;
        this.nextCh();
        this.copying = true;
        block4: while (this.c >= 0) {
            if (this.c == 60) {
                this.nextCh();
                this.skipSpace();
                switch (this.c) {
                    case 33: {
                        this.nextCh();
                        if (this.c != 45) continue block4;
                        this.nextCh();
                        if (this.c != 45) continue block4;
                        this.nextCh();
                        this.skipComment();
                        continue block4;
                    }
                    case 47: {
                        this.nextCh();
                        this.scanIdentifier();
                        this.skipTag();
                        continue block4;
                    }
                }
                String string = this.scanIdentifier();
                if (string.equals("a")) {
                    this.scanLink();
                    continue;
                }
                this.skipTag();
                continue;
            }
            this.nextCh();
        }
    }

    private void scanLink() throws IOException {
        this.skipSpace();
        while (this.c != 62) {
            String string = this.scanIdentifier();
            if (string.equalsIgnoreCase("href")) {
                this.out.write(61);
                this.copying = false;
                String string2 = this.scanValue();
                this.out.write(34);
                this.out.write(this.edit(string2));
                this.out.write(34);
                this.copying = true;
            } else {
                this.scanValue();
            }
            this.skipSpace();
        }
        this.nextCh();
    }

    private String scanIdentifier() throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        while (true) {
            if (this.c >= 97 && this.c <= 122) {
                stringBuffer.append((char)this.c);
                this.nextCh();
                continue;
            }
            if (this.c >= 65 && this.c <= 90) {
                stringBuffer.append((char)(97 + (this.c - 65)));
                this.nextCh();
                continue;
            }
            if (this.c >= 48 && this.c <= 57) {
                stringBuffer.append((char)this.c);
                this.nextCh();
                continue;
            }
            if (this.c != 45) break;
            stringBuffer.append((char)this.c);
            this.nextCh();
        }
        if (stringBuffer.length() == 0) {
            throw new IOException(i18n.getString("editLinks.idExpected", new Object[]{this.currFile, new Integer(this.line)}));
        }
        return stringBuffer.toString();
    }

    private String scanValue() throws IOException {
        this.skipSpace();
        if (this.c != 61) {
            return "";
        }
        int n = -1;
        this.nextCh();
        this.skipSpace();
        if (this.c == 39 || this.c == 34) {
            n = this.c;
            this.nextCh();
            this.skipSpace();
        }
        StringBuffer stringBuffer = new StringBuffer();
        while (n < 0 && this.c != 32 && this.c != 9 && this.c != 10 && this.c != 13 && this.c != 62 || n >= 0 && this.c != n) {
            if (this.c == -1 || this.c == 10 || this.c == 13) {
                throw new IOException(i18n.getString("editLinks.mismatchQuotes", new Object[]{this.currFile, new Integer(this.line)}));
            }
            stringBuffer.append((char)this.c);
            this.nextCh();
        }
        if (this.c == n) {
            this.nextCh();
        }
        this.skipSpace();
        return stringBuffer.toString();
    }

    private void skipComment() throws IOException {
        int n = 0;
        while (this.c != -1 && (n < 2 || this.c != 62)) {
            n = this.c == 45 ? ++n : 0;
            this.nextCh();
        }
        this.nextCh();
    }

    private void skipSpace() throws IOException {
        while (this.c == 32 || this.c == 9 || this.c == 10 || this.c == 13) {
            this.nextCh();
        }
    }

    private void skipTag() throws IOException {
        this.skipSpace();
        while (this.c != 62) {
            String string = this.scanIdentifier();
            if (string == "") {
                throw new IOException(i18n.getString("editLinks.badHTML", new Object[]{this.currFile, new Integer(this.line)}));
            }
            String string2 = this.scanValue();
            this.skipSpace();
        }
        this.nextCh();
    }

    private void nextCh() throws IOException {
        if (this.copying) {
            this.out.write((char)this.c);
        }
        this.c = this.in.read();
        if (this.c == 10) {
            ++this.line;
        }
    }

    private String edit(String string) {
        for (int i = 0; i < this.edits.length; ++i) {
            String[] stringArray = this.edits[i];
            if (!string.startsWith(stringArray[0])) continue;
            String string2 = stringArray[0];
            String string3 = stringArray[1];
            char c = EditLinks.guessSep(string2);
            char c2 = EditLinks.guessSep(string3);
            String string4 = string.substring(string2.length());
            String string5 = c != '\u0000' && c2 != '\u0000' && c != c2 ? string4.replace(c, c2) : string4;
            return string3 + string5;
        }
        return string;
    }

    private static char guessSep(String string) {
        int n;
        int n2 = string.lastIndexOf(47);
        if (n2 > (n = string.lastIndexOf(92))) {
            return '/';
        }
        if (n > n2) {
            return '\\';
        }
        return '\u0000';
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class BadArgs
    extends Exception {
        BadArgs(I18NResourceBundle i18NResourceBundle, String string) {
            super(i18NResourceBundle.getString(string));
        }

        BadArgs(I18NResourceBundle i18NResourceBundle, String string, Object object) {
            super(i18NResourceBundle.getString(string, object));
        }
    }
}

