/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest;

import com.sun.javatest.TestDescription;
import com.sun.javatest.util.DynamicArray;
import com.sun.javatest.util.I18NResourceBundle;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import java.util.Vector;

public class ExcludeList {
    private Map table = new HashMap();
    private String title;
    private boolean strict;
    private static I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(class$com$sun$javatest$ExcludeList == null ? (class$com$sun$javatest$ExcludeList = ExcludeList.class$("com.sun.javatest.ExcludeList")) : class$com$sun$javatest$ExcludeList);
    public static final String EXCLUDEFILE_EXTN = ".jtx";
    static /* synthetic */ Class class$com$sun$javatest$ExcludeList;

    public static boolean isExcludeFile(File file) {
        return file.getPath().endsWith(EXCLUDEFILE_EXTN);
    }

    public ExcludeList() {
    }

    public ExcludeList(File file) throws FileNotFoundException, IOException, Fault {
        this(file, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExcludeList(File file, boolean bl) throws FileNotFoundException, IOException, Fault {
        this.setStrictModeEnabled(bl);
        if (file != null) {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            Parser parser = new Parser(bufferedReader);
            try {
                Entry entry;
                while ((entry = parser.readEntry()) != null) {
                    this.addEntry(entry);
                }
            }
            finally {
                bufferedReader.close();
            }
            this.title = parser.getTitle();
        }
    }

    public ExcludeList(File[] fileArray) throws FileNotFoundException, IOException, Fault {
        this(fileArray, false);
    }

    public ExcludeList(File[] fileArray, boolean bl) throws FileNotFoundException, IOException, Fault {
        this.setStrictModeEnabled(bl);
        for (int i = 0; i < fileArray.length; ++i) {
            ExcludeList excludeList = new ExcludeList(fileArray[i], bl);
            this.merge(excludeList);
        }
    }

    public void setStrictModeEnabled(boolean bl) {
        this.strict = bl;
    }

    public boolean isStrictModeEnabled() {
        return this.strict;
    }

    public boolean excludesAllOf(TestDescription testDescription) {
        return this.excludesAllOf(testDescription.getRootRelativeURL());
    }

    public boolean excludesAllOf(String string) {
        Object v = this.table.get(new Key(string));
        return v != null && v instanceof Entry && ((Entry)v).testCase == null;
    }

    public boolean excludesAnyOf(TestDescription testDescription) {
        return this.excludesAnyOf(testDescription.getRootRelativeURL());
    }

    public boolean excludesAnyOf(String string) {
        Object v = this.table.get(new Key(string));
        return v != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getTestCases(TestDescription testDescription) {
        Key key = new Key(testDescription.getRootRelativeURL());
        Map map = this.table;
        synchronized (map) {
            Object v = this.table.get(key);
            if (v == null) {
                return null;
            }
            if (v instanceof Entry) {
                Entry entry = (Entry)v;
                if (entry.testCase == null) {
                    return null;
                }
                return new String[]{entry.testCase};
            }
            Entry[] entryArray = (Entry[])v;
            String[] stringArray = new String[entryArray.length];
            for (int i = 0; i < entryArray.length; ++i) {
                stringArray[i] = entryArray[i].testCase;
            }
            return stringArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEntry(Entry entry) throws Fault {
        Map map = this.table;
        synchronized (map) {
            Key key = new Key(entry.relativeURL);
            Object v = this.table.get(key);
            if (v == null) {
                this.table.put(key, entry);
            } else if (v instanceof Entry) {
                Entry entry2 = (Entry)v;
                if (entry2.testCase == null) {
                    if (entry.testCase == null) {
                        this.table.put(key, entry);
                    } else if (this.strict) {
                        throw new Fault(i18n, "excl.cantExcludeCase", entry.relativeURL);
                    }
                } else if (entry.testCase == null) {
                    if (this.strict) {
                        throw new Fault(i18n, "excl.cantExcludeTest", entry.relativeURL);
                    }
                    this.table.put(key, entry);
                } else if (entry2.testCase.equals(entry.testCase)) {
                    this.table.put(key, entry);
                } else {
                    this.table.put(key, new Entry[]{entry2, entry});
                }
            } else if (entry.testCase == null) {
                if (this.strict) {
                    throw new Fault(i18n, "excl.cantExcludeTest", entry.relativeURL);
                }
                this.table.put(key, entry);
            } else {
                Object[] objectArray = (Entry[])v;
                for (int i = 0; i < objectArray.length; ++i) {
                    if (!objectArray[i].testCase.equals(entry.testCase)) continue;
                    objectArray[i] = entry;
                    return;
                }
                this.table.put(key, DynamicArray.append(objectArray, entry));
            }
        }
    }

    public Entry getEntry(String string) {
        int n;
        String string2 = null;
        if (string.endsWith("]") && (n = string.lastIndexOf("[")) != -1) {
            string2 = string.substring(n + 1, string.length() - 1);
            string = string.substring(0, n);
        }
        return this.getEntry(string, string2);
    }

    public Entry getEntry(String string, String string2) {
        Key key = new Key(string);
        Object v = this.table.get(key);
        if (v == null) {
            return null;
        }
        if (v instanceof Entry) {
            Entry entry = (Entry)v;
            if (string2 == null) {
                return entry;
            }
            return ExcludeList.isInList(entry.testCase, string2) ? entry : null;
        }
        Entry[] entryArray = (Entry[])v;
        for (int i = 0; i < entryArray.length; ++i) {
            Entry entry = entryArray[i];
            if (!ExcludeList.isInList(entry.testCase, string2)) continue;
            return entry;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void merge(ExcludeList excludeList) {
        Map map = this.table;
        synchronized (map) {
            Iterator iterator = excludeList.getIterator(false);
            while (iterator.hasNext()) {
                String[] stringArray;
                Entry entry = (Entry)iterator.next();
                Key key = new Key(entry.relativeURL);
                Object v = this.table.get(key);
                if (v == null) {
                    this.table.put(key, entry);
                    continue;
                }
                if (v instanceof Entry) {
                    stringArray = (String[])v;
                    if (((Entry)stringArray).testCase == null || entry.testCase == null) {
                        this.table.put(key, new Entry(((Entry)stringArray).relativeURL, null, ExcludeList.mergeBugIds(((Entry)stringArray).bugIdStrings, entry.bugIdStrings), ExcludeList.mergePlatforms(((Entry)stringArray).platforms, entry.platforms), ExcludeList.mergeSynopsis(((Entry)stringArray).synopsis, entry.synopsis)));
                        continue;
                    }
                    this.table.put(key, new Entry[]{stringArray, entry});
                    continue;
                }
                if (entry.testCase == null) {
                    stringArray = entry.bugIdStrings;
                    String[] stringArray2 = entry.platforms;
                    String string = entry.synopsis;
                    Entry[] entryArray = (Entry[])v;
                    for (int i = 0; i < entryArray.length; ++i) {
                        stringArray = ExcludeList.mergeBugIds(stringArray, entryArray[i].bugIdStrings);
                        stringArray2 = ExcludeList.mergePlatforms(stringArray2, entryArray[i].platforms);
                        string = ExcludeList.mergeSynopsis(string, entryArray[i].synopsis);
                    }
                    this.table.put(key, new Entry(entry.relativeURL, null, stringArray, stringArray2, string));
                    continue;
                }
                this.table.put(key, (Entry[])DynamicArray.append((Entry[])v, entry));
            }
        }
    }

    private static String[] mergeBugIds(String[] stringArray, String[] stringArray2) {
        return ExcludeList.merge(stringArray, stringArray2);
    }

    private static String[] mergePlatforms(String[] stringArray, String[] stringArray2) {
        return ExcludeList.merge(stringArray, stringArray2);
    }

    private static String[] merge(String[] stringArray, String[] stringArray2) {
        TreeSet<String> treeSet = new TreeSet<String>();
        treeSet.addAll(Arrays.asList(stringArray));
        treeSet.addAll(Arrays.asList(stringArray2));
        return treeSet.toArray(new String[treeSet.size()]);
    }

    private static String mergeSynopsis(String string, String string2) {
        if (string == null || string.trim().length() == 0) {
            return string2;
        }
        if (string2 == null || string2.trim().length() == 0) {
            return string;
        }
        if (string.indexOf(string2) != -1) {
            return string;
        }
        if (string2.indexOf(string) != -1) {
            return string2;
        }
        return string + "; " + string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEntry(Entry entry) {
        Map map = this.table;
        synchronized (map) {
            Key key = new Key(entry.relativeURL);
            Object v = this.table.get(key);
            if (v == null) {
                return;
            }
            if (v instanceof Entry) {
                if (v == entry) {
                    this.table.remove(key);
                }
            } else {
                Entry[] entryArray = (Entry[])DynamicArray.remove((Object[])((Entry[])v), entry);
                if (entryArray == v) {
                    return;
                }
                if (entryArray.length == 1) {
                    this.table.put(key, entryArray[0]);
                } else {
                    this.table.put(key, entryArray);
                }
            }
        }
    }

    public boolean isEmpty() {
        return this.table.isEmpty();
    }

    public int size() {
        int n = 0;
        Iterator iterator = this.table.values().iterator();
        while (iterator.hasNext()) {
            Object v = iterator.next();
            if (v instanceof Entry[]) {
                n += ((Entry[])v).length;
                continue;
            }
            ++n;
        }
        return n;
    }

    public Iterator getIterator(boolean bl) {
        if (bl) {
            return this.table.values().iterator();
        }
        Vector<Object> vector = new Vector<Object>(this.table.size());
        Iterator iterator = this.table.values().iterator();
        while (iterator.hasNext()) {
            Object v = iterator.next();
            if (v instanceof Entry) {
                vector.addElement(v);
                continue;
            }
            Entry[] entryArray = (Entry[])v;
            for (int i = 0; i < entryArray.length; ++i) {
                vector.addElement(entryArray[i]);
            }
        }
        return vector.iterator();
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public void write(File file) throws IOException {
        Object object;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        TreeSet<Entry> treeSet = new TreeSet<Entry>();
        Object object2 = this.getIterator(false);
        while (object2.hasNext()) {
            object = (Entry)object2.next();
            treeSet.add((Entry)object);
            n = ((Entry)object).testCase == null ? Math.max(((Entry)object).relativeURL.length(), n) : Math.max(((Entry)object).relativeURL.length() + ((Entry)object).testCase.length() + 2, n);
            n2 = Math.max(this.bugIdsToString((Entry)object).length(), n2);
            n3 = Math.max(this.platformsToString((Entry)object).length(), n3);
        }
        object2 = new BufferedWriter(new FileWriter(file));
        ((Writer)object2).write("# Exclude List");
        ((BufferedWriter)object2).newLine();
        ((Writer)object2).write("# SCCS %W% %E%");
        ((BufferedWriter)object2).newLine();
        if (this.title != null) {
            ((Writer)object2).write("### title " + this.title);
            ((BufferedWriter)object2).newLine();
        }
        object = treeSet.iterator();
        while (object.hasNext()) {
            Entry entry = (Entry)object.next();
            if (entry.testCase == null) {
                this.write((Writer)object2, entry.relativeURL, n + 2);
            } else {
                this.write((Writer)object2, entry.relativeURL + "[" + entry.testCase + "]", n + 2);
            }
            this.write((Writer)object2, this.bugIdsToString(entry), n2 + 2);
            this.write((Writer)object2, this.platformsToString(entry), n3 + 2);
            ((Writer)object2).write(entry.synopsis);
            ((BufferedWriter)object2).newLine();
        }
        ((BufferedWriter)object2).close();
    }

    private void write(Writer writer, String string, int n) throws IOException {
        writer.write(string);
        for (int i = string.length(); i < n; ++i) {
            writer.write(32);
        }
    }

    private String bugIdsToString(Entry entry) {
        StringBuffer stringBuffer = new StringBuffer(entry.bugIdStrings.length * 10);
        stringBuffer.append(entry.bugIdStrings[0]);
        for (int i = 1; i < entry.bugIdStrings.length; ++i) {
            stringBuffer.append(',');
            stringBuffer.append(entry.bugIdStrings[i]);
        }
        return stringBuffer.toString();
    }

    private String platformsToString(Entry entry) {
        StringBuffer stringBuffer = new StringBuffer(entry.platforms.length * 10);
        stringBuffer.append(entry.platforms[0]);
        for (int i = 1; i < entry.platforms.length; ++i) {
            stringBuffer.append(',');
            stringBuffer.append(entry.platforms[i]);
        }
        return stringBuffer.toString();
    }

    private static boolean equals(String string, String string2) {
        return string == null && string2 == null || string != null && string2 != null && string.equals(string2);
    }

    private static boolean isInList(String string, String string2) {
        if (string == null || string2 == null) {
            return false;
        }
        int n = string.indexOf(string2);
        while (n != -1) {
            if (!(n != 0 && string.charAt(n - 1) != ',' || n + string2.length() != string.length() && string.charAt(n + string2.length()) != ',')) {
                return true;
            }
            n = string.indexOf(string2, n + 1);
        }
        return false;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static final class Entry
    implements Comparable {
        private String relativeURL;
        private String testCase;
        private String[] bugIdStrings;
        private int[] bugIds;
        private String[] platforms;
        private String synopsis;

        public Entry(String string, String string2, String[] stringArray, String[] stringArray2, String string3) {
            if (stringArray == null || stringArray2 == null) {
                throw new NullPointerException();
            }
            if (stringArray.length == 0 && stringArray2.length > 0) {
                throw new IllegalArgumentException();
            }
            this.relativeURL = string;
            this.testCase = string2;
            this.bugIdStrings = stringArray;
            this.platforms = stringArray2;
            this.synopsis = string3;
        }

        public Entry(String string, String string2, int[] nArray, String[] stringArray, String string3) {
            if (nArray == null || stringArray == null) {
                throw new NullPointerException();
            }
            if (nArray.length == 0 && stringArray.length > 0) {
                throw new IllegalArgumentException();
            }
            this.relativeURL = string;
            this.testCase = string2;
            this.bugIdStrings = new String[nArray.length];
            for (int i = 0; i < nArray.length; ++i) {
                this.bugIdStrings[i] = String.valueOf(nArray[i]);
            }
            this.bugIds = nArray;
            this.platforms = stringArray;
            this.synopsis = string3;
        }

        public int compareTo(Object object) {
            Entry entry = (Entry)object;
            int n = this.relativeURL.compareTo(entry.relativeURL);
            if (n == 0) {
                if (this.testCase == null && entry.testCase == null) {
                    return 0;
                }
                if (this.testCase == null) {
                    return -1;
                }
                if (entry.testCase == null) {
                    return 1;
                }
                return this.testCase.compareTo(entry.testCase);
            }
            return n;
        }

        public String getRelativeURL() {
            return this.relativeURL;
        }

        public String getTestCases() {
            return this.testCase;
        }

        public String[] getTestCaseList() {
            if (this.testCase == null) {
                return null;
            }
            Vector<String> vector = new Vector<String>();
            int n = -1;
            for (int i = 0; i < this.testCase.length(); ++i) {
                if (this.testCase.charAt(i) == ',') {
                    if (n != -1) {
                        vector.addElement(this.testCase.substring(n, i));
                    }
                    n = -1;
                    continue;
                }
                if (n != -1) continue;
                n = i;
            }
            if (n != -1) {
                vector.addElement(this.testCase.substring(n));
            }
            if (vector.size() == 0) {
                return null;
            }
            Object[] objectArray = new String[vector.size()];
            vector.copyInto(objectArray);
            return objectArray;
        }

        public int[] getBugIds() {
            if (this.bugIds == null) {
                this.bugIds = new int[this.bugIdStrings.length];
                for (int i = 0; i < this.bugIds.length; ++i) {
                    try {
                        this.bugIds[i] = Integer.parseInt(this.bugIdStrings[i]);
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.bugIds[i] = -1;
                    }
                }
            }
            return this.bugIds;
        }

        public String[] getBugIdStrings() {
            return this.bugIdStrings;
        }

        public String[] getPlatforms() {
            return this.platforms;
        }

        public String getSynopsis() {
            return this.synopsis;
        }

        public static Entry read(String string) throws Fault {
            try {
                return new Parser(new StringReader(string)).readEntry();
            }
            catch (IOException iOException) {
                throw new Fault(i18n, "excl.badEntry", iOException);
            }
        }

        public boolean equals(Object object) {
            if (object instanceof Entry) {
                Entry entry = (Entry)object;
                return Entry.equals(this.relativeURL, entry.relativeURL) && Entry.equals(this.testCase, entry.testCase) && Entry.equals(this.bugIdStrings, entry.bugIdStrings) && Entry.equals(this.platforms, entry.platforms) && Entry.equals(this.synopsis, entry.synopsis);
            }
            return false;
        }

        public int hashCode() {
            return this.relativeURL.hashCode();
        }

        public String toString() {
            int n;
            StringBuffer stringBuffer = new StringBuffer(64);
            stringBuffer.append(this.relativeURL);
            if (this.testCase != null) {
                stringBuffer.append('[');
                stringBuffer.append(this.testCase);
                stringBuffer.append(']');
            }
            if (this.bugIdStrings != null) {
                for (n = 0; n < this.bugIdStrings.length; ++n) {
                    stringBuffer.append(n == 0 ? (char)' ' : ',');
                    stringBuffer.append(this.bugIdStrings[n]);
                }
            }
            if (this.platforms != null) {
                for (n = 0; n < this.platforms.length; ++n) {
                    stringBuffer.append(n == 0 ? (char)' ' : ',');
                    stringBuffer.append(this.platforms[n]);
                }
            }
            if (this.synopsis != null) {
                stringBuffer.append(' ');
                stringBuffer.append(this.synopsis);
            }
            return new String(stringBuffer);
        }

        private static boolean equals(int[] nArray, int[] nArray2) {
            if (nArray == null || nArray2 == null) {
                return nArray == null && nArray2 == null;
            }
            if (nArray.length != nArray2.length) {
                return false;
            }
            for (int i = 0; i < nArray.length; ++i) {
                if (nArray[i] == nArray2[i]) continue;
                return false;
            }
            return true;
        }

        private static boolean equals(String[] stringArray, String[] stringArray2) {
            if (stringArray == null || stringArray2 == null) {
                return stringArray == null && stringArray2 == null;
            }
            if (stringArray.length != stringArray2.length) {
                return false;
            }
            for (int i = 0; i < stringArray.length; ++i) {
                if (Entry.equals(stringArray[i], stringArray2[i])) continue;
                return false;
            }
            return true;
        }

        private static boolean equals(String string, String string2) {
            return string == null && string2 == null || string != null && string2 != null && string.equals(string2);
        }
    }

    private static class Key {
        private static final char sep = File.separatorChar;
        private String relativeURL;
        private int hash;

        Key(String string) {
            this.relativeURL = string;
        }

        public int hashCode() {
            int n = this.hash;
            if (n == 0) {
                int n2 = this.relativeURL.length();
                for (int i = 0; i < n2; ++i) {
                    char c = Character.toLowerCase(this.relativeURL.charAt(i));
                    if (c == sep) {
                        c = '/';
                    }
                    n = 31 * n + c;
                }
                this.hash = n;
            }
            return n;
        }

        public boolean equals(Object object) {
            if (object == null || !(object instanceof Key)) {
                return false;
            }
            String string = this.relativeURL;
            String string2 = ((Key)object).relativeURL;
            int n = string.length();
            if (n != string2.length()) {
                return false;
            }
            for (int i = 0; i < n; ++i) {
                char c;
                char c2 = Character.toLowerCase(string.charAt(i));
                if (c2 == sep) {
                    c2 = '/';
                }
                if ((c = Character.toLowerCase(string2.charAt(i))) == sep) {
                    c = '/';
                }
                if (c2 == c) continue;
                return false;
            }
            return true;
        }
    }

    private static final class Parser {
        private Reader in;
        private int ch;
        private Map platformCache = new HashMap();
        private String title;

        Parser(Reader reader) throws IOException {
            this.in = reader;
            this.ch = reader.read();
        }

        String getTitle() {
            return this.title;
        }

        Entry readEntry() throws IOException, Fault {
            int n;
            String string = this.readURL();
            if (string == null) {
                return null;
            }
            String string2 = null;
            if (string.endsWith("]") && (n = string.lastIndexOf("[")) != -1) {
                string2 = string.substring(n + 1, string.length() - 1);
                string = string.substring(0, n);
            }
            String[] stringArray = this.readBugIds();
            String[] stringArray2 = this.readPlatforms();
            String string3 = this.readRest();
            return new Entry(string, string2, stringArray, stringArray2, string3);
        }

        private boolean isEndOfLine(int n) {
            return n == -1 || n == 10 || n == 13;
        }

        private boolean isWhitespace(int n) {
            return n == 32 || n == 9;
        }

        private String readURL() throws IOException, Fault {
            block5: while (true) {
                this.skipWhite();
                switch (this.ch) {
                    case -1: {
                        return null;
                    }
                    case 35: {
                        this.skipComment();
                        continue block5;
                    }
                    case 10: 
                    case 13: {
                        this.ch = this.in.read();
                        continue block5;
                    }
                }
                break;
            }
            return this.readWord();
        }

        private String[] readBugIds() throws IOException {
            this.skipWhite();
            TreeSet<String> treeSet = new TreeSet<String>();
            StringBuffer stringBuffer = new StringBuffer();
            while (!this.isEndOfLine(this.ch) && !this.isWhitespace(this.ch)) {
                if (this.ch == 44) {
                    if (stringBuffer.length() > 0) {
                        treeSet.add(stringBuffer.toString());
                        stringBuffer.setLength(0);
                    }
                } else {
                    stringBuffer.append((char)this.ch);
                }
                this.ch = this.in.read();
            }
            if (stringBuffer.length() > 0) {
                treeSet.add(stringBuffer.toString());
            }
            if (treeSet.size() == 0) {
                treeSet.add("0");
            }
            return treeSet.toArray(new String[treeSet.size()]);
        }

        private String[] readPlatforms() throws IOException {
            this.skipWhite();
            String string = this.readWord();
            String[] stringArray = (String[])this.platformCache.get(string);
            if (stringArray == null) {
                int n = 0;
                for (int i = 0; i < string.length(); ++i) {
                    if (string.charAt(i) != ',') continue;
                    ++n;
                }
                TreeSet<String> treeSet = new TreeSet<String>();
                int n2 = 0;
                int n3 = string.indexOf(44);
                while (n3 != -1) {
                    treeSet.add(string.substring(n2, n3));
                    n2 = n3 + 1;
                    n3 = string.indexOf(44, n2);
                }
                treeSet.add(string.substring(n2));
                stringArray = treeSet.toArray(new String[treeSet.size()]);
                this.platformCache.put(string, stringArray);
            }
            return stringArray;
        }

        private String readRest() throws IOException {
            this.skipWhite();
            StringBuffer stringBuffer = new StringBuffer(80);
            while (!this.isEndOfLine(this.ch)) {
                stringBuffer.append((char)this.ch);
                this.ch = this.in.read();
            }
            this.ch = this.in.read();
            return stringBuffer.toString();
        }

        private String readWord() throws IOException {
            StringBuffer stringBuffer = new StringBuffer(32);
            while (!this.isEndOfLine(this.ch) && !this.isWhitespace(this.ch)) {
                stringBuffer.append((char)this.ch);
                this.ch = this.in.read();
            }
            return stringBuffer.toString();
        }

        private void skipComment() throws IOException, Fault {
            this.ch = this.in.read();
            if (this.ch == 35) {
                this.ch = this.in.read();
                if (this.ch == 35) {
                    this.ch = this.in.read();
                    this.skipWhite();
                    String string = this.readWord();
                    if (string.equals("title")) {
                        this.skipWhite();
                        this.title = this.readRest();
                        return;
                    }
                }
            }
            while (!this.isEndOfLine(this.ch)) {
                this.ch = this.in.read();
            }
        }

        private void skipWhite() throws IOException {
            while (this.ch != -1 && this.isWhitespace(this.ch)) {
                this.ch = this.in.read();
            }
        }
    }

    public static class Fault
    extends Exception {
        Fault(I18NResourceBundle i18NResourceBundle, String string, Object object) {
            super(i18NResourceBundle.getString(string, object));
        }
    }
}

