/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest;

import com.sun.javatest.WorkDirectory;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Date;
import java.util.Properties;

public class LastRunInfo {
    private String configName;
    private long startTime;
    private long finishTime;
    private static final String FILENAME = "lastRun.txt";
    private static final String START = "startTime";
    private static final String FINISH = "finishTime";
    private static final String CONFIG = "configName";

    private LastRunInfo() {
    }

    private LastRunInfo(WorkDirectory workDirectory) throws IOException {
        this();
        FileInputStream fileInputStream = new FileInputStream(workDirectory.getSystemFile(FILENAME));
        Properties properties = new Properties();
        properties.load(fileInputStream);
        String string = properties.getProperty(START);
        try {
            this.startTime = Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        string = properties.getProperty(FINISH);
        try {
            this.finishTime = Long.parseLong(string);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.configName = properties.getProperty(CONFIG);
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getFinishTime() {
        return this.finishTime;
    }

    public Date getStartDate() {
        return new Date(this.startTime);
    }

    public Date getFinishDate() {
        return new Date(this.finishTime);
    }

    public String getConfigName() {
        return this.configName;
    }

    public static LastRunInfo readInfo(WorkDirectory workDirectory) throws IOException {
        return new LastRunInfo(workDirectory);
    }

    public static void writeInfo(WorkDirectory workDirectory, long l, long l2, String string) throws IOException {
        Properties properties = new Properties();
        properties.setProperty(CONFIG, string);
        properties.setProperty(START, Long.toString(l));
        properties.setProperty(FINISH, Long.toString(l2));
        FileOutputStream fileOutputStream = new FileOutputStream(workDirectory.getSystemFile(FILENAME));
        properties.store(fileOutputStream, "Last test run info");
    }
}

