/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest;

import com.sun.javatest.TestDescription;
import com.sun.javatest.TestEnvironment;
import com.sun.javatest.TestFilter;
import com.sun.javatest.util.I18NResourceBundle;
import com.sun.javatest.util.StringArray;
import java.io.File;
import java.text.Collator;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;

public abstract class TestFinder {
    private Map keywordCache = new HashMap();
    private static final TestDescription[] noTests = new TestDescription[0];
    private File root;
    private File rootDir;
    protected TestEnvironment env;
    private ErrorHandler errHandler;
    private Comparator comp = this.getDefaultComparator();
    private Vector files;
    private Vector tests;
    private Map testsInFile = new HashMap();
    private Vector errorMessages = new Vector();
    protected static boolean debug = Boolean.getBoolean("debug." + (class$com$sun$javatest$TestFinder == null ? (class$com$sun$javatest$TestFinder = TestFinder.class$("com.sun.javatest.TestFinder")) : class$com$sun$javatest$TestFinder).getName());
    private static final File userDir = new File(System.getProperty("user.dir"));
    private static I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(class$com$sun$javatest$TestFinder == null ? (class$com$sun$javatest$TestFinder = TestFinder.class$("com.sun.javatest.TestFinder")) : class$com$sun$javatest$TestFinder);
    static /* synthetic */ Class class$com$sun$javatest$TestFinder;

    public void init(String[] stringArray, File file, TestEnvironment testEnvironment) throws Fault {
        if (stringArray != null) {
            this.decodeAllArgs(stringArray);
        }
        this.setRoot(file);
        this.env = testEnvironment;
    }

    public void init(String[] stringArray, File file, File[] fileArray, TestFilter[] testFilterArray, TestEnvironment testEnvironment) throws Fault {
        this.init(stringArray, file, testEnvironment);
    }

    protected void decodeAllArgs(String[] stringArray) throws Fault {
        int n;
        for (int i = 0; i < stringArray.length; i += n) {
            n = this.decodeArg(stringArray, i);
            if (n != 0) continue;
            throw new Fault(i18n, "finder.badArg", stringArray[i]);
        }
    }

    protected int decodeArg(String[] stringArray, int n) throws Fault {
        return 0;
    }

    protected void setRoot(File file) throws IllegalStateException, Fault {
        if (this.root != null) {
            throw new IllegalStateException("root already set");
        }
        this.root = file.isAbsolute() ? file : new File(userDir, file.getPath());
        this.rootDir = this.root.isDirectory() ? this.root : new File(this.root.getParent());
    }

    public File getRoot() {
        return this.root;
    }

    public File getRootDir() {
        return this.rootDir;
    }

    public void setComparator(Comparator comparator) {
        if (comparator != null) {
            this.comp = comparator;
        }
    }

    public Comparator getComparator() {
        return this.comp;
    }

    protected Comparator getDefaultComparator() {
        Collator collator = Collator.getInstance(Locale.US);
        collator.setStrength(0);
        return collator;
    }

    public ErrorHandler getErrorHandler() {
        return this.errHandler;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errHandler = errorHandler;
    }

    protected void error(I18NResourceBundle i18NResourceBundle, String string) {
        this.localizedError(i18NResourceBundle.getString(string));
    }

    protected void error(I18NResourceBundle i18NResourceBundle, String string, Object object) {
        this.localizedError(i18NResourceBundle.getString(string, object));
    }

    protected void error(I18NResourceBundle i18NResourceBundle, String string, Object[] objectArray) {
        this.localizedError(i18NResourceBundle.getString(string, objectArray));
    }

    protected void localizedError(String string) {
        this.errorMessages.add(string);
        if (this.errHandler != null) {
            this.errHandler.error(string);
        }
    }

    public synchronized int getErrorCount() {
        return this.errorMessages.size();
    }

    public synchronized String[] getErrors() {
        Object[] objectArray = new String[this.errorMessages.size()];
        this.errorMessages.copyInto(objectArray);
        return objectArray;
    }

    public synchronized void clearErrors() {
        this.errorMessages.setSize(0);
    }

    public synchronized void read(File file) {
        if (this.tests != null) {
            this.tests.setSize(0);
        }
        if (this.files != null) {
            this.files.setSize(0);
        }
        this.testsInFile.clear();
        this.scan(file.isAbsolute() ? file : new File(this.rootDir, file.getPath()));
    }

    protected abstract void scan(File var1);

    protected void processEntry(Map map, String string, String string2) {
        if ((string = string.intern()).equalsIgnoreCase("keywords")) {
            String string3 = (String)this.keywordCache.get(string2);
            if (string3 == null) {
                String string4 = string2.toLowerCase();
                Object[] objectArray = StringArray.split(string4);
                Arrays.sort(objectArray);
                string3 = StringArray.join((String[])objectArray).intern();
                this.keywordCache.put(string2, string3);
            }
            string2 = string3;
        } else {
            string2 = string2.intern();
        }
        map.put(string, string2);
    }

    protected Map normalize(Map map) {
        return map;
    }

    protected void foundTestDescription(Map map, File file, int n) {
        String string;
        Integer n2;
        Object object;
        map = this.normalize(map);
        if (debug) {
            System.err.println("Found TestDescription");
            System.err.println("--------values----------------------------");
            object = map.keySet().iterator();
            while (object.hasNext()) {
                n2 = object.next();
                System.err.println(">> " + n2 + ": " + map.get(n2));
            }
            System.err.println("------------------------------------------");
        }
        if ((object = (String)map.get("id")) == null) {
            object = "";
        }
        if ((n2 = (Integer)this.testsInFile.get(object)) != null) {
            int n3 = 1;
            while (this.testsInFile.get(string = (String)object + "__" + n3) != null) {
                ++n3;
            }
            this.error(i18n, "finder.nonUniqueId", new Object[]{file, ((String)object).equals("") ? "(unset)" : object, new Integer(n), n2, string});
            object = string;
            map.put("id", object);
        }
        this.testsInFile.put(object, new Integer(n));
        TestDescription testDescription = new TestDescription(this.root, file, map);
        if (this.errHandler != null && (string = testDescription.getRootRelativeURL()).indexOf(32) != -1) {
            this.error(i18n, "finder.spaceInId", testDescription.getRootRelativeURL());
        }
        this.foundTestDescription(testDescription);
    }

    protected void foundTestDescription(TestDescription testDescription) {
        if (this.tests == null) {
            this.tests = new Vector();
        }
        int n = 0;
        if (this.tests.size() == 0) {
            n = 0;
        } else {
            int n2 = 0;
            int n3 = this.tests.size() - 1;
            int n4 = 0;
            String string = testDescription.getName();
            while (n2 < n3) {
                n4 = (n3 + n2) / 2;
                int n5 = this.comp.compare(string, ((TestDescription)this.tests.get(n4)).getName());
                if (n5 < 0) {
                    n3 = n4;
                    continue;
                }
                if (n5 < 0) continue;
                n2 = n4 + 1;
            }
            n = this.comp.compare(string, ((TestDescription)this.tests.get(n2)).getName()) > 0 ? n2 + 1 : n2;
        }
        this.tests.insertElementAt(testDescription, n);
    }

    public TestDescription[] getTests() {
        if (this.tests == null) {
            return noTests;
        }
        Object[] objectArray = new TestDescription[this.tests.size()];
        this.tests.copyInto(objectArray);
        return objectArray;
    }

    protected void foundFile(File file) {
        if (this.files == null) {
            this.files = new Vector();
        }
        int n = 0;
        if (this.files.size() == 0) {
            n = 0;
        } else {
            int n2 = 0;
            int n3 = this.files.size() - 1;
            int n4 = 0;
            String string = file.getPath();
            while (n2 < n3) {
                n4 = (n3 + n2) / 2;
                int n5 = this.comp.compare(string, ((File)this.files.get(n4)).getPath());
                if (n5 < 0) {
                    n3 = n4;
                    continue;
                }
                if (n5 < 0) continue;
                n2 = n4 + 1;
            }
            n = this.comp.compare(string, ((File)this.files.get(n2)).getPath()) > 0 ? n2 + 1 : n2;
        }
        this.files.insertElementAt(file, n);
    }

    public File[] getFiles() {
        if (this.files == null) {
            return new File[0];
        }
        Object[] objectArray = new File[this.files.size()];
        this.files.copyInto(objectArray);
        return objectArray;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static interface ErrorHandler {
        public void error(String var1);
    }

    public static class Fault
    extends Exception {
        public Fault(I18NResourceBundle i18NResourceBundle, String string) {
            super(i18NResourceBundle.getString(string));
        }

        public Fault(I18NResourceBundle i18NResourceBundle, String string, Object object) {
            super(i18NResourceBundle.getString(string, object));
        }

        public Fault(I18NResourceBundle i18NResourceBundle, String string, Object[] objectArray) {
            super(i18NResourceBundle.getString(string, objectArray));
        }
    }
}

