/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest;

import com.sun.javatest.Status;
import com.sun.javatest.TestResult;
import com.sun.javatest.WorkDirectory;
import com.sun.javatest.util.Debug;
import com.sun.javatest.util.Fifo;
import com.sun.javatest.util.I18NResourceBundle;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

public class TestResultCache {
    private static final int DEFAULT_COMPRESS_PERCENT_LEVEL = 40;
    private static final int MIN_TEST_READ_INTERVAL = 10000;
    private static final int MIN_TEST_WRITE_INTERVAL = 10000;
    private static final int MAX_SHUTDOWN_TIME = 30000;
    private static final long INITIAL_LOCK_NOTIFY_TIME = 20000L;
    private static final long LOCK_NOTIFY_INTERVAL = 60000L;
    private static final long MAX_LOCK_WAIT_TIME = Integer.getInteger("javatest.trc.timeout", 5) * 60000;
    private static final int INITIAL_RETRY_DELAY_TIME = 500;
    private static final int MAX_RETRY_DELAY_TIME = 10000;
    private Observer observer;
    private WeakReference weakObserver;
    private WorkDirectory workDir;
    private WeakReference weakWorkDir;
    private File cacheFile;
    private File lockFile;
    private Thread worker;
    private Thread shutdownHandler;
    private RandomAccessFile raf;
    private int uniqueInitialEntryCount;
    private int totalEntryCount;
    private int lastSerial;
    private long lastFileSize;
    private boolean updateNeeded;
    private boolean fullUpdateRequested;
    private boolean compressNeeded;
    private boolean compressRequested;
    private boolean flushRequested;
    private boolean shutdownRequested;
    private Fifo testsToWrite = new Fifo();
    private static final String V1_FILENAME = "ResultCache.jtw";
    private static final String V1_LOCKNAME = "ResultCache.jtw.lck";
    private static final String V2_FILENAME = "ResultCache2.jtw";
    private static final String V2_LOCKNAME = "ResultCache2.jtw.lck";
    private static I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(class$com$sun$javatest$TestResultCache == null ? (class$com$sun$javatest$TestResultCache = TestResultCache.class$("com.sun.javatest.TestResultCache")) : class$com$sun$javatest$TestResultCache);
    private static int workerNumber;
    private static int debug;
    private static final boolean DEBUG_BASIC;
    private static final boolean DEBUG_TESTS;
    private static final boolean DEBUG_WORK;
    private static final boolean DEBUG_CHECK_WORK;
    private static final boolean DEBUG_SYNC;
    static /* synthetic */ Class class$com$sun$javatest$TestResultCache;

    public TestResultCache(WorkDirectory workDirectory, Observer observer) throws IOException {
        this.workDir = workDirectory;
        this.observer = observer;
        this.weakWorkDir = new WeakReference<WorkDirectory>(workDirectory);
        this.weakObserver = new WeakReference<Observer>(observer);
        this.cacheFile = workDirectory.getSystemFile(V2_FILENAME);
        this.lockFile = workDirectory.getSystemFile(V2_LOCKNAME);
        File file = workDirectory.getSystemFile(V1_FILENAME);
        if (file.exists()) {
            workDirectory.log(i18n, "trc.rmCachev1", file.getAbsolutePath());
            file.delete();
        }
        if ((file = workDirectory.getSystemFile(V1_LOCKNAME)).exists()) {
            workDirectory.log(i18n, "trc.rmLockv1", file.getAbsolutePath());
            file.delete();
        }
        this.raf = new RandomAccessFile(this.cacheFile, "rw");
        this.worker = new Thread(){

            public void run() {
                TestResultCache.this.doWorkUntilDone();
            }
        };
        this.worker.setName("TestResultCache.worker" + workerNumber++ + "[" + workDirectory.getRoot() + "]");
        this.worker.setDaemon(true);
        int n = Math.max(0, Math.min(Thread.currentThread().getPriority() - 1, 3));
        this.worker.setPriority(n);
        this.worker.start();
        this.shutdownHandler = new Thread(){

            public void run() {
                TestResultCache.this.shutdown();
            }
        };
        Runtime.getRuntime().addShutdownHook(this.shutdownHandler);
    }

    synchronized void insert(TestResult testResult) {
        if (DEBUG_TESTS) {
            Debug.println("TRC.insert " + testResult.getWorkRelativePath() + " " + testResult.getStatus());
        }
        this.reviveWeakReferences();
        this.testsToWrite.insert(testResult);
        this.notifyAll();
    }

    synchronized void requestFullUpdate() {
        if (!this.shutdownRequested) {
            this.reviveWeakReferences();
            this.fullUpdateRequested = true;
            this.notifyAll();
        }
    }

    synchronized boolean needsCompress() {
        return this.compressNeeded;
    }

    synchronized void compress() {
        if (!this.shutdownRequested) {
            this.reviveWeakReferences();
            this.compressRequested = true;
            this.notifyAll();
        }
    }

    synchronized void flush() {
        this.reviveWeakReferences();
        this.flushRequested = true;
        this.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void doWorkUntilDone() {
        var1_1 = Integer.getInteger("javatest.trc.cacheThreshold", 40);
        var1_1 = Math.max(1, Math.min(var1_1, 100));
        var2_2 = true;
        this.fullUpdateRequested = true;
        try {
            block30: {
                block26: {
                    block29: {
                        block25: {
                            try {
                                while (var2_2) {
                                    this.doWork();
                                    var3_3 = this;
                                    synchronized (var3_3) {
                                        if (this.flushRequested && this.testsToWrite.size() == 0) {
                                            this.flushRequested = false;
                                        }
                                        var4_6 = System.currentTimeMillis();
                                        var2_2 = this.isWorkAvailable(var4_6);
                                        while (!var2_2 && !this.shutdownRequested) {
                                            this.workDir = null;
                                            this.observer = null;
                                            if (TestResultCache.DEBUG_SYNC) {
                                                Debug.println("TRC.worker waiting");
                                            }
                                            this.wait(10000L);
                                            var2_2 = this.isWorkAvailable(var4_6);
                                            if (!TestResultCache.DEBUG_SYNC) continue;
                                            Debug.println("TRC.worker awake haveWork=" + var2_2);
                                        }
                                        this.reviveWeakReferences();
                                        if (this.workDir == null || this.observer == null) {
                                            // MONITOREXIT @DISABLED, blocks:[0, 1, 20, 6, 24] lbl27 : MonitorExitStatement: MONITOREXIT : var3_3
                                            var9_8 = null;
                                            break block25;
                                        }
                                        this.compressNeeded = this.totalEntryCount == 0 ? false : (var6_7 = this.totalEntryCount - this.uniqueInitialEntryCount) * 100 / this.totalEntryCount > var1_1;
                                    }
                                }
                                break block26;
                            }
                            catch (IOException var3_4) {
                                this.observer.error(var3_4);
                                var9_10 = null;
                                try {
                                    this.raf.close();
                                }
                                catch (IOException var10_15) {
                                    // empty catch block
                                }
                                var10_15 = this;
                                synchronized (var10_15) {
                                    this.worker = null;
                                    this.notifyAll();
                                    return;
                                }
                            }
                            catch (InterruptedException var3_5) {
                                block28: {
                                    var9_11 = null;
                                    ** try [egrp 4[TRYBLOCK] [12 : 277->287)] { 
lbl53:
                                    // 1 sources

                                    this.raf.close();
                                    break block28;
lbl55:
                                    // 1 sources

                                    catch (IOException var10_16) {
                                        // empty catch block
                                    }
                                }
                                var10_16 = this;
                                synchronized (var10_16) {
                                    this.worker = null;
                                    this.notifyAll();
                                    return;
                                }
                            }
                        }
                        ** try [egrp 4[TRYBLOCK] [12 : 277->287)] { 
lbl65:
                        // 1 sources

                        this.raf.close();
                        break block29;
lbl67:
                        // 1 sources

                        catch (IOException var10_13) {
                            // empty catch block
                        }
                    }
                    var10_13 = this;
                    synchronized (var10_13) {
                        this.worker = null;
                        this.notifyAll();
                        return;
                    }
                }
                var9_9 = null;
                ** try [egrp 4[TRYBLOCK] [12 : 277->287)] { 
lbl78:
                // 1 sources

                this.raf.close();
                break block30;
lbl80:
                // 1 sources

                catch (IOException var10_14) {
                    // empty catch block
                }
            }
            var10_14 = this;
            synchronized (var10_14) {
                this.worker = null;
                this.notifyAll();
                return;
            }
        }
        catch (Throwable var8_18) {
            block31: {
                var9_12 = null;
                ** try [egrp 4[TRYBLOCK] [12 : 277->287)] { 
lbl92:
                // 1 sources

                this.raf.close();
                break block31;
lbl94:
                // 1 sources

                catch (IOException var10_17) {
                    // empty catch block
                }
            }
            var10_17 = this;
            synchronized (var10_17) {
                this.worker = null;
                this.notifyAll();
                throw var8_18;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doWork() throws IOException {
        Map map = null;
        boolean bl = false;
        this.getLock();
        try {
            try {
                if (this.raf.length() > 0L) {
                    map = this.readCache();
                    if (map == null) {
                        bl = true;
                    }
                } else {
                    bl = true;
                }
            }
            catch (Throwable throwable) {
                if (DEBUG_BASIC) {
                    Debug.println("TRC.corrupt " + throwable);
                }
                this.workDir.log(i18n, "trc.reloadFault", throwable);
                bl = true;
                this.raf.setLength(0L);
            }
            if (bl && this.shutdownRequested) {
                this.testsToWrite.flush();
                this.raf.setLength(0L);
                return;
            }
            if (bl) {
                this.observer.buildingCache(bl);
                map = this.readJTRFiles();
                this.observer.builtCache();
            }
            if (bl || this.compressRequested || this.raf.length() == 0L) {
                this.writeCache(map);
                this.compressRequested = false;
            }
            this.updateCache(map);
        }
        finally {
            this.releaseLock();
        }
        if (this.updateNeeded) {
            if (!this.shutdownRequested) {
                this.observer.update(map);
            }
            this.fullUpdateRequested = false;
        }
    }

    private boolean isWorkAvailable(long l) {
        if (this.compressRequested || this.flushRequested || this.fullUpdateRequested) {
            if (DEBUG_CHECK_WORK) {
                Debug.println("TRC.haveWork (request" + (this.compressRequested ? ":compress" : "") + (this.flushRequested ? ":flush" : "") + (this.fullUpdateRequested ? ":update" : "") + ")");
            }
            return true;
        }
        long l2 = System.currentTimeMillis();
        if (l2 - l >= 10000L && this.testsToWrite.size() > 0) {
            if (DEBUG_CHECK_WORK) {
                Debug.println("TRC.haveWork (" + this.testsToWrite.size() + " tests)");
            }
            return true;
        }
        try {
            if (l2 - l >= 10000L && this.raf.length() != this.lastFileSize) {
                if (DEBUG_CHECK_WORK) {
                    Debug.println("TRC.haveWork (file size changed: " + this.raf.length() + ")");
                }
                return true;
            }
        }
        catch (IOException iOException) {
            if (DEBUG_CHECK_WORK) {
                Debug.println("TRC.haveWork (" + iOException.getMessage() + ")");
            }
            return true;
        }
        return false;
    }

    private synchronized void shutdown() {
        if (DEBUG_BASIC) {
            Debug.println("TRC.worker shutdown, " + this.testsToWrite.size() + " tests to flush");
        }
        this.shutdownRequested = true;
        if (this.testsToWrite.size() > 0) {
            this.flushRequested = true;
        }
        this.notifyAll();
        long l = System.currentTimeMillis();
        long l2 = l + 30000L;
        try {
            while (this.worker != null & l < l2) {
                if (DEBUG_SYNC) {
                    Debug.println("TRC.shutdown waiting for worker to exit");
                }
                this.wait(l2 - l);
                l = System.currentTimeMillis();
            }
            if (DEBUG_SYNC) {
                Debug.println("TRC.shutdown done");
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private Map readJTRFiles() {
        TreeMap treeMap = new TreeMap();
        this.readJTRFiles(this.workDir.getRoot(), treeMap);
        return treeMap;
    }

    private void readJTRFiles(File file, Map map) {
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            for (int i = 0; i < fileArray.length && !this.shutdownRequested; ++i) {
                File file2 = fileArray[i];
                if (file2.isDirectory()) {
                    this.readJTRFiles(file2, map);
                } else if (TestResult.isResultFile(file2)) {
                    try {
                        TestResult testResult = new TestResult(file2);
                        map.put(testResult.getWorkRelativePath(), testResult);
                    }
                    catch (TestResult.ResultFileNotFoundFault resultFileNotFoundFault) {
                        this.workDir.log(i18n, "trc.lostjtr", file2);
                    }
                    catch (TestResult.ReloadFault reloadFault) {
                        this.workDir.log(i18n, "trc.badjtr", file2);
                        file2.delete();
                    }
                }
                fileArray[i] = null;
            }
        }
    }

    private TestResult reload(Map map, TestResult testResult) {
        File file = this.workDir.getFile(testResult.getWorkRelativePath());
        try {
            return new TestResult(file);
        }
        catch (TestResult.ResultFileNotFoundFault resultFileNotFoundFault) {
            String string = testResult.getTestName();
            testResult = new TestResult(string, this.workDir, Status.notRun(""));
            map.put(string, testResult);
            return testResult;
        }
        catch (TestResult.ReloadFault reloadFault) {
            this.workDir.log(i18n, "trc.badjtr", file);
            file.delete();
            String string = testResult.getTestName();
            testResult = new TestResult(string, this.workDir, Status.notRun("previous results corrupted"));
            map.put(string, testResult);
            return testResult;
        }
    }

    private Map readCache() throws IOException, IllegalArgumentException {
        if (DEBUG_WORK) {
            Debug.println("TRC.readCache");
        }
        this.raf.seek(0L);
        int n = this.raf.readInt();
        if (DEBUG_WORK) {
            Debug.println("TRC.readCache serial=" + n);
        }
        if (this.lastFileSize == -1L || n != this.lastSerial || this.fullUpdateRequested || this.compressRequested) {
            this.updateNeeded = this.fullUpdateRequested || n != this.lastSerial || this.raf.length() > this.lastFileSize;
            this.lastSerial = n;
            this.totalEntryCount = 0;
            Map map = this.readCacheEntries();
            this.uniqueInitialEntryCount = map.size();
            if (DEBUG_WORK) {
                Debug.println("TRC.readCache read all (" + map.size() + " tests, " + this.uniqueInitialEntryCount + " unique)");
            }
            return map;
        }
        if (this.raf.length() > this.lastFileSize) {
            this.raf.seek(this.lastFileSize);
            Map map = this.readCacheEntries();
            if (DEBUG_WORK) {
                Debug.println("TRC.readCache read update (" + map.size() + " tests)");
            }
            this.updateNeeded = true;
            return map;
        }
        this.updateNeeded = false;
        return null;
    }

    private Map readCacheEntries() throws IOException, IllegalArgumentException {
        TreeMap<String, TestResult> treeMap = new TreeMap<String, TestResult>();
        while (this.raf.getFilePointer() < this.raf.length()) {
            String string = this.raf.readUTF();
            int n = this.raf.readInt();
            String string2 = this.raf.readUTF();
            long l = this.raf.readLong();
            TestResult testResult = new TestResult(string, this.workDir, new Status(n, string2), l);
            treeMap.put(testResult.getWorkRelativePath(), testResult);
            ++this.totalEntryCount;
        }
        this.lastFileSize = this.raf.length();
        return treeMap;
    }

    private void writeCache(Map map) throws IOException {
        TestResult testResult;
        if (map == null) {
            throw new IllegalStateException();
        }
        while ((testResult = (TestResult)this.testsToWrite.remove()) != null) {
            String string = testResult.getTestName();
            TestResult testResult2 = (TestResult)map.get(string);
            if (testResult2 != null && !testResult2.getStatus().equals(testResult.getStatus())) {
                this.reload(map, testResult);
                continue;
            }
            map.put(testResult.getWorkRelativePath(), testResult);
        }
        this.raf.seek(0L);
        long l = System.currentTimeMillis();
        this.lastSerial = (int)((l >> 16) + (l & 0xFFFFL));
        this.raf.writeInt(this.lastSerial);
        Iterator iterator = map.values().iterator();
        while (iterator.hasNext()) {
            testResult = (TestResult)iterator.next();
            this.writeCacheEntry(testResult);
        }
        if (DEBUG_WORK) {
            Debug.println("TRC.writeCache write all (" + map.size() + " tests)");
        }
        this.lastFileSize = this.raf.length();
        this.uniqueInitialEntryCount = this.totalEntryCount = map.size();
    }

    private void updateCache(Map map) throws IOException {
        TestResult testResult;
        int n = 0;
        this.raf.seek(this.lastFileSize);
        while ((testResult = (TestResult)this.testsToWrite.remove()) != null) {
            String string;
            TestResult testResult2;
            if (map != null && (testResult2 = (TestResult)map.get(string = testResult.getTestName())) != null && !testResult2.getStatus().equals(testResult.getStatus())) {
                testResult = this.reload(map, testResult);
            }
            this.writeCacheEntry(testResult);
            ++n;
        }
        if (DEBUG_WORK && n > 0) {
            Debug.println("TRC.writeCache write update (" + n + " tests)");
        }
        this.lastFileSize = this.raf.length();
    }

    private void writeCacheEntry(TestResult testResult) throws IOException {
        String string = testResult.getTestName();
        Status status = testResult.getStatus();
        this.raf.writeUTF(string);
        this.raf.writeInt(status.getType());
        this.raf.writeUTF(status.getReason());
        this.raf.writeLong(testResult.getEndTime());
        ++this.totalEntryCount;
    }

    private void getLock() throws IOException {
        long l = System.currentTimeMillis();
        int n = 500;
        long l2 = 0L;
        while (!this.lockFile.createNewFile()) {
            long l3 = System.currentTimeMillis();
            long l4 = l3 - l;
            if (l4 < 20000L) continue;
            if (l4 < MAX_LOCK_WAIT_TIME) {
                long l5 = l3 - l2;
                if (l2 == 0L || l5 > 60000L) {
                    this.observer.waitingForLock(l4);
                    l2 = System.currentTimeMillis();
                }
                if (n < 10000) {
                    n = Math.min(2 * n, 10000);
                }
            } else {
                this.observer.timeoutWaitingForLock();
                this.workDir.log(i18n, "trc.lockTimeout");
                try {
                    if (this.raf != null) {
                        this.raf.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.cacheFile.delete();
                this.lockFile.delete();
                this.raf = new RandomAccessFile(this.cacheFile, "rw");
            }
            try {
                Thread.currentThread();
                Thread.sleep(n);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.observer.acquiredLock();
    }

    private void releaseLock() {
        this.lockFile.delete();
        this.observer.releasedLock();
    }

    private void reviveWeakReferences() {
        if (this.workDir == null) {
            this.workDir = (WorkDirectory)this.weakWorkDir.get();
        }
        if (this.observer == null) {
            this.observer = (Observer)this.weakObserver.get();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        debug = Debug.getInt(class$com$sun$javatest$TestResultCache == null ? (class$com$sun$javatest$TestResultCache = TestResultCache.class$("com.sun.javatest.TestResultCache")) : class$com$sun$javatest$TestResultCache);
        DEBUG_BASIC = debug >= 1;
        DEBUG_TESTS = debug >= 2;
        DEBUG_WORK = debug >= 3;
        DEBUG_CHECK_WORK = debug >= 4;
        DEBUG_SYNC = debug >= 5;
    }

    public static interface Observer {
        public void update(Map var1);

        public void waitingForLock(long var1);

        public void timeoutWaitingForLock();

        public void acquiredLock();

        public void releasedLock();

        public void buildingCache(boolean var1);

        public void buildingCache(TestResult var1);

        public void builtCache();

        public void error(Throwable var1);
    }
}

