/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest;

import com.sun.javatest.JavaTestError;
import com.sun.javatest.Status;
import com.sun.javatest.TRT_HttpHandler;
import com.sun.javatest.TRT_Iterator;
import com.sun.javatest.TRT_TreeNode;
import com.sun.javatest.TestDescription;
import com.sun.javatest.TestFilter;
import com.sun.javatest.TestFinder;
import com.sun.javatest.TestResult;
import com.sun.javatest.TestResultCache;
import com.sun.javatest.TestSuite;
import com.sun.javatest.WorkDirectory;
import com.sun.javatest.httpd.HttpdServer;
import com.sun.javatest.httpd.RootRegistry;
import com.sun.javatest.util.Debug;
import com.sun.javatest.util.DynamicArray;
import com.sun.javatest.util.I18NResourceBundle;
import com.sun.javatest.util.StringArray;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Vector;

public class TestResultTable {
    private Hashtable[] statusTables;
    private WorkDirectory workDir;
    private TestFinder finder;
    private String[] finderErrors = new String[0];
    private Observer[] observers = new Observer[0];
    private TRT_HttpHandler httpHandle;
    private TreeObserver[] treeObservers = new TreeObserver[0];
    private TestResultCache trCache;
    private boolean suppressFinderScan = false;
    private Updater updater = new Updater();
    private volatile boolean updateInProgress;
    private volatile boolean cacheInitialized;
    private volatile boolean cacheShutdown;
    private Vector testsInUpdate = new Vector();
    private static int instanceId;
    private TRT_TreeNode root;
    private File suiteRoot;
    private static I18NResourceBundle i18n;
    static final Status notYetRun;
    private static int debug;
    static /* synthetic */ Class class$com$sun$javatest$TestResultTable;

    public TestResultTable() {
        this.statusTables = new Hashtable[4];
        for (int i = 0; i < this.statusTables.length; ++i) {
            this.statusTables[i] = new Hashtable();
        }
        this.root = new TRT_TreeNode(this, null);
        ++instanceId;
        if (HttpdServer.isActive()) {
            String string = "/trt/" + instanceId;
            this.httpHandle = new TRT_HttpHandler(this, string, instanceId);
            RootRegistry.getInstance().addHandler(string, "Test Result Table", this.httpHandle);
            RootRegistry.associateObject(this, this.httpHandle);
        }
    }

    public TestResultTable(WorkDirectory workDirectory) {
        this();
        this.setWorkDirectory(workDirectory);
    }

    public TestResultTable(WorkDirectory workDirectory, TestFinder testFinder) {
        this();
        this.setWorkDirectory(workDirectory, testFinder);
    }

    public void setTestFinder(TestFinder testFinder) {
        if (this.finder != null) {
            throw new IllegalStateException(i18n.getString("trt.alreadyFinder"));
        }
        this.finder = testFinder;
        if (this.trCache == null) {
            this.initFinder();
        }
    }

    public WorkDirectory getWorkDir() {
        return this.getWorkDirectory();
    }

    public WorkDirectory getWorkDirectory() {
        return this.workDir;
    }

    public void setWorkDirectory(WorkDirectory workDirectory) {
        this.setWorkDirectory(workDirectory, workDirectory.getTestSuite().getTestFinder());
    }

    private void setWorkDirectory(WorkDirectory workDirectory, TestFinder testFinder) {
        if (workDirectory == null) {
            throw new NullPointerException();
        }
        if (this.workDir == workDirectory) {
            return;
        }
        if (this.workDir != null && this.workDir != workDirectory) {
            throw new IllegalStateException();
        }
        if (this.finder != null && this.finder != testFinder) {
            throw new IllegalStateException();
        }
        this.workDir = workDirectory;
        this.finder = testFinder;
        this.initFinder();
        try {
            this.trCache = new TestResultCache(this.workDir, this.updater);
        }
        catch (IOException iOException) {
            this.updater.error(iOException);
        }
    }

    public int getCurrentTestCount() {
        return this.root.getCurrentSize();
    }

    void starting() {
    }

    void finished() {
        if (this.trCache != null) {
            if (this.needsCacheCompress()) {
                if (debug > 0) {
                    Debug.print("TRT.finished(), attempting cache compress...");
                }
                this.trCache.compress();
            }
        } else {
            if (debug > 0) {
                Debug.print("TRT.finished(), requesting cache flush...");
            }
            this.trCache.flush();
        }
    }

    public void update(TestResult testResult) {
        this.update(testResult, false);
    }

    public void update(TestResult testResult, boolean bl) {
        TestResult testResult2 = this.insert(testResult, bl);
        if (testResult != testResult2) {
            testResult.shareStatus(this.statusTables);
            for (int i = 0; i < this.observers.length; ++i) {
                this.observers[i].update(testResult2, testResult);
            }
        } else {
            for (int i = 0; i < this.observers.length; ++i) {
                this.observers[i].updated(testResult);
            }
        }
        this.testsInUpdate.add(testResult);
        if (this.trCache != null && !this.updateInProgress && testResult.getStatus().getType() != 3) {
            this.trCache.insert(testResult);
        }
        this.testsInUpdate.remove(testResult);
    }

    public synchronized boolean waitUntilReady() {
        while (!this.cacheInitialized || this.updateInProgress) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                if (debug <= 0) continue;
                interruptedException.printStackTrace(Debug.getWriter());
            }
        }
        return true;
    }

    public synchronized boolean isReady() {
        return this.cacheInitialized && !this.updateInProgress;
    }

    public TestResult lookup(TestDescription testDescription) {
        return this.lookup(TestResult.getWorkRelativePath(testDescription.getRootRelativeURL()));
    }

    public TestResult lookup(String string) {
        if (this.root == null) {
            return null;
        }
        return TestResultTable.findTest(this.root, string, string);
    }

    public Object resolveUrl(String string) {
        return TestResultTable.lookupNode(this.root, string);
    }

    public boolean validatePath(String string) {
        if (string == null) {
            return false;
        }
        Object[] objectArray = TestResultTable.lookupInitURL(this.root, string);
        return objectArray != null && objectArray.length > 0;
    }

    public static TreeNode[] getObjectPath(TestResult testResult) {
        if (testResult == null) {
            return null;
        }
        Vector<TreeNode> vector = new Vector<TreeNode>();
        for (TreeNode treeNode = testResult.getParent(); treeNode != null; treeNode = treeNode.getParent()) {
            vector.insertElementAt(treeNode, 0);
        }
        Object[] objectArray = new TreeNode[vector.size()];
        vector.copyInto(objectArray);
        if (debug == 2 || debug == 99) {
            Debug.println("TRT - getObjectPath() results:");
            Debug.println("   -> target: " + testResult.getTestName());
            Debug.println("   -> resulting path length: " + objectArray.length);
        }
        if (objectArray == null || objectArray.length == 0) {
            return null;
        }
        return objectArray;
    }

    public static TreeNode[] getObjectPath(TreeNode treeNode) {
        if (treeNode == null) {
            return null;
        }
        Vector<TreeNode> vector = new Vector<TreeNode>();
        for (TreeNode treeNode2 = treeNode; treeNode2 != null; treeNode2 = treeNode2.getParent()) {
            vector.insertElementAt(treeNode2, 0);
        }
        Object[] objectArray = new TreeNode[vector.size()];
        vector.copyInto(objectArray);
        if (debug == 2 || debug == 99) {
            Debug.println("TRT - getObjectPath() results:");
            Debug.println("   -> target RRP: " + TestResultTable.getRootRelativePath(treeNode));
            Debug.println("   -> resulting path length: " + objectArray.length);
        }
        return objectArray;
    }

    public TreeIterator getIterator() {
        if (this.root == null) {
            return NullEnum.getInstance();
        }
        return TestResultTable.getIterator(this.root);
    }

    public Enumeration elements() {
        return this.getIterator();
    }

    public TreeIterator getIterator(TestFilter[] testFilterArray) {
        if (this.root == null) {
            return NullEnum.getInstance();
        }
        return TestResultTable.getIterator((TreeNode)this.root, testFilterArray);
    }

    public Enumeration elements(TestFilter[] testFilterArray) {
        return this.getIterator(testFilterArray);
    }

    public static TreeIterator getIterator(TreeNode treeNode) {
        if (treeNode == null) {
            return NullEnum.getInstance();
        }
        return new TRT_Iterator(treeNode);
    }

    public static Enumeration elements(TreeNode treeNode) {
        return TestResultTable.getIterator(treeNode);
    }

    public static TreeIterator getIterator(TreeNode treeNode, TestFilter testFilter) {
        if (treeNode == null) {
            return NullEnum.getInstance();
        }
        TestFilter[] testFilterArray = new TestFilter[]{testFilter};
        return new TRT_Iterator(treeNode, testFilterArray);
    }

    public static Enumeration elements(TreeNode treeNode, TestFilter testFilter) {
        return TestResultTable.getIterator(treeNode, testFilter);
    }

    public static TreeIterator getIterator(TreeNode treeNode, TestFilter[] testFilterArray) {
        if (treeNode == null) {
            return NullEnum.getInstance();
        }
        return new TRT_Iterator(treeNode, testFilterArray);
    }

    public static Enumeration elements(TreeNode treeNode, TestFilter[] testFilterArray) {
        return TestResultTable.getIterator(treeNode, testFilterArray);
    }

    public Enumeration elements(String string, TestFilter[] testFilterArray) {
        if (string == null) {
            return NullEnum.getInstance();
        }
        String[] stringArray = new String[]{string};
        return this.elements(stringArray, testFilterArray);
    }

    public TreeIterator getIterator(File[] fileArray, TestFilter[] testFilterArray) throws Fault {
        String[] stringArray = this.preProcessInitFiles(fileArray);
        if (stringArray != null && stringArray.length > 0) {
            return this.getIterator(stringArray, testFilterArray);
        }
        return this.getIterator(testFilterArray);
    }

    public Enumeration elements(File[] fileArray, TestFilter[] testFilterArray) throws Fault {
        return this.getIterator(fileArray, testFilterArray);
    }

    public TreeIterator getIterator(String[] stringArray, TestFilter[] testFilterArray) {
        Object[] objectArray = new TreeNode[]{};
        TestResult[] testResultArray = new TestResult[]{};
        String[] stringArray2 = this.sortByName(stringArray);
        stringArray2 = this.distillUrls(stringArray2);
        for (int i = 0; i < stringArray2.length; ++i) {
            Object[] objectArray2 = TestResultTable.lookupInitURL(this.root, stringArray2[i]);
            if (debug == 1 || debug == 99) {
                Debug.println("TRT.lookupInitURL gave back " + objectArray2);
            }
            if (objectArray2 == null) continue;
            if (objectArray2 instanceof TreeNode[]) {
                if (TestResultTable.arrayContains(objectArray, objectArray2)) continue;
                objectArray = (TreeNode[])DynamicArray.append(objectArray, (TreeNode)objectArray2[0]);
                continue;
            }
            if (objectArray2 instanceof TestResult[]) {
                TestResult[] testResultArray2 = new TestResult[objectArray2.length + testResultArray.length];
                System.arraycopy(testResultArray, 0, testResultArray2, 0, testResultArray.length);
                System.arraycopy((TestResult[])objectArray2, 0, testResultArray2, testResultArray.length, objectArray2.length);
                testResultArray = testResultArray2;
                continue;
            }
            throw new IllegalArgumentException(i18n.getString("trt.invalidIURL", stringArray2[i]));
        }
        if (!(objectArray != null && objectArray.length != 0 || testResultArray != null && testResultArray.length != 0)) {
            if (debug == 1 || debug == 99) {
                Debug.println("None of the initial URLs could be looked up.");
            }
            return NullEnum.getInstance();
        }
        if (testResultArray.length > 0) {
            if (debug == 1 || debug == 99) {
                Debug.println("Using combo TreeIterator, " + testResultArray.length + " tests, " + objectArray.length + " nodes.");
            }
            return new TRT_Iterator((TreeNode[])objectArray, testResultArray, testFilterArray);
        }
        return new TRT_Iterator((TreeNode[])objectArray, testFilterArray);
    }

    public Enumeration elements(String[] stringArray, TestFilter[] testFilterArray) {
        return this.getIterator(stringArray, testFilterArray);
    }

    public int size() {
        if (this.root == null) {
            return 0;
        }
        return this.root.getSize();
    }

    TestResult insert(TestResult testResult) {
        return this.insert(testResult, false);
    }

    TestResult insert(TestResult testResult, boolean bl) {
        if (testResult == null) {
            return null;
        }
        String string = testResult.getWorkRelativePath();
        TRT_TreeNode[] tRT_TreeNodeArray = new TRT_TreeNode[]{};
        return this.insert(this.root, string, testResult, tRT_TreeNodeArray, bl);
    }

    TestResult insert(TestResult testResult, Status status) {
        if (testResult == null) {
            return null;
        }
        String string = testResult.getWorkRelativePath();
        TRT_TreeNode[] tRT_TreeNodeArray = new TRT_TreeNode[]{};
        return this.insert(this.root, string, testResult, tRT_TreeNodeArray, false);
    }

    public TreeNode getRoot() {
        return this.root;
    }

    public File getTestSuiteRoot() {
        return this.suiteRoot;
    }

    public TestFinder getTestFinder() {
        return this.finder;
    }

    public static String getRootRelativePath(TreeNode treeNode) {
        if (treeNode.isRoot()) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(treeNode.getName());
        for (treeNode = treeNode.getParent(); treeNode != null && !treeNode.isRoot(); treeNode = treeNode.getParent()) {
            stringBuffer.insert(0, '/');
            stringBuffer.insert(0, treeNode.getName());
        }
        return stringBuffer.toString();
    }

    public static TreeNode findNode(TreeNode treeNode, String string) {
        if (treeNode == null) {
            throw new IllegalArgumentException(i18n.getString("trt.nodeNull"));
        }
        if (string == null) {
            throw new IllegalArgumentException(i18n.getString("trt.pathNull"));
        }
        if (string.length() == 0) {
            return treeNode;
        }
        String string2 = TestResultTable.getDirName(string);
        TreeNode treeNode2 = null;
        if (debug > 9) {
            Debug.println("TRT.findNode() looking for " + string + " in " + treeNode.getName());
        }
        if (string2 == string) {
            treeNode2 = ((TRT_TreeNode)treeNode).getTreeNode(string, false);
        } else {
            TRT_TreeNode tRT_TreeNode = ((TRT_TreeNode)treeNode).getTreeNode(string2, false);
            if (tRT_TreeNode != null) {
                treeNode2 = TestResultTable.findNode(tRT_TreeNode, TestResultTable.behead(string));
            }
        }
        return treeNode2;
    }

    public synchronized void addObserver(Observer observer) {
        if (observer == null) {
            throw new NullPointerException();
        }
        this.observers = (Observer[])DynamicArray.append(this.observers, observer);
    }

    public synchronized void removeObserver(Observer observer) {
        this.observers = (Observer[])DynamicArray.remove((Object[])this.observers, observer);
    }

    public void addObserver(TreeObserver treeObserver) {
        this.treeObservers = (TreeObserver[])DynamicArray.append(this.treeObservers, treeObserver);
    }

    public void removeObserver(TreeObserver treeObserver) {
        if (this.treeObservers != null) {
            this.treeObservers = (TreeObserver[])DynamicArray.remove((Object[])this.treeObservers, treeObserver);
        }
    }

    public synchronized TestResult resetTest(TestResult testResult) {
        TestResult testResult2 = null;
        this.workDir.log(i18n, "trt.rstTest", testResult.getTestName());
        TreeNode[] treeNodeArray = TestResultTable.getObjectPath(testResult);
        if (treeNodeArray == null) {
            testResult2 = this.lookup(testResult.getWorkRelativePath());
            if (debug > 0) {
                Debug.println("Recovered test by replacement (1). " + testResult2);
            }
        } else {
            TRT_TreeNode tRT_TreeNode = (TRT_TreeNode)treeNodeArray[treeNodeArray.length - 1];
            int n = tRT_TreeNode.getIndex(testResult, false);
            if (n >= 0) {
                testResult2 = tRT_TreeNode.resetTest(n, testResult);
                if (testResult2 == null && debug > 0) {
                    Debug.println("reset of test " + testResult.getTestName() + " failed.");
                } else {
                    if (this.trCache != null) {
                        this.testsInUpdate.add(testResult2);
                        this.trCache.insert(testResult2);
                        this.testsInUpdate.remove(testResult2);
                    }
                    this.notifyRemoveLeaf(treeNodeArray, testResult, n);
                    this.notifyNewLeaf(treeNodeArray, testResult2, n);
                }
            } else {
                testResult2 = this.lookup(testResult.getWorkRelativePath());
                if (debug > 0) {
                    Debug.println("Recovered test by replacement (2). " + testResult2);
                }
            }
        }
        return testResult2;
    }

    public synchronized TestResult resetTest(String string) {
        TestResult testResult = TestResultTable.findTest(this.root, TestResult.getWorkRelativePath(string), string);
        if (testResult == null) {
            return null;
        }
        return this.resetTest(testResult);
    }

    public synchronized boolean refreshIfNeeded(String string) throws Fault {
        TestResult testResult = this.lookup(TestResult.getWorkRelativePath(string));
        if (testResult == null) {
            throw new Fault(i18n, "trt.refreshNoTest", string);
        }
        TreeNode[] treeNodeArray = TestResultTable.getObjectPath(testResult);
        if (treeNodeArray == null) {
            return false;
        }
        TRT_TreeNode tRT_TreeNode = (TRT_TreeNode)treeNodeArray[treeNodeArray.length - 1];
        TestResult testResult2 = tRT_TreeNode.refreshIfNeeded(testResult);
        if (testResult2 != testResult) {
            this.notifyChangeLeaf(TestResultTable.getObjectPath(tRT_TreeNode), testResult2, tRT_TreeNode.getTestIndex(testResult2, false), testResult);
        }
        return false;
    }

    public synchronized boolean refreshIfNeeded(TreeNode treeNode) throws Fault {
        if (treeNode.getEnclosingTable() != this) {
            throw new IllegalStateException("refresh requested for node not owned by this table");
        }
        return this.recursiveRefresh((TRT_TreeNode)treeNode);
    }

    void suppressFinderScan(boolean bl) {
        TestSuite testSuite;
        this.suppressFinderScan = !bl ? false : (this.workDir != null ? ((testSuite = this.workDir.getTestSuite()) != null && (testSuite.getTestRefreshBehavior(0) || testSuite.getTestRefreshBehavior(1) || testSuite.getTestRefreshBehavior(2)) ? false : bl) : bl);
    }

    boolean isFinderScanSuppressed() {
        return this.suppressFinderScan;
    }

    boolean isBranchFile(File file) {
        return file.isDirectory();
    }

    long getLastModifiedTime(File file) {
        return file.lastModified();
    }

    private String[] sortByName(String[] stringArray) {
        if (stringArray == null || stringArray.length <= 1) {
            return stringArray;
        }
        Comparator comparator = this.finder.getComparator();
        if (comparator == null) {
            return stringArray;
        }
        ArrayList<String[]> arrayList = new ArrayList<String[]>(stringArray.length);
        HashMap hashMap = new HashMap();
        for (int i = 0; i < stringArray.length; ++i) {
            arrayList.add(StringArray.splitList(stringArray[i], "/"));
            hashMap.put(stringArray[i], arrayList.get(arrayList.size() - 1));
        }
        ArrayList<String> arrayList2 = new ArrayList<String>(stringArray.length);
        arrayList2.add(stringArray[0]);
        for (int i = 1; i < arrayList.size(); ++i) {
            String[] stringArray2 = (String[])arrayList.get(i);
            for (int j = 0; j < arrayList2.size(); ++j) {
                String[] stringArray3 = (String[])hashMap.get(arrayList2.get(j));
                int n = this.compareStringArrays(comparator, stringArray2, stringArray3);
                if (n == 0) {
                    arrayList2.add(j + 1, stringArray[i]);
                    stringArray2 = null;
                    break;
                }
                if (n >= 0) continue;
                arrayList2.add(j, stringArray[i]);
                stringArray2 = null;
                break;
            }
            if (stringArray2 == null) continue;
            arrayList2.add(stringArray[i]);
        }
        return arrayList2.toArray(new String[arrayList2.size()]);
    }

    private int compareStringArrays(Comparator comparator, String[] stringArray, String[] stringArray2) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (i >= stringArray2.length) {
                return 1;
            }
            int n = comparator.compare(stringArray[i], stringArray2[i]);
            if (n == 0) continue;
            return n;
        }
        return 0;
    }

    private String[] distillUrls(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return stringArray;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(stringArray[0]);
        for (int i = 1; i < stringArray.length; ++i) {
            int n;
            String string = (String)arrayList.get(arrayList.size() - 1);
            int n2 = string.lastIndexOf(47);
            int n3 = n = n2 == -1 ? string.lastIndexOf(35) : string.lastIndexOf(n2, 35);
            if (n < 0 && stringArray[i].startsWith(string) && (stringArray[i].length() == string.length() || stringArray[i].charAt(string.length()) == '#')) continue;
            arrayList.add(stringArray[i]);
        }
        if (arrayList.size() == stringArray.length) {
            return stringArray;
        }
        String[] stringArray2 = new String[arrayList.size()];
        return arrayList.toArray(stringArray2);
    }

    private synchronized void updateFromCache(Map map) {
        this.updateInProgress = true;
        Iterator iterator = map.values().iterator();
        while (iterator.hasNext()) {
            TestResult testResult = (TestResult)iterator.next();
            this.update(testResult, this.suppressFinderScan);
        }
        if (!this.cacheInitialized) {
            this.cacheInitialized = true;
        }
        this.updateInProgress = false;
        this.notifyAll();
    }

    synchronized TestResult insert(TRT_TreeNode tRT_TreeNode, String string, TestResult testResult, TRT_TreeNode[] tRT_TreeNodeArray) {
        return this.insert(tRT_TreeNode, string, testResult, tRT_TreeNodeArray, false);
    }

    synchronized TestResult insert(TRT_TreeNode tRT_TreeNode, String string, TestResult testResult, TRT_TreeNode[] tRT_TreeNodeArray, boolean bl) {
        String string2;
        if (debug > 9) {
            Debug.println("TRT Beginning insert " + string);
        }
        if (string == (string2 = TestResultTable.behead(string))) {
            TestResult testResult2 = tRT_TreeNode.addChild(testResult, bl);
            tRT_TreeNodeArray = (TRT_TreeNode[])DynamicArray.append(tRT_TreeNodeArray, tRT_TreeNode);
            if (testResult2 == null) {
                if (debug > 10) {
                    Debug.println("   => Inserted TR: " + testResult.getTestName());
                    Debug.println("   => Test Ref: " + testResult);
                    Debug.println("   => Status is: " + Status.typeToString(testResult.getStatus().getType()));
                    Debug.println("   => TRT: " + this);
                    Debug.println("   => Node Ref: " + tRT_TreeNode);
                    Debug.println("   => Node path: " + TestResultTable.getRootRelativePath(tRT_TreeNode));
                    Debug.println("   => Index in node: " + tRT_TreeNode.getIndex(testResult, bl));
                }
                this.notifyNewLeaf(tRT_TreeNodeArray, testResult, tRT_TreeNode.getIndex(testResult, bl));
            } else if (testResult2 == testResult) {
                if (debug > 10) {
                    Debug.println("   => Ignored new TR: " + testResult.getTestName());
                    Debug.println("   => Test Ref: " + testResult);
                    Debug.println("   => Status is: " + Status.typeToString(testResult.getStatus().getType()));
                    Debug.println("   => RESETTING IT! " + this.updateInProgress);
                }
                if (this.updateInProgress) {
                    this.resetTest(testResult.getTestName());
                }
            } else {
                int n = tRT_TreeNode.getIndex(testResult, bl);
                if (debug > 10) {
                    Debug.println("   => Updated TR: " + testResult.getTestName());
                    Debug.println("   => Test Ref: " + testResult);
                    Debug.println("   => Status is: " + Status.typeToString(testResult.getStatus().getType()));
                    Debug.println("   => TRT: " + this);
                    Debug.println("   => Node Ref: " + tRT_TreeNode);
                    Debug.println("   => Node path: " + TestResultTable.getRootRelativePath(tRT_TreeNode));
                    Debug.println("   => Index in node: " + n);
                }
                if (n != -1) {
                    if (testResult2 != null && testResult2 != testResult) {
                        if (testResult.isShrunk()) {
                            try {
                                TestDescription testDescription = testResult2.getDescription();
                                if (testDescription != null) {
                                    testResult.setTestDescription(testDescription);
                                }
                            }
                            catch (TestResult.Fault fault) {
                                // empty catch block
                            }
                        }
                        this.notifyRemoveLeaf(tRT_TreeNodeArray, testResult2, n);
                        this.notifyNewLeaf(tRT_TreeNodeArray, testResult, n);
                    } else {
                        this.notifyChangeLeaf(tRT_TreeNodeArray, testResult, n, testResult2);
                    }
                }
            }
            return testResult2;
        }
        String string3 = TestResultTable.getDirName(string);
        TRT_TreeNode tRT_TreeNode2 = tRT_TreeNode.getTreeNode(string3, bl);
        if (tRT_TreeNode2 == null) {
            TRT_TreeNode tRT_TreeNode3 = new TRT_TreeNode(this, tRT_TreeNode);
            tRT_TreeNode3.setName(TestResultTable.getDirName(string3));
            tRT_TreeNode.addChild(tRT_TreeNode3, bl);
            tRT_TreeNodeArray = (TRT_TreeNode[])DynamicArray.append(tRT_TreeNodeArray, tRT_TreeNode3);
            this.notifyNewBranch(tRT_TreeNodeArray, tRT_TreeNode3, tRT_TreeNode.getIndex(tRT_TreeNode3, bl));
            return this.insert(tRT_TreeNode3, string2, testResult, tRT_TreeNodeArray, bl);
        }
        tRT_TreeNodeArray = (TRT_TreeNode[])DynamicArray.append(tRT_TreeNodeArray, tRT_TreeNode);
        return this.insert(tRT_TreeNode2, string2, testResult, tRT_TreeNodeArray, bl);
    }

    private boolean recursiveRefresh(TRT_TreeNode tRT_TreeNode) {
        boolean bl = tRT_TreeNode.refreshIfNeeded();
        TreeNode[] treeNodeArray = tRT_TreeNode.getTreeNodes();
        if (treeNodeArray != null) {
            for (int i = 0; i < treeNodeArray.length; ++i) {
                bl |= this.recursiveRefresh((TRT_TreeNode)treeNodeArray[i]);
            }
        }
        return bl;
    }

    void notifyNewBranch(TreeNode[] treeNodeArray, TreeNode treeNode, int n) {
        if (this.treeObservers == null) {
            return;
        }
        for (int i = 0; i < this.treeObservers.length; ++i) {
            this.treeObservers[i].nodeInserted(treeNodeArray, treeNode, n);
        }
    }

    void notifyNewLeaf(TreeNode[] treeNodeArray, TestResult testResult, int n) {
        if (this.treeObservers == null) {
            return;
        }
        for (int i = 0; i < this.treeObservers.length; ++i) {
            this.treeObservers[i].nodeInserted(treeNodeArray, testResult, n);
        }
    }

    private void notifyChangeLeaf(TreeNode[] treeNodeArray, TestResult testResult, int n, TestResult testResult2) {
        if (this.treeObservers == null) {
            return;
        }
        for (int i = 0; i < this.treeObservers.length; ++i) {
            this.treeObservers[i].nodeChanged(treeNodeArray, testResult, n, testResult2);
        }
    }

    void notifyRemoveLeaf(TreeNode[] treeNodeArray, TestResult testResult, int n) {
        if (this.treeObservers == null) {
            return;
        }
        for (int i = 0; i < this.treeObservers.length; ++i) {
            this.treeObservers[i].nodeRemoved(treeNodeArray, testResult, n);
        }
    }

    private String[] preProcessInitFiles(File[] fileArray) throws Fault {
        if (fileArray == null || fileArray.length == 0) {
            if (debug > 1) {
                Debug.println("Initial files set empty.");
            }
            return null;
        }
        if (debug > 1) {
            Debug.println("Initial files: ");
            for (int i = 0; i < fileArray.length; ++i) {
                Debug.println("  + " + fileArray[i].getPath());
            }
        }
        String[] stringArray = new String[fileArray.length];
        int n = stringArray.length;
        int n2 = this.getWorkDir() == null ? 0 : this.finder.getRootDir().getAbsolutePath().length() + 1;
        for (int i = 0; i < fileArray.length; ++i) {
            if (debug > 1) {
                Debug.println(" *** init url resolve begin ***");
            }
            String string = null;
            if (this.finder.getRootDir().equals(fileArray[i])) {
                --n;
                if (debug <= 1) continue;
                Debug.println("An initial URL equals testsuite root, ignoring it.");
                continue;
            }
            if (fileArray[i].isAbsolute()) {
                String string2;
                String string3 = TestResultTable.getRootRelativePath(this.getRoot());
                if (debug > 1) {
                    Debug.println("  -> Initial URL is absolute, stripping from " + fileArray[i].getPath());
                    Debug.println("  -> Stripping: " + this.finder.getRootDir());
                    Debug.println("  -> removing rrp: " + string3);
                }
                if (!(string2 = fileArray[i].getPath()).startsWith(this.finder.getRootDir().getPath())) {
                    throw new Fault(i18n, "trt.badInitFile", string2);
                }
                String string4 = string2.substring(n2 += string3 == null || string3.length() == 0 ? 0 : string3.length() + 1);
                string = string4.replace(File.separatorChar, '/');
            } else {
                string = fileArray[i].getPath().replace(File.separatorChar, '/');
            }
            stringArray[i] = string;
        }
        if (n != fileArray.length) {
            String[] stringArray2 = new String[n];
            System.arraycopy(stringArray, 0, stringArray2, 0, n);
            stringArray = stringArray2;
        }
        if (debug > 1) {
            Debug.println("*** finished preprocessing of init urls ***");
        }
        return stringArray;
    }

    private static TestResult findTest(TreeNode treeNode, String string, String string2) {
        ((TRT_TreeNode)treeNode).scanIfNeeded();
        if (debug == 2 || debug == 99) {
            Debug.println("TRT looking for " + string2 + " IN " + treeNode.getName());
        }
        String string3 = TestResultTable.getDirName(string2);
        TestResult testResult = null;
        if (string3 == string2) {
            int n;
            if (debug == 2 || debug == 99) {
                Debug.println("    -> Looking for TR in this node.");
            }
            if ((n = ((TRT_TreeNode)treeNode).getResultIndex(string, false)) != -1) {
                testResult = (TestResult)treeNode.getChild(n);
                if (debug == 2 || debug == 99) {
                    Debug.println("    -> TRT.findTest() located " + testResult);
                    Debug.println("");
                }
            } else if (debug == 2 || debug == 99) {
                Debug.println("    -> TRT.findTest(): unable to find node " + string);
                Debug.println("");
            }
        } else {
            TRT_TreeNode tRT_TreeNode;
            if (debug == 2 || debug == 99) {
                Debug.println("    -> Looking for branch name: " + string3);
            }
            if ((tRT_TreeNode = ((TRT_TreeNode)treeNode).getTreeNode(string3, false)) != null) {
                testResult = TestResultTable.findTest(tRT_TreeNode, string, TestResultTable.behead(string2));
            } else if (debug == 2 || debug == 99) {
                Debug.println("TRT.findTest(): unable to find node " + string);
            }
        }
        return testResult;
    }

    private static TreeNode[] lookup(TreeNode treeNode, String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return null;
        }
        Object[] objectArray = new TreeNode[]{};
        for (int i = 0; i < stringArray.length; ++i) {
            TreeNode treeNode2;
            if (stringArray[i] == null || (treeNode2 = TestResultTable.findNode(treeNode, stringArray[i])) == null) continue;
            objectArray = (TreeNode[])DynamicArray.append(objectArray, treeNode2);
        }
        if (debug == 2 || debug == 99) {
            Debug.println("TRT.lookup(url[]) found " + objectArray.length + " matches.");
        }
        return objectArray;
    }

    private static Object lookupNode(TreeNode treeNode, String string) {
        TreeNode treeNode2 = TestResultTable.findNode(treeNode, string);
        if (treeNode2 != null) {
            return treeNode2;
        }
        String string2 = TestResult.getWorkRelativePath(string);
        TestResult testResult = TestResultTable.findTest((TRT_TreeNode)treeNode, string2, string2);
        if (testResult != null) {
            try {
                TestDescription testDescription = testResult.getDescription();
                if (testDescription.getRootRelativeURL().equals(string)) {
                    return testResult;
                }
            }
            catch (TestResult.Fault fault) {
                // empty catch block
            }
        }
        return null;
    }

    private static Object[] lookupInitURL(TreeNode treeNode, String string) {
        TreeNode treeNode2;
        Object object;
        if (treeNode == null || string == null) {
            throw new IllegalArgumentException("Starting node or URL may not be null!");
        }
        if (debug == 2 || debug == 99) {
            Debug.println("Starting iurl lookup on " + string + " in " + treeNode.getName());
        }
        if ((object = TestResultTable.lookupNode(treeNode, string)) != null) {
            if (debug == 2 || debug == 99 && object instanceof TreeNode) {
                Debug.println("  -> simple match found " + TestResultTable.getRootRelativePath((TreeNode)object));
            }
            if (object instanceof TestResult) {
                return new TestResult[]{(TestResult)object};
            }
            return new TreeNode[]{(TreeNode)object};
        }
        if (debug == 2 || debug == 99) {
            Debug.println("TRT looking for tests beginning with " + string + " IN " + treeNode.getName());
            Debug.println("   -> retrieving possible TRs from " + TestResultTable.betail(string));
        }
        if ((treeNode2 = TestResultTable.findNode(treeNode, TestResultTable.betail(string))) == null) {
            if (debug == 2 || debug == 99) {
                Debug.println("   -> No parent node found!");
            }
            return null;
        }
        Object[] objectArray = treeNode2.getTestResults();
        if (objectArray == null || objectArray.length == 0) {
            return null;
        }
        Vector<Object> vector = new Vector<Object>();
        try {
            for (int i = 0; i < objectArray.length; ++i) {
                if (!objectArray[i].getDescription().getRootRelativeURL().startsWith(string)) continue;
                vector.addElement(objectArray[i]);
            }
        }
        catch (TestResult.Fault fault) {
            throw new JavaTestError(i18n, "trt.trNoTd", fault);
        }
        if (vector.size() > 0) {
            objectArray = new TestResult[vector.size()];
            vector.copyInto(objectArray);
        } else {
            objectArray = null;
        }
        return objectArray;
    }

    private void initFinder() {
        this.suiteRoot = this.finder.getRoot();
    }

    private boolean needsCacheCompress() {
        return this.trCache.needsCompress();
    }

    protected void finalize() throws Throwable {
        super.finalize();
        RootRegistry.getInstance().removeHandler(this.httpHandle);
        RootRegistry.unassociateObject(this, this.httpHandle);
        this.httpHandle = null;
    }

    private synchronized void setUpdateInProgress(boolean bl) {
        this.updateInProgress = bl;
        this.notifyAll();
    }

    static String behead(String string) {
        int n = string.indexOf("/");
        if (n == -1) {
            return string;
        }
        return string.substring(n + 1);
    }

    static String getDirName(String string) {
        int n = string.indexOf(47);
        if (n == -1) {
            return string;
        }
        return string.substring(0, n);
    }

    static String betail(String string) {
        int n = string.lastIndexOf(47);
        if (n == -1) {
            return string;
        }
        return string.substring(0, n);
    }

    static boolean arrayContains(Object[] objectArray, Object object) {
        if (objectArray == null || objectArray.length == 0) {
            return false;
        }
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i] != object) continue;
            return true;
        }
        return false;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        i18n = I18NResourceBundle.getBundleForClass(class$com$sun$javatest$TestResultTable == null ? (class$com$sun$javatest$TestResultTable = TestResultTable.class$("com.sun.javatest.TestResultTable")) : class$com$sun$javatest$TestResultTable);
        notYetRun = Status.notRun("test is awaiting execution");
        debug = Debug.getInt(class$com$sun$javatest$TestResultTable == null ? (class$com$sun$javatest$TestResultTable = TestResultTable.class$("com.sun.javatest.TestResultTable")) : class$com$sun$javatest$TestResultTable);
    }

    public class PathRecord {
        private TreeNode[] nodes;
        private int[] inds;
        private TestResult tr;

        PathRecord() {
        }

        PathRecord(TestResult testResult) {
            this.tr = testResult;
        }

        PathRecord(TreeNode[] treeNodeArray, TestResult testResult) {
            this.tr = testResult;
            this.nodes = treeNodeArray;
        }

        PathRecord(TreeNode[] treeNodeArray, int[] nArray) {
            this.nodes = treeNodeArray;
            this.inds = nArray;
        }

        void setTestResult(TestResult testResult) {
            this.tr = testResult;
        }

        void addNode(TreeNode treeNode) {
            if (this.tr != null) {
                throw new JavaTestError(i18n, "trt.invalidPath");
            }
            this.nodes = (TreeNode[])DynamicArray.append(this.nodes, treeNode);
        }

        public int[] getIndicies() {
            if (this.inds == null) {
                this.inds = this.generateInds(this.tr);
            }
            return this.inds;
        }

        public TreeNode[] getNodes() {
            if (this.nodes == null) {
                this.nodes = this.generateNodes(this.tr);
            }
            return this.nodes;
        }

        public TreeNode[] generateNodes(TestResult testResult) {
            if (testResult == null) {
                return null;
            }
            TreeNode[] treeNodeArray = null;
            for (TreeNode treeNode = testResult.getParent(); treeNode != null; treeNode = treeNode.getParent()) {
                treeNodeArray = (TreeNode[])DynamicArray.insert(treeNodeArray, treeNode, 0);
            }
            return treeNodeArray;
        }

        private int[] generateInds(TestResult testResult) {
            return null;
        }
    }

    class Updater
    implements TestResultCache.Observer {
        private int rebuildCount;

        Updater() {
        }

        public void update(Map map) {
            TestResultTable.this.updateFromCache(map);
        }

        public void waitingForLock(long l) {
            int n = (int)(l / 1000L);
            int n2 = n / 60;
            this.writeI18N("trt.waitingForLock", new Object[]{TestResultTable.this.workDir.getRoot(), new Integer(n2), new Integer(n -= 60 * n2)});
        }

        public void timeoutWaitingForLock() {
            this.writeI18N("trt.timeoutForLock", TestResultTable.this.workDir.getRoot());
        }

        public void acquiredLock() {
        }

        public void releasedLock() {
        }

        public void buildingCache(boolean bl) {
            this.rebuildCount = 0;
        }

        public void buildingCache(TestResult testResult) {
            ++this.rebuildCount;
            if (this.rebuildCount == 100) {
                this.writeI18N("trt.rebuild");
            } else if (this.rebuildCount % 100 == 0) {
                System.err.println(".");
            }
        }

        public void builtCache() {
            if (this.rebuildCount > 0) {
                System.err.println();
            }
        }

        public void error(Throwable throwable) {
            this.writeI18N("trt.cacheError", throwable);
            throwable.printStackTrace();
        }

        private void writeI18N(String string) {
            System.err.println(i18n.getString(string));
        }

        private void writeI18N(String string, Object object) {
            System.err.println(i18n.getString(string, object));
        }

        private void writeI18N(String string, Object[] objectArray) {
            System.err.println(i18n.getString(string, objectArray));
        }
    }

    public static interface TreeIterator
    extends Enumeration,
    Iterator {
        public boolean hasMoreElements();

        public Object nextElement();

        public boolean hasNext();

        public Object next();

        public void remove();

        public int getRejectCount();

        public void setRecordRejects(boolean var1);

        public int[] getResultStats();

        public Hashtable getFilterStats();

        public TestFilter[] getFilters();

        public String[] getInitialURLs();

        public Object peek();

        public boolean isPending(TestResult var1);
    }

    private static class NullEnum
    extends TRT_Iterator {
        private static NullEnum instance;

        private NullEnum() {
        }

        public boolean hasNext() {
            return this.hasMoreElements();
        }

        public Object next() {
            return this.nextElement();
        }

        public void remove() {
            throw new UnsupportedOperationException("Cannot remove from TestResultTable thhrough interator.  Do not call this method.");
        }

        public boolean hasMoreElements() {
            return false;
        }

        public Object nextElement() {
            throw new NoSuchElementException(i18n.getString("trt.noElements"));
        }

        public static NullEnum getInstance() {
            if (instance == null) {
                instance = new NullEnum();
            }
            return instance;
        }
    }

    public static interface TreeNode {
        public void addObserver(TreeNodeObserver var1);

        public void removeObserver(TreeNodeObserver var1);

        public int getSize();

        public TreeNode getParent();

        public boolean isRoot();

        public TestResultTable getEnclosingTable();

        public boolean isUpToDate();

        public int getChildCount();

        public Object getChild(int var1);

        public TestResult[] getTestResults();

        public TreeNode[] getTreeNodes();

        public String getName();

        public boolean isLeaf(int var1);

        public int[] getChildStatus();

        public int getIndex(Object var1);

        public TestResult matchTest(String var1);
    }

    public static class Fault
    extends Exception {
        Fault(I18NResourceBundle i18NResourceBundle, String string) {
            super(i18NResourceBundle.getString(string));
        }

        Fault(I18NResourceBundle i18NResourceBundle, String string, Object object) {
            super(i18NResourceBundle.getString(string, object));
        }

        Fault(I18NResourceBundle i18NResourceBundle, String string, Object[] objectArray) {
            super(i18NResourceBundle.getString(string, objectArray));
        }
    }

    public static interface TreeNodeObserver {
        public void insertedBranch(TreeNode var1, TreeNode var2, int var3);

        public void insertedResult(TreeNode var1, TestResult var2, int var3);

        public void replacedResult(TreeNode var1, TestResult var2, TestResult var3, int var4);

        public void removedBranch(TreeNode var1, int var2);

        public void removedResult(TreeNode var1, TestResult var2, int var3);

        public void countersInvalidated(TreeNode var1);
    }

    public static interface TreeObserver {
        public void nodeInserted(TreeNode[] var1, Object var2, int var3);

        public void nodeChanged(TreeNode[] var1, Object var2, int var3, Object var4);

        public void nodeRemoved(TreeNode[] var1, Object var2, int var3);
    }

    public static interface Observer {
        public void update(TestResult var1, TestResult var2);

        public void updated(TestResult var1);
    }
}

