/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest;

import com.sun.javatest.Harness;
import com.sun.javatest.Parameters;
import com.sun.javatest.ProductInfo;
import com.sun.javatest.TestDescription;
import com.sun.javatest.TestFinder;
import com.sun.javatest.TestResult;
import com.sun.javatest.TestSuite;
import com.sun.javatest.WorkDirectory;
import com.sun.javatest.util.BackupPolicy;
import com.sun.javatest.util.I18NResourceBundle;
import com.sun.javatest.util.TextWriter;
import java.io.File;
import java.io.IOException;
import java.util.Date;

class Trace
implements Harness.Observer {
    TextWriter out;
    File reportDir;
    BackupPolicy backupPolicy;
    private static I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(class$com$sun$javatest$Trace == null ? (class$com$sun$javatest$Trace = Trace.class$("com.sun.javatest.Trace")) : class$com$sun$javatest$Trace);
    static /* synthetic */ Class class$com$sun$javatest$Trace;

    Trace(BackupPolicy backupPolicy) {
        this.backupPolicy = backupPolicy;
    }

    public synchronized void startingTestRun(Parameters parameters) {
        this.openOutput(parameters);
        if (this.out != null) {
            TestSuite testSuite = parameters.getTestSuite();
            String string = testSuite == null ? "null" : testSuite.getClass().getName();
            TestFinder testFinder = parameters.getWorkDirectory().getTestResultTable().getTestFinder();
            String string2 = testFinder == null ? "null" : testFinder.getClass().getName();
            this.println(i18n, "trace.starting", new Object[]{string, string2});
        }
    }

    public synchronized void startingTest(TestResult testResult) {
        if (this.out != null) {
            TestDescription testDescription = null;
            try {
                testDescription = testResult.getDescription();
            }
            catch (TestResult.Fault fault) {
                fault.printStackTrace();
            }
            this.println(i18n, "trace.testStarting", testDescription.getRootRelativeURL());
        }
    }

    public synchronized void finishedTest(TestResult testResult) {
        if (this.out != null) {
            try {
                TestDescription testDescription = testResult.getDescription();
                this.println(i18n, "trace.testFinished", new Object[]{testDescription.getRootRelativeURL(), testResult.getStatus()});
            }
            catch (TestResult.Fault fault) {
                fault.printStackTrace();
            }
        }
    }

    public synchronized void stoppingTestRun() {
        if (this.out != null) {
            this.println(i18n, "trace.stopping");
        }
    }

    public synchronized void finishedTesting() {
        if (this.out != null) {
            this.println(i18n, "trace.cleanup");
        }
    }

    public synchronized void finishedTestRun(boolean bl) {
        if (this.out != null) {
            if (bl) {
                this.println(i18n, "trace.doneOK");
            } else {
                this.println(i18n, "trace.doneNotOK");
            }
            this.close();
        }
    }

    public synchronized void error(String string) {
        if (this.out != null) {
            this.println(i18n, "trace.error", string);
        }
    }

    private void openOutput(Parameters parameters) {
        try {
            WorkDirectory workDirectory = parameters.getWorkDirectory();
            File file = workDirectory.getSystemFile("harness.trace");
            boolean bl = Boolean.getBoolean("javatest.trace.autoflush");
            this.out = new TextWriter(this.backupPolicy.backupAndOpenWriter(file));
            this.out.println("# Trace file started at " + new Date());
            this.out.println("# " + ProductInfo.getName() + " version " + ProductInfo.getVersion());
            this.out.println("# class directory: " + Harness.getClassDir());
            this.out.println("# using java: " + System.getProperty("java.home"));
        }
        catch (IOException iOException) {
            System.err.println("Cannot open trace file: trace cancelled");
            System.err.println(iOException);
            this.out = null;
        }
    }

    private void close() {
        if (this.out != null) {
            try {
                this.out.close();
            }
            catch (IOException iOException) {
                System.err.println("Exception occurred writing to trace file");
                System.err.println(iOException);
            }
            this.out = null;
        }
    }

    private void println(I18NResourceBundle i18NResourceBundle, String string) {
        this.printLocalizedLn(i18NResourceBundle.getString(string));
    }

    private void println(I18NResourceBundle i18NResourceBundle, String string, Object object) {
        this.printLocalizedLn(i18NResourceBundle.getString(string, object));
    }

    private void println(I18NResourceBundle i18NResourceBundle, String string, Object[] objectArray) {
        this.printLocalizedLn(i18NResourceBundle.getString(string, objectArray));
    }

    private void printLocalizedLn(String string) {
        try {
            this.out.println(string);
            this.out.flush();
        }
        catch (IOException iOException) {
            System.err.println("Exception occurred writing to trace file");
            System.err.println(iOException);
            System.err.println("while trying to write: " + string);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

