/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.agent;

import com.sun.javatest.agent.Connection;
import com.sun.javatest.agent.ConnectionFactory;
import com.sun.javatest.agent.SocketConnection;
import java.io.IOException;
import java.net.Socket;
import java.net.UnknownHostException;

public class ActiveConnectionFactory
implements ConnectionFactory {
    private String host;
    private int port;

    public ActiveConnectionFactory(String string, int n) {
        if (string == null) {
            throw new NullPointerException();
        }
        if (string.length() == 0 || n <= 0) {
            throw new IllegalArgumentException();
        }
        this.host = string;
        this.port = n;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public Connection nextConnection() throws ConnectionFactory.Fault {
        try {
            return new SocketConnection(new Socket(this.host, this.port));
        }
        catch (UnknownHostException unknownHostException) {
            throw new ConnectionFactory.Fault(unknownHostException, true);
        }
        catch (IOException iOException) {
            throw new ConnectionFactory.Fault(iOException, false);
        }
    }

    public void close() {
    }
}

