/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.agent;

import com.sun.javatest.agent.Agent;
import com.sun.javatest.util.StringArray;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Vector;

public class Map {
    private String[] fromValues;
    private String[] toValues;
    static /* synthetic */ Class class$java$lang$String;

    public static Map readFile(String string) throws IOException {
        try {
            Class<?> clazz = Class.forName("java.io.FileReader");
            Constructor<?> constructor = clazz.getConstructor(class$java$lang$String == null ? (class$java$lang$String = Map.class$("java.lang.String")) : class$java$lang$String);
            Reader reader = (Reader)constructor.newInstance(string);
            return new Map(reader);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IOException("file system not accessible (" + classNotFoundException + ")");
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            if (throwable instanceof IOException) {
                throw (IOException)throwable;
            }
            throw Map.fileSystemProblem(throwable);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw Map.fileSystemProblem(illegalAccessException);
        }
        catch (InstantiationException instantiationException) {
            throw Map.fileSystemProblem(instantiationException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw Map.fileSystemProblem(noSuchMethodException);
        }
        catch (Error error) {
            throw Map.fileSystemProblem(error);
        }
    }

    public static Map readURL(URL uRL) throws IOException {
        return new Map(new InputStreamReader(uRL.openStream()));
    }

    public static Map readFileOrURL(String string) throws IOException {
        if (string.length() > 5 && string.substring(0, 5).equalsIgnoreCase("http:")) {
            return Map.readURL(new URL(string));
        }
        return Map.readFile(string);
    }

    private static IOException fileSystemProblem(Throwable throwable) {
        return new IOException("problem accessing file system: " + throwable);
    }

    public Map(Reader reader) throws IOException {
        String string;
        BufferedReader bufferedReader = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
        Vector<String> vector = new Vector<String>();
        Vector<String> vector2 = new Vector<String>();
        while ((string = bufferedReader.readLine()) != null) {
            if ((string = string.trim()).length() <= 0 || string.startsWith("#")) continue;
            String[] stringArray = StringArray.split(string);
            if (stringArray.length < 2) {
                throw new IOException("format error in map file, line is: " + string);
            }
            vector.addElement(stringArray[0]);
            vector2.addElement(stringArray[1]);
        }
        bufferedReader.close();
        this.fromValues = new String[vector.size()];
        vector.copyInto(this.fromValues);
        this.toValues = new String[vector2.size()];
        vector2.copyInto(this.toValues);
    }

    public void map(String[] stringArray) {
        if (this.fromValues == null) {
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            for (int j = 0; j < this.fromValues.length; ++j) {
                String string2 = this.fromValues[j];
                String string3 = this.toValues[j];
                int n = string.indexOf(string2);
                while (n != -1) {
                    string = string.substring(0, n) + string3 + string.substring(n + string2.length());
                    n = string.indexOf(string2, n + string3.length());
                }
            }
            if (Agent.tracing && string != stringArray[i]) {
                Agent.traceOut.println("MAPARG-from: " + stringArray[i]);
                Agent.traceOut.println("MAPARG-to:   " + string);
            }
            stringArray[i] = string;
        }
    }

    public Enumeration enumerate() {
        Vector<String[]> vector = new Vector<String[]>(this.fromValues.length);
        for (int i = 0; i < this.fromValues.length; ++i) {
            vector.addElement(new String[]{this.fromValues[i], this.toValues[i]});
        }
        return vector.elements();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

