/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.agent;

import com.sun.javatest.agent.Connection;
import com.sun.javatest.agent.ConnectionFactory;
import com.sun.javatest.agent.SocketConnection;
import java.io.IOException;
import java.net.ServerSocket;

public class PassiveConnectionFactory
implements ConnectionFactory {
    private ServerSocket serverSocket;

    public PassiveConnectionFactory(int n, int n2) throws IOException {
        if (n < 0 || n2 < 0) {
            throw new IllegalArgumentException();
        }
        this.serverSocket = new ServerSocket(n, n2);
    }

    public PassiveConnectionFactory(ServerSocket serverSocket) {
        this.serverSocket = serverSocket;
    }

    public int getPort() {
        return this.serverSocket.getLocalPort();
    }

    public Connection nextConnection() throws ConnectionFactory.Fault {
        try {
            return new SocketConnection(this.serverSocket.accept());
        }
        catch (IOException iOException) {
            throw new ConnectionFactory.Fault(iOException, false);
        }
    }

    public void close() throws ConnectionFactory.Fault {
        try {
            this.serverSocket.close();
        }
        catch (IOException iOException) {
            throw new ConnectionFactory.Fault(iOException, true);
        }
    }
}

