/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.agent;

import com.sun.javatest.agent.Connection;
import com.sun.javatest.agent.ConnectionFactory;
import com.sun.javatest.agent.SerialPortConnection;
import java.io.IOException;
import javax.comm.CommPortIdentifier;
import javax.comm.NoSuchPortException;
import javax.comm.PortInUseException;

public class SerialPortConnectionFactory
implements ConnectionFactory {
    private CommPortIdentifier portId;
    private String app;
    private int timeout;

    public SerialPortConnectionFactory(String string, String string2, int n) throws NoSuchPortException {
        this(CommPortIdentifier.getPortIdentifier((String)string), string2, n);
    }

    public SerialPortConnectionFactory(CommPortIdentifier commPortIdentifier, String string, int n) {
        if (commPortIdentifier.getPortType() != 1) {
            throw new IllegalArgumentException("Not a serial port: " + commPortIdentifier.getName());
        }
        this.portId = commPortIdentifier;
        this.app = string;
        this.timeout = n;
    }

    public synchronized Connection nextConnection() throws ConnectionFactory.Fault {
        try {
            SerialPortConnection serialPortConnection = new SerialPortConnection(this.portId, this.app, this.timeout);
            return serialPortConnection;
        }
        catch (InterruptedException interruptedException) {
            System.err.println("Error connection: " + interruptedException);
            throw new ConnectionFactory.Fault(interruptedException, true);
        }
        catch (IOException iOException) {
            System.err.println("Error connection: " + iOException);
            throw new ConnectionFactory.Fault(iOException, true);
        }
        catch (PortInUseException portInUseException) {
            System.err.println("Error connection: " + (Object)((Object)portInUseException));
            throw new ConnectionFactory.Fault((Exception)((Object)portInUseException), false);
        }
    }

    public void close() {
    }
}

