/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.audit;

import com.sun.javatest.InterviewParameters;
import com.sun.javatest.audit.Audit;
import com.sun.javatest.audit.AuditToolManager;
import com.sun.javatest.tool.Command;
import com.sun.javatest.tool.CommandContext;
import com.sun.javatest.tool.CommandManager;
import com.sun.javatest.tool.Desktop;
import com.sun.javatest.util.HelpTree;
import com.sun.javatest.util.I18NResourceBundle;
import java.util.ListIterator;

public class AuditCommandManager
extends CommandManager {
    private static I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(class$com$sun$javatest$audit$AuditCommandManager == null ? (class$com$sun$javatest$audit$AuditCommandManager = AuditCommandManager.class$("com.sun.javatest.audit.AuditCommandManager")) : class$com$sun$javatest$audit$AuditCommandManager);
    static /* synthetic */ Class class$com$sun$javatest$audit$AuditCommandManager;
    static /* synthetic */ Class class$com$sun$javatest$audit$AuditToolManager;

    public HelpTree.Node getHelp() {
        String[] stringArray = new String[]{"audit", "showAudit"};
        return new HelpTree.Node(i18n, "cmgr.help", stringArray);
    }

    public boolean parseCommand(String string, ListIterator listIterator, CommandContext commandContext) throws Command.Fault {
        if (string.equalsIgnoreCase(AuditCommand.getName())) {
            commandContext.addCommand(new AuditCommand(listIterator));
            return true;
        }
        if (string.equalsIgnoreCase(ShowAuditCommand.getName())) {
            commandContext.addCommand(new ShowAuditCommand(listIterator));
            return true;
        }
        return false;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class ShowAuditCommand
    extends Command {
        static String getName() {
            return "showAudit";
        }

        ShowAuditCommand(ListIterator listIterator) {
            super(ShowAuditCommand.getName());
        }

        public int getDesktopMode() {
            return 2;
        }

        public void run(CommandContext commandContext) {
            Desktop desktop = commandContext.getDesktop();
            AuditToolManager auditToolManager = (AuditToolManager)desktop.getToolManager(class$com$sun$javatest$audit$AuditToolManager == null ? (class$com$sun$javatest$audit$AuditToolManager = AuditCommandManager.class$("com.sun.javatest.audit.AuditToolManager")) : class$com$sun$javatest$audit$AuditToolManager);
            auditToolManager.startTool();
        }
    }

    private static class AuditCommand
    extends Command {
        private boolean showAllEnvValues;
        private boolean showMultipleEnvValues;

        static String getName() {
            return "audit";
        }

        AuditCommand(ListIterator listIterator) throws Command.Fault {
            super(AuditCommand.getName());
            while (listIterator.hasNext()) {
                String string = this.nextArg(listIterator);
                if (string.equalsIgnoreCase("-showEnvValues")) {
                    this.showAllEnvValues = true;
                    continue;
                }
                if (string.equalsIgnoreCase("-showMultipleEnvValues")) {
                    this.showMultipleEnvValues = true;
                    continue;
                }
                this.putbackArg(listIterator);
                break;
            }
        }

        public boolean isActionCommand() {
            return true;
        }

        public void run(CommandContext commandContext) throws Command.Fault {
            InterviewParameters interviewParameters = this.getConfig(commandContext);
            Audit audit = new Audit(interviewParameters);
            audit.report(System.out, this.showAllEnvValues, this.showMultipleEnvValues);
            if (audit.isOK()) {
                commandContext.printMessage(i18n, "audit.ok");
            } else {
                commandContext.printErrorMessage(i18n, "audit.failed");
            }
        }
    }
}

