/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.audit;

import com.sun.javatest.audit.AuditTool;
import com.sun.javatest.tool.Desktop;
import com.sun.javatest.tool.Tool;
import com.sun.javatest.tool.ToolAction;
import com.sun.javatest.tool.ToolManager;
import java.awt.event.ActionEvent;
import java.util.Map;
import javax.swing.Action;

public class AuditToolManager
extends ToolManager {
    private AuditTool tool;

    public AuditToolManager(Desktop desktop) {
        super(desktop);
    }

    public Action[] getWindowOpenMenuActions() {
        ToolAction toolAction = new ToolAction(this.i18n, "tmgr.openAudit"){

            public void actionPerformed(ActionEvent actionEvent) {
                AuditToolManager.this.startTool();
            }
        };
        return new Action[]{toolAction};
    }

    public Tool startTool() {
        AuditTool auditTool = this.getTool();
        Desktop desktop = this.getDesktop();
        if (!desktop.containsTool(auditTool)) {
            desktop.addTool(auditTool);
        }
        desktop.setSelectedTool(auditTool);
        return auditTool;
    }

    public Tool restoreTool(Map map) {
        AuditTool auditTool = this.getTool();
        auditTool.restore(map);
        return auditTool;
    }

    AuditTool getTool() {
        if (this.tool == null) {
            this.tool = new AuditTool(this);
            this.tool.addObserver(new Tool.Observer(){

                public void shortTitleChanged(Tool tool, String string) {
                }

                public void titleChanged(Tool tool, String string) {
                }

                public void toolDisposed(Tool tool) {
                    if (tool == AuditToolManager.this.tool) {
                        AuditToolManager.this.tool = null;
                    }
                }
            });
        }
        return this.tool;
    }
}

