/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.cof;

import com.sun.javatest.TestResult;
import com.sun.javatest.TestResultTable;
import com.sun.javatest.TestSuite;
import com.sun.javatest.WorkDirectory;
import com.sun.javatest.cof.COFData;
import com.sun.javatest.cof.COFItem;
import com.sun.javatest.cof.COFTest;
import com.sun.javatest.util.I18NResourceBundle;
import com.sun.javatest.util.XMLWriter;
import java.io.File;
import java.io.IOException;
import java.util.regex.Pattern;

class COFTestSuite
extends COFItem {
    private static final String[] cofStatus = new String[4];
    private static I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(class$com$sun$javatest$cof$COFTestSuite == null ? (class$com$sun$javatest$cof$COFTestSuite = COFTestSuite.class$("com.sun.javatest.cof.COFTestSuite")) : class$com$sun$javatest$cof$COFTestSuite);
    private COFData cofData;
    private boolean legacyMode = false;
    private String name;
    protected Pattern testCasePattern = Pattern.compile("^(\\S+): (Passed\\.|Failed\\.|Error\\.|Not\\ run\\.)(.*)");
    private TestResultTable trt;
    static /* synthetic */ Class class$com$sun$javatest$cof$COFTestSuite;

    COFTestSuite(File file) {
        this.trt = new TestResultTable();
        this.scan(file);
        this.legacyMode = true;
    }

    COFTestSuite(File file, COFData cOFData) {
        this.cofData = cOFData;
        this.trt = new TestResultTable();
        this.name = this.cofData.get("testsuites.testsuite.name");
        this.scan(file);
        this.legacyMode = true;
    }

    COFTestSuite(TestResultTable testResultTable) {
        this.trt = testResultTable;
    }

    COFTestSuite(WorkDirectory workDirectory) {
        this(workDirectory, null);
    }

    COFTestSuite(WorkDirectory workDirectory, COFData cOFData) {
        this.cofData = cOFData;
        TestSuite testSuite = workDirectory.getTestSuite();
        this.name = testSuite.getID();
        this.trt = workDirectory.getTestResultTable();
    }

    void scan(File file) {
        String[] stringArray = file.list();
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                File file2 = new File(file, stringArray[i]);
                if (file2.isDirectory()) {
                    this.scan(file2);
                    continue;
                }
                if (!TestResult.isResultFile(file2)) continue;
                try {
                    TestResult testResult = new TestResult(file2);
                    this.trt.update(testResult);
                    continue;
                }
                catch (TestResult.Fault fault) {
                    System.err.println(i18n.getString("ts.badTest", new Object[]{file2, fault.getMessage()}));
                }
            }
        }
    }

    void write(XMLWriter xMLWriter) throws IOException {
        xMLWriter.startTag("testsuite");
        xMLWriter.writeAttr("id", "unknownTestSuite:0");
        xMLWriter.startTag("name");
        xMLWriter.write(this.name == null ? "unknown" : this.name);
        xMLWriter.endTag("name");
        xMLWriter.startTag("tests");
        if (!this.legacyMode) {
            this.trt.waitUntilReady();
        }
        TestResultTable.TreeIterator treeIterator = this.trt.getIterator();
        while (treeIterator.hasNext()) {
            TestResult testResult = (TestResult)treeIterator.next();
            xMLWriter.newLine();
            new COFTest(testResult, this.cofData).write(xMLWriter);
        }
        xMLWriter.endTag("tests");
        xMLWriter.endTag("testsuite");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        COFTestSuite.cofStatus[0] = "pass";
        COFTestSuite.cofStatus[1] = "fail";
        COFTestSuite.cofStatus[2] = "error";
        COFTestSuite.cofStatus[3] = "did_not_run";
    }
}

