/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.exec;

import com.sun.javatest.JavaTestError;
import com.sun.javatest.Parameters;
import com.sun.javatest.TestResultTable;
import com.sun.javatest.TestSuite;
import com.sun.javatest.exec.BP_BranchSubpanel;
import com.sun.javatest.exec.BP_Model;
import com.sun.javatest.exec.BranchPanel;
import com.sun.javatest.exec.ProgressMeter;
import com.sun.javatest.exec.TT_NodeCache;
import com.sun.javatest.exec.TestTreeModel;
import com.sun.javatest.tool.I18NUtils;
import com.sun.javatest.tool.PieChart;
import com.sun.javatest.tool.UIFactory;
import com.sun.javatest.util.Debug;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.image.BufferedImage;
import java.util.Arrays;
import javax.help.CSH;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.plaf.metal.MetalLookAndFeel;

class BP_SummarySubpanel
extends BP_BranchSubpanel {
    private CounterThread ct;
    private int[] stats;
    private int filtered;
    private JLabel progLabel;
    private ProgressMeter pMeter;
    private JLabel[] sTypes;
    private JTextField[] sValues;
    private JTextField subtotalTf;
    private JTextField totalTf;
    private JTextField folderNameTf;
    private JTextField filterNameTf;
    private JTextField filterDescTf;
    private PieChart pie;
    private static Color[] pieColors;
    private static final int NUM_FIELDS = 7;
    private static final int SUBTOTAL_INDEX = 4;
    private static final int FILTERED_INDEX = 5;
    private static final int TOTAL_INDEX = 6;
    private static final int NONTOTAL_FIELD_RMARGIN = 10;
    private static final int TOTAL_FIELD_RMARGIN = 2;
    private static final int ACTIVE_FREQUENCY = 1000;
    private static final int INACTIVE_FREQUENCY = 2500;
    private final int NTFIELD_WIDTH = 5;
    private final int TFIELD_WIDTH = 7;
    protected final int[] stateOrdering = new int[]{2, 1, 3, 0};
    private static int debug;
    static /* synthetic */ Class class$com$sun$javatest$exec$BP_SummarySubpanel;

    BP_SummarySubpanel(UIFactory uIFactory, BP_Model bP_Model, TestTreeModel testTreeModel) {
        super("stats", uIFactory, bP_Model, testTreeModel, "br.summ");
        this.init();
    }

    void init() {
        int n;
        if (pieColors == null) {
            pieColors = new Color[5];
            BP_SummarySubpanel.pieColors[0] = I18NUtils.getStatusColor(0);
            BP_SummarySubpanel.pieColors[1] = I18NUtils.getStatusColor(1);
            BP_SummarySubpanel.pieColors[2] = I18NUtils.getStatusColor(2);
            BP_SummarySubpanel.pieColors[3] = I18NUtils.getStatusColor(3);
            BP_SummarySubpanel.pieColors[BP_SummarySubpanel.pieColors.length - 1] = I18NUtils.getStatusColor(4);
        }
        CSH.setHelpIDString(this, "browse.summaryTab.csh");
        JPanel jPanel = this.uif.createPanel("br.summ.body", false);
        jPanel.setLayout(new GridBagLayout());
        JPanel jPanel2 = this.uif.createPanel("br.summStats", false);
        jPanel2.setLayout(new GridBagLayout());
        jPanel2.setOpaque(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n2 = 3;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipady = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        this.sTypes = new JLabel[7];
        for (n = 0; n < 4; ++n) {
            this.sTypes[n] = this.uif.createLabel("br.summ.status" + n);
            this.sTypes[n].setHorizontalAlignment(2);
            this.sTypes[n].setDisplayedMnemonic(this.uif.getI18NString("br.summ.status" + n + ".mne").charAt(0));
            this.sTypes[n].setIcon(new LegendIcon(I18NUtils.getStatusBarColor(n), true));
            this.uif.setAccessibleDescription(this.sTypes[n], "br.summ.status" + n);
        }
        this.sTypes[4] = this.uif.createLabel("br.summ.subtotal");
        this.sTypes[5] = this.uif.createLabel("br.summ.filtered");
        this.sTypes[6] = this.uif.createLabel("br.summ.total");
        this.sTypes[5].setIcon(new LegendIcon(I18NUtils.getStatusColor(4), true));
        this.sTypes[4].setDisplayedMnemonic(this.uif.getI18NString("br.summ.subtotal.mne").charAt(0));
        this.sTypes[5].setDisplayedMnemonic(this.uif.getI18NString("br.summ.filtered.mne").charAt(0));
        this.sTypes[6].setDisplayedMnemonic(this.uif.getI18NString("br.summ.total.mne").charAt(0));
        this.uif.setAccessibleDescription(this.sTypes[4], "br.summ.subtotal");
        this.uif.setAccessibleDescription(this.sTypes[5], "br.summ.filtered");
        this.uif.setAccessibleDescription(this.sTypes[6], "br.summ.total");
        this.sTypes[4].setBackground(MetalLookAndFeel.getPrimaryControlDarkShadow());
        this.sTypes[4].setForeground(MetalLookAndFeel.getWindowBackground());
        this.sTypes[4].setOpaque(true);
        this.sTypes[6].setBackground(MetalLookAndFeel.getPrimaryControlDarkShadow());
        this.sTypes[6].setForeground(MetalLookAndFeel.getWindowBackground());
        this.sTypes[6].setOpaque(true);
        this.sValues = new JTextField[7];
        for (n = 0; n < 4; ++n) {
            this.sValues[n] = this.createPlainField(n);
        }
        this.sValues[5] = this.createPlainField(5);
        this.sValues[4] = this.createTotalField(4);
        this.sValues[6] = this.createTotalField(6);
        this.sTypes[4].setIcon(new LegendIcon(this.sTypes[4].getBackground(), false));
        this.sTypes[6].setIcon(new LegendIcon(this.sTypes[6].getBackground(), false));
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.weightx = 0.0;
        for (n = 0; n < 7; ++n) {
            gridBagConstraints.gridy = n + n2;
            gridBagConstraints.gridx = 1;
            gridBagConstraints.insets.right = 10;
            gridBagConstraints.fill = n == 4 || n == 6 ? 0 : 2;
            jPanel2.add((Component)this.sTypes[n], gridBagConstraints);
            gridBagConstraints.gridx = 2;
            gridBagConstraints.insets.right = this.sValues[n] != this.subtotalTf && this.sValues[n] != this.totalTf ? 10 : 2;
            jPanel2.add((Component)this.sValues[n], gridBagConstraints);
            this.sTypes[n].setLabelFor(this.sValues[n]);
        }
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 15;
        gridBagConstraints.weighty = 10.0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weighty = 10.0;
        gridBagConstraints.gridwidth = 3;
        Component component = Box.createVerticalStrut(1);
        jPanel.add(component, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 3.0;
        gridBagConstraints.fill = 2;
        component = Box.createHorizontalStrut(1);
        jPanel.add(component, gridBagConstraints);
        gridBagConstraints.gridx = 4;
        component = Box.createHorizontalStrut(1);
        jPanel.add(component, gridBagConstraints);
        gridBagConstraints.weighty = 0.0;
        JLabel jLabel = this.uif.createLabel("br.summ.fldlbl", true);
        jLabel.setOpaque(false);
        this.folderNameTf = this.uif.createOutputField("br.summ.fldtf", 35, jLabel);
        this.folderNameTf.setOpaque(false);
        this.folderNameTf.setBorder(BorderFactory.createEmptyBorder());
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 14;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridx = 1;
        jPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 5.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 16;
        jPanel.add((Component)this.folderNameTf, gridBagConstraints);
        jLabel = this.uif.createLabel("br.summ.ftrlbl", true);
        jLabel.setOpaque(false);
        this.filterNameTf = this.uif.createOutputField("br.summ.ftrtf", 35, jLabel);
        this.filterNameTf.setOpaque(false);
        this.filterNameTf.setBorder(BorderFactory.createEmptyBorder());
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 14;
        gridBagConstraints.fill = 0;
        jPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 5.0;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)this.filterNameTf, gridBagConstraints);
        this.filterDescTf = this.uif.createOutputField("br.summ.fdesc", 35);
        this.filterDescTf.setOpaque(false);
        this.filterDescTf.setBorder(BorderFactory.createEmptyBorder());
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridx = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.fill = 0;
        jPanel.add((Component)this.filterDescTf, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        Divider divider = new Divider(1, 5);
        divider.getInsets().top = 5;
        divider.getInsets().bottom = 5;
        jPanel.add((Component)divider, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 3.0;
        gridBagConstraints.fill = 2;
        component = Box.createHorizontalStrut(1);
        jPanel.add(component, gridBagConstraints);
        JPanel jPanel3 = this.uif.createPanel("br.statpie", new GridBagLayout(), false);
        jPanel3.setOpaque(false);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.fill = 0;
        gridBagConstraints2.anchor = 10;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.weightx = 1.0;
        jPanel2.setMinimumSize(new Dimension(80, 80));
        jPanel3.add((Component)jPanel2, gridBagConstraints2);
        jPanel2.setMinimumSize(new Dimension(150, 100));
        this.pie = new PieChart(new int[]{100}, new Color[]{I18NUtils.getStatusColor(4)});
        gridBagConstraints2.fill = 1;
        gridBagConstraints2.weightx = 2.0;
        gridBagConstraints2.gridx = 1;
        jPanel3.add((Component)this.pie, gridBagConstraints2);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 3;
        jPanel.add((Component)jPanel3, gridBagConstraints);
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 10.0;
        gridBagConstraints.weighty = 10.0;
        component = Box.createVerticalStrut(5);
        jPanel.add(component, gridBagConstraints);
        jPanel.setMinimumSize(new Dimension(150, 100));
        jPanel.setBackground(Color.WHITE);
        jPanel.setOpaque(true);
        JScrollPane jScrollPane = this.uif.createScrollPane(jPanel, 20, 30);
        jScrollPane.setMinimumSize(new Dimension(150, 100));
        this.setLayout(new BorderLayout());
        this.add((Component)jScrollPane, "Center");
        this.setMinimumSize(new Dimension(150, 100));
    }

    void dispose() {
        if (this.ct != null) {
            this.ct.interrupt();
            this.ct = null;
        }
    }

    protected JTextField createPlainField(int n) {
        JTextField jTextField = this.uif.createOutputField("br.summ." + n, 5);
        jTextField.setHorizontalAlignment(4);
        jTextField.setBorder(BorderFactory.createEmptyBorder());
        jTextField.setOpaque(false);
        return jTextField;
    }

    protected JTextField createTotalField(int n) {
        JTextField jTextField = this.uif.createOutputField("br.summ." + n, 7);
        jTextField.setHorizontalAlignment(4);
        jTextField.setBorder(null);
        jTextField.setBackground(MetalLookAndFeel.getPrimaryControlDarkShadow());
        jTextField.setForeground(MetalLookAndFeel.getWindowBackground());
        jTextField.setEnabled(true);
        return jTextField;
    }

    protected void updateSubpanel(TestResultTable.TreeNode treeNode) {
        super.updateSubpanel(treeNode);
        if (debug > 1) {
            Debug.println("BP_SP - updateSubpanel() called");
        }
        if (this.filterNameTf != null && this.filterDescTf != null && !this.ttm.getTestFilter().getName().equals(this.filterNameTf.getText())) {
            this.filterNameTf.setText(this.ttm.getTestFilter().getName());
            this.filterDescTf.setText(this.ttm.getTestFilter().getDescription());
        }
        if (this.ct != null && this.ct.getNode() == this.subpanelNode) {
            return;
        }
        if (debug > 0) {
            Debug.println("BP_SP - updating panel");
        }
        if (this.ct == null) {
            this.ct = new CounterThread(this.subpanelNode, this.sValues);
            this.ct.setPriority(4);
            this.ct.start();
        }
        this.ct.setNode(this.subpanelNode);
        String string = this.subpanelNode.getName();
        if (string != null) {
            this.folderNameTf.setText(string);
        } else {
            Parameters parameters = this.ttm.getParameters();
            if (parameters != null) {
                TestSuite testSuite = parameters.getTestSuite();
                this.folderNameTf.setText(testSuite == null ? "" : this.uif.getI18NString("br.summ.fldtf.root", testSuite.getName()));
            }
        }
    }

    static /* synthetic */ Color[] access$000() {
        return pieColors;
    }

    static /* synthetic */ PieChart access$200(BP_SummarySubpanel bP_SummarySubpanel) {
        return bP_SummarySubpanel.pie;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        debug = Debug.getInt(class$com$sun$javatest$exec$BP_SummarySubpanel == null ? (class$com$sun$javatest$exec$BP_SummarySubpanel = BP_SummarySubpanel.class$("com.sun.javatest.exec.BP_SummarySubpanel")) : class$com$sun$javatest$exec$BP_SummarySubpanel);
    }

    private class LegendIcon
    implements Icon {
        private Color color;
        private Color shadowColor;
        private Image image;
        private boolean paintShadow;

        LegendIcon(Color color, boolean bl) {
            this.color = color;
            this.shadowColor = new Color(0x555555);
            this.paintShadow = bl;
        }

        LegendIcon() {
            this.shadowColor = null;
            this.color = null;
        }

        public int getIconWidth() {
            return 16;
        }

        public int getIconHeight() {
            return 16;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            if (this.image == null) {
                this.image = new BufferedImage(this.getIconWidth(), this.getIconHeight(), 2);
                Graphics graphics2 = this.image.getGraphics();
                this.paintIt(graphics2, this.paintShadow, this.color);
                graphics2.dispose();
            }
            graphics.drawImage(this.image, n, n2, null);
        }

        private void paintIt(Graphics graphics, boolean bl, Color color) {
            int n;
            int n2;
            if (color == null) {
                return;
            }
            int n3 = 2;
            int n4 = 2;
            if (bl) {
                n2 = 10;
                n = 10;
            } else {
                n2 = 12;
                n = 12;
            }
            if (bl) {
                graphics.setColor(this.shadowColor);
                graphics.fillRect(n3 + 2, n4 + 2, n, n2);
            }
            graphics.setColor(color);
            graphics.fillRect(n3, n4, n, n2);
        }
    }

    class Divider2
    extends JComponent {
        int thick = 2;
        int arcWidth = 15;

        public Divider2() {
        }

        public Divider2(int n) {
            this.thick = n;
        }

        protected void paintComponent(Graphics graphics) {
            if (this.isOpaque()) {
                graphics.setColor(this.getBackground());
                graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
            }
            Insets insets = this.getInsets();
            int n = this.getWidth() - insets.left - insets.right;
            int n2 = this.getHeight() - insets.left - insets.right;
            graphics.setColor(MetalLookAndFeel.getSeparatorForeground());
            if (n2 < 2) {
                return;
            }
            if (n2 < this.thick * 2) {
                int n3 = n2 / 2;
                graphics.fillRect(insets.left, n3 - this.thick / 2, n, this.thick);
            } else {
                int n4 = n2 / 2;
                graphics.fillRect(insets.left + this.arcWidth, n4 - this.thick * 2, n - this.arcWidth, this.thick);
                graphics.fillArc(insets.left, n4 - this.thick * 2, n, this.thick * 2, -90, 0);
            }
        }

        public Dimension getPreferredSize() {
            return this.getMinimumSize();
        }

        public Dimension getMinimumSize() {
            Insets insets = this.getInsets();
            return new Dimension(this.arcWidth * 2 + insets.left + insets.right, this.thick * 2 + insets.top + insets.bottom);
        }
    }

    class Divider
    extends JComponent {
        int thick = 2;
        int space = 4;

        public Divider() {
        }

        public Divider(int n, int n2) {
            this.thick = n;
            this.space = n2;
        }

        protected void paintComponent(Graphics graphics) {
            if (this.isOpaque()) {
                graphics.setColor(this.getBackground());
                graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
            }
            Insets insets = this.getInsets();
            int n = this.getWidth() - insets.left - insets.right;
            int n2 = this.getHeight() - insets.left - insets.right;
            graphics.setColor(Color.BLACK);
            int n3 = n2 / 2;
            graphics.fillRect(insets.left, n3 - this.thick / 2, n, this.thick);
        }

        public Dimension getPreferredSize() {
            return this.getMinimumSize();
        }

        public Dimension getMinimumSize() {
            Insets insets = this.getInsets();
            return new Dimension(10 + insets.left + insets.right, this.thick * 2 + this.space + insets.top + insets.bottom);
        }
    }

    private class CounterThread
    extends Thread {
        private volatile boolean stopping;
        private TestResultTable.TreeNode node;
        private TT_NodeCache cache;
        private JTextField[] tfs;
        private int[] lastStats;
        private boolean debug = Debug.getBoolean(class$com$sun$javatest$exec$BP_SummarySubpanel == null ? (class$com$sun$javatest$exec$BP_SummarySubpanel = BP_SummarySubpanel.class$("com.sun.javatest.exec.BP_SummarySubpanel")) : class$com$sun$javatest$exec$BP_SummarySubpanel, "CounterThread");

        CounterThread(TestResultTable.TreeNode treeNode, JTextField[] jTextFieldArray) {
            super("BP_SP.CounterThread");
            this.node = treeNode;
            this.tfs = jTextFieldArray;
        }

        TestResultTable.TreeNode getNode() {
            return this.node;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            if (this.debug) {
                Debug.println("BP_SP.CT - thread running");
                Debug.println("   -> " + this);
            }
            if (this.stopping) {
                this.halt();
                return;
            }
            Object object = this;
            synchronized (object) {
                this.cache = BP_SummarySubpanel.this.ttm.getNodeInfo(this.node, true);
            }
            if (!BP_SummarySubpanel.this.model.isRunning()) {
                EventQueue.invokeLater(new BranchPanel.TextUpdater(2, this.tfs, null, BP_SummarySubpanel.this.uif));
                BP_SummarySubpanel.this.showMessage(BP_SummarySubpanel.this.uif.getI18NString("br.summ.working"));
            }
            while (true) {
                int[] nArray;
                if (this.stopping) {
                    if (!this.debug) break;
                    Debug.println("BP_SP.CT - thread terminating in run() due to halt()");
                    Debug.println("   -> " + this);
                    break;
                }
                boolean bl = false;
                CounterThread counterThread = this;
                synchronized (counterThread) {
                    this.cache = BP_SummarySubpanel.this.ttm.getNodeInfo(this.node, true);
                    if (this.cache == null) {
                        continue;
                    }
                    object = this.cache.getStats();
                    nArray = this.fillStats((int[])object, this.cache.getRejectCount(), true, true);
                    bl = this.cache.isComplete();
                }
                if (!Arrays.equals(this.lastStats, nArray)) {
                    this.notifyUpdate((int[])object, nArray);
                    this.lastStats = nArray;
                    this.updateMessage((int[])object, !bl);
                }
                counterThread = this;
                synchronized (counterThread) {
                    try {
                        if (this.cache == null || this.cache.isComplete()) {
                            this.wait(2500L);
                        } else {
                            this.wait(1000L);
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        return;
                    }
                }
            }
            if (this.stopping) {
                this.halt();
                return;
            }
            CounterThread counterThread = this;
            synchronized (counterThread) {
                if (this.cache == null) {
                    this.cache = BP_SummarySubpanel.this.ttm.getNodeInfo(this.node, true);
                }
                object = this.cache.getStats();
                this.notifyUpdate((int[])object, this.fillStats((int[])object, this.cache.getRejectCount(), true, true));
            }
            this.updateMessage((int[])object, false);
            if (this.debug) {
                Debug.println("counter thread done...");
            }
        }

        public void halt() {
            if (this.debug) {
                Debug.println("BP_SP.CT - thread stopping");
                Debug.println("   -> " + this);
            }
            this.stopping = true;
        }

        synchronized void setNode(TestResultTable.TreeNode treeNode) {
            if (treeNode != this.node) {
                this.cache = null;
                this.node = treeNode;
            }
        }

        private int[] fillStats(int[] nArray, int n, boolean bl, boolean bl2) {
            int[] nArray2 = new int[this.tfs.length];
            System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
            if (bl) {
                int n2 = 0;
                for (int i = 0; i < nArray.length; ++i) {
                    n2 += nArray[i];
                }
                nArray2[4] = n2;
            } else {
                nArray2[4] = -1;
            }
            nArray2[5] = n;
            nArray2[6] = bl2 ? nArray2[5] + nArray2[4] : -1;
            return nArray2;
        }

        private void updateMessage(int[] nArray, boolean bl) {
            int n = -1;
            for (int i = 0; i < BP_SummarySubpanel.this.stateOrdering.length; ++i) {
                if (nArray[BP_SummarySubpanel.this.stateOrdering[i]] <= 0) continue;
                n = BP_SummarySubpanel.this.stateOrdering[i];
                break;
            }
            if (this.stopping) {
                this.halt();
                return;
            }
            if (n != -1) {
                String string = null;
                switch (n) {
                    case 0: {
                        string = BP_SummarySubpanel.this.uif.getI18NString("br.worst.0");
                        break;
                    }
                    case 1: {
                        string = BP_SummarySubpanel.this.uif.getI18NString("br.worst.1");
                        break;
                    }
                    case 2: {
                        string = BP_SummarySubpanel.this.uif.getI18NString("br.worst.2");
                        break;
                    }
                    case 3: {
                        string = BP_SummarySubpanel.this.uif.getI18NString("br.worst.3");
                        break;
                    }
                    default: {
                        throw new JavaTestError(BP_SummarySubpanel.this.uif.getI18NString("br.worstNum"));
                    }
                }
                if (bl) {
                    string = BP_SummarySubpanel.this.uif.getI18NString("br.stillWork") + string;
                }
                BP_SummarySubpanel.this.showMessage(string);
            } else {
                BP_SummarySubpanel.this.showMessage(BP_SummarySubpanel.this.uif.getI18NString("br.none"));
            }
        }

        private void notifyUpdate(int[] nArray, int[] nArray2) {
            EventQueue.invokeLater(new BranchPanel.TextUpdater(1, this.tfs, nArray2, BP_SummarySubpanel.this.uif));
            int[] nArray3 = new int[5];
            System.arraycopy(nArray, 0, nArray3, 0, nArray.length);
            nArray3[4] = nArray2[5];
            EventQueue.invokeLater(new Runnable(this, nArray3){
                private final /* synthetic */ int[] val$pieStats;
                private final /* synthetic */ CounterThread this$1;
                {
                    this.this$1 = counterThread;
                    this.val$pieStats = nArray;
                }

                public void run() {
                    BP_SummarySubpanel.access$200(CounterThread.access$100(this.this$1)).setValue(this.val$pieStats, BP_SummarySubpanel.access$000());
                }
            });
        }

        static /* synthetic */ BP_SummarySubpanel access$100(CounterThread counterThread) {
            return counterThread.BP_SummarySubpanel.this;
        }
    }
}

