/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.exec;

import com.sun.interview.Interview;
import com.sun.javatest.InterviewParameters;
import com.sun.javatest.TestSuite;
import com.sun.javatest.tool.FileChooser;
import com.sun.javatest.tool.ToolDialog;
import com.sun.javatest.tool.UIFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

class CE_TemplateDialog
extends ToolDialog {
    private InterviewParameters config;
    private FileChooser fileChooser;
    private JTextField fileField;
    private JButton browseBtn;
    private JCheckBox testSuiteCheckBox;
    private JCheckBox workDirCheckBox;
    private JCheckBox markersCheckBox;
    private JCheckBox filterCheckBox;
    private JCheckBox clearCheckBox;
    private JButton okBtn;
    private Listener listener;

    CE_TemplateDialog(JComponent jComponent, InterviewParameters interviewParameters, UIFactory uIFactory) {
        super(jComponent, uIFactory, "ct");
        this.config = interviewParameters;
        this.fileChooser = new FileChooser(true);
        this.fileChooser.addChoosableExtension(".jti", uIFactory.getI18NString("ct.jtiFiles"));
    }

    public void setVisible(boolean bl) {
        if (bl) {
            if (this.markersCheckBox == null) {
                this.initGUI();
            }
            this.markersCheckBox.setSelected(this.config.getMarkersEnabled());
            this.filterCheckBox.setEnabled(this.markersCheckBox.isSelected());
            this.filterCheckBox.setSelected(this.config.getMarkersFilterEnabled());
        }
        super.setVisible(bl);
    }

    protected void initGUI() {
        this.setI18NTitle("ct.title");
        this.setHelp("confEdit.templateDialog.csh");
        this.listener = new Listener();
        JPanel jPanel = this.uif.createPanel("ct.body", false);
        jPanel.setLayout(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 30, 10));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JLabel jLabel = this.uif.createLabel("ct.file");
        gridBagConstraints.insets.right = 10;
        jPanel.add((Component)jLabel, gridBagConstraints);
        JPanel jPanel2 = this.uif.createPanel("ct.file", false);
        jPanel2.setLayout(new BorderLayout());
        this.fileField = this.uif.createInputField("ct.file", 32);
        this.fileField.getDocument().addDocumentListener(this.listener);
        jLabel.setLabelFor(this.fileField);
        jPanel2.add((Component)this.fileField, "Center");
        this.browseBtn = this.uif.createButton("ct.browse", this.listener);
        jPanel2.add((Component)this.browseBtn, "East");
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets.top = 10;
        gridBagConstraints.insets.right = 0;
        gridBagConstraints.weightx = 1.0;
        jPanel.add((Component)jPanel2, gridBagConstraints);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        jPanel.add(Box.createHorizontalGlue(), gridBagConstraints2);
        this.testSuiteCheckBox = this.uif.createCheckBox("ct.testSuite");
        this.testSuiteCheckBox.addChangeListener(this.listener);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets.top = 0;
        jPanel.add((Component)this.testSuiteCheckBox, gridBagConstraints);
        jPanel.add(Box.createHorizontalGlue(), gridBagConstraints2);
        this.workDirCheckBox = this.uif.createCheckBox("ct.workDir");
        this.workDirCheckBox.setEnabled(this.testSuiteCheckBox.isSelected());
        jPanel.add((Component)this.workDirCheckBox, gridBagConstraints);
        jPanel.add(Box.createHorizontalGlue(), gridBagConstraints2);
        this.markersCheckBox = this.uif.createCheckBox("ct.markers");
        this.markersCheckBox.addChangeListener(this.listener);
        jPanel.add((Component)this.markersCheckBox, gridBagConstraints);
        jPanel.add(Box.createHorizontalGlue(), gridBagConstraints2);
        this.filterCheckBox = this.uif.createCheckBox("ct.filter");
        this.filterCheckBox.setEnabled(this.markersCheckBox.isSelected());
        jPanel.add((Component)this.filterCheckBox, gridBagConstraints);
        jPanel.add(Box.createHorizontalGlue(), gridBagConstraints2);
        this.clearCheckBox = this.uif.createCheckBox("ct.clear");
        jPanel.add((Component)this.clearCheckBox, gridBagConstraints);
        this.setBody(jPanel);
        this.okBtn = this.uif.createButton("ct.ok", this.listener);
        this.okBtn.setEnabled(false);
        JButton jButton = this.uif.createCancelButton("ct.cancel");
        JButton jButton2 = this.uif.createHelpButton("ct.help", "confEdit.templateDialog.csh");
        this.setButtons(new JButton[]{this.okBtn, jButton, jButton2}, null);
    }

    private void doBrowse() {
        String string;
        int n;
        String string2 = this.fileField.getText();
        if (string2.length() > 0) {
            File file = new File(string2);
            if (file.isDirectory()) {
                this.fileChooser.setCurrentDirectory(file);
            } else {
                this.fileChooser.setSelectedFile(file);
            }
        }
        if ((n = this.fileChooser.showDialog(this.parent, this.uif.getI18NString("ct.open.btn"))) != 0) {
            return;
        }
        File file = this.fileChooser.getSelectedFile();
        if (!file.exists() && !(string = file.getPath()).endsWith(".jti")) {
            file = new File(string + ".jti");
        }
        if (file != null) {
            this.fileField.setText(file.getPath());
        }
    }

    private boolean doSave() {
        Object object;
        String string = this.fileField.getText();
        if (string.length() == 0) {
            return false;
        }
        File file = new File(string);
        if (!file.exists() && !((String)(object = file.getPath())).endsWith(".jti")) {
            file = new File((String)object + ".jti");
        }
        if (file.exists()) {
            int n = this.uif.showYesNoCancelDialog("ce.save.warn");
            switch (n) {
                case 0: {
                    break;
                }
                default: {
                    return false;
                }
            }
        }
        if (this.clearCheckBox.isSelected() || this.markersCheckBox.isSelected() != this.config.getMarkersEnabled() || this.filterCheckBox.isSelected() != this.config.getMarkersFilterEnabled()) {
            try {
                object = this.config.getTestSuite().createInterview();
                HashMap hashMap = new HashMap();
                this.config.save(hashMap);
                ((InterviewParameters)object).load(hashMap, false);
            }
            catch (Interview.Fault fault) {
                return false;
            }
            catch (TestSuite.Fault fault) {
                return false;
            }
            ((InterviewParameters)object).setMarkersEnabled(this.markersCheckBox.isSelected());
            ((InterviewParameters)object).setMarkersFilterEnabled(this.filterCheckBox.isSelected());
            if (this.clearCheckBox.isSelected()) {
                ((Interview)object).clearMarkedResponses(null);
            }
        } else {
            object = this.config;
        }
        boolean bl = this.testSuiteCheckBox.isSelected();
        boolean bl2 = this.workDirCheckBox.isSelected();
        try {
            ((InterviewParameters)object).saveAs(file, bl, !bl ? false : bl2);
            return true;
        }
        catch (IOException iOException) {
            this.uif.showError("ct.save", iOException.toString());
            return false;
        }
        catch (Interview.Fault fault) {
            this.uif.showError("ct.save", fault.getMessage());
            return false;
        }
    }

    private class Listener
    implements ActionListener,
    ChangeListener,
    DocumentListener {
        private Listener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            boolean bl;
            Object object = actionEvent.getSource();
            if (object == CE_TemplateDialog.this.browseBtn) {
                CE_TemplateDialog.this.doBrowse();
            } else if (object == CE_TemplateDialog.this.okBtn && (bl = CE_TemplateDialog.this.doSave())) {
                CE_TemplateDialog.this.setVisible(false);
            }
        }

        public void stateChanged(ChangeEvent changeEvent) {
            Object object = changeEvent.getSource();
            if (object == CE_TemplateDialog.this.testSuiteCheckBox) {
                CE_TemplateDialog.this.workDirCheckBox.setEnabled(CE_TemplateDialog.this.testSuiteCheckBox.isSelected());
            } else if (object == CE_TemplateDialog.this.markersCheckBox) {
                CE_TemplateDialog.this.filterCheckBox.setEnabled(CE_TemplateDialog.this.markersCheckBox.isSelected());
            }
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            this.changedUpdate(documentEvent);
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            this.changedUpdate(documentEvent);
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            File file;
            File file2;
            String string = CE_TemplateDialog.this.fileField.getText();
            boolean bl = string.length() == 0 ? false : ((file2 = new File(string)).exists() && file2.isDirectory() ? false : (file = file2.getParentFile()) != null && file.exists() && file.isDirectory());
            CE_TemplateDialog.this.okBtn.setEnabled(bl);
        }
    }
}

